<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VendorCreditItem StructType
 * @subpackage Structs
 */
class VendorCreditItem extends AbstractStructBase
{
    /**
     * The item
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $item;
    /**
     * The vendorName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $vendorName;
    /**
     * The line
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $line;
    /**
     * The orderLine
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $orderLine;
    /**
     * The quantity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $quantity;
    /**
     * The units
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $units;
    /**
     * The inventoryDetail
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\InventoryDetail
     */
    public $inventoryDetail;
    /**
     * The serialNumbersList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRefList
     */
    public $serialNumbersList;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $description;
    /**
     * The rate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $rate;
    /**
     * The amount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $amount;
    /**
     * The binNumbers
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $binNumbers;
    /**
     * The taxCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $taxCode;
    /**
     * The taxRate1
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $taxRate1;
    /**
     * The taxRate2
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $taxRate2;
    /**
     * The grossAmt
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $grossAmt;
    /**
     * The tax1Amt
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $tax1Amt;
    /**
     * The options
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CustomFieldList
     */
    public $options;
    /**
     * The department
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $department;
    /**
     * The class
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $class;
    /**
     * The location
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $location;
    /**
     * The customer
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $customer;
    /**
     * The isBillable
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $isBillable;
    /**
     * The amortizationSched
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $amortizationSched;
    /**
     * The amortizStartDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $amortizStartDate;
    /**
     * The amortizationEndDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $amortizationEndDate;
    /**
     * The amortizationResidual
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $amortizationResidual;
    /**
     * The taxAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $taxAmount;
    /**
     * The taxDetailsReference
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $taxDetailsReference;
    /**
     * The customFieldList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CustomFieldList
     */
    public $customFieldList;
    /**
     * Constructor method for VendorCreditItem
     * @uses VendorCreditItem::setItem()
     * @uses VendorCreditItem::setVendorName()
     * @uses VendorCreditItem::setLine()
     * @uses VendorCreditItem::setOrderLine()
     * @uses VendorCreditItem::setQuantity()
     * @uses VendorCreditItem::setUnits()
     * @uses VendorCreditItem::setInventoryDetail()
     * @uses VendorCreditItem::setSerialNumbersList()
     * @uses VendorCreditItem::setDescription()
     * @uses VendorCreditItem::setRate()
     * @uses VendorCreditItem::setAmount()
     * @uses VendorCreditItem::setBinNumbers()
     * @uses VendorCreditItem::setTaxCode()
     * @uses VendorCreditItem::setTaxRate1()
     * @uses VendorCreditItem::setTaxRate2()
     * @uses VendorCreditItem::setGrossAmt()
     * @uses VendorCreditItem::setTax1Amt()
     * @uses VendorCreditItem::setOptions()
     * @uses VendorCreditItem::setDepartment()
     * @uses VendorCreditItem::setClass()
     * @uses VendorCreditItem::setLocation()
     * @uses VendorCreditItem::setCustomer()
     * @uses VendorCreditItem::setIsBillable()
     * @uses VendorCreditItem::setAmortizationSched()
     * @uses VendorCreditItem::setAmortizStartDate()
     * @uses VendorCreditItem::setAmortizationEndDate()
     * @uses VendorCreditItem::setAmortizationResidual()
     * @uses VendorCreditItem::setTaxAmount()
     * @uses VendorCreditItem::setTaxDetailsReference()
     * @uses VendorCreditItem::setCustomFieldList()
     * @param \StructType\RecordRef $item
     * @param string $vendorName
     * @param int $line
     * @param int $orderLine
     * @param float $quantity
     * @param \StructType\RecordRef $units
     * @param \StructType\InventoryDetail $inventoryDetail
     * @param \StructType\RecordRefList $serialNumbersList
     * @param string $description
     * @param string $rate
     * @param float $amount
     * @param string $binNumbers
     * @param \StructType\RecordRef $taxCode
     * @param float $taxRate1
     * @param float $taxRate2
     * @param float $grossAmt
     * @param float $tax1Amt
     * @param \StructType\CustomFieldList $options
     * @param \StructType\RecordRef $department
     * @param \StructType\RecordRef $class
     * @param \StructType\RecordRef $location
     * @param \StructType\RecordRef $customer
     * @param bool $isBillable
     * @param \StructType\RecordRef $amortizationSched
     * @param string $amortizStartDate
     * @param string $amortizationEndDate
     * @param string $amortizationResidual
     * @param float $taxAmount
     * @param string $taxDetailsReference
     * @param \StructType\CustomFieldList $customFieldList
     */
    public function __construct(\StructType\RecordRef $item = null, $vendorName = null, $line = null, $orderLine = null, $quantity = null, \StructType\RecordRef $units = null, \StructType\InventoryDetail $inventoryDetail = null, \StructType\RecordRefList $serialNumbersList = null, $description = null, $rate = null, $amount = null, $binNumbers = null, \StructType\RecordRef $taxCode = null, $taxRate1 = null, $taxRate2 = null, $grossAmt = null, $tax1Amt = null, \StructType\CustomFieldList $options = null, \StructType\RecordRef $department = null, \StructType\RecordRef $class = null, \StructType\RecordRef $location = null, \StructType\RecordRef $customer = null, $isBillable = null, \StructType\RecordRef $amortizationSched = null, $amortizStartDate = null, $amortizationEndDate = null, $amortizationResidual = null, $taxAmount = null, $taxDetailsReference = null, \StructType\CustomFieldList $customFieldList = null)
    {
        $this
            ->setItem($item)
            ->setVendorName($vendorName)
            ->setLine($line)
            ->setOrderLine($orderLine)
            ->setQuantity($quantity)
            ->setUnits($units)
            ->setInventoryDetail($inventoryDetail)
            ->setSerialNumbersList($serialNumbersList)
            ->setDescription($description)
            ->setRate($rate)
            ->setAmount($amount)
            ->setBinNumbers($binNumbers)
            ->setTaxCode($taxCode)
            ->setTaxRate1($taxRate1)
            ->setTaxRate2($taxRate2)
            ->setGrossAmt($grossAmt)
            ->setTax1Amt($tax1Amt)
            ->setOptions($options)
            ->setDepartment($department)
            ->setClass($class)
            ->setLocation($location)
            ->setCustomer($customer)
            ->setIsBillable($isBillable)
            ->setAmortizationSched($amortizationSched)
            ->setAmortizStartDate($amortizStartDate)
            ->setAmortizationEndDate($amortizationEndDate)
            ->setAmortizationResidual($amortizationResidual)
            ->setTaxAmount($taxAmount)
            ->setTaxDetailsReference($taxDetailsReference)
            ->setCustomFieldList($customFieldList);
    }
    /**
     * Get item value
     * @return \StructType\RecordRef|null
     */
    public function getItem()
    {
        return $this->item;
    }
    /**
     * Set item value
     * @param \StructType\RecordRef $item
     * @return \StructType\VendorCreditItem
     */
    public function setItem(\StructType\RecordRef $item = null)
    {
        $this->item = $item;
        return $this;
    }
    /**
     * Get vendorName value
     * @return string|null
     */
    public function getVendorName()
    {
        return $this->vendorName;
    }
    /**
     * Set vendorName value
     * @param string $vendorName
     * @return \StructType\VendorCreditItem
     */
    public function setVendorName($vendorName = null)
    {
        // validation for constraint: string
        if (!is_null($vendorName) && !is_string($vendorName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vendorName, true), gettype($vendorName)), __LINE__);
        }
        $this->vendorName = $vendorName;
        return $this;
    }
    /**
     * Get line value
     * @return int|null
     */
    public function getLine()
    {
        return $this->line;
    }
    /**
     * Set line value
     * @param int $line
     * @return \StructType\VendorCreditItem
     */
    public function setLine($line = null)
    {
        // validation for constraint: int
        if (!is_null($line) && !(is_int($line) || ctype_digit($line))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($line, true), gettype($line)), __LINE__);
        }
        $this->line = $line;
        return $this;
    }
    /**
     * Get orderLine value
     * @return int|null
     */
    public function getOrderLine()
    {
        return $this->orderLine;
    }
    /**
     * Set orderLine value
     * @param int $orderLine
     * @return \StructType\VendorCreditItem
     */
    public function setOrderLine($orderLine = null)
    {
        // validation for constraint: int
        if (!is_null($orderLine) && !(is_int($orderLine) || ctype_digit($orderLine))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($orderLine, true), gettype($orderLine)), __LINE__);
        }
        $this->orderLine = $orderLine;
        return $this;
    }
    /**
     * Get quantity value
     * @return float|null
     */
    public function getQuantity()
    {
        return $this->quantity;
    }
    /**
     * Set quantity value
     * @param float $quantity
     * @return \StructType\VendorCreditItem
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: float
        if (!is_null($quantity) && !(is_float($quantity) || is_numeric($quantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($quantity, true), gettype($quantity)), __LINE__);
        }
        $this->quantity = $quantity;
        return $this;
    }
    /**
     * Get units value
     * @return \StructType\RecordRef|null
     */
    public function getUnits()
    {
        return $this->units;
    }
    /**
     * Set units value
     * @param \StructType\RecordRef $units
     * @return \StructType\VendorCreditItem
     */
    public function setUnits(\StructType\RecordRef $units = null)
    {
        $this->units = $units;
        return $this;
    }
    /**
     * Get inventoryDetail value
     * @return \StructType\InventoryDetail|null
     */
    public function getInventoryDetail()
    {
        return $this->inventoryDetail;
    }
    /**
     * Set inventoryDetail value
     * @param \StructType\InventoryDetail $inventoryDetail
     * @return \StructType\VendorCreditItem
     */
    public function setInventoryDetail(\StructType\InventoryDetail $inventoryDetail = null)
    {
        $this->inventoryDetail = $inventoryDetail;
        return $this;
    }
    /**
     * Get serialNumbersList value
     * @return \StructType\RecordRefList|null
     */
    public function getSerialNumbersList()
    {
        return $this->serialNumbersList;
    }
    /**
     * Set serialNumbersList value
     * @param \StructType\RecordRefList $serialNumbersList
     * @return \StructType\VendorCreditItem
     */
    public function setSerialNumbersList(\StructType\RecordRefList $serialNumbersList = null)
    {
        $this->serialNumbersList = $serialNumbersList;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\VendorCreditItem
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get rate value
     * @return string|null
     */
    public function getRate()
    {
        return $this->rate;
    }
    /**
     * Set rate value
     * @param string $rate
     * @return \StructType\VendorCreditItem
     */
    public function setRate($rate = null)
    {
        // validation for constraint: string
        if (!is_null($rate) && !is_string($rate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rate, true), gettype($rate)), __LINE__);
        }
        $this->rate = $rate;
        return $this;
    }
    /**
     * Get amount value
     * @return float|null
     */
    public function getAmount()
    {
        return $this->amount;
    }
    /**
     * Set amount value
     * @param float $amount
     * @return \StructType\VendorCreditItem
     */
    public function setAmount($amount = null)
    {
        // validation for constraint: float
        if (!is_null($amount) && !(is_float($amount) || is_numeric($amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($amount, true), gettype($amount)), __LINE__);
        }
        $this->amount = $amount;
        return $this;
    }
    /**
     * Get binNumbers value
     * @return string|null
     */
    public function getBinNumbers()
    {
        return $this->binNumbers;
    }
    /**
     * Set binNumbers value
     * @param string $binNumbers
     * @return \StructType\VendorCreditItem
     */
    public function setBinNumbers($binNumbers = null)
    {
        // validation for constraint: string
        if (!is_null($binNumbers) && !is_string($binNumbers)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($binNumbers, true), gettype($binNumbers)), __LINE__);
        }
        $this->binNumbers = $binNumbers;
        return $this;
    }
    /**
     * Get taxCode value
     * @return \StructType\RecordRef|null
     */
    public function getTaxCode()
    {
        return $this->taxCode;
    }
    /**
     * Set taxCode value
     * @param \StructType\RecordRef $taxCode
     * @return \StructType\VendorCreditItem
     */
    public function setTaxCode(\StructType\RecordRef $taxCode = null)
    {
        $this->taxCode = $taxCode;
        return $this;
    }
    /**
     * Get taxRate1 value
     * @return float|null
     */
    public function getTaxRate1()
    {
        return $this->taxRate1;
    }
    /**
     * Set taxRate1 value
     * @param float $taxRate1
     * @return \StructType\VendorCreditItem
     */
    public function setTaxRate1($taxRate1 = null)
    {
        // validation for constraint: float
        if (!is_null($taxRate1) && !(is_float($taxRate1) || is_numeric($taxRate1))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($taxRate1, true), gettype($taxRate1)), __LINE__);
        }
        $this->taxRate1 = $taxRate1;
        return $this;
    }
    /**
     * Get taxRate2 value
     * @return float|null
     */
    public function getTaxRate2()
    {
        return $this->taxRate2;
    }
    /**
     * Set taxRate2 value
     * @param float $taxRate2
     * @return \StructType\VendorCreditItem
     */
    public function setTaxRate2($taxRate2 = null)
    {
        // validation for constraint: float
        if (!is_null($taxRate2) && !(is_float($taxRate2) || is_numeric($taxRate2))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($taxRate2, true), gettype($taxRate2)), __LINE__);
        }
        $this->taxRate2 = $taxRate2;
        return $this;
    }
    /**
     * Get grossAmt value
     * @return float|null
     */
    public function getGrossAmt()
    {
        return $this->grossAmt;
    }
    /**
     * Set grossAmt value
     * @param float $grossAmt
     * @return \StructType\VendorCreditItem
     */
    public function setGrossAmt($grossAmt = null)
    {
        // validation for constraint: float
        if (!is_null($grossAmt) && !(is_float($grossAmt) || is_numeric($grossAmt))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($grossAmt, true), gettype($grossAmt)), __LINE__);
        }
        $this->grossAmt = $grossAmt;
        return $this;
    }
    /**
     * Get tax1Amt value
     * @return float|null
     */
    public function getTax1Amt()
    {
        return $this->tax1Amt;
    }
    /**
     * Set tax1Amt value
     * @param float $tax1Amt
     * @return \StructType\VendorCreditItem
     */
    public function setTax1Amt($tax1Amt = null)
    {
        // validation for constraint: float
        if (!is_null($tax1Amt) && !(is_float($tax1Amt) || is_numeric($tax1Amt))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($tax1Amt, true), gettype($tax1Amt)), __LINE__);
        }
        $this->tax1Amt = $tax1Amt;
        return $this;
    }
    /**
     * Get options value
     * @return \StructType\CustomFieldList|null
     */
    public function getOptions()
    {
        return $this->options;
    }
    /**
     * Set options value
     * @param \StructType\CustomFieldList $options
     * @return \StructType\VendorCreditItem
     */
    public function setOptions(\StructType\CustomFieldList $options = null)
    {
        $this->options = $options;
        return $this;
    }
    /**
     * Get department value
     * @return \StructType\RecordRef|null
     */
    public function getDepartment()
    {
        return $this->department;
    }
    /**
     * Set department value
     * @param \StructType\RecordRef $department
     * @return \StructType\VendorCreditItem
     */
    public function setDepartment(\StructType\RecordRef $department = null)
    {
        $this->department = $department;
        return $this;
    }
    /**
     * Get class value
     * @return \StructType\RecordRef|null
     */
    public function getClass()
    {
        return $this->class;
    }
    /**
     * Set class value
     * @param \StructType\RecordRef $class
     * @return \StructType\VendorCreditItem
     */
    public function setClass(\StructType\RecordRef $class = null)
    {
        $this->class = $class;
        return $this;
    }
    /**
     * Get location value
     * @return \StructType\RecordRef|null
     */
    public function getLocation()
    {
        return $this->location;
    }
    /**
     * Set location value
     * @param \StructType\RecordRef $location
     * @return \StructType\VendorCreditItem
     */
    public function setLocation(\StructType\RecordRef $location = null)
    {
        $this->location = $location;
        return $this;
    }
    /**
     * Get customer value
     * @return \StructType\RecordRef|null
     */
    public function getCustomer()
    {
        return $this->customer;
    }
    /**
     * Set customer value
     * @param \StructType\RecordRef $customer
     * @return \StructType\VendorCreditItem
     */
    public function setCustomer(\StructType\RecordRef $customer = null)
    {
        $this->customer = $customer;
        return $this;
    }
    /**
     * Get isBillable value
     * @return bool|null
     */
    public function getIsBillable()
    {
        return $this->isBillable;
    }
    /**
     * Set isBillable value
     * @param bool $isBillable
     * @return \StructType\VendorCreditItem
     */
    public function setIsBillable($isBillable = null)
    {
        // validation for constraint: boolean
        if (!is_null($isBillable) && !is_bool($isBillable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isBillable, true), gettype($isBillable)), __LINE__);
        }
        $this->isBillable = $isBillable;
        return $this;
    }
    /**
     * Get amortizationSched value
     * @return \StructType\RecordRef|null
     */
    public function getAmortizationSched()
    {
        return $this->amortizationSched;
    }
    /**
     * Set amortizationSched value
     * @param \StructType\RecordRef $amortizationSched
     * @return \StructType\VendorCreditItem
     */
    public function setAmortizationSched(\StructType\RecordRef $amortizationSched = null)
    {
        $this->amortizationSched = $amortizationSched;
        return $this;
    }
    /**
     * Get amortizStartDate value
     * @return string|null
     */
    public function getAmortizStartDate()
    {
        return $this->amortizStartDate;
    }
    /**
     * Set amortizStartDate value
     * @param string $amortizStartDate
     * @return \StructType\VendorCreditItem
     */
    public function setAmortizStartDate($amortizStartDate = null)
    {
        // validation for constraint: string
        if (!is_null($amortizStartDate) && !is_string($amortizStartDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($amortizStartDate, true), gettype($amortizStartDate)), __LINE__);
        }
        $this->amortizStartDate = $amortizStartDate;
        return $this;
    }
    /**
     * Get amortizationEndDate value
     * @return string|null
     */
    public function getAmortizationEndDate()
    {
        return $this->amortizationEndDate;
    }
    /**
     * Set amortizationEndDate value
     * @param string $amortizationEndDate
     * @return \StructType\VendorCreditItem
     */
    public function setAmortizationEndDate($amortizationEndDate = null)
    {
        // validation for constraint: string
        if (!is_null($amortizationEndDate) && !is_string($amortizationEndDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($amortizationEndDate, true), gettype($amortizationEndDate)), __LINE__);
        }
        $this->amortizationEndDate = $amortizationEndDate;
        return $this;
    }
    /**
     * Get amortizationResidual value
     * @return string|null
     */
    public function getAmortizationResidual()
    {
        return $this->amortizationResidual;
    }
    /**
     * Set amortizationResidual value
     * @param string $amortizationResidual
     * @return \StructType\VendorCreditItem
     */
    public function setAmortizationResidual($amortizationResidual = null)
    {
        // validation for constraint: string
        if (!is_null($amortizationResidual) && !is_string($amortizationResidual)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($amortizationResidual, true), gettype($amortizationResidual)), __LINE__);
        }
        $this->amortizationResidual = $amortizationResidual;
        return $this;
    }
    /**
     * Get taxAmount value
     * @return float|null
     */
    public function getTaxAmount()
    {
        return $this->taxAmount;
    }
    /**
     * Set taxAmount value
     * @param float $taxAmount
     * @return \StructType\VendorCreditItem
     */
    public function setTaxAmount($taxAmount = null)
    {
        // validation for constraint: float
        if (!is_null($taxAmount) && !(is_float($taxAmount) || is_numeric($taxAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($taxAmount, true), gettype($taxAmount)), __LINE__);
        }
        $this->taxAmount = $taxAmount;
        return $this;
    }
    /**
     * Get taxDetailsReference value
     * @return string|null
     */
    public function getTaxDetailsReference()
    {
        return $this->taxDetailsReference;
    }
    /**
     * Set taxDetailsReference value
     * @param string $taxDetailsReference
     * @return \StructType\VendorCreditItem
     */
    public function setTaxDetailsReference($taxDetailsReference = null)
    {
        // validation for constraint: string
        if (!is_null($taxDetailsReference) && !is_string($taxDetailsReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($taxDetailsReference, true), gettype($taxDetailsReference)), __LINE__);
        }
        $this->taxDetailsReference = $taxDetailsReference;
        return $this;
    }
    /**
     * Get customFieldList value
     * @return \StructType\CustomFieldList|null
     */
    public function getCustomFieldList()
    {
        return $this->customFieldList;
    }
    /**
     * Set customFieldList value
     * @param \StructType\CustomFieldList $customFieldList
     * @return \StructType\VendorCreditItem
     */
    public function setCustomFieldList(\StructType\CustomFieldList $customFieldList = null)
    {
        $this->customFieldList = $customFieldList;
        return $this;
    }
}
