<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Usage StructType
 * @subpackage Structs
 */
class Usage extends Record
{
    /**
     * The customForm
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $customForm;
    /**
     * The memo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $memo;
    /**
     * The item
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $item;
    /**
     * The subscriptionPlan
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $subscriptionPlan;
    /**
     * The customer
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $customer;
    /**
     * The usageSubscription
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $usageSubscription;
    /**
     * The usageSubscriptionLine
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $usageSubscriptionLine;
    /**
     * The usageQuantity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $usageQuantity;
    /**
     * The usageDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $usageDate;
    /**
     * The internalId
     * @var string
     */
    public $internalId;
    /**
     * The externalId
     * @var string
     */
    public $externalId;
    /**
     * Constructor method for Usage
     * @uses Usage::setCustomForm()
     * @uses Usage::setMemo()
     * @uses Usage::setItem()
     * @uses Usage::setSubscriptionPlan()
     * @uses Usage::setCustomer()
     * @uses Usage::setUsageSubscription()
     * @uses Usage::setUsageSubscriptionLine()
     * @uses Usage::setUsageQuantity()
     * @uses Usage::setUsageDate()
     * @uses Usage::setInternalId()
     * @uses Usage::setExternalId()
     * @param \StructType\RecordRef $customForm
     * @param string $memo
     * @param \StructType\RecordRef $item
     * @param \StructType\RecordRef $subscriptionPlan
     * @param \StructType\RecordRef $customer
     * @param \StructType\RecordRef $usageSubscription
     * @param \StructType\RecordRef $usageSubscriptionLine
     * @param float $usageQuantity
     * @param string $usageDate
     * @param string $internalId
     * @param string $externalId
     */
    public function __construct(\StructType\RecordRef $customForm = null, $memo = null, \StructType\RecordRef $item = null, \StructType\RecordRef $subscriptionPlan = null, \StructType\RecordRef $customer = null, \StructType\RecordRef $usageSubscription = null, \StructType\RecordRef $usageSubscriptionLine = null, $usageQuantity = null, $usageDate = null, $internalId = null, $externalId = null)
    {
        $this
            ->setCustomForm($customForm)
            ->setMemo($memo)
            ->setItem($item)
            ->setSubscriptionPlan($subscriptionPlan)
            ->setCustomer($customer)
            ->setUsageSubscription($usageSubscription)
            ->setUsageSubscriptionLine($usageSubscriptionLine)
            ->setUsageQuantity($usageQuantity)
            ->setUsageDate($usageDate)
            ->setInternalId($internalId)
            ->setExternalId($externalId);
    }
    /**
     * Get customForm value
     * @return \StructType\RecordRef|null
     */
    public function getCustomForm()
    {
        return $this->customForm;
    }
    /**
     * Set customForm value
     * @param \StructType\RecordRef $customForm
     * @return \StructType\Usage
     */
    public function setCustomForm(\StructType\RecordRef $customForm = null)
    {
        $this->customForm = $customForm;
        return $this;
    }
    /**
     * Get memo value
     * @return string|null
     */
    public function getMemo()
    {
        return $this->memo;
    }
    /**
     * Set memo value
     * @param string $memo
     * @return \StructType\Usage
     */
    public function setMemo($memo = null)
    {
        // validation for constraint: string
        if (!is_null($memo) && !is_string($memo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($memo, true), gettype($memo)), __LINE__);
        }
        $this->memo = $memo;
        return $this;
    }
    /**
     * Get item value
     * @return \StructType\RecordRef|null
     */
    public function getItem()
    {
        return $this->item;
    }
    /**
     * Set item value
     * @param \StructType\RecordRef $item
     * @return \StructType\Usage
     */
    public function setItem(\StructType\RecordRef $item = null)
    {
        $this->item = $item;
        return $this;
    }
    /**
     * Get subscriptionPlan value
     * @return \StructType\RecordRef|null
     */
    public function getSubscriptionPlan()
    {
        return $this->subscriptionPlan;
    }
    /**
     * Set subscriptionPlan value
     * @param \StructType\RecordRef $subscriptionPlan
     * @return \StructType\Usage
     */
    public function setSubscriptionPlan(\StructType\RecordRef $subscriptionPlan = null)
    {
        $this->subscriptionPlan = $subscriptionPlan;
        return $this;
    }
    /**
     * Get customer value
     * @return \StructType\RecordRef|null
     */
    public function getCustomer()
    {
        return $this->customer;
    }
    /**
     * Set customer value
     * @param \StructType\RecordRef $customer
     * @return \StructType\Usage
     */
    public function setCustomer(\StructType\RecordRef $customer = null)
    {
        $this->customer = $customer;
        return $this;
    }
    /**
     * Get usageSubscription value
     * @return \StructType\RecordRef|null
     */
    public function getUsageSubscription()
    {
        return $this->usageSubscription;
    }
    /**
     * Set usageSubscription value
     * @param \StructType\RecordRef $usageSubscription
     * @return \StructType\Usage
     */
    public function setUsageSubscription(\StructType\RecordRef $usageSubscription = null)
    {
        $this->usageSubscription = $usageSubscription;
        return $this;
    }
    /**
     * Get usageSubscriptionLine value
     * @return \StructType\RecordRef|null
     */
    public function getUsageSubscriptionLine()
    {
        return $this->usageSubscriptionLine;
    }
    /**
     * Set usageSubscriptionLine value
     * @param \StructType\RecordRef $usageSubscriptionLine
     * @return \StructType\Usage
     */
    public function setUsageSubscriptionLine(\StructType\RecordRef $usageSubscriptionLine = null)
    {
        $this->usageSubscriptionLine = $usageSubscriptionLine;
        return $this;
    }
    /**
     * Get usageQuantity value
     * @return float|null
     */
    public function getUsageQuantity()
    {
        return $this->usageQuantity;
    }
    /**
     * Set usageQuantity value
     * @param float $usageQuantity
     * @return \StructType\Usage
     */
    public function setUsageQuantity($usageQuantity = null)
    {
        // validation for constraint: float
        if (!is_null($usageQuantity) && !(is_float($usageQuantity) || is_numeric($usageQuantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($usageQuantity, true), gettype($usageQuantity)), __LINE__);
        }
        $this->usageQuantity = $usageQuantity;
        return $this;
    }
    /**
     * Get usageDate value
     * @return string|null
     */
    public function getUsageDate()
    {
        return $this->usageDate;
    }
    /**
     * Set usageDate value
     * @param string $usageDate
     * @return \StructType\Usage
     */
    public function setUsageDate($usageDate = null)
    {
        // validation for constraint: string
        if (!is_null($usageDate) && !is_string($usageDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($usageDate, true), gettype($usageDate)), __LINE__);
        }
        $this->usageDate = $usageDate;
        return $this;
    }
    /**
     * Get internalId value
     * @return string|null
     */
    public function getInternalId()
    {
        return $this->internalId;
    }
    /**
     * Set internalId value
     * @param string $internalId
     * @return \StructType\Usage
     */
    public function setInternalId($internalId = null)
    {
        // validation for constraint: string
        if (!is_null($internalId) && !is_string($internalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($internalId, true), gettype($internalId)), __LINE__);
        }
        $this->internalId = $internalId;
        return $this;
    }
    /**
     * Get externalId value
     * @return string|null
     */
    public function getExternalId()
    {
        return $this->externalId;
    }
    /**
     * Set externalId value
     * @param string $externalId
     * @return \StructType\Usage
     */
    public function setExternalId($externalId = null)
    {
        // validation for constraint: string
        if (!is_null($externalId) && !is_string($externalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($externalId, true), gettype($externalId)), __LINE__);
        }
        $this->externalId = $externalId;
        return $this;
    }
}
