<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UnitsTypeUomList StructType
 * @subpackage Structs
 */
class UnitsTypeUomList extends AbstractStructBase
{
    /**
     * The uom
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\UnitsTypeUom[]
     */
    public $uom;
    /**
     * The replaceAll
     * Meta information extracted from the WSDL
     * - default: true
     * @var bool
     */
    public $replaceAll;
    /**
     * Constructor method for UnitsTypeUomList
     * @uses UnitsTypeUomList::setUom()
     * @uses UnitsTypeUomList::setReplaceAll()
     * @param \StructType\UnitsTypeUom[] $uom
     * @param bool $replaceAll
     */
    public function __construct(array $uom = array(), $replaceAll = true)
    {
        $this
            ->setUom($uom)
            ->setReplaceAll($replaceAll);
    }
    /**
     * Get uom value
     * @return \StructType\UnitsTypeUom[]|null
     */
    public function getUom()
    {
        return $this->uom;
    }
    /**
     * This method is responsible for validating the values passed to the setUom method
     * This method is willingly generated in order to preserve the one-line inline validation within the setUom method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateUomForArrayConstraintsFromSetUom(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $unitsTypeUomListUomItem) {
            // validation for constraint: itemType
            if (!$unitsTypeUomListUomItem instanceof \StructType\UnitsTypeUom) {
                $invalidValues[] = is_object($unitsTypeUomListUomItem) ? get_class($unitsTypeUomListUomItem) : sprintf('%s(%s)', gettype($unitsTypeUomListUomItem), var_export($unitsTypeUomListUomItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The uom property can only contain items of type \StructType\UnitsTypeUom, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set uom value
     * @throws \InvalidArgumentException
     * @param \StructType\UnitsTypeUom[] $uom
     * @return \StructType\UnitsTypeUomList
     */
    public function setUom(array $uom = array())
    {
        // validation for constraint: array
        if ('' !== ($uomArrayErrorMessage = self::validateUomForArrayConstraintsFromSetUom($uom))) {
            throw new \InvalidArgumentException($uomArrayErrorMessage, __LINE__);
        }
        $this->uom = $uom;
        return $this;
    }
    /**
     * Add item to uom value
     * @throws \InvalidArgumentException
     * @param \StructType\UnitsTypeUom $item
     * @return \StructType\UnitsTypeUomList
     */
    public function addToUom(\StructType\UnitsTypeUom $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\UnitsTypeUom) {
            throw new \InvalidArgumentException(sprintf('The uom property can only contain items of type \StructType\UnitsTypeUom, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->uom[] = $item;
        return $this;
    }
    /**
     * Get replaceAll value
     * @return bool|null
     */
    public function getReplaceAll()
    {
        return $this->replaceAll;
    }
    /**
     * Set replaceAll value
     * @param bool $replaceAll
     * @return \StructType\UnitsTypeUomList
     */
    public function setReplaceAll($replaceAll = true)
    {
        // validation for constraint: boolean
        if (!is_null($replaceAll) && !is_bool($replaceAll)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($replaceAll, true), gettype($replaceAll)), __LINE__);
        }
        $this->replaceAll = $replaceAll;
        return $this;
    }
}
