<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TransferOrderItem StructType
 * @subpackage Structs
 */
class TransferOrderItem extends AbstractStructBase
{
    /**
     * The item
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $item;
    /**
     * The line
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $line;
    /**
     * The quantityAvailable
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $quantityAvailable;
    /**
     * The quantityOnHand
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $quantityOnHand;
    /**
     * The quantityBackOrdered
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $quantityBackOrdered;
    /**
     * The quantityCommitted
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $quantityCommitted;
    /**
     * The quantityFulfilled
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $quantityFulfilled;
    /**
     * The quantityPacked
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $quantityPacked;
    /**
     * The quantityPicked
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $quantityPicked;
    /**
     * The quantityReceived
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $quantityReceived;
    /**
     * The quantity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $quantity;
    /**
     * The rate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $rate;
    /**
     * The units
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $units;
    /**
     * The amount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $amount;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $description;
    /**
     * The inventoryDetail
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\InventoryDetail
     */
    public $inventoryDetail;
    /**
     * The serialNumbers
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $serialNumbers;
    /**
     * The commitInventory
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $commitInventory;
    /**
     * The orderPriority
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $orderPriority;
    /**
     * The options
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CustomFieldList
     */
    public $options;
    /**
     * The isClosed
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $isClosed;
    /**
     * The department
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $department;
    /**
     * The class
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $class;
    /**
     * The lastPurchasePrice
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $lastPurchasePrice;
    /**
     * The averageCost
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $averageCost;
    /**
     * The expectedShipDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $expectedShipDate;
    /**
     * The expectedReceiptDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $expectedReceiptDate;
    /**
     * The requestedDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $requestedDate;
    /**
     * The orderAllocationStrategy
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $orderAllocationStrategy;
    /**
     * The customFieldList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CustomFieldList
     */
    public $customFieldList;
    /**
     * Constructor method for TransferOrderItem
     * @uses TransferOrderItem::setItem()
     * @uses TransferOrderItem::setLine()
     * @uses TransferOrderItem::setQuantityAvailable()
     * @uses TransferOrderItem::setQuantityOnHand()
     * @uses TransferOrderItem::setQuantityBackOrdered()
     * @uses TransferOrderItem::setQuantityCommitted()
     * @uses TransferOrderItem::setQuantityFulfilled()
     * @uses TransferOrderItem::setQuantityPacked()
     * @uses TransferOrderItem::setQuantityPicked()
     * @uses TransferOrderItem::setQuantityReceived()
     * @uses TransferOrderItem::setQuantity()
     * @uses TransferOrderItem::setRate()
     * @uses TransferOrderItem::setUnits()
     * @uses TransferOrderItem::setAmount()
     * @uses TransferOrderItem::setDescription()
     * @uses TransferOrderItem::setInventoryDetail()
     * @uses TransferOrderItem::setSerialNumbers()
     * @uses TransferOrderItem::setCommitInventory()
     * @uses TransferOrderItem::setOrderPriority()
     * @uses TransferOrderItem::setOptions()
     * @uses TransferOrderItem::setIsClosed()
     * @uses TransferOrderItem::setDepartment()
     * @uses TransferOrderItem::setClass()
     * @uses TransferOrderItem::setLastPurchasePrice()
     * @uses TransferOrderItem::setAverageCost()
     * @uses TransferOrderItem::setExpectedShipDate()
     * @uses TransferOrderItem::setExpectedReceiptDate()
     * @uses TransferOrderItem::setRequestedDate()
     * @uses TransferOrderItem::setOrderAllocationStrategy()
     * @uses TransferOrderItem::setCustomFieldList()
     * @param \StructType\RecordRef $item
     * @param int $line
     * @param float $quantityAvailable
     * @param float $quantityOnHand
     * @param float $quantityBackOrdered
     * @param float $quantityCommitted
     * @param float $quantityFulfilled
     * @param float $quantityPacked
     * @param float $quantityPicked
     * @param float $quantityReceived
     * @param float $quantity
     * @param float $rate
     * @param \StructType\RecordRef $units
     * @param float $amount
     * @param string $description
     * @param \StructType\InventoryDetail $inventoryDetail
     * @param string $serialNumbers
     * @param string $commitInventory
     * @param float $orderPriority
     * @param \StructType\CustomFieldList $options
     * @param bool $isClosed
     * @param \StructType\RecordRef $department
     * @param \StructType\RecordRef $class
     * @param float $lastPurchasePrice
     * @param float $averageCost
     * @param string $expectedShipDate
     * @param string $expectedReceiptDate
     * @param string $requestedDate
     * @param \StructType\RecordRef $orderAllocationStrategy
     * @param \StructType\CustomFieldList $customFieldList
     */
    public function __construct(\StructType\RecordRef $item = null, $line = null, $quantityAvailable = null, $quantityOnHand = null, $quantityBackOrdered = null, $quantityCommitted = null, $quantityFulfilled = null, $quantityPacked = null, $quantityPicked = null, $quantityReceived = null, $quantity = null, $rate = null, \StructType\RecordRef $units = null, $amount = null, $description = null, \StructType\InventoryDetail $inventoryDetail = null, $serialNumbers = null, $commitInventory = null, $orderPriority = null, \StructType\CustomFieldList $options = null, $isClosed = null, \StructType\RecordRef $department = null, \StructType\RecordRef $class = null, $lastPurchasePrice = null, $averageCost = null, $expectedShipDate = null, $expectedReceiptDate = null, $requestedDate = null, \StructType\RecordRef $orderAllocationStrategy = null, \StructType\CustomFieldList $customFieldList = null)
    {
        $this
            ->setItem($item)
            ->setLine($line)
            ->setQuantityAvailable($quantityAvailable)
            ->setQuantityOnHand($quantityOnHand)
            ->setQuantityBackOrdered($quantityBackOrdered)
            ->setQuantityCommitted($quantityCommitted)
            ->setQuantityFulfilled($quantityFulfilled)
            ->setQuantityPacked($quantityPacked)
            ->setQuantityPicked($quantityPicked)
            ->setQuantityReceived($quantityReceived)
            ->setQuantity($quantity)
            ->setRate($rate)
            ->setUnits($units)
            ->setAmount($amount)
            ->setDescription($description)
            ->setInventoryDetail($inventoryDetail)
            ->setSerialNumbers($serialNumbers)
            ->setCommitInventory($commitInventory)
            ->setOrderPriority($orderPriority)
            ->setOptions($options)
            ->setIsClosed($isClosed)
            ->setDepartment($department)
            ->setClass($class)
            ->setLastPurchasePrice($lastPurchasePrice)
            ->setAverageCost($averageCost)
            ->setExpectedShipDate($expectedShipDate)
            ->setExpectedReceiptDate($expectedReceiptDate)
            ->setRequestedDate($requestedDate)
            ->setOrderAllocationStrategy($orderAllocationStrategy)
            ->setCustomFieldList($customFieldList);
    }
    /**
     * Get item value
     * @return \StructType\RecordRef|null
     */
    public function getItem()
    {
        return $this->item;
    }
    /**
     * Set item value
     * @param \StructType\RecordRef $item
     * @return \StructType\TransferOrderItem
     */
    public function setItem(\StructType\RecordRef $item = null)
    {
        $this->item = $item;
        return $this;
    }
    /**
     * Get line value
     * @return int|null
     */
    public function getLine()
    {
        return $this->line;
    }
    /**
     * Set line value
     * @param int $line
     * @return \StructType\TransferOrderItem
     */
    public function setLine($line = null)
    {
        // validation for constraint: int
        if (!is_null($line) && !(is_int($line) || ctype_digit($line))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($line, true), gettype($line)), __LINE__);
        }
        $this->line = $line;
        return $this;
    }
    /**
     * Get quantityAvailable value
     * @return float|null
     */
    public function getQuantityAvailable()
    {
        return $this->quantityAvailable;
    }
    /**
     * Set quantityAvailable value
     * @param float $quantityAvailable
     * @return \StructType\TransferOrderItem
     */
    public function setQuantityAvailable($quantityAvailable = null)
    {
        // validation for constraint: float
        if (!is_null($quantityAvailable) && !(is_float($quantityAvailable) || is_numeric($quantityAvailable))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($quantityAvailable, true), gettype($quantityAvailable)), __LINE__);
        }
        $this->quantityAvailable = $quantityAvailable;
        return $this;
    }
    /**
     * Get quantityOnHand value
     * @return float|null
     */
    public function getQuantityOnHand()
    {
        return $this->quantityOnHand;
    }
    /**
     * Set quantityOnHand value
     * @param float $quantityOnHand
     * @return \StructType\TransferOrderItem
     */
    public function setQuantityOnHand($quantityOnHand = null)
    {
        // validation for constraint: float
        if (!is_null($quantityOnHand) && !(is_float($quantityOnHand) || is_numeric($quantityOnHand))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($quantityOnHand, true), gettype($quantityOnHand)), __LINE__);
        }
        $this->quantityOnHand = $quantityOnHand;
        return $this;
    }
    /**
     * Get quantityBackOrdered value
     * @return float|null
     */
    public function getQuantityBackOrdered()
    {
        return $this->quantityBackOrdered;
    }
    /**
     * Set quantityBackOrdered value
     * @param float $quantityBackOrdered
     * @return \StructType\TransferOrderItem
     */
    public function setQuantityBackOrdered($quantityBackOrdered = null)
    {
        // validation for constraint: float
        if (!is_null($quantityBackOrdered) && !(is_float($quantityBackOrdered) || is_numeric($quantityBackOrdered))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($quantityBackOrdered, true), gettype($quantityBackOrdered)), __LINE__);
        }
        $this->quantityBackOrdered = $quantityBackOrdered;
        return $this;
    }
    /**
     * Get quantityCommitted value
     * @return float|null
     */
    public function getQuantityCommitted()
    {
        return $this->quantityCommitted;
    }
    /**
     * Set quantityCommitted value
     * @param float $quantityCommitted
     * @return \StructType\TransferOrderItem
     */
    public function setQuantityCommitted($quantityCommitted = null)
    {
        // validation for constraint: float
        if (!is_null($quantityCommitted) && !(is_float($quantityCommitted) || is_numeric($quantityCommitted))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($quantityCommitted, true), gettype($quantityCommitted)), __LINE__);
        }
        $this->quantityCommitted = $quantityCommitted;
        return $this;
    }
    /**
     * Get quantityFulfilled value
     * @return float|null
     */
    public function getQuantityFulfilled()
    {
        return $this->quantityFulfilled;
    }
    /**
     * Set quantityFulfilled value
     * @param float $quantityFulfilled
     * @return \StructType\TransferOrderItem
     */
    public function setQuantityFulfilled($quantityFulfilled = null)
    {
        // validation for constraint: float
        if (!is_null($quantityFulfilled) && !(is_float($quantityFulfilled) || is_numeric($quantityFulfilled))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($quantityFulfilled, true), gettype($quantityFulfilled)), __LINE__);
        }
        $this->quantityFulfilled = $quantityFulfilled;
        return $this;
    }
    /**
     * Get quantityPacked value
     * @return float|null
     */
    public function getQuantityPacked()
    {
        return $this->quantityPacked;
    }
    /**
     * Set quantityPacked value
     * @param float $quantityPacked
     * @return \StructType\TransferOrderItem
     */
    public function setQuantityPacked($quantityPacked = null)
    {
        // validation for constraint: float
        if (!is_null($quantityPacked) && !(is_float($quantityPacked) || is_numeric($quantityPacked))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($quantityPacked, true), gettype($quantityPacked)), __LINE__);
        }
        $this->quantityPacked = $quantityPacked;
        return $this;
    }
    /**
     * Get quantityPicked value
     * @return float|null
     */
    public function getQuantityPicked()
    {
        return $this->quantityPicked;
    }
    /**
     * Set quantityPicked value
     * @param float $quantityPicked
     * @return \StructType\TransferOrderItem
     */
    public function setQuantityPicked($quantityPicked = null)
    {
        // validation for constraint: float
        if (!is_null($quantityPicked) && !(is_float($quantityPicked) || is_numeric($quantityPicked))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($quantityPicked, true), gettype($quantityPicked)), __LINE__);
        }
        $this->quantityPicked = $quantityPicked;
        return $this;
    }
    /**
     * Get quantityReceived value
     * @return float|null
     */
    public function getQuantityReceived()
    {
        return $this->quantityReceived;
    }
    /**
     * Set quantityReceived value
     * @param float $quantityReceived
     * @return \StructType\TransferOrderItem
     */
    public function setQuantityReceived($quantityReceived = null)
    {
        // validation for constraint: float
        if (!is_null($quantityReceived) && !(is_float($quantityReceived) || is_numeric($quantityReceived))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($quantityReceived, true), gettype($quantityReceived)), __LINE__);
        }
        $this->quantityReceived = $quantityReceived;
        return $this;
    }
    /**
     * Get quantity value
     * @return float|null
     */
    public function getQuantity()
    {
        return $this->quantity;
    }
    /**
     * Set quantity value
     * @param float $quantity
     * @return \StructType\TransferOrderItem
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: float
        if (!is_null($quantity) && !(is_float($quantity) || is_numeric($quantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($quantity, true), gettype($quantity)), __LINE__);
        }
        $this->quantity = $quantity;
        return $this;
    }
    /**
     * Get rate value
     * @return float|null
     */
    public function getRate()
    {
        return $this->rate;
    }
    /**
     * Set rate value
     * @param float $rate
     * @return \StructType\TransferOrderItem
     */
    public function setRate($rate = null)
    {
        // validation for constraint: float
        if (!is_null($rate) && !(is_float($rate) || is_numeric($rate))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($rate, true), gettype($rate)), __LINE__);
        }
        $this->rate = $rate;
        return $this;
    }
    /**
     * Get units value
     * @return \StructType\RecordRef|null
     */
    public function getUnits()
    {
        return $this->units;
    }
    /**
     * Set units value
     * @param \StructType\RecordRef $units
     * @return \StructType\TransferOrderItem
     */
    public function setUnits(\StructType\RecordRef $units = null)
    {
        $this->units = $units;
        return $this;
    }
    /**
     * Get amount value
     * @return float|null
     */
    public function getAmount()
    {
        return $this->amount;
    }
    /**
     * Set amount value
     * @param float $amount
     * @return \StructType\TransferOrderItem
     */
    public function setAmount($amount = null)
    {
        // validation for constraint: float
        if (!is_null($amount) && !(is_float($amount) || is_numeric($amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($amount, true), gettype($amount)), __LINE__);
        }
        $this->amount = $amount;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\TransferOrderItem
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get inventoryDetail value
     * @return \StructType\InventoryDetail|null
     */
    public function getInventoryDetail()
    {
        return $this->inventoryDetail;
    }
    /**
     * Set inventoryDetail value
     * @param \StructType\InventoryDetail $inventoryDetail
     * @return \StructType\TransferOrderItem
     */
    public function setInventoryDetail(\StructType\InventoryDetail $inventoryDetail = null)
    {
        $this->inventoryDetail = $inventoryDetail;
        return $this;
    }
    /**
     * Get serialNumbers value
     * @return string|null
     */
    public function getSerialNumbers()
    {
        return $this->serialNumbers;
    }
    /**
     * Set serialNumbers value
     * @param string $serialNumbers
     * @return \StructType\TransferOrderItem
     */
    public function setSerialNumbers($serialNumbers = null)
    {
        // validation for constraint: string
        if (!is_null($serialNumbers) && !is_string($serialNumbers)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serialNumbers, true), gettype($serialNumbers)), __LINE__);
        }
        $this->serialNumbers = $serialNumbers;
        return $this;
    }
    /**
     * Get commitInventory value
     * @return string|null
     */
    public function getCommitInventory()
    {
        return $this->commitInventory;
    }
    /**
     * Set commitInventory value
     * @uses \EnumType\TransferOrderItemCommitInventory::valueIsValid()
     * @uses \EnumType\TransferOrderItemCommitInventory::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $commitInventory
     * @return \StructType\TransferOrderItem
     */
    public function setCommitInventory($commitInventory = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\TransferOrderItemCommitInventory::valueIsValid($commitInventory)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\TransferOrderItemCommitInventory', is_array($commitInventory) ? implode(', ', $commitInventory) : var_export($commitInventory, true), implode(', ', \EnumType\TransferOrderItemCommitInventory::getValidValues())), __LINE__);
        }
        $this->commitInventory = $commitInventory;
        return $this;
    }
    /**
     * Get orderPriority value
     * @return float|null
     */
    public function getOrderPriority()
    {
        return $this->orderPriority;
    }
    /**
     * Set orderPriority value
     * @param float $orderPriority
     * @return \StructType\TransferOrderItem
     */
    public function setOrderPriority($orderPriority = null)
    {
        // validation for constraint: float
        if (!is_null($orderPriority) && !(is_float($orderPriority) || is_numeric($orderPriority))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($orderPriority, true), gettype($orderPriority)), __LINE__);
        }
        $this->orderPriority = $orderPriority;
        return $this;
    }
    /**
     * Get options value
     * @return \StructType\CustomFieldList|null
     */
    public function getOptions()
    {
        return $this->options;
    }
    /**
     * Set options value
     * @param \StructType\CustomFieldList $options
     * @return \StructType\TransferOrderItem
     */
    public function setOptions(\StructType\CustomFieldList $options = null)
    {
        $this->options = $options;
        return $this;
    }
    /**
     * Get isClosed value
     * @return bool|null
     */
    public function getIsClosed()
    {
        return $this->isClosed;
    }
    /**
     * Set isClosed value
     * @param bool $isClosed
     * @return \StructType\TransferOrderItem
     */
    public function setIsClosed($isClosed = null)
    {
        // validation for constraint: boolean
        if (!is_null($isClosed) && !is_bool($isClosed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isClosed, true), gettype($isClosed)), __LINE__);
        }
        $this->isClosed = $isClosed;
        return $this;
    }
    /**
     * Get department value
     * @return \StructType\RecordRef|null
     */
    public function getDepartment()
    {
        return $this->department;
    }
    /**
     * Set department value
     * @param \StructType\RecordRef $department
     * @return \StructType\TransferOrderItem
     */
    public function setDepartment(\StructType\RecordRef $department = null)
    {
        $this->department = $department;
        return $this;
    }
    /**
     * Get class value
     * @return \StructType\RecordRef|null
     */
    public function getClass()
    {
        return $this->class;
    }
    /**
     * Set class value
     * @param \StructType\RecordRef $class
     * @return \StructType\TransferOrderItem
     */
    public function setClass(\StructType\RecordRef $class = null)
    {
        $this->class = $class;
        return $this;
    }
    /**
     * Get lastPurchasePrice value
     * @return float|null
     */
    public function getLastPurchasePrice()
    {
        return $this->lastPurchasePrice;
    }
    /**
     * Set lastPurchasePrice value
     * @param float $lastPurchasePrice
     * @return \StructType\TransferOrderItem
     */
    public function setLastPurchasePrice($lastPurchasePrice = null)
    {
        // validation for constraint: float
        if (!is_null($lastPurchasePrice) && !(is_float($lastPurchasePrice) || is_numeric($lastPurchasePrice))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($lastPurchasePrice, true), gettype($lastPurchasePrice)), __LINE__);
        }
        $this->lastPurchasePrice = $lastPurchasePrice;
        return $this;
    }
    /**
     * Get averageCost value
     * @return float|null
     */
    public function getAverageCost()
    {
        return $this->averageCost;
    }
    /**
     * Set averageCost value
     * @param float $averageCost
     * @return \StructType\TransferOrderItem
     */
    public function setAverageCost($averageCost = null)
    {
        // validation for constraint: float
        if (!is_null($averageCost) && !(is_float($averageCost) || is_numeric($averageCost))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($averageCost, true), gettype($averageCost)), __LINE__);
        }
        $this->averageCost = $averageCost;
        return $this;
    }
    /**
     * Get expectedShipDate value
     * @return string|null
     */
    public function getExpectedShipDate()
    {
        return $this->expectedShipDate;
    }
    /**
     * Set expectedShipDate value
     * @param string $expectedShipDate
     * @return \StructType\TransferOrderItem
     */
    public function setExpectedShipDate($expectedShipDate = null)
    {
        // validation for constraint: string
        if (!is_null($expectedShipDate) && !is_string($expectedShipDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($expectedShipDate, true), gettype($expectedShipDate)), __LINE__);
        }
        $this->expectedShipDate = $expectedShipDate;
        return $this;
    }
    /**
     * Get expectedReceiptDate value
     * @return string|null
     */
    public function getExpectedReceiptDate()
    {
        return $this->expectedReceiptDate;
    }
    /**
     * Set expectedReceiptDate value
     * @param string $expectedReceiptDate
     * @return \StructType\TransferOrderItem
     */
    public function setExpectedReceiptDate($expectedReceiptDate = null)
    {
        // validation for constraint: string
        if (!is_null($expectedReceiptDate) && !is_string($expectedReceiptDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($expectedReceiptDate, true), gettype($expectedReceiptDate)), __LINE__);
        }
        $this->expectedReceiptDate = $expectedReceiptDate;
        return $this;
    }
    /**
     * Get requestedDate value
     * @return string|null
     */
    public function getRequestedDate()
    {
        return $this->requestedDate;
    }
    /**
     * Set requestedDate value
     * @param string $requestedDate
     * @return \StructType\TransferOrderItem
     */
    public function setRequestedDate($requestedDate = null)
    {
        // validation for constraint: string
        if (!is_null($requestedDate) && !is_string($requestedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requestedDate, true), gettype($requestedDate)), __LINE__);
        }
        $this->requestedDate = $requestedDate;
        return $this;
    }
    /**
     * Get orderAllocationStrategy value
     * @return \StructType\RecordRef|null
     */
    public function getOrderAllocationStrategy()
    {
        return $this->orderAllocationStrategy;
    }
    /**
     * Set orderAllocationStrategy value
     * @param \StructType\RecordRef $orderAllocationStrategy
     * @return \StructType\TransferOrderItem
     */
    public function setOrderAllocationStrategy(\StructType\RecordRef $orderAllocationStrategy = null)
    {
        $this->orderAllocationStrategy = $orderAllocationStrategy;
        return $this;
    }
    /**
     * Get customFieldList value
     * @return \StructType\CustomFieldList|null
     */
    public function getCustomFieldList()
    {
        return $this->customFieldList;
    }
    /**
     * Set customFieldList value
     * @param \StructType\CustomFieldList $customFieldList
     * @return \StructType\TransferOrderItem
     */
    public function setCustomFieldList(\StructType\CustomFieldList $customFieldList = null)
    {
        $this->customFieldList = $customFieldList;
        return $this;
    }
}
