<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TransferOrder StructType
 * @subpackage Structs
 */
class TransferOrder extends Record
{
    /**
     * The createdDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $createdDate;
    /**
     * The lastModifiedDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $lastModifiedDate;
    /**
     * The customForm
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $customForm;
    /**
     * The shippingCost
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $shippingCost;
    /**
     * The subTotal
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $subTotal;
    /**
     * The status
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $status;
    /**
     * The shippingAddress
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Address
     */
    public $shippingAddress;
    /**
     * The shipIsResidential
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $shipIsResidential;
    /**
     * The shipAddressList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $shipAddressList;
    /**
     * The fob
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $fob;
    /**
     * The tranDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $tranDate;
    /**
     * The tranId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $tranId;
    /**
     * The source
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $source;
    /**
     * The orderStatus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $orderStatus;
    /**
     * The subsidiary
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $subsidiary;
    /**
     * The employee
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $employee;
    /**
     * The useItemCostAsTransferCost
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $useItemCostAsTransferCost;
    /**
     * The incoterm
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $incoterm;
    /**
     * The firmed
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $firmed;
    /**
     * The department
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $department;
    /**
     * The class
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $class;
    /**
     * The location
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $location;
    /**
     * The transferLocation
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $transferLocation;
    /**
     * The memo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $memo;
    /**
     * The shipDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $shipDate;
    /**
     * The shipMethod
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $shipMethod;
    /**
     * The trackingNumbers
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $trackingNumbers;
    /**
     * The linkedTrackingNumbers
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $linkedTrackingNumbers;
    /**
     * The shipComplete
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $shipComplete;
    /**
     * The altShippingCost
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $altShippingCost;
    /**
     * The shippingTax1Rate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $shippingTax1Rate;
    /**
     * The shippingTax2Rate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $shippingTax2Rate;
    /**
     * The handlingTax1Rate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $handlingTax1Rate;
    /**
     * The handlingTax2Rate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $handlingTax2Rate;
    /**
     * The shippingTaxCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $shippingTaxCode;
    /**
     * The handlingTaxCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $handlingTaxCode;
    /**
     * The total
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $total;
    /**
     * The itemList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\TransferOrderItemList
     */
    public $itemList;
    /**
     * The accountingBookDetailList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\AccountingBookDetailList
     */
    public $accountingBookDetailList;
    /**
     * The customFieldList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CustomFieldList
     */
    public $customFieldList;
    /**
     * The internalId
     * @var string
     */
    public $internalId;
    /**
     * The externalId
     * @var string
     */
    public $externalId;
    /**
     * Constructor method for TransferOrder
     * @uses TransferOrder::setCreatedDate()
     * @uses TransferOrder::setLastModifiedDate()
     * @uses TransferOrder::setCustomForm()
     * @uses TransferOrder::setShippingCost()
     * @uses TransferOrder::setSubTotal()
     * @uses TransferOrder::setStatus()
     * @uses TransferOrder::setShippingAddress()
     * @uses TransferOrder::setShipIsResidential()
     * @uses TransferOrder::setShipAddressList()
     * @uses TransferOrder::setFob()
     * @uses TransferOrder::setTranDate()
     * @uses TransferOrder::setTranId()
     * @uses TransferOrder::setSource()
     * @uses TransferOrder::setOrderStatus()
     * @uses TransferOrder::setSubsidiary()
     * @uses TransferOrder::setEmployee()
     * @uses TransferOrder::setUseItemCostAsTransferCost()
     * @uses TransferOrder::setIncoterm()
     * @uses TransferOrder::setFirmed()
     * @uses TransferOrder::setDepartment()
     * @uses TransferOrder::setClass()
     * @uses TransferOrder::setLocation()
     * @uses TransferOrder::setTransferLocation()
     * @uses TransferOrder::setMemo()
     * @uses TransferOrder::setShipDate()
     * @uses TransferOrder::setShipMethod()
     * @uses TransferOrder::setTrackingNumbers()
     * @uses TransferOrder::setLinkedTrackingNumbers()
     * @uses TransferOrder::setShipComplete()
     * @uses TransferOrder::setAltShippingCost()
     * @uses TransferOrder::setShippingTax1Rate()
     * @uses TransferOrder::setShippingTax2Rate()
     * @uses TransferOrder::setHandlingTax1Rate()
     * @uses TransferOrder::setHandlingTax2Rate()
     * @uses TransferOrder::setShippingTaxCode()
     * @uses TransferOrder::setHandlingTaxCode()
     * @uses TransferOrder::setTotal()
     * @uses TransferOrder::setItemList()
     * @uses TransferOrder::setAccountingBookDetailList()
     * @uses TransferOrder::setCustomFieldList()
     * @uses TransferOrder::setInternalId()
     * @uses TransferOrder::setExternalId()
     * @param string $createdDate
     * @param string $lastModifiedDate
     * @param \StructType\RecordRef $customForm
     * @param float $shippingCost
     * @param float $subTotal
     * @param string $status
     * @param \StructType\Address $shippingAddress
     * @param bool $shipIsResidential
     * @param \StructType\RecordRef $shipAddressList
     * @param string $fob
     * @param string $tranDate
     * @param string $tranId
     * @param string $source
     * @param string $orderStatus
     * @param \StructType\RecordRef $subsidiary
     * @param \StructType\RecordRef $employee
     * @param bool $useItemCostAsTransferCost
     * @param \StructType\RecordRef $incoterm
     * @param bool $firmed
     * @param \StructType\RecordRef $department
     * @param \StructType\RecordRef $class
     * @param \StructType\RecordRef $location
     * @param \StructType\RecordRef $transferLocation
     * @param string $memo
     * @param string $shipDate
     * @param \StructType\RecordRef $shipMethod
     * @param string $trackingNumbers
     * @param string $linkedTrackingNumbers
     * @param bool $shipComplete
     * @param float $altShippingCost
     * @param float $shippingTax1Rate
     * @param float $shippingTax2Rate
     * @param float $handlingTax1Rate
     * @param float $handlingTax2Rate
     * @param \StructType\RecordRef $shippingTaxCode
     * @param \StructType\RecordRef $handlingTaxCode
     * @param float $total
     * @param \StructType\TransferOrderItemList $itemList
     * @param \StructType\AccountingBookDetailList $accountingBookDetailList
     * @param \StructType\CustomFieldList $customFieldList
     * @param string $internalId
     * @param string $externalId
     */
    public function __construct($createdDate = null, $lastModifiedDate = null, \StructType\RecordRef $customForm = null, $shippingCost = null, $subTotal = null, $status = null, \StructType\Address $shippingAddress = null, $shipIsResidential = null, \StructType\RecordRef $shipAddressList = null, $fob = null, $tranDate = null, $tranId = null, $source = null, $orderStatus = null, \StructType\RecordRef $subsidiary = null, \StructType\RecordRef $employee = null, $useItemCostAsTransferCost = null, \StructType\RecordRef $incoterm = null, $firmed = null, \StructType\RecordRef $department = null, \StructType\RecordRef $class = null, \StructType\RecordRef $location = null, \StructType\RecordRef $transferLocation = null, $memo = null, $shipDate = null, \StructType\RecordRef $shipMethod = null, $trackingNumbers = null, $linkedTrackingNumbers = null, $shipComplete = null, $altShippingCost = null, $shippingTax1Rate = null, $shippingTax2Rate = null, $handlingTax1Rate = null, $handlingTax2Rate = null, \StructType\RecordRef $shippingTaxCode = null, \StructType\RecordRef $handlingTaxCode = null, $total = null, \StructType\TransferOrderItemList $itemList = null, \StructType\AccountingBookDetailList $accountingBookDetailList = null, \StructType\CustomFieldList $customFieldList = null, $internalId = null, $externalId = null)
    {
        $this
            ->setCreatedDate($createdDate)
            ->setLastModifiedDate($lastModifiedDate)
            ->setCustomForm($customForm)
            ->setShippingCost($shippingCost)
            ->setSubTotal($subTotal)
            ->setStatus($status)
            ->setShippingAddress($shippingAddress)
            ->setShipIsResidential($shipIsResidential)
            ->setShipAddressList($shipAddressList)
            ->setFob($fob)
            ->setTranDate($tranDate)
            ->setTranId($tranId)
            ->setSource($source)
            ->setOrderStatus($orderStatus)
            ->setSubsidiary($subsidiary)
            ->setEmployee($employee)
            ->setUseItemCostAsTransferCost($useItemCostAsTransferCost)
            ->setIncoterm($incoterm)
            ->setFirmed($firmed)
            ->setDepartment($department)
            ->setClass($class)
            ->setLocation($location)
            ->setTransferLocation($transferLocation)
            ->setMemo($memo)
            ->setShipDate($shipDate)
            ->setShipMethod($shipMethod)
            ->setTrackingNumbers($trackingNumbers)
            ->setLinkedTrackingNumbers($linkedTrackingNumbers)
            ->setShipComplete($shipComplete)
            ->setAltShippingCost($altShippingCost)
            ->setShippingTax1Rate($shippingTax1Rate)
            ->setShippingTax2Rate($shippingTax2Rate)
            ->setHandlingTax1Rate($handlingTax1Rate)
            ->setHandlingTax2Rate($handlingTax2Rate)
            ->setShippingTaxCode($shippingTaxCode)
            ->setHandlingTaxCode($handlingTaxCode)
            ->setTotal($total)
            ->setItemList($itemList)
            ->setAccountingBookDetailList($accountingBookDetailList)
            ->setCustomFieldList($customFieldList)
            ->setInternalId($internalId)
            ->setExternalId($externalId);
    }
    /**
     * Get createdDate value
     * @return string|null
     */
    public function getCreatedDate()
    {
        return $this->createdDate;
    }
    /**
     * Set createdDate value
     * @param string $createdDate
     * @return \StructType\TransferOrder
     */
    public function setCreatedDate($createdDate = null)
    {
        // validation for constraint: string
        if (!is_null($createdDate) && !is_string($createdDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createdDate, true), gettype($createdDate)), __LINE__);
        }
        $this->createdDate = $createdDate;
        return $this;
    }
    /**
     * Get lastModifiedDate value
     * @return string|null
     */
    public function getLastModifiedDate()
    {
        return $this->lastModifiedDate;
    }
    /**
     * Set lastModifiedDate value
     * @param string $lastModifiedDate
     * @return \StructType\TransferOrder
     */
    public function setLastModifiedDate($lastModifiedDate = null)
    {
        // validation for constraint: string
        if (!is_null($lastModifiedDate) && !is_string($lastModifiedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastModifiedDate, true), gettype($lastModifiedDate)), __LINE__);
        }
        $this->lastModifiedDate = $lastModifiedDate;
        return $this;
    }
    /**
     * Get customForm value
     * @return \StructType\RecordRef|null
     */
    public function getCustomForm()
    {
        return $this->customForm;
    }
    /**
     * Set customForm value
     * @param \StructType\RecordRef $customForm
     * @return \StructType\TransferOrder
     */
    public function setCustomForm(\StructType\RecordRef $customForm = null)
    {
        $this->customForm = $customForm;
        return $this;
    }
    /**
     * Get shippingCost value
     * @return float|null
     */
    public function getShippingCost()
    {
        return $this->shippingCost;
    }
    /**
     * Set shippingCost value
     * @param float $shippingCost
     * @return \StructType\TransferOrder
     */
    public function setShippingCost($shippingCost = null)
    {
        // validation for constraint: float
        if (!is_null($shippingCost) && !(is_float($shippingCost) || is_numeric($shippingCost))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($shippingCost, true), gettype($shippingCost)), __LINE__);
        }
        $this->shippingCost = $shippingCost;
        return $this;
    }
    /**
     * Get subTotal value
     * @return float|null
     */
    public function getSubTotal()
    {
        return $this->subTotal;
    }
    /**
     * Set subTotal value
     * @param float $subTotal
     * @return \StructType\TransferOrder
     */
    public function setSubTotal($subTotal = null)
    {
        // validation for constraint: float
        if (!is_null($subTotal) && !(is_float($subTotal) || is_numeric($subTotal))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($subTotal, true), gettype($subTotal)), __LINE__);
        }
        $this->subTotal = $subTotal;
        return $this;
    }
    /**
     * Get status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->status;
    }
    /**
     * Set status value
     * @param string $status
     * @return \StructType\TransferOrder
     */
    public function setStatus($status = null)
    {
        // validation for constraint: string
        if (!is_null($status) && !is_string($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($status, true), gettype($status)), __LINE__);
        }
        $this->status = $status;
        return $this;
    }
    /**
     * Get shippingAddress value
     * @return \StructType\Address|null
     */
    public function getShippingAddress()
    {
        return $this->shippingAddress;
    }
    /**
     * Set shippingAddress value
     * @param \StructType\Address $shippingAddress
     * @return \StructType\TransferOrder
     */
    public function setShippingAddress(\StructType\Address $shippingAddress = null)
    {
        $this->shippingAddress = $shippingAddress;
        return $this;
    }
    /**
     * Get shipIsResidential value
     * @return bool|null
     */
    public function getShipIsResidential()
    {
        return $this->shipIsResidential;
    }
    /**
     * Set shipIsResidential value
     * @param bool $shipIsResidential
     * @return \StructType\TransferOrder
     */
    public function setShipIsResidential($shipIsResidential = null)
    {
        // validation for constraint: boolean
        if (!is_null($shipIsResidential) && !is_bool($shipIsResidential)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($shipIsResidential, true), gettype($shipIsResidential)), __LINE__);
        }
        $this->shipIsResidential = $shipIsResidential;
        return $this;
    }
    /**
     * Get shipAddressList value
     * @return \StructType\RecordRef|null
     */
    public function getShipAddressList()
    {
        return $this->shipAddressList;
    }
    /**
     * Set shipAddressList value
     * @param \StructType\RecordRef $shipAddressList
     * @return \StructType\TransferOrder
     */
    public function setShipAddressList(\StructType\RecordRef $shipAddressList = null)
    {
        $this->shipAddressList = $shipAddressList;
        return $this;
    }
    /**
     * Get fob value
     * @return string|null
     */
    public function getFob()
    {
        return $this->fob;
    }
    /**
     * Set fob value
     * @param string $fob
     * @return \StructType\TransferOrder
     */
    public function setFob($fob = null)
    {
        // validation for constraint: string
        if (!is_null($fob) && !is_string($fob)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fob, true), gettype($fob)), __LINE__);
        }
        $this->fob = $fob;
        return $this;
    }
    /**
     * Get tranDate value
     * @return string|null
     */
    public function getTranDate()
    {
        return $this->tranDate;
    }
    /**
     * Set tranDate value
     * @param string $tranDate
     * @return \StructType\TransferOrder
     */
    public function setTranDate($tranDate = null)
    {
        // validation for constraint: string
        if (!is_null($tranDate) && !is_string($tranDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tranDate, true), gettype($tranDate)), __LINE__);
        }
        $this->tranDate = $tranDate;
        return $this;
    }
    /**
     * Get tranId value
     * @return string|null
     */
    public function getTranId()
    {
        return $this->tranId;
    }
    /**
     * Set tranId value
     * @param string $tranId
     * @return \StructType\TransferOrder
     */
    public function setTranId($tranId = null)
    {
        // validation for constraint: string
        if (!is_null($tranId) && !is_string($tranId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tranId, true), gettype($tranId)), __LINE__);
        }
        $this->tranId = $tranId;
        return $this;
    }
    /**
     * Get source value
     * @return string|null
     */
    public function getSource()
    {
        return $this->source;
    }
    /**
     * Set source value
     * @param string $source
     * @return \StructType\TransferOrder
     */
    public function setSource($source = null)
    {
        // validation for constraint: string
        if (!is_null($source) && !is_string($source)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($source, true), gettype($source)), __LINE__);
        }
        $this->source = $source;
        return $this;
    }
    /**
     * Get orderStatus value
     * @return string|null
     */
    public function getOrderStatus()
    {
        return $this->orderStatus;
    }
    /**
     * Set orderStatus value
     * @uses \EnumType\TransferOrderOrderStatus::valueIsValid()
     * @uses \EnumType\TransferOrderOrderStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $orderStatus
     * @return \StructType\TransferOrder
     */
    public function setOrderStatus($orderStatus = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\TransferOrderOrderStatus::valueIsValid($orderStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\TransferOrderOrderStatus', is_array($orderStatus) ? implode(', ', $orderStatus) : var_export($orderStatus, true), implode(', ', \EnumType\TransferOrderOrderStatus::getValidValues())), __LINE__);
        }
        $this->orderStatus = $orderStatus;
        return $this;
    }
    /**
     * Get subsidiary value
     * @return \StructType\RecordRef|null
     */
    public function getSubsidiary()
    {
        return $this->subsidiary;
    }
    /**
     * Set subsidiary value
     * @param \StructType\RecordRef $subsidiary
     * @return \StructType\TransferOrder
     */
    public function setSubsidiary(\StructType\RecordRef $subsidiary = null)
    {
        $this->subsidiary = $subsidiary;
        return $this;
    }
    /**
     * Get employee value
     * @return \StructType\RecordRef|null
     */
    public function getEmployee()
    {
        return $this->employee;
    }
    /**
     * Set employee value
     * @param \StructType\RecordRef $employee
     * @return \StructType\TransferOrder
     */
    public function setEmployee(\StructType\RecordRef $employee = null)
    {
        $this->employee = $employee;
        return $this;
    }
    /**
     * Get useItemCostAsTransferCost value
     * @return bool|null
     */
    public function getUseItemCostAsTransferCost()
    {
        return $this->useItemCostAsTransferCost;
    }
    /**
     * Set useItemCostAsTransferCost value
     * @param bool $useItemCostAsTransferCost
     * @return \StructType\TransferOrder
     */
    public function setUseItemCostAsTransferCost($useItemCostAsTransferCost = null)
    {
        // validation for constraint: boolean
        if (!is_null($useItemCostAsTransferCost) && !is_bool($useItemCostAsTransferCost)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($useItemCostAsTransferCost, true), gettype($useItemCostAsTransferCost)), __LINE__);
        }
        $this->useItemCostAsTransferCost = $useItemCostAsTransferCost;
        return $this;
    }
    /**
     * Get incoterm value
     * @return \StructType\RecordRef|null
     */
    public function getIncoterm()
    {
        return $this->incoterm;
    }
    /**
     * Set incoterm value
     * @param \StructType\RecordRef $incoterm
     * @return \StructType\TransferOrder
     */
    public function setIncoterm(\StructType\RecordRef $incoterm = null)
    {
        $this->incoterm = $incoterm;
        return $this;
    }
    /**
     * Get firmed value
     * @return bool|null
     */
    public function getFirmed()
    {
        return $this->firmed;
    }
    /**
     * Set firmed value
     * @param bool $firmed
     * @return \StructType\TransferOrder
     */
    public function setFirmed($firmed = null)
    {
        // validation for constraint: boolean
        if (!is_null($firmed) && !is_bool($firmed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($firmed, true), gettype($firmed)), __LINE__);
        }
        $this->firmed = $firmed;
        return $this;
    }
    /**
     * Get department value
     * @return \StructType\RecordRef|null
     */
    public function getDepartment()
    {
        return $this->department;
    }
    /**
     * Set department value
     * @param \StructType\RecordRef $department
     * @return \StructType\TransferOrder
     */
    public function setDepartment(\StructType\RecordRef $department = null)
    {
        $this->department = $department;
        return $this;
    }
    /**
     * Get class value
     * @return \StructType\RecordRef|null
     */
    public function getClass()
    {
        return $this->class;
    }
    /**
     * Set class value
     * @param \StructType\RecordRef $class
     * @return \StructType\TransferOrder
     */
    public function setClass(\StructType\RecordRef $class = null)
    {
        $this->class = $class;
        return $this;
    }
    /**
     * Get location value
     * @return \StructType\RecordRef|null
     */
    public function getLocation()
    {
        return $this->location;
    }
    /**
     * Set location value
     * @param \StructType\RecordRef $location
     * @return \StructType\TransferOrder
     */
    public function setLocation(\StructType\RecordRef $location = null)
    {
        $this->location = $location;
        return $this;
    }
    /**
     * Get transferLocation value
     * @return \StructType\RecordRef|null
     */
    public function getTransferLocation()
    {
        return $this->transferLocation;
    }
    /**
     * Set transferLocation value
     * @param \StructType\RecordRef $transferLocation
     * @return \StructType\TransferOrder
     */
    public function setTransferLocation(\StructType\RecordRef $transferLocation = null)
    {
        $this->transferLocation = $transferLocation;
        return $this;
    }
    /**
     * Get memo value
     * @return string|null
     */
    public function getMemo()
    {
        return $this->memo;
    }
    /**
     * Set memo value
     * @param string $memo
     * @return \StructType\TransferOrder
     */
    public function setMemo($memo = null)
    {
        // validation for constraint: string
        if (!is_null($memo) && !is_string($memo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($memo, true), gettype($memo)), __LINE__);
        }
        $this->memo = $memo;
        return $this;
    }
    /**
     * Get shipDate value
     * @return string|null
     */
    public function getShipDate()
    {
        return $this->shipDate;
    }
    /**
     * Set shipDate value
     * @param string $shipDate
     * @return \StructType\TransferOrder
     */
    public function setShipDate($shipDate = null)
    {
        // validation for constraint: string
        if (!is_null($shipDate) && !is_string($shipDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shipDate, true), gettype($shipDate)), __LINE__);
        }
        $this->shipDate = $shipDate;
        return $this;
    }
    /**
     * Get shipMethod value
     * @return \StructType\RecordRef|null
     */
    public function getShipMethod()
    {
        return $this->shipMethod;
    }
    /**
     * Set shipMethod value
     * @param \StructType\RecordRef $shipMethod
     * @return \StructType\TransferOrder
     */
    public function setShipMethod(\StructType\RecordRef $shipMethod = null)
    {
        $this->shipMethod = $shipMethod;
        return $this;
    }
    /**
     * Get trackingNumbers value
     * @return string|null
     */
    public function getTrackingNumbers()
    {
        return $this->trackingNumbers;
    }
    /**
     * Set trackingNumbers value
     * @param string $trackingNumbers
     * @return \StructType\TransferOrder
     */
    public function setTrackingNumbers($trackingNumbers = null)
    {
        // validation for constraint: string
        if (!is_null($trackingNumbers) && !is_string($trackingNumbers)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($trackingNumbers, true), gettype($trackingNumbers)), __LINE__);
        }
        $this->trackingNumbers = $trackingNumbers;
        return $this;
    }
    /**
     * Get linkedTrackingNumbers value
     * @return string|null
     */
    public function getLinkedTrackingNumbers()
    {
        return $this->linkedTrackingNumbers;
    }
    /**
     * Set linkedTrackingNumbers value
     * @param string $linkedTrackingNumbers
     * @return \StructType\TransferOrder
     */
    public function setLinkedTrackingNumbers($linkedTrackingNumbers = null)
    {
        // validation for constraint: string
        if (!is_null($linkedTrackingNumbers) && !is_string($linkedTrackingNumbers)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($linkedTrackingNumbers, true), gettype($linkedTrackingNumbers)), __LINE__);
        }
        $this->linkedTrackingNumbers = $linkedTrackingNumbers;
        return $this;
    }
    /**
     * Get shipComplete value
     * @return bool|null
     */
    public function getShipComplete()
    {
        return $this->shipComplete;
    }
    /**
     * Set shipComplete value
     * @param bool $shipComplete
     * @return \StructType\TransferOrder
     */
    public function setShipComplete($shipComplete = null)
    {
        // validation for constraint: boolean
        if (!is_null($shipComplete) && !is_bool($shipComplete)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($shipComplete, true), gettype($shipComplete)), __LINE__);
        }
        $this->shipComplete = $shipComplete;
        return $this;
    }
    /**
     * Get altShippingCost value
     * @return float|null
     */
    public function getAltShippingCost()
    {
        return $this->altShippingCost;
    }
    /**
     * Set altShippingCost value
     * @param float $altShippingCost
     * @return \StructType\TransferOrder
     */
    public function setAltShippingCost($altShippingCost = null)
    {
        // validation for constraint: float
        if (!is_null($altShippingCost) && !(is_float($altShippingCost) || is_numeric($altShippingCost))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($altShippingCost, true), gettype($altShippingCost)), __LINE__);
        }
        $this->altShippingCost = $altShippingCost;
        return $this;
    }
    /**
     * Get shippingTax1Rate value
     * @return float|null
     */
    public function getShippingTax1Rate()
    {
        return $this->shippingTax1Rate;
    }
    /**
     * Set shippingTax1Rate value
     * @param float $shippingTax1Rate
     * @return \StructType\TransferOrder
     */
    public function setShippingTax1Rate($shippingTax1Rate = null)
    {
        // validation for constraint: float
        if (!is_null($shippingTax1Rate) && !(is_float($shippingTax1Rate) || is_numeric($shippingTax1Rate))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($shippingTax1Rate, true), gettype($shippingTax1Rate)), __LINE__);
        }
        $this->shippingTax1Rate = $shippingTax1Rate;
        return $this;
    }
    /**
     * Get shippingTax2Rate value
     * @return float|null
     */
    public function getShippingTax2Rate()
    {
        return $this->shippingTax2Rate;
    }
    /**
     * Set shippingTax2Rate value
     * @param float $shippingTax2Rate
     * @return \StructType\TransferOrder
     */
    public function setShippingTax2Rate($shippingTax2Rate = null)
    {
        // validation for constraint: float
        if (!is_null($shippingTax2Rate) && !(is_float($shippingTax2Rate) || is_numeric($shippingTax2Rate))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($shippingTax2Rate, true), gettype($shippingTax2Rate)), __LINE__);
        }
        $this->shippingTax2Rate = $shippingTax2Rate;
        return $this;
    }
    /**
     * Get handlingTax1Rate value
     * @return float|null
     */
    public function getHandlingTax1Rate()
    {
        return $this->handlingTax1Rate;
    }
    /**
     * Set handlingTax1Rate value
     * @param float $handlingTax1Rate
     * @return \StructType\TransferOrder
     */
    public function setHandlingTax1Rate($handlingTax1Rate = null)
    {
        // validation for constraint: float
        if (!is_null($handlingTax1Rate) && !(is_float($handlingTax1Rate) || is_numeric($handlingTax1Rate))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($handlingTax1Rate, true), gettype($handlingTax1Rate)), __LINE__);
        }
        $this->handlingTax1Rate = $handlingTax1Rate;
        return $this;
    }
    /**
     * Get handlingTax2Rate value
     * @return float|null
     */
    public function getHandlingTax2Rate()
    {
        return $this->handlingTax2Rate;
    }
    /**
     * Set handlingTax2Rate value
     * @param float $handlingTax2Rate
     * @return \StructType\TransferOrder
     */
    public function setHandlingTax2Rate($handlingTax2Rate = null)
    {
        // validation for constraint: float
        if (!is_null($handlingTax2Rate) && !(is_float($handlingTax2Rate) || is_numeric($handlingTax2Rate))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($handlingTax2Rate, true), gettype($handlingTax2Rate)), __LINE__);
        }
        $this->handlingTax2Rate = $handlingTax2Rate;
        return $this;
    }
    /**
     * Get shippingTaxCode value
     * @return \StructType\RecordRef|null
     */
    public function getShippingTaxCode()
    {
        return $this->shippingTaxCode;
    }
    /**
     * Set shippingTaxCode value
     * @param \StructType\RecordRef $shippingTaxCode
     * @return \StructType\TransferOrder
     */
    public function setShippingTaxCode(\StructType\RecordRef $shippingTaxCode = null)
    {
        $this->shippingTaxCode = $shippingTaxCode;
        return $this;
    }
    /**
     * Get handlingTaxCode value
     * @return \StructType\RecordRef|null
     */
    public function getHandlingTaxCode()
    {
        return $this->handlingTaxCode;
    }
    /**
     * Set handlingTaxCode value
     * @param \StructType\RecordRef $handlingTaxCode
     * @return \StructType\TransferOrder
     */
    public function setHandlingTaxCode(\StructType\RecordRef $handlingTaxCode = null)
    {
        $this->handlingTaxCode = $handlingTaxCode;
        return $this;
    }
    /**
     * Get total value
     * @return float|null
     */
    public function getTotal()
    {
        return $this->total;
    }
    /**
     * Set total value
     * @param float $total
     * @return \StructType\TransferOrder
     */
    public function setTotal($total = null)
    {
        // validation for constraint: float
        if (!is_null($total) && !(is_float($total) || is_numeric($total))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($total, true), gettype($total)), __LINE__);
        }
        $this->total = $total;
        return $this;
    }
    /**
     * Get itemList value
     * @return \StructType\TransferOrderItemList|null
     */
    public function getItemList()
    {
        return $this->itemList;
    }
    /**
     * Set itemList value
     * @param \StructType\TransferOrderItemList $itemList
     * @return \StructType\TransferOrder
     */
    public function setItemList(\StructType\TransferOrderItemList $itemList = null)
    {
        $this->itemList = $itemList;
        return $this;
    }
    /**
     * Get accountingBookDetailList value
     * @return \StructType\AccountingBookDetailList|null
     */
    public function getAccountingBookDetailList()
    {
        return $this->accountingBookDetailList;
    }
    /**
     * Set accountingBookDetailList value
     * @param \StructType\AccountingBookDetailList $accountingBookDetailList
     * @return \StructType\TransferOrder
     */
    public function setAccountingBookDetailList(\StructType\AccountingBookDetailList $accountingBookDetailList = null)
    {
        $this->accountingBookDetailList = $accountingBookDetailList;
        return $this;
    }
    /**
     * Get customFieldList value
     * @return \StructType\CustomFieldList|null
     */
    public function getCustomFieldList()
    {
        return $this->customFieldList;
    }
    /**
     * Set customFieldList value
     * @param \StructType\CustomFieldList $customFieldList
     * @return \StructType\TransferOrder
     */
    public function setCustomFieldList(\StructType\CustomFieldList $customFieldList = null)
    {
        $this->customFieldList = $customFieldList;
        return $this;
    }
    /**
     * Get internalId value
     * @return string|null
     */
    public function getInternalId()
    {
        return $this->internalId;
    }
    /**
     * Set internalId value
     * @param string $internalId
     * @return \StructType\TransferOrder
     */
    public function setInternalId($internalId = null)
    {
        // validation for constraint: string
        if (!is_null($internalId) && !is_string($internalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($internalId, true), gettype($internalId)), __LINE__);
        }
        $this->internalId = $internalId;
        return $this;
    }
    /**
     * Get externalId value
     * @return string|null
     */
    public function getExternalId()
    {
        return $this->externalId;
    }
    /**
     * Set externalId value
     * @param string $externalId
     * @return \StructType\TransferOrder
     */
    public function setExternalId($externalId = null)
    {
        // validation for constraint: string
        if (!is_null($externalId) && !is_string($externalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($externalId, true), gettype($externalId)), __LINE__);
        }
        $this->externalId = $externalId;
        return $this;
    }
}
