<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TransactionColumnCustomFieldFilterList StructType
 * @subpackage Structs
 */
class TransactionColumnCustomFieldFilterList extends AbstractStructBase
{
    /**
     * The filter
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\TransactionColumnCustomFieldFilter[]
     */
    public $filter;
    /**
     * The replaceAll
     * Meta information extracted from the WSDL
     * - default: true
     * @var bool
     */
    public $replaceAll;
    /**
     * Constructor method for TransactionColumnCustomFieldFilterList
     * @uses TransactionColumnCustomFieldFilterList::setFilter()
     * @uses TransactionColumnCustomFieldFilterList::setReplaceAll()
     * @param \StructType\TransactionColumnCustomFieldFilter[] $filter
     * @param bool $replaceAll
     */
    public function __construct(array $filter = array(), $replaceAll = true)
    {
        $this
            ->setFilter($filter)
            ->setReplaceAll($replaceAll);
    }
    /**
     * Get filter value
     * @return \StructType\TransactionColumnCustomFieldFilter[]|null
     */
    public function getFilter()
    {
        return $this->filter;
    }
    /**
     * This method is responsible for validating the values passed to the setFilter method
     * This method is willingly generated in order to preserve the one-line inline validation within the setFilter method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateFilterForArrayConstraintsFromSetFilter(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $transactionColumnCustomFieldFilterListFilterItem) {
            // validation for constraint: itemType
            if (!$transactionColumnCustomFieldFilterListFilterItem instanceof \StructType\TransactionColumnCustomFieldFilter) {
                $invalidValues[] = is_object($transactionColumnCustomFieldFilterListFilterItem) ? get_class($transactionColumnCustomFieldFilterListFilterItem) : sprintf('%s(%s)', gettype($transactionColumnCustomFieldFilterListFilterItem), var_export($transactionColumnCustomFieldFilterListFilterItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The filter property can only contain items of type \StructType\TransactionColumnCustomFieldFilter, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set filter value
     * @throws \InvalidArgumentException
     * @param \StructType\TransactionColumnCustomFieldFilter[] $filter
     * @return \StructType\TransactionColumnCustomFieldFilterList
     */
    public function setFilter(array $filter = array())
    {
        // validation for constraint: array
        if ('' !== ($filterArrayErrorMessage = self::validateFilterForArrayConstraintsFromSetFilter($filter))) {
            throw new \InvalidArgumentException($filterArrayErrorMessage, __LINE__);
        }
        $this->filter = $filter;
        return $this;
    }
    /**
     * Add item to filter value
     * @throws \InvalidArgumentException
     * @param \StructType\TransactionColumnCustomFieldFilter $item
     * @return \StructType\TransactionColumnCustomFieldFilterList
     */
    public function addToFilter(\StructType\TransactionColumnCustomFieldFilter $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\TransactionColumnCustomFieldFilter) {
            throw new \InvalidArgumentException(sprintf('The filter property can only contain items of type \StructType\TransactionColumnCustomFieldFilter, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->filter[] = $item;
        return $this;
    }
    /**
     * Get replaceAll value
     * @return bool|null
     */
    public function getReplaceAll()
    {
        return $this->replaceAll;
    }
    /**
     * Set replaceAll value
     * @param bool $replaceAll
     * @return \StructType\TransactionColumnCustomFieldFilterList
     */
    public function setReplaceAll($replaceAll = true)
    {
        // validation for constraint: boolean
        if (!is_null($replaceAll) && !is_bool($replaceAll)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($replaceAll, true), gettype($replaceAll)), __LINE__);
        }
        $this->replaceAll = $replaceAll;
        return $this;
    }
}
