<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TopicSolution StructType
 * @subpackage Structs
 */
class TopicSolution extends AbstractStructBase
{
    /**
     * The solution
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $solution;
    /**
     * The message
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $message;
    /**
     * Constructor method for TopicSolution
     * @uses TopicSolution::setSolution()
     * @uses TopicSolution::setMessage()
     * @param \StructType\RecordRef $solution
     * @param string $message
     */
    public function __construct(\StructType\RecordRef $solution = null, $message = null)
    {
        $this
            ->setSolution($solution)
            ->setMessage($message);
    }
    /**
     * Get solution value
     * @return \StructType\RecordRef|null
     */
    public function getSolution()
    {
        return $this->solution;
    }
    /**
     * Set solution value
     * @param \StructType\RecordRef $solution
     * @return \StructType\TopicSolution
     */
    public function setSolution(\StructType\RecordRef $solution = null)
    {
        $this->solution = $solution;
        return $this;
    }
    /**
     * Get message value
     * @return string|null
     */
    public function getMessage()
    {
        return $this->message;
    }
    /**
     * Set message value
     * @param string $message
     * @return \StructType\TopicSolution
     */
    public function setMessage($message = null)
    {
        // validation for constraint: string
        if (!is_null($message) && !is_string($message)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($message, true), gettype($message)), __LINE__);
        }
        $this->message = $message;
        return $this;
    }
}
