<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Topic StructType
 * Meta information extracted from the WSDL
 * - type: listSupport:Topic
 * @subpackage Structs
 */
class Topic extends Record
{
    /**
     * The title
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $title;
    /**
     * The parentTopic
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $parentTopic;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $description;
    /**
     * The isInactive
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $isInactive;
    /**
     * The longDescription
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $longDescription;
    /**
     * The solutionList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\TopicSolutionList
     */
    public $solutionList;
    /**
     * The internalId
     * @var string
     */
    public $internalId;
    /**
     * The externalId
     * @var string
     */
    public $externalId;
    /**
     * Constructor method for Topic
     * @uses Topic::setTitle()
     * @uses Topic::setParentTopic()
     * @uses Topic::setDescription()
     * @uses Topic::setIsInactive()
     * @uses Topic::setLongDescription()
     * @uses Topic::setSolutionList()
     * @uses Topic::setInternalId()
     * @uses Topic::setExternalId()
     * @param string $title
     * @param \StructType\RecordRef $parentTopic
     * @param string $description
     * @param bool $isInactive
     * @param string $longDescription
     * @param \StructType\TopicSolutionList $solutionList
     * @param string $internalId
     * @param string $externalId
     */
    public function __construct($title = null, \StructType\RecordRef $parentTopic = null, $description = null, $isInactive = null, $longDescription = null, \StructType\TopicSolutionList $solutionList = null, $internalId = null, $externalId = null)
    {
        $this
            ->setTitle($title)
            ->setParentTopic($parentTopic)
            ->setDescription($description)
            ->setIsInactive($isInactive)
            ->setLongDescription($longDescription)
            ->setSolutionList($solutionList)
            ->setInternalId($internalId)
            ->setExternalId($externalId);
    }
    /**
     * Get title value
     * @return string|null
     */
    public function getTitle()
    {
        return $this->title;
    }
    /**
     * Set title value
     * @param string $title
     * @return \StructType\Topic
     */
    public function setTitle($title = null)
    {
        // validation for constraint: string
        if (!is_null($title) && !is_string($title)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($title, true), gettype($title)), __LINE__);
        }
        $this->title = $title;
        return $this;
    }
    /**
     * Get parentTopic value
     * @return \StructType\RecordRef|null
     */
    public function getParentTopic()
    {
        return $this->parentTopic;
    }
    /**
     * Set parentTopic value
     * @param \StructType\RecordRef $parentTopic
     * @return \StructType\Topic
     */
    public function setParentTopic(\StructType\RecordRef $parentTopic = null)
    {
        $this->parentTopic = $parentTopic;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\Topic
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get isInactive value
     * @return bool|null
     */
    public function getIsInactive()
    {
        return $this->isInactive;
    }
    /**
     * Set isInactive value
     * @param bool $isInactive
     * @return \StructType\Topic
     */
    public function setIsInactive($isInactive = null)
    {
        // validation for constraint: boolean
        if (!is_null($isInactive) && !is_bool($isInactive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isInactive, true), gettype($isInactive)), __LINE__);
        }
        $this->isInactive = $isInactive;
        return $this;
    }
    /**
     * Get longDescription value
     * @return string|null
     */
    public function getLongDescription()
    {
        return $this->longDescription;
    }
    /**
     * Set longDescription value
     * @param string $longDescription
     * @return \StructType\Topic
     */
    public function setLongDescription($longDescription = null)
    {
        // validation for constraint: string
        if (!is_null($longDescription) && !is_string($longDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($longDescription, true), gettype($longDescription)), __LINE__);
        }
        $this->longDescription = $longDescription;
        return $this;
    }
    /**
     * Get solutionList value
     * @return \StructType\TopicSolutionList|null
     */
    public function getSolutionList()
    {
        return $this->solutionList;
    }
    /**
     * Set solutionList value
     * @param \StructType\TopicSolutionList $solutionList
     * @return \StructType\Topic
     */
    public function setSolutionList(\StructType\TopicSolutionList $solutionList = null)
    {
        $this->solutionList = $solutionList;
        return $this;
    }
    /**
     * Get internalId value
     * @return string|null
     */
    public function getInternalId()
    {
        return $this->internalId;
    }
    /**
     * Set internalId value
     * @param string $internalId
     * @return \StructType\Topic
     */
    public function setInternalId($internalId = null)
    {
        // validation for constraint: string
        if (!is_null($internalId) && !is_string($internalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($internalId, true), gettype($internalId)), __LINE__);
        }
        $this->internalId = $internalId;
        return $this;
    }
    /**
     * Get externalId value
     * @return string|null
     */
    public function getExternalId()
    {
        return $this->externalId;
    }
    /**
     * Set externalId value
     * @param string $externalId
     * @return \StructType\Topic
     */
    public function setExternalId($externalId = null)
    {
        // validation for constraint: string
        if (!is_null($externalId) && !is_string($externalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($externalId, true), gettype($externalId)), __LINE__);
        }
        $this->externalId = $externalId;
        return $this;
    }
}
