<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TokenPassport StructType
 * @subpackage Structs
 */
class TokenPassport extends AbstractStructBase
{
    /**
     * The account
     * @var string
     */
    public $account;
    /**
     * The consumerKey
     * @var string
     */
    public $consumerKey;
    /**
     * The token
     * @var string
     */
    public $token;
    /**
     * The nonce
     * @var string
     */
    public $nonce;
    /**
     * The timestamp
     * @var int
     */
    public $timestamp;
    /**
     * The signature
     * @var \StructType\TokenPassportSignature
     */
    public $signature;
    /**
     * Constructor method for TokenPassport
     * @uses TokenPassport::setAccount()
     * @uses TokenPassport::setConsumerKey()
     * @uses TokenPassport::setToken()
     * @uses TokenPassport::setNonce()
     * @uses TokenPassport::setTimestamp()
     * @uses TokenPassport::setSignature()
     * @param string $account
     * @param string $consumerKey
     * @param string $token
     * @param string $nonce
     * @param int $timestamp
     * @param \StructType\TokenPassportSignature $signature
     */
    public function __construct($account = null, $consumerKey = null, $token = null, $nonce = null, $timestamp = null, \StructType\TokenPassportSignature $signature = null)
    {
        $this
            ->setAccount($account)
            ->setConsumerKey($consumerKey)
            ->setToken($token)
            ->setNonce($nonce)
            ->setTimestamp($timestamp)
            ->setSignature($signature);
    }
    /**
     * Get account value
     * @return string|null
     */
    public function getAccount()
    {
        return $this->account;
    }
    /**
     * Set account value
     * @param string $account
     * @return \StructType\TokenPassport
     */
    public function setAccount($account = null)
    {
        // validation for constraint: string
        if (!is_null($account) && !is_string($account)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($account, true), gettype($account)), __LINE__);
        }
        $this->account = $account;
        return $this;
    }
    /**
     * Get consumerKey value
     * @return string|null
     */
    public function getConsumerKey()
    {
        return $this->consumerKey;
    }
    /**
     * Set consumerKey value
     * @param string $consumerKey
     * @return \StructType\TokenPassport
     */
    public function setConsumerKey($consumerKey = null)
    {
        // validation for constraint: string
        if (!is_null($consumerKey) && !is_string($consumerKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($consumerKey, true), gettype($consumerKey)), __LINE__);
        }
        $this->consumerKey = $consumerKey;
        return $this;
    }
    /**
     * Get token value
     * @return string|null
     */
    public function getToken()
    {
        return $this->token;
    }
    /**
     * Set token value
     * @param string $token
     * @return \StructType\TokenPassport
     */
    public function setToken($token = null)
    {
        // validation for constraint: string
        if (!is_null($token) && !is_string($token)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($token, true), gettype($token)), __LINE__);
        }
        $this->token = $token;
        return $this;
    }
    /**
     * Get nonce value
     * @return string|null
     */
    public function getNonce()
    {
        return $this->nonce;
    }
    /**
     * Set nonce value
     * @param string $nonce
     * @return \StructType\TokenPassport
     */
    public function setNonce($nonce = null)
    {
        // validation for constraint: string
        if (!is_null($nonce) && !is_string($nonce)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nonce, true), gettype($nonce)), __LINE__);
        }
        $this->nonce = $nonce;
        return $this;
    }
    /**
     * Get timestamp value
     * @return int|null
     */
    public function getTimestamp()
    {
        return $this->timestamp;
    }
    /**
     * Set timestamp value
     * @param int $timestamp
     * @return \StructType\TokenPassport
     */
    public function setTimestamp($timestamp = null)
    {
        // validation for constraint: int
        if (!is_null($timestamp) && !(is_int($timestamp) || ctype_digit($timestamp))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($timestamp, true), gettype($timestamp)), __LINE__);
        }
        $this->timestamp = $timestamp;
        return $this;
    }
    /**
     * Get signature value
     * @return \StructType\TokenPassportSignature|null
     */
    public function getSignature()
    {
        return $this->signature;
    }
    /**
     * Set signature value
     * @param \StructType\TokenPassportSignature $signature
     * @return \StructType\TokenPassport
     */
    public function setSignature(\StructType\TokenPassportSignature $signature = null)
    {
        $this->signature = $signature;
        return $this;
    }
}
