<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TimeSheetSearchRowBasic StructType
 * @subpackage Structs
 */
class TimeSheetSearchRowBasic extends SearchRowBasic
{
    /**
     * The approvalStatus
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnSelectField[]
     */
    public $approvalStatus;
    /**
     * The employee
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnSelectField[]
     */
    public $employee;
    /**
     * The endDate
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnDateField[]
     */
    public $endDate;
    /**
     * The externalId
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnSelectField[]
     */
    public $externalId;
    /**
     * The id
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnLongField[]
     */
    public $id;
    /**
     * The internalId
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnSelectField[]
     */
    public $internalId;
    /**
     * The startDate
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnDateField[]
     */
    public $startDate;
    /**
     * The totalHours
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnStringField[]
     */
    public $totalHours;
    /**
     * The customFieldList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SearchColumnCustomFieldList
     */
    public $customFieldList;
    /**
     * Constructor method for TimeSheetSearchRowBasic
     * @uses TimeSheetSearchRowBasic::setApprovalStatus()
     * @uses TimeSheetSearchRowBasic::setEmployee()
     * @uses TimeSheetSearchRowBasic::setEndDate()
     * @uses TimeSheetSearchRowBasic::setExternalId()
     * @uses TimeSheetSearchRowBasic::setId()
     * @uses TimeSheetSearchRowBasic::setInternalId()
     * @uses TimeSheetSearchRowBasic::setStartDate()
     * @uses TimeSheetSearchRowBasic::setTotalHours()
     * @uses TimeSheetSearchRowBasic::setCustomFieldList()
     * @param \StructType\SearchColumnSelectField[] $approvalStatus
     * @param \StructType\SearchColumnSelectField[] $employee
     * @param \StructType\SearchColumnDateField[] $endDate
     * @param \StructType\SearchColumnSelectField[] $externalId
     * @param \StructType\SearchColumnLongField[] $id
     * @param \StructType\SearchColumnSelectField[] $internalId
     * @param \StructType\SearchColumnDateField[] $startDate
     * @param \StructType\SearchColumnStringField[] $totalHours
     * @param \StructType\SearchColumnCustomFieldList $customFieldList
     */
    public function __construct(array $approvalStatus = array(), array $employee = array(), array $endDate = array(), array $externalId = array(), array $id = array(), array $internalId = array(), array $startDate = array(), array $totalHours = array(), \StructType\SearchColumnCustomFieldList $customFieldList = null)
    {
        $this
            ->setApprovalStatus($approvalStatus)
            ->setEmployee($employee)
            ->setEndDate($endDate)
            ->setExternalId($externalId)
            ->setId($id)
            ->setInternalId($internalId)
            ->setStartDate($startDate)
            ->setTotalHours($totalHours)
            ->setCustomFieldList($customFieldList);
    }
    /**
     * Get approvalStatus value
     * @return \StructType\SearchColumnSelectField[]|null
     */
    public function getApprovalStatus()
    {
        return $this->approvalStatus;
    }
    /**
     * This method is responsible for validating the values passed to the setApprovalStatus method
     * This method is willingly generated in order to preserve the one-line inline validation within the setApprovalStatus method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateApprovalStatusForArrayConstraintsFromSetApprovalStatus(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $timeSheetSearchRowBasicApprovalStatusItem) {
            // validation for constraint: itemType
            if (!$timeSheetSearchRowBasicApprovalStatusItem instanceof \StructType\SearchColumnSelectField) {
                $invalidValues[] = is_object($timeSheetSearchRowBasicApprovalStatusItem) ? get_class($timeSheetSearchRowBasicApprovalStatusItem) : sprintf('%s(%s)', gettype($timeSheetSearchRowBasicApprovalStatusItem), var_export($timeSheetSearchRowBasicApprovalStatusItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The approvalStatus property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set approvalStatus value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField[] $approvalStatus
     * @return \StructType\TimeSheetSearchRowBasic
     */
    public function setApprovalStatus(array $approvalStatus = array())
    {
        // validation for constraint: array
        if ('' !== ($approvalStatusArrayErrorMessage = self::validateApprovalStatusForArrayConstraintsFromSetApprovalStatus($approvalStatus))) {
            throw new \InvalidArgumentException($approvalStatusArrayErrorMessage, __LINE__);
        }
        $this->approvalStatus = $approvalStatus;
        return $this;
    }
    /**
     * Add item to approvalStatus value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField $item
     * @return \StructType\TimeSheetSearchRowBasic
     */
    public function addToApprovalStatus(\StructType\SearchColumnSelectField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnSelectField) {
            throw new \InvalidArgumentException(sprintf('The approvalStatus property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->approvalStatus[] = $item;
        return $this;
    }
    /**
     * Get employee value
     * @return \StructType\SearchColumnSelectField[]|null
     */
    public function getEmployee()
    {
        return $this->employee;
    }
    /**
     * This method is responsible for validating the values passed to the setEmployee method
     * This method is willingly generated in order to preserve the one-line inline validation within the setEmployee method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateEmployeeForArrayConstraintsFromSetEmployee(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $timeSheetSearchRowBasicEmployeeItem) {
            // validation for constraint: itemType
            if (!$timeSheetSearchRowBasicEmployeeItem instanceof \StructType\SearchColumnSelectField) {
                $invalidValues[] = is_object($timeSheetSearchRowBasicEmployeeItem) ? get_class($timeSheetSearchRowBasicEmployeeItem) : sprintf('%s(%s)', gettype($timeSheetSearchRowBasicEmployeeItem), var_export($timeSheetSearchRowBasicEmployeeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The employee property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set employee value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField[] $employee
     * @return \StructType\TimeSheetSearchRowBasic
     */
    public function setEmployee(array $employee = array())
    {
        // validation for constraint: array
        if ('' !== ($employeeArrayErrorMessage = self::validateEmployeeForArrayConstraintsFromSetEmployee($employee))) {
            throw new \InvalidArgumentException($employeeArrayErrorMessage, __LINE__);
        }
        $this->employee = $employee;
        return $this;
    }
    /**
     * Add item to employee value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField $item
     * @return \StructType\TimeSheetSearchRowBasic
     */
    public function addToEmployee(\StructType\SearchColumnSelectField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnSelectField) {
            throw new \InvalidArgumentException(sprintf('The employee property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->employee[] = $item;
        return $this;
    }
    /**
     * Get endDate value
     * @return \StructType\SearchColumnDateField[]|null
     */
    public function getEndDate()
    {
        return $this->endDate;
    }
    /**
     * This method is responsible for validating the values passed to the setEndDate method
     * This method is willingly generated in order to preserve the one-line inline validation within the setEndDate method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateEndDateForArrayConstraintsFromSetEndDate(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $timeSheetSearchRowBasicEndDateItem) {
            // validation for constraint: itemType
            if (!$timeSheetSearchRowBasicEndDateItem instanceof \StructType\SearchColumnDateField) {
                $invalidValues[] = is_object($timeSheetSearchRowBasicEndDateItem) ? get_class($timeSheetSearchRowBasicEndDateItem) : sprintf('%s(%s)', gettype($timeSheetSearchRowBasicEndDateItem), var_export($timeSheetSearchRowBasicEndDateItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The endDate property can only contain items of type \StructType\SearchColumnDateField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set endDate value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDateField[] $endDate
     * @return \StructType\TimeSheetSearchRowBasic
     */
    public function setEndDate(array $endDate = array())
    {
        // validation for constraint: array
        if ('' !== ($endDateArrayErrorMessage = self::validateEndDateForArrayConstraintsFromSetEndDate($endDate))) {
            throw new \InvalidArgumentException($endDateArrayErrorMessage, __LINE__);
        }
        $this->endDate = $endDate;
        return $this;
    }
    /**
     * Add item to endDate value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDateField $item
     * @return \StructType\TimeSheetSearchRowBasic
     */
    public function addToEndDate(\StructType\SearchColumnDateField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnDateField) {
            throw new \InvalidArgumentException(sprintf('The endDate property can only contain items of type \StructType\SearchColumnDateField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->endDate[] = $item;
        return $this;
    }
    /**
     * Get externalId value
     * @return \StructType\SearchColumnSelectField[]|null
     */
    public function getExternalId()
    {
        return $this->externalId;
    }
    /**
     * This method is responsible for validating the values passed to the setExternalId method
     * This method is willingly generated in order to preserve the one-line inline validation within the setExternalId method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateExternalIdForArrayConstraintsFromSetExternalId(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $timeSheetSearchRowBasicExternalIdItem) {
            // validation for constraint: itemType
            if (!$timeSheetSearchRowBasicExternalIdItem instanceof \StructType\SearchColumnSelectField) {
                $invalidValues[] = is_object($timeSheetSearchRowBasicExternalIdItem) ? get_class($timeSheetSearchRowBasicExternalIdItem) : sprintf('%s(%s)', gettype($timeSheetSearchRowBasicExternalIdItem), var_export($timeSheetSearchRowBasicExternalIdItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The externalId property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set externalId value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField[] $externalId
     * @return \StructType\TimeSheetSearchRowBasic
     */
    public function setExternalId(array $externalId = array())
    {
        // validation for constraint: array
        if ('' !== ($externalIdArrayErrorMessage = self::validateExternalIdForArrayConstraintsFromSetExternalId($externalId))) {
            throw new \InvalidArgumentException($externalIdArrayErrorMessage, __LINE__);
        }
        $this->externalId = $externalId;
        return $this;
    }
    /**
     * Add item to externalId value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField $item
     * @return \StructType\TimeSheetSearchRowBasic
     */
    public function addToExternalId(\StructType\SearchColumnSelectField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnSelectField) {
            throw new \InvalidArgumentException(sprintf('The externalId property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->externalId[] = $item;
        return $this;
    }
    /**
     * Get id value
     * @return \StructType\SearchColumnLongField[]|null
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * This method is responsible for validating the values passed to the setId method
     * This method is willingly generated in order to preserve the one-line inline validation within the setId method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateIdForArrayConstraintsFromSetId(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $timeSheetSearchRowBasicIdItem) {
            // validation for constraint: itemType
            if (!$timeSheetSearchRowBasicIdItem instanceof \StructType\SearchColumnLongField) {
                $invalidValues[] = is_object($timeSheetSearchRowBasicIdItem) ? get_class($timeSheetSearchRowBasicIdItem) : sprintf('%s(%s)', gettype($timeSheetSearchRowBasicIdItem), var_export($timeSheetSearchRowBasicIdItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The id property can only contain items of type \StructType\SearchColumnLongField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set id value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnLongField[] $id
     * @return \StructType\TimeSheetSearchRowBasic
     */
    public function setId(array $id = array())
    {
        // validation for constraint: array
        if ('' !== ($idArrayErrorMessage = self::validateIdForArrayConstraintsFromSetId($id))) {
            throw new \InvalidArgumentException($idArrayErrorMessage, __LINE__);
        }
        $this->id = $id;
        return $this;
    }
    /**
     * Add item to id value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnLongField $item
     * @return \StructType\TimeSheetSearchRowBasic
     */
    public function addToId(\StructType\SearchColumnLongField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnLongField) {
            throw new \InvalidArgumentException(sprintf('The id property can only contain items of type \StructType\SearchColumnLongField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->id[] = $item;
        return $this;
    }
    /**
     * Get internalId value
     * @return \StructType\SearchColumnSelectField[]|null
     */
    public function getInternalId()
    {
        return $this->internalId;
    }
    /**
     * This method is responsible for validating the values passed to the setInternalId method
     * This method is willingly generated in order to preserve the one-line inline validation within the setInternalId method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateInternalIdForArrayConstraintsFromSetInternalId(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $timeSheetSearchRowBasicInternalIdItem) {
            // validation for constraint: itemType
            if (!$timeSheetSearchRowBasicInternalIdItem instanceof \StructType\SearchColumnSelectField) {
                $invalidValues[] = is_object($timeSheetSearchRowBasicInternalIdItem) ? get_class($timeSheetSearchRowBasicInternalIdItem) : sprintf('%s(%s)', gettype($timeSheetSearchRowBasicInternalIdItem), var_export($timeSheetSearchRowBasicInternalIdItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The internalId property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set internalId value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField[] $internalId
     * @return \StructType\TimeSheetSearchRowBasic
     */
    public function setInternalId(array $internalId = array())
    {
        // validation for constraint: array
        if ('' !== ($internalIdArrayErrorMessage = self::validateInternalIdForArrayConstraintsFromSetInternalId($internalId))) {
            throw new \InvalidArgumentException($internalIdArrayErrorMessage, __LINE__);
        }
        $this->internalId = $internalId;
        return $this;
    }
    /**
     * Add item to internalId value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField $item
     * @return \StructType\TimeSheetSearchRowBasic
     */
    public function addToInternalId(\StructType\SearchColumnSelectField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnSelectField) {
            throw new \InvalidArgumentException(sprintf('The internalId property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->internalId[] = $item;
        return $this;
    }
    /**
     * Get startDate value
     * @return \StructType\SearchColumnDateField[]|null
     */
    public function getStartDate()
    {
        return $this->startDate;
    }
    /**
     * This method is responsible for validating the values passed to the setStartDate method
     * This method is willingly generated in order to preserve the one-line inline validation within the setStartDate method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateStartDateForArrayConstraintsFromSetStartDate(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $timeSheetSearchRowBasicStartDateItem) {
            // validation for constraint: itemType
            if (!$timeSheetSearchRowBasicStartDateItem instanceof \StructType\SearchColumnDateField) {
                $invalidValues[] = is_object($timeSheetSearchRowBasicStartDateItem) ? get_class($timeSheetSearchRowBasicStartDateItem) : sprintf('%s(%s)', gettype($timeSheetSearchRowBasicStartDateItem), var_export($timeSheetSearchRowBasicStartDateItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The startDate property can only contain items of type \StructType\SearchColumnDateField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set startDate value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDateField[] $startDate
     * @return \StructType\TimeSheetSearchRowBasic
     */
    public function setStartDate(array $startDate = array())
    {
        // validation for constraint: array
        if ('' !== ($startDateArrayErrorMessage = self::validateStartDateForArrayConstraintsFromSetStartDate($startDate))) {
            throw new \InvalidArgumentException($startDateArrayErrorMessage, __LINE__);
        }
        $this->startDate = $startDate;
        return $this;
    }
    /**
     * Add item to startDate value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDateField $item
     * @return \StructType\TimeSheetSearchRowBasic
     */
    public function addToStartDate(\StructType\SearchColumnDateField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnDateField) {
            throw new \InvalidArgumentException(sprintf('The startDate property can only contain items of type \StructType\SearchColumnDateField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->startDate[] = $item;
        return $this;
    }
    /**
     * Get totalHours value
     * @return \StructType\SearchColumnStringField[]|null
     */
    public function getTotalHours()
    {
        return $this->totalHours;
    }
    /**
     * This method is responsible for validating the values passed to the setTotalHours method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTotalHours method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTotalHoursForArrayConstraintsFromSetTotalHours(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $timeSheetSearchRowBasicTotalHoursItem) {
            // validation for constraint: itemType
            if (!$timeSheetSearchRowBasicTotalHoursItem instanceof \StructType\SearchColumnStringField) {
                $invalidValues[] = is_object($timeSheetSearchRowBasicTotalHoursItem) ? get_class($timeSheetSearchRowBasicTotalHoursItem) : sprintf('%s(%s)', gettype($timeSheetSearchRowBasicTotalHoursItem), var_export($timeSheetSearchRowBasicTotalHoursItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The totalHours property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set totalHours value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField[] $totalHours
     * @return \StructType\TimeSheetSearchRowBasic
     */
    public function setTotalHours(array $totalHours = array())
    {
        // validation for constraint: array
        if ('' !== ($totalHoursArrayErrorMessage = self::validateTotalHoursForArrayConstraintsFromSetTotalHours($totalHours))) {
            throw new \InvalidArgumentException($totalHoursArrayErrorMessage, __LINE__);
        }
        $this->totalHours = $totalHours;
        return $this;
    }
    /**
     * Add item to totalHours value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField $item
     * @return \StructType\TimeSheetSearchRowBasic
     */
    public function addToTotalHours(\StructType\SearchColumnStringField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnStringField) {
            throw new \InvalidArgumentException(sprintf('The totalHours property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->totalHours[] = $item;
        return $this;
    }
    /**
     * Get customFieldList value
     * @return \StructType\SearchColumnCustomFieldList|null
     */
    public function getCustomFieldList()
    {
        return $this->customFieldList;
    }
    /**
     * Set customFieldList value
     * @param \StructType\SearchColumnCustomFieldList $customFieldList
     * @return \StructType\TimeSheetSearchRowBasic
     */
    public function setCustomFieldList(\StructType\SearchColumnCustomFieldList $customFieldList = null)
    {
        $this->customFieldList = $customFieldList;
        return $this;
    }
}
