<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TimeEntrySearchAdvanced StructType
 * @subpackage Structs
 */
class TimeEntrySearchAdvanced extends SearchRecord
{
    /**
     * The criteria
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\TimeEntrySearch
     */
    public $criteria;
    /**
     * The columns
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\TimeEntrySearchRow
     */
    public $columns;
    /**
     * The savedSearchId
     * @var string
     */
    public $savedSearchId;
    /**
     * The savedSearchScriptId
     * @var string
     */
    public $savedSearchScriptId;
    /**
     * Constructor method for TimeEntrySearchAdvanced
     * @uses TimeEntrySearchAdvanced::setCriteria()
     * @uses TimeEntrySearchAdvanced::setColumns()
     * @uses TimeEntrySearchAdvanced::setSavedSearchId()
     * @uses TimeEntrySearchAdvanced::setSavedSearchScriptId()
     * @param \StructType\TimeEntrySearch $criteria
     * @param \StructType\TimeEntrySearchRow $columns
     * @param string $savedSearchId
     * @param string $savedSearchScriptId
     */
    public function __construct(\StructType\TimeEntrySearch $criteria = null, \StructType\TimeEntrySearchRow $columns = null, $savedSearchId = null, $savedSearchScriptId = null)
    {
        $this
            ->setCriteria($criteria)
            ->setColumns($columns)
            ->setSavedSearchId($savedSearchId)
            ->setSavedSearchScriptId($savedSearchScriptId);
    }
    /**
     * Get criteria value
     * @return \StructType\TimeEntrySearch|null
     */
    public function getCriteria()
    {
        return $this->criteria;
    }
    /**
     * Set criteria value
     * @param \StructType\TimeEntrySearch $criteria
     * @return \StructType\TimeEntrySearchAdvanced
     */
    public function setCriteria(\StructType\TimeEntrySearch $criteria = null)
    {
        $this->criteria = $criteria;
        return $this;
    }
    /**
     * Get columns value
     * @return \StructType\TimeEntrySearchRow|null
     */
    public function getColumns()
    {
        return $this->columns;
    }
    /**
     * Set columns value
     * @param \StructType\TimeEntrySearchRow $columns
     * @return \StructType\TimeEntrySearchAdvanced
     */
    public function setColumns(\StructType\TimeEntrySearchRow $columns = null)
    {
        $this->columns = $columns;
        return $this;
    }
    /**
     * Get savedSearchId value
     * @return string|null
     */
    public function getSavedSearchId()
    {
        return $this->savedSearchId;
    }
    /**
     * Set savedSearchId value
     * @param string $savedSearchId
     * @return \StructType\TimeEntrySearchAdvanced
     */
    public function setSavedSearchId($savedSearchId = null)
    {
        // validation for constraint: string
        if (!is_null($savedSearchId) && !is_string($savedSearchId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($savedSearchId, true), gettype($savedSearchId)), __LINE__);
        }
        $this->savedSearchId = $savedSearchId;
        return $this;
    }
    /**
     * Get savedSearchScriptId value
     * @return string|null
     */
    public function getSavedSearchScriptId()
    {
        return $this->savedSearchScriptId;
    }
    /**
     * Set savedSearchScriptId value
     * @param string $savedSearchScriptId
     * @return \StructType\TimeEntrySearchAdvanced
     */
    public function setSavedSearchScriptId($savedSearchScriptId = null)
    {
        // validation for constraint: string
        if (!is_null($savedSearchScriptId) && !is_string($savedSearchScriptId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($savedSearchScriptId, true), gettype($savedSearchScriptId)), __LINE__);
        }
        $this->savedSearchScriptId = $savedSearchScriptId;
        return $this;
    }
}
