<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TimeEntry StructType
 * @subpackage Structs
 */
class TimeEntry extends Record
{
    /**
     * The hours
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Duration
     */
    public $hours;
    /**
     * The createdDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $createdDate;
    /**
     * The lastModifiedDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $lastModifiedDate;
    /**
     * The customer
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $customer;
    /**
     * The caseTaskEvent
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $caseTaskEvent;
    /**
     * The item
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $item;
    /**
     * The isBillable
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $isBillable;
    /**
     * The payrollItem
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $payrollItem;
    /**
     * The paidExternally
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $paidExternally;
    /**
     * The price
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $price;
    /**
     * The rate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $rate;
    /**
     * The overrideRate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $overrideRate;
    /**
     * The memo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $memo;
    /**
     * The department
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $department;
    /**
     * The class
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $class;
    /**
     * The location
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $location;
    /**
     * The billingClass
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $billingClass;
    /**
     * The subsidiary
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $subsidiary;
    /**
     * The approvalStatus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $approvalStatus;
    /**
     * The timeType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $timeType;
    /**
     * The customFieldList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CustomFieldList
     */
    public $customFieldList;
    /**
     * The internalId
     * @var string
     */
    public $internalId;
    /**
     * The externalId
     * @var string
     */
    public $externalId;
    /**
     * Constructor method for TimeEntry
     * @uses TimeEntry::setHours()
     * @uses TimeEntry::setCreatedDate()
     * @uses TimeEntry::setLastModifiedDate()
     * @uses TimeEntry::setCustomer()
     * @uses TimeEntry::setCaseTaskEvent()
     * @uses TimeEntry::setItem()
     * @uses TimeEntry::setIsBillable()
     * @uses TimeEntry::setPayrollItem()
     * @uses TimeEntry::setPaidExternally()
     * @uses TimeEntry::setPrice()
     * @uses TimeEntry::setRate()
     * @uses TimeEntry::setOverrideRate()
     * @uses TimeEntry::setMemo()
     * @uses TimeEntry::setDepartment()
     * @uses TimeEntry::setClass()
     * @uses TimeEntry::setLocation()
     * @uses TimeEntry::setBillingClass()
     * @uses TimeEntry::setSubsidiary()
     * @uses TimeEntry::setApprovalStatus()
     * @uses TimeEntry::setTimeType()
     * @uses TimeEntry::setCustomFieldList()
     * @uses TimeEntry::setInternalId()
     * @uses TimeEntry::setExternalId()
     * @param \StructType\Duration $hours
     * @param string $createdDate
     * @param string $lastModifiedDate
     * @param \StructType\RecordRef $customer
     * @param \StructType\RecordRef $caseTaskEvent
     * @param \StructType\RecordRef $item
     * @param bool $isBillable
     * @param \StructType\RecordRef $payrollItem
     * @param bool $paidExternally
     * @param \StructType\RecordRef $price
     * @param float $rate
     * @param bool $overrideRate
     * @param string $memo
     * @param \StructType\RecordRef $department
     * @param \StructType\RecordRef $class
     * @param \StructType\RecordRef $location
     * @param string $billingClass
     * @param \StructType\RecordRef $subsidiary
     * @param \StructType\RecordRef $approvalStatus
     * @param string $timeType
     * @param \StructType\CustomFieldList $customFieldList
     * @param string $internalId
     * @param string $externalId
     */
    public function __construct(\StructType\Duration $hours = null, $createdDate = null, $lastModifiedDate = null, \StructType\RecordRef $customer = null, \StructType\RecordRef $caseTaskEvent = null, \StructType\RecordRef $item = null, $isBillable = null, \StructType\RecordRef $payrollItem = null, $paidExternally = null, \StructType\RecordRef $price = null, $rate = null, $overrideRate = null, $memo = null, \StructType\RecordRef $department = null, \StructType\RecordRef $class = null, \StructType\RecordRef $location = null, $billingClass = null, \StructType\RecordRef $subsidiary = null, \StructType\RecordRef $approvalStatus = null, $timeType = null, \StructType\CustomFieldList $customFieldList = null, $internalId = null, $externalId = null)
    {
        $this
            ->setHours($hours)
            ->setCreatedDate($createdDate)
            ->setLastModifiedDate($lastModifiedDate)
            ->setCustomer($customer)
            ->setCaseTaskEvent($caseTaskEvent)
            ->setItem($item)
            ->setIsBillable($isBillable)
            ->setPayrollItem($payrollItem)
            ->setPaidExternally($paidExternally)
            ->setPrice($price)
            ->setRate($rate)
            ->setOverrideRate($overrideRate)
            ->setMemo($memo)
            ->setDepartment($department)
            ->setClass($class)
            ->setLocation($location)
            ->setBillingClass($billingClass)
            ->setSubsidiary($subsidiary)
            ->setApprovalStatus($approvalStatus)
            ->setTimeType($timeType)
            ->setCustomFieldList($customFieldList)
            ->setInternalId($internalId)
            ->setExternalId($externalId);
    }
    /**
     * Get hours value
     * @return \StructType\Duration|null
     */
    public function getHours()
    {
        return $this->hours;
    }
    /**
     * Set hours value
     * @param \StructType\Duration $hours
     * @return \StructType\TimeEntry
     */
    public function setHours(\StructType\Duration $hours = null)
    {
        $this->hours = $hours;
        return $this;
    }
    /**
     * Get createdDate value
     * @return string|null
     */
    public function getCreatedDate()
    {
        return $this->createdDate;
    }
    /**
     * Set createdDate value
     * @param string $createdDate
     * @return \StructType\TimeEntry
     */
    public function setCreatedDate($createdDate = null)
    {
        // validation for constraint: string
        if (!is_null($createdDate) && !is_string($createdDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createdDate, true), gettype($createdDate)), __LINE__);
        }
        $this->createdDate = $createdDate;
        return $this;
    }
    /**
     * Get lastModifiedDate value
     * @return string|null
     */
    public function getLastModifiedDate()
    {
        return $this->lastModifiedDate;
    }
    /**
     * Set lastModifiedDate value
     * @param string $lastModifiedDate
     * @return \StructType\TimeEntry
     */
    public function setLastModifiedDate($lastModifiedDate = null)
    {
        // validation for constraint: string
        if (!is_null($lastModifiedDate) && !is_string($lastModifiedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastModifiedDate, true), gettype($lastModifiedDate)), __LINE__);
        }
        $this->lastModifiedDate = $lastModifiedDate;
        return $this;
    }
    /**
     * Get customer value
     * @return \StructType\RecordRef|null
     */
    public function getCustomer()
    {
        return $this->customer;
    }
    /**
     * Set customer value
     * @param \StructType\RecordRef $customer
     * @return \StructType\TimeEntry
     */
    public function setCustomer(\StructType\RecordRef $customer = null)
    {
        $this->customer = $customer;
        return $this;
    }
    /**
     * Get caseTaskEvent value
     * @return \StructType\RecordRef|null
     */
    public function getCaseTaskEvent()
    {
        return $this->caseTaskEvent;
    }
    /**
     * Set caseTaskEvent value
     * @param \StructType\RecordRef $caseTaskEvent
     * @return \StructType\TimeEntry
     */
    public function setCaseTaskEvent(\StructType\RecordRef $caseTaskEvent = null)
    {
        $this->caseTaskEvent = $caseTaskEvent;
        return $this;
    }
    /**
     * Get item value
     * @return \StructType\RecordRef|null
     */
    public function getItem()
    {
        return $this->item;
    }
    /**
     * Set item value
     * @param \StructType\RecordRef $item
     * @return \StructType\TimeEntry
     */
    public function setItem(\StructType\RecordRef $item = null)
    {
        $this->item = $item;
        return $this;
    }
    /**
     * Get isBillable value
     * @return bool|null
     */
    public function getIsBillable()
    {
        return $this->isBillable;
    }
    /**
     * Set isBillable value
     * @param bool $isBillable
     * @return \StructType\TimeEntry
     */
    public function setIsBillable($isBillable = null)
    {
        // validation for constraint: boolean
        if (!is_null($isBillable) && !is_bool($isBillable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isBillable, true), gettype($isBillable)), __LINE__);
        }
        $this->isBillable = $isBillable;
        return $this;
    }
    /**
     * Get payrollItem value
     * @return \StructType\RecordRef|null
     */
    public function getPayrollItem()
    {
        return $this->payrollItem;
    }
    /**
     * Set payrollItem value
     * @param \StructType\RecordRef $payrollItem
     * @return \StructType\TimeEntry
     */
    public function setPayrollItem(\StructType\RecordRef $payrollItem = null)
    {
        $this->payrollItem = $payrollItem;
        return $this;
    }
    /**
     * Get paidExternally value
     * @return bool|null
     */
    public function getPaidExternally()
    {
        return $this->paidExternally;
    }
    /**
     * Set paidExternally value
     * @param bool $paidExternally
     * @return \StructType\TimeEntry
     */
    public function setPaidExternally($paidExternally = null)
    {
        // validation for constraint: boolean
        if (!is_null($paidExternally) && !is_bool($paidExternally)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($paidExternally, true), gettype($paidExternally)), __LINE__);
        }
        $this->paidExternally = $paidExternally;
        return $this;
    }
    /**
     * Get price value
     * @return \StructType\RecordRef|null
     */
    public function getPrice()
    {
        return $this->price;
    }
    /**
     * Set price value
     * @param \StructType\RecordRef $price
     * @return \StructType\TimeEntry
     */
    public function setPrice(\StructType\RecordRef $price = null)
    {
        $this->price = $price;
        return $this;
    }
    /**
     * Get rate value
     * @return float|null
     */
    public function getRate()
    {
        return $this->rate;
    }
    /**
     * Set rate value
     * @param float $rate
     * @return \StructType\TimeEntry
     */
    public function setRate($rate = null)
    {
        // validation for constraint: float
        if (!is_null($rate) && !(is_float($rate) || is_numeric($rate))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($rate, true), gettype($rate)), __LINE__);
        }
        $this->rate = $rate;
        return $this;
    }
    /**
     * Get overrideRate value
     * @return bool|null
     */
    public function getOverrideRate()
    {
        return $this->overrideRate;
    }
    /**
     * Set overrideRate value
     * @param bool $overrideRate
     * @return \StructType\TimeEntry
     */
    public function setOverrideRate($overrideRate = null)
    {
        // validation for constraint: boolean
        if (!is_null($overrideRate) && !is_bool($overrideRate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($overrideRate, true), gettype($overrideRate)), __LINE__);
        }
        $this->overrideRate = $overrideRate;
        return $this;
    }
    /**
     * Get memo value
     * @return string|null
     */
    public function getMemo()
    {
        return $this->memo;
    }
    /**
     * Set memo value
     * @param string $memo
     * @return \StructType\TimeEntry
     */
    public function setMemo($memo = null)
    {
        // validation for constraint: string
        if (!is_null($memo) && !is_string($memo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($memo, true), gettype($memo)), __LINE__);
        }
        $this->memo = $memo;
        return $this;
    }
    /**
     * Get department value
     * @return \StructType\RecordRef|null
     */
    public function getDepartment()
    {
        return $this->department;
    }
    /**
     * Set department value
     * @param \StructType\RecordRef $department
     * @return \StructType\TimeEntry
     */
    public function setDepartment(\StructType\RecordRef $department = null)
    {
        $this->department = $department;
        return $this;
    }
    /**
     * Get class value
     * @return \StructType\RecordRef|null
     */
    public function getClass()
    {
        return $this->class;
    }
    /**
     * Set class value
     * @param \StructType\RecordRef $class
     * @return \StructType\TimeEntry
     */
    public function setClass(\StructType\RecordRef $class = null)
    {
        $this->class = $class;
        return $this;
    }
    /**
     * Get location value
     * @return \StructType\RecordRef|null
     */
    public function getLocation()
    {
        return $this->location;
    }
    /**
     * Set location value
     * @param \StructType\RecordRef $location
     * @return \StructType\TimeEntry
     */
    public function setLocation(\StructType\RecordRef $location = null)
    {
        $this->location = $location;
        return $this;
    }
    /**
     * Get billingClass value
     * @return string|null
     */
    public function getBillingClass()
    {
        return $this->billingClass;
    }
    /**
     * Set billingClass value
     * @param string $billingClass
     * @return \StructType\TimeEntry
     */
    public function setBillingClass($billingClass = null)
    {
        // validation for constraint: string
        if (!is_null($billingClass) && !is_string($billingClass)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($billingClass, true), gettype($billingClass)), __LINE__);
        }
        $this->billingClass = $billingClass;
        return $this;
    }
    /**
     * Get subsidiary value
     * @return \StructType\RecordRef|null
     */
    public function getSubsidiary()
    {
        return $this->subsidiary;
    }
    /**
     * Set subsidiary value
     * @param \StructType\RecordRef $subsidiary
     * @return \StructType\TimeEntry
     */
    public function setSubsidiary(\StructType\RecordRef $subsidiary = null)
    {
        $this->subsidiary = $subsidiary;
        return $this;
    }
    /**
     * Get approvalStatus value
     * @return \StructType\RecordRef|null
     */
    public function getApprovalStatus()
    {
        return $this->approvalStatus;
    }
    /**
     * Set approvalStatus value
     * @param \StructType\RecordRef $approvalStatus
     * @return \StructType\TimeEntry
     */
    public function setApprovalStatus(\StructType\RecordRef $approvalStatus = null)
    {
        $this->approvalStatus = $approvalStatus;
        return $this;
    }
    /**
     * Get timeType value
     * @return string|null
     */
    public function getTimeType()
    {
        return $this->timeType;
    }
    /**
     * Set timeType value
     * @uses \EnumType\TimeBillTimeType::valueIsValid()
     * @uses \EnumType\TimeBillTimeType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $timeType
     * @return \StructType\TimeEntry
     */
    public function setTimeType($timeType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\TimeBillTimeType::valueIsValid($timeType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\TimeBillTimeType', is_array($timeType) ? implode(', ', $timeType) : var_export($timeType, true), implode(', ', \EnumType\TimeBillTimeType::getValidValues())), __LINE__);
        }
        $this->timeType = $timeType;
        return $this;
    }
    /**
     * Get customFieldList value
     * @return \StructType\CustomFieldList|null
     */
    public function getCustomFieldList()
    {
        return $this->customFieldList;
    }
    /**
     * Set customFieldList value
     * @param \StructType\CustomFieldList $customFieldList
     * @return \StructType\TimeEntry
     */
    public function setCustomFieldList(\StructType\CustomFieldList $customFieldList = null)
    {
        $this->customFieldList = $customFieldList;
        return $this;
    }
    /**
     * Get internalId value
     * @return string|null
     */
    public function getInternalId()
    {
        return $this->internalId;
    }
    /**
     * Set internalId value
     * @param string $internalId
     * @return \StructType\TimeEntry
     */
    public function setInternalId($internalId = null)
    {
        // validation for constraint: string
        if (!is_null($internalId) && !is_string($internalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($internalId, true), gettype($internalId)), __LINE__);
        }
        $this->internalId = $internalId;
        return $this;
    }
    /**
     * Get externalId value
     * @return string|null
     */
    public function getExternalId()
    {
        return $this->externalId;
    }
    /**
     * Set externalId value
     * @param string $externalId
     * @return \StructType\TimeEntry
     */
    public function setExternalId($externalId = null)
    {
        // validation for constraint: string
        if (!is_null($externalId) && !is_string($externalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($externalId, true), gettype($externalId)), __LINE__);
        }
        $this->externalId = $externalId;
        return $this;
    }
}
