<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TaxDetailsList StructType
 * @subpackage Structs
 */
class TaxDetailsList extends AbstractStructBase
{
    /**
     * The taxDetails
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\TaxDetails[]
     */
    public $taxDetails;
    /**
     * The replaceAll
     * Meta information extracted from the WSDL
     * - default: true
     * @var bool
     */
    public $replaceAll;
    /**
     * Constructor method for TaxDetailsList
     * @uses TaxDetailsList::setTaxDetails()
     * @uses TaxDetailsList::setReplaceAll()
     * @param \StructType\TaxDetails[] $taxDetails
     * @param bool $replaceAll
     */
    public function __construct(array $taxDetails = array(), $replaceAll = true)
    {
        $this
            ->setTaxDetails($taxDetails)
            ->setReplaceAll($replaceAll);
    }
    /**
     * Get taxDetails value
     * @return \StructType\TaxDetails[]|null
     */
    public function getTaxDetails()
    {
        return $this->taxDetails;
    }
    /**
     * This method is responsible for validating the values passed to the setTaxDetails method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTaxDetails method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTaxDetailsForArrayConstraintsFromSetTaxDetails(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $taxDetailsListTaxDetailsItem) {
            // validation for constraint: itemType
            if (!$taxDetailsListTaxDetailsItem instanceof \StructType\TaxDetails) {
                $invalidValues[] = is_object($taxDetailsListTaxDetailsItem) ? get_class($taxDetailsListTaxDetailsItem) : sprintf('%s(%s)', gettype($taxDetailsListTaxDetailsItem), var_export($taxDetailsListTaxDetailsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The taxDetails property can only contain items of type \StructType\TaxDetails, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set taxDetails value
     * @throws \InvalidArgumentException
     * @param \StructType\TaxDetails[] $taxDetails
     * @return \StructType\TaxDetailsList
     */
    public function setTaxDetails(array $taxDetails = array())
    {
        // validation for constraint: array
        if ('' !== ($taxDetailsArrayErrorMessage = self::validateTaxDetailsForArrayConstraintsFromSetTaxDetails($taxDetails))) {
            throw new \InvalidArgumentException($taxDetailsArrayErrorMessage, __LINE__);
        }
        $this->taxDetails = $taxDetails;
        return $this;
    }
    /**
     * Add item to taxDetails value
     * @throws \InvalidArgumentException
     * @param \StructType\TaxDetails $item
     * @return \StructType\TaxDetailsList
     */
    public function addToTaxDetails(\StructType\TaxDetails $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\TaxDetails) {
            throw new \InvalidArgumentException(sprintf('The taxDetails property can only contain items of type \StructType\TaxDetails, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->taxDetails[] = $item;
        return $this;
    }
    /**
     * Get replaceAll value
     * @return bool|null
     */
    public function getReplaceAll()
    {
        return $this->replaceAll;
    }
    /**
     * Set replaceAll value
     * @param bool $replaceAll
     * @return \StructType\TaxDetailsList
     */
    public function setReplaceAll($replaceAll = true)
    {
        // validation for constraint: boolean
        if (!is_null($replaceAll) && !is_bool($replaceAll)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($replaceAll, true), gettype($replaceAll)), __LINE__);
        }
        $this->replaceAll = $replaceAll;
        return $this;
    }
}
