<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TaskTimeItemList StructType
 * @subpackage Structs
 */
class TaskTimeItemList extends AbstractStructBase
{
    /**
     * The timeItem
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\TimeItem[]
     */
    public $timeItem;
    /**
     * The replaceAll
     * Meta information extracted from the WSDL
     * - default: true
     * @var bool
     */
    public $replaceAll;
    /**
     * Constructor method for TaskTimeItemList
     * @uses TaskTimeItemList::setTimeItem()
     * @uses TaskTimeItemList::setReplaceAll()
     * @param \StructType\TimeItem[] $timeItem
     * @param bool $replaceAll
     */
    public function __construct(array $timeItem = array(), $replaceAll = true)
    {
        $this
            ->setTimeItem($timeItem)
            ->setReplaceAll($replaceAll);
    }
    /**
     * Get timeItem value
     * @return \StructType\TimeItem[]|null
     */
    public function getTimeItem()
    {
        return $this->timeItem;
    }
    /**
     * This method is responsible for validating the values passed to the setTimeItem method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTimeItem method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTimeItemForArrayConstraintsFromSetTimeItem(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $taskTimeItemListTimeItemItem) {
            // validation for constraint: itemType
            if (!$taskTimeItemListTimeItemItem instanceof \StructType\TimeItem) {
                $invalidValues[] = is_object($taskTimeItemListTimeItemItem) ? get_class($taskTimeItemListTimeItemItem) : sprintf('%s(%s)', gettype($taskTimeItemListTimeItemItem), var_export($taskTimeItemListTimeItemItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The timeItem property can only contain items of type \StructType\TimeItem, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set timeItem value
     * @throws \InvalidArgumentException
     * @param \StructType\TimeItem[] $timeItem
     * @return \StructType\TaskTimeItemList
     */
    public function setTimeItem(array $timeItem = array())
    {
        // validation for constraint: array
        if ('' !== ($timeItemArrayErrorMessage = self::validateTimeItemForArrayConstraintsFromSetTimeItem($timeItem))) {
            throw new \InvalidArgumentException($timeItemArrayErrorMessage, __LINE__);
        }
        $this->timeItem = $timeItem;
        return $this;
    }
    /**
     * Add item to timeItem value
     * @throws \InvalidArgumentException
     * @param \StructType\TimeItem $item
     * @return \StructType\TaskTimeItemList
     */
    public function addToTimeItem(\StructType\TimeItem $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\TimeItem) {
            throw new \InvalidArgumentException(sprintf('The timeItem property can only contain items of type \StructType\TimeItem, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->timeItem[] = $item;
        return $this;
    }
    /**
     * Get replaceAll value
     * @return bool|null
     */
    public function getReplaceAll()
    {
        return $this->replaceAll;
    }
    /**
     * Set replaceAll value
     * @param bool $replaceAll
     * @return \StructType\TaskTimeItemList
     */
    public function setReplaceAll($replaceAll = true)
    {
        // validation for constraint: boolean
        if (!is_null($replaceAll) && !is_bool($replaceAll)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($replaceAll, true), gettype($replaceAll)), __LINE__);
        }
        $this->replaceAll = $replaceAll;
        return $this;
    }
}
