<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TaskContact StructType
 * @subpackage Structs
 */
class TaskContact extends AbstractStructBase
{
    /**
     * The company
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $company;
    /**
     * The contact
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $contact;
    /**
     * Constructor method for TaskContact
     * @uses TaskContact::setCompany()
     * @uses TaskContact::setContact()
     * @param \StructType\RecordRef $company
     * @param \StructType\RecordRef $contact
     */
    public function __construct(\StructType\RecordRef $company = null, \StructType\RecordRef $contact = null)
    {
        $this
            ->setCompany($company)
            ->setContact($contact);
    }
    /**
     * Get company value
     * @return \StructType\RecordRef|null
     */
    public function getCompany()
    {
        return $this->company;
    }
    /**
     * Set company value
     * @param \StructType\RecordRef $company
     * @return \StructType\TaskContact
     */
    public function setCompany(\StructType\RecordRef $company = null)
    {
        $this->company = $company;
        return $this;
    }
    /**
     * Get contact value
     * @return \StructType\RecordRef|null
     */
    public function getContact()
    {
        return $this->contact;
    }
    /**
     * Set contact value
     * @param \StructType\RecordRef $contact
     * @return \StructType\TaskContact
     */
    public function setContact(\StructType\RecordRef $contact = null)
    {
        $this->contact = $contact;
        return $this;
    }
}
