<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SupportCaseStatus StructType
 * Meta information extracted from the WSDL
 * - type: listSupport:SupportCaseStatus
 * @subpackage Structs
 */
class SupportCaseStatus extends Record
{
    /**
     * The name
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $name;
    /**
     * The insertBefore
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $insertBefore;
    /**
     * The stage
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $stage;
    /**
     * The caseOnHold
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $caseOnHold;
    /**
     * The autoCloseCase
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $autoCloseCase;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $description;
    /**
     * The isInactive
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $isInactive;
    /**
     * The internalId
     * @var string
     */
    public $internalId;
    /**
     * The externalId
     * @var string
     */
    public $externalId;
    /**
     * Constructor method for SupportCaseStatus
     * @uses SupportCaseStatus::setName()
     * @uses SupportCaseStatus::setInsertBefore()
     * @uses SupportCaseStatus::setStage()
     * @uses SupportCaseStatus::setCaseOnHold()
     * @uses SupportCaseStatus::setAutoCloseCase()
     * @uses SupportCaseStatus::setDescription()
     * @uses SupportCaseStatus::setIsInactive()
     * @uses SupportCaseStatus::setInternalId()
     * @uses SupportCaseStatus::setExternalId()
     * @param string $name
     * @param \StructType\RecordRef $insertBefore
     * @param string $stage
     * @param bool $caseOnHold
     * @param bool $autoCloseCase
     * @param string $description
     * @param bool $isInactive
     * @param string $internalId
     * @param string $externalId
     */
    public function __construct($name = null, \StructType\RecordRef $insertBefore = null, $stage = null, $caseOnHold = null, $autoCloseCase = null, $description = null, $isInactive = null, $internalId = null, $externalId = null)
    {
        $this
            ->setName($name)
            ->setInsertBefore($insertBefore)
            ->setStage($stage)
            ->setCaseOnHold($caseOnHold)
            ->setAutoCloseCase($autoCloseCase)
            ->setDescription($description)
            ->setIsInactive($isInactive)
            ->setInternalId($internalId)
            ->setExternalId($externalId);
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\SupportCaseStatus
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get insertBefore value
     * @return \StructType\RecordRef|null
     */
    public function getInsertBefore()
    {
        return $this->insertBefore;
    }
    /**
     * Set insertBefore value
     * @param \StructType\RecordRef $insertBefore
     * @return \StructType\SupportCaseStatus
     */
    public function setInsertBefore(\StructType\RecordRef $insertBefore = null)
    {
        $this->insertBefore = $insertBefore;
        return $this;
    }
    /**
     * Get stage value
     * @return string|null
     */
    public function getStage()
    {
        return $this->stage;
    }
    /**
     * Set stage value
     * @uses \EnumType\SupportCaseStatusStage::valueIsValid()
     * @uses \EnumType\SupportCaseStatusStage::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $stage
     * @return \StructType\SupportCaseStatus
     */
    public function setStage($stage = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\SupportCaseStatusStage::valueIsValid($stage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\SupportCaseStatusStage', is_array($stage) ? implode(', ', $stage) : var_export($stage, true), implode(', ', \EnumType\SupportCaseStatusStage::getValidValues())), __LINE__);
        }
        $this->stage = $stage;
        return $this;
    }
    /**
     * Get caseOnHold value
     * @return bool|null
     */
    public function getCaseOnHold()
    {
        return $this->caseOnHold;
    }
    /**
     * Set caseOnHold value
     * @param bool $caseOnHold
     * @return \StructType\SupportCaseStatus
     */
    public function setCaseOnHold($caseOnHold = null)
    {
        // validation for constraint: boolean
        if (!is_null($caseOnHold) && !is_bool($caseOnHold)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($caseOnHold, true), gettype($caseOnHold)), __LINE__);
        }
        $this->caseOnHold = $caseOnHold;
        return $this;
    }
    /**
     * Get autoCloseCase value
     * @return bool|null
     */
    public function getAutoCloseCase()
    {
        return $this->autoCloseCase;
    }
    /**
     * Set autoCloseCase value
     * @param bool $autoCloseCase
     * @return \StructType\SupportCaseStatus
     */
    public function setAutoCloseCase($autoCloseCase = null)
    {
        // validation for constraint: boolean
        if (!is_null($autoCloseCase) && !is_bool($autoCloseCase)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($autoCloseCase, true), gettype($autoCloseCase)), __LINE__);
        }
        $this->autoCloseCase = $autoCloseCase;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\SupportCaseStatus
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get isInactive value
     * @return bool|null
     */
    public function getIsInactive()
    {
        return $this->isInactive;
    }
    /**
     * Set isInactive value
     * @param bool $isInactive
     * @return \StructType\SupportCaseStatus
     */
    public function setIsInactive($isInactive = null)
    {
        // validation for constraint: boolean
        if (!is_null($isInactive) && !is_bool($isInactive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isInactive, true), gettype($isInactive)), __LINE__);
        }
        $this->isInactive = $isInactive;
        return $this;
    }
    /**
     * Get internalId value
     * @return string|null
     */
    public function getInternalId()
    {
        return $this->internalId;
    }
    /**
     * Set internalId value
     * @param string $internalId
     * @return \StructType\SupportCaseStatus
     */
    public function setInternalId($internalId = null)
    {
        // validation for constraint: string
        if (!is_null($internalId) && !is_string($internalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($internalId, true), gettype($internalId)), __LINE__);
        }
        $this->internalId = $internalId;
        return $this;
    }
    /**
     * Get externalId value
     * @return string|null
     */
    public function getExternalId()
    {
        return $this->externalId;
    }
    /**
     * Set externalId value
     * @param string $externalId
     * @return \StructType\SupportCaseStatus
     */
    public function setExternalId($externalId = null)
    {
        // validation for constraint: string
        if (!is_null($externalId) && !is_string($externalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($externalId, true), gettype($externalId)), __LINE__);
        }
        $this->externalId = $externalId;
        return $this;
    }
}
