<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Subsidiary StructType
 * Meta information extracted from the WSDL
 * - type: listAcct:Subsidiary
 * @subpackage Structs
 */
class Subsidiary extends Record
{
    /**
     * The name
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $name;
    /**
     * The parent
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $parent;
    /**
     * The isInactive
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $isInactive;
    /**
     * The showSubsidiaryName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $showSubsidiaryName;
    /**
     * The url
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $url;
    /**
     * The logo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $logo;
    /**
     * The tranPrefix
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $tranPrefix;
    /**
     * The pageLogo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $pageLogo;
    /**
     * The state
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $state;
    /**
     * The country
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $country;
    /**
     * The mainAddress
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Address
     */
    public $mainAddress;
    /**
     * The shippingAddress
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Address
     */
    public $shippingAddress;
    /**
     * The returnAddress
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Address
     */
    public $returnAddress;
    /**
     * The legalName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $legalName;
    /**
     * The isElimination
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $isElimination;
    /**
     * The fiscalCalendar
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $fiscalCalendar;
    /**
     * The taxFiscalCalendar
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $taxFiscalCalendar;
    /**
     * The allowPayroll
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $allowPayroll;
    /**
     * The email
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $email;
    /**
     * The currency
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $currency;
    /**
     * The purchaseOrderQuantity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $purchaseOrderQuantity;
    /**
     * The purchaseOrderAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $purchaseOrderAmount;
    /**
     * The purchaseOrderQuantityDiff
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $purchaseOrderQuantityDiff;
    /**
     * The receiptQuantity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $receiptQuantity;
    /**
     * The receiptAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $receiptAmount;
    /**
     * The receiptQuantityDiff
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $receiptQuantityDiff;
    /**
     * The fax
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $fax;
    /**
     * The edition
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $edition;
    /**
     * The federalIdNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $federalIdNumber;
    /**
     * The addrLanguage
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $addrLanguage;
    /**
     * The nonConsol
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $nonConsol;
    /**
     * The consol
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $consol;
    /**
     * The state1TaxNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $state1TaxNumber;
    /**
     * The taxRegistrationList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SubsidiaryTaxRegistrationList
     */
    public $taxRegistrationList;
    /**
     * The ssnOrTin
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ssnOrTin;
    /**
     * The interCoAccount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $interCoAccount;
    /**
     * The nexusList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SubsidiaryNexusList
     */
    public $nexusList;
    /**
     * The accountingBookDetailList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SubsidiaryAccountingBookDetailList
     */
    public $accountingBookDetailList;
    /**
     * The checkLayout
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $checkLayout;
    /**
     * The inboundEmail
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $inboundEmail;
    /**
     * The classTranslationList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ClassTranslationList
     */
    public $classTranslationList;
    /**
     * The customFieldList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CustomFieldList
     */
    public $customFieldList;
    /**
     * The internalId
     * @var string
     */
    public $internalId;
    /**
     * The externalId
     * @var string
     */
    public $externalId;
    /**
     * Constructor method for Subsidiary
     * @uses Subsidiary::setName()
     * @uses Subsidiary::setParent()
     * @uses Subsidiary::setIsInactive()
     * @uses Subsidiary::setShowSubsidiaryName()
     * @uses Subsidiary::setUrl()
     * @uses Subsidiary::setLogo()
     * @uses Subsidiary::setTranPrefix()
     * @uses Subsidiary::setPageLogo()
     * @uses Subsidiary::setState()
     * @uses Subsidiary::setCountry()
     * @uses Subsidiary::setMainAddress()
     * @uses Subsidiary::setShippingAddress()
     * @uses Subsidiary::setReturnAddress()
     * @uses Subsidiary::setLegalName()
     * @uses Subsidiary::setIsElimination()
     * @uses Subsidiary::setFiscalCalendar()
     * @uses Subsidiary::setTaxFiscalCalendar()
     * @uses Subsidiary::setAllowPayroll()
     * @uses Subsidiary::setEmail()
     * @uses Subsidiary::setCurrency()
     * @uses Subsidiary::setPurchaseOrderQuantity()
     * @uses Subsidiary::setPurchaseOrderAmount()
     * @uses Subsidiary::setPurchaseOrderQuantityDiff()
     * @uses Subsidiary::setReceiptQuantity()
     * @uses Subsidiary::setReceiptAmount()
     * @uses Subsidiary::setReceiptQuantityDiff()
     * @uses Subsidiary::setFax()
     * @uses Subsidiary::setEdition()
     * @uses Subsidiary::setFederalIdNumber()
     * @uses Subsidiary::setAddrLanguage()
     * @uses Subsidiary::setNonConsol()
     * @uses Subsidiary::setConsol()
     * @uses Subsidiary::setState1TaxNumber()
     * @uses Subsidiary::setTaxRegistrationList()
     * @uses Subsidiary::setSsnOrTin()
     * @uses Subsidiary::setInterCoAccount()
     * @uses Subsidiary::setNexusList()
     * @uses Subsidiary::setAccountingBookDetailList()
     * @uses Subsidiary::setCheckLayout()
     * @uses Subsidiary::setInboundEmail()
     * @uses Subsidiary::setClassTranslationList()
     * @uses Subsidiary::setCustomFieldList()
     * @uses Subsidiary::setInternalId()
     * @uses Subsidiary::setExternalId()
     * @param string $name
     * @param \StructType\RecordRef $parent
     * @param bool $isInactive
     * @param bool $showSubsidiaryName
     * @param string $url
     * @param \StructType\RecordRef $logo
     * @param string $tranPrefix
     * @param \StructType\RecordRef $pageLogo
     * @param string $state
     * @param string $country
     * @param \StructType\Address $mainAddress
     * @param \StructType\Address $shippingAddress
     * @param \StructType\Address $returnAddress
     * @param string $legalName
     * @param bool $isElimination
     * @param \StructType\RecordRef $fiscalCalendar
     * @param \StructType\RecordRef $taxFiscalCalendar
     * @param bool $allowPayroll
     * @param string $email
     * @param \StructType\RecordRef $currency
     * @param float $purchaseOrderQuantity
     * @param float $purchaseOrderAmount
     * @param float $purchaseOrderQuantityDiff
     * @param float $receiptQuantity
     * @param float $receiptAmount
     * @param float $receiptQuantityDiff
     * @param string $fax
     * @param string $edition
     * @param string $federalIdNumber
     * @param string $addrLanguage
     * @param string $nonConsol
     * @param string $consol
     * @param string $state1TaxNumber
     * @param \StructType\SubsidiaryTaxRegistrationList $taxRegistrationList
     * @param string $ssnOrTin
     * @param \StructType\RecordRef $interCoAccount
     * @param \StructType\SubsidiaryNexusList $nexusList
     * @param \StructType\SubsidiaryAccountingBookDetailList $accountingBookDetailList
     * @param \StructType\RecordRef $checkLayout
     * @param string $inboundEmail
     * @param \StructType\ClassTranslationList $classTranslationList
     * @param \StructType\CustomFieldList $customFieldList
     * @param string $internalId
     * @param string $externalId
     */
    public function __construct($name = null, \StructType\RecordRef $parent = null, $isInactive = null, $showSubsidiaryName = null, $url = null, \StructType\RecordRef $logo = null, $tranPrefix = null, \StructType\RecordRef $pageLogo = null, $state = null, $country = null, \StructType\Address $mainAddress = null, \StructType\Address $shippingAddress = null, \StructType\Address $returnAddress = null, $legalName = null, $isElimination = null, \StructType\RecordRef $fiscalCalendar = null, \StructType\RecordRef $taxFiscalCalendar = null, $allowPayroll = null, $email = null, \StructType\RecordRef $currency = null, $purchaseOrderQuantity = null, $purchaseOrderAmount = null, $purchaseOrderQuantityDiff = null, $receiptQuantity = null, $receiptAmount = null, $receiptQuantityDiff = null, $fax = null, $edition = null, $federalIdNumber = null, $addrLanguage = null, $nonConsol = null, $consol = null, $state1TaxNumber = null, \StructType\SubsidiaryTaxRegistrationList $taxRegistrationList = null, $ssnOrTin = null, \StructType\RecordRef $interCoAccount = null, \StructType\SubsidiaryNexusList $nexusList = null, \StructType\SubsidiaryAccountingBookDetailList $accountingBookDetailList = null, \StructType\RecordRef $checkLayout = null, $inboundEmail = null, \StructType\ClassTranslationList $classTranslationList = null, \StructType\CustomFieldList $customFieldList = null, $internalId = null, $externalId = null)
    {
        $this
            ->setName($name)
            ->setParent($parent)
            ->setIsInactive($isInactive)
            ->setShowSubsidiaryName($showSubsidiaryName)
            ->setUrl($url)
            ->setLogo($logo)
            ->setTranPrefix($tranPrefix)
            ->setPageLogo($pageLogo)
            ->setState($state)
            ->setCountry($country)
            ->setMainAddress($mainAddress)
            ->setShippingAddress($shippingAddress)
            ->setReturnAddress($returnAddress)
            ->setLegalName($legalName)
            ->setIsElimination($isElimination)
            ->setFiscalCalendar($fiscalCalendar)
            ->setTaxFiscalCalendar($taxFiscalCalendar)
            ->setAllowPayroll($allowPayroll)
            ->setEmail($email)
            ->setCurrency($currency)
            ->setPurchaseOrderQuantity($purchaseOrderQuantity)
            ->setPurchaseOrderAmount($purchaseOrderAmount)
            ->setPurchaseOrderQuantityDiff($purchaseOrderQuantityDiff)
            ->setReceiptQuantity($receiptQuantity)
            ->setReceiptAmount($receiptAmount)
            ->setReceiptQuantityDiff($receiptQuantityDiff)
            ->setFax($fax)
            ->setEdition($edition)
            ->setFederalIdNumber($federalIdNumber)
            ->setAddrLanguage($addrLanguage)
            ->setNonConsol($nonConsol)
            ->setConsol($consol)
            ->setState1TaxNumber($state1TaxNumber)
            ->setTaxRegistrationList($taxRegistrationList)
            ->setSsnOrTin($ssnOrTin)
            ->setInterCoAccount($interCoAccount)
            ->setNexusList($nexusList)
            ->setAccountingBookDetailList($accountingBookDetailList)
            ->setCheckLayout($checkLayout)
            ->setInboundEmail($inboundEmail)
            ->setClassTranslationList($classTranslationList)
            ->setCustomFieldList($customFieldList)
            ->setInternalId($internalId)
            ->setExternalId($externalId);
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\Subsidiary
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get parent value
     * @return \StructType\RecordRef|null
     */
    public function getParent()
    {
        return $this->parent;
    }
    /**
     * Set parent value
     * @param \StructType\RecordRef $parent
     * @return \StructType\Subsidiary
     */
    public function setParent(\StructType\RecordRef $parent = null)
    {
        $this->parent = $parent;
        return $this;
    }
    /**
     * Get isInactive value
     * @return bool|null
     */
    public function getIsInactive()
    {
        return $this->isInactive;
    }
    /**
     * Set isInactive value
     * @param bool $isInactive
     * @return \StructType\Subsidiary
     */
    public function setIsInactive($isInactive = null)
    {
        // validation for constraint: boolean
        if (!is_null($isInactive) && !is_bool($isInactive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isInactive, true), gettype($isInactive)), __LINE__);
        }
        $this->isInactive = $isInactive;
        return $this;
    }
    /**
     * Get showSubsidiaryName value
     * @return bool|null
     */
    public function getShowSubsidiaryName()
    {
        return $this->showSubsidiaryName;
    }
    /**
     * Set showSubsidiaryName value
     * @param bool $showSubsidiaryName
     * @return \StructType\Subsidiary
     */
    public function setShowSubsidiaryName($showSubsidiaryName = null)
    {
        // validation for constraint: boolean
        if (!is_null($showSubsidiaryName) && !is_bool($showSubsidiaryName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($showSubsidiaryName, true), gettype($showSubsidiaryName)), __LINE__);
        }
        $this->showSubsidiaryName = $showSubsidiaryName;
        return $this;
    }
    /**
     * Get url value
     * @return string|null
     */
    public function getUrl()
    {
        return $this->url;
    }
    /**
     * Set url value
     * @param string $url
     * @return \StructType\Subsidiary
     */
    public function setUrl($url = null)
    {
        // validation for constraint: string
        if (!is_null($url) && !is_string($url)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($url, true), gettype($url)), __LINE__);
        }
        $this->url = $url;
        return $this;
    }
    /**
     * Get logo value
     * @return \StructType\RecordRef|null
     */
    public function getLogo()
    {
        return $this->logo;
    }
    /**
     * Set logo value
     * @param \StructType\RecordRef $logo
     * @return \StructType\Subsidiary
     */
    public function setLogo(\StructType\RecordRef $logo = null)
    {
        $this->logo = $logo;
        return $this;
    }
    /**
     * Get tranPrefix value
     * @return string|null
     */
    public function getTranPrefix()
    {
        return $this->tranPrefix;
    }
    /**
     * Set tranPrefix value
     * @param string $tranPrefix
     * @return \StructType\Subsidiary
     */
    public function setTranPrefix($tranPrefix = null)
    {
        // validation for constraint: string
        if (!is_null($tranPrefix) && !is_string($tranPrefix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tranPrefix, true), gettype($tranPrefix)), __LINE__);
        }
        $this->tranPrefix = $tranPrefix;
        return $this;
    }
    /**
     * Get pageLogo value
     * @return \StructType\RecordRef|null
     */
    public function getPageLogo()
    {
        return $this->pageLogo;
    }
    /**
     * Set pageLogo value
     * @param \StructType\RecordRef $pageLogo
     * @return \StructType\Subsidiary
     */
    public function setPageLogo(\StructType\RecordRef $pageLogo = null)
    {
        $this->pageLogo = $pageLogo;
        return $this;
    }
    /**
     * Get state value
     * @return string|null
     */
    public function getState()
    {
        return $this->state;
    }
    /**
     * Set state value
     * @param string $state
     * @return \StructType\Subsidiary
     */
    public function setState($state = null)
    {
        // validation for constraint: string
        if (!is_null($state) && !is_string($state)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($state, true), gettype($state)), __LINE__);
        }
        $this->state = $state;
        return $this;
    }
    /**
     * Get country value
     * @return string|null
     */
    public function getCountry()
    {
        return $this->country;
    }
    /**
     * Set country value
     * @uses \EnumType\Country::valueIsValid()
     * @uses \EnumType\Country::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $country
     * @return \StructType\Subsidiary
     */
    public function setCountry($country = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Country::valueIsValid($country)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\Country', is_array($country) ? implode(', ', $country) : var_export($country, true), implode(', ', \EnumType\Country::getValidValues())), __LINE__);
        }
        $this->country = $country;
        return $this;
    }
    /**
     * Get mainAddress value
     * @return \StructType\Address|null
     */
    public function getMainAddress()
    {
        return $this->mainAddress;
    }
    /**
     * Set mainAddress value
     * @param \StructType\Address $mainAddress
     * @return \StructType\Subsidiary
     */
    public function setMainAddress(\StructType\Address $mainAddress = null)
    {
        $this->mainAddress = $mainAddress;
        return $this;
    }
    /**
     * Get shippingAddress value
     * @return \StructType\Address|null
     */
    public function getShippingAddress()
    {
        return $this->shippingAddress;
    }
    /**
     * Set shippingAddress value
     * @param \StructType\Address $shippingAddress
     * @return \StructType\Subsidiary
     */
    public function setShippingAddress(\StructType\Address $shippingAddress = null)
    {
        $this->shippingAddress = $shippingAddress;
        return $this;
    }
    /**
     * Get returnAddress value
     * @return \StructType\Address|null
     */
    public function getReturnAddress()
    {
        return $this->returnAddress;
    }
    /**
     * Set returnAddress value
     * @param \StructType\Address $returnAddress
     * @return \StructType\Subsidiary
     */
    public function setReturnAddress(\StructType\Address $returnAddress = null)
    {
        $this->returnAddress = $returnAddress;
        return $this;
    }
    /**
     * Get legalName value
     * @return string|null
     */
    public function getLegalName()
    {
        return $this->legalName;
    }
    /**
     * Set legalName value
     * @param string $legalName
     * @return \StructType\Subsidiary
     */
    public function setLegalName($legalName = null)
    {
        // validation for constraint: string
        if (!is_null($legalName) && !is_string($legalName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($legalName, true), gettype($legalName)), __LINE__);
        }
        $this->legalName = $legalName;
        return $this;
    }
    /**
     * Get isElimination value
     * @return bool|null
     */
    public function getIsElimination()
    {
        return $this->isElimination;
    }
    /**
     * Set isElimination value
     * @param bool $isElimination
     * @return \StructType\Subsidiary
     */
    public function setIsElimination($isElimination = null)
    {
        // validation for constraint: boolean
        if (!is_null($isElimination) && !is_bool($isElimination)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isElimination, true), gettype($isElimination)), __LINE__);
        }
        $this->isElimination = $isElimination;
        return $this;
    }
    /**
     * Get fiscalCalendar value
     * @return \StructType\RecordRef|null
     */
    public function getFiscalCalendar()
    {
        return $this->fiscalCalendar;
    }
    /**
     * Set fiscalCalendar value
     * @param \StructType\RecordRef $fiscalCalendar
     * @return \StructType\Subsidiary
     */
    public function setFiscalCalendar(\StructType\RecordRef $fiscalCalendar = null)
    {
        $this->fiscalCalendar = $fiscalCalendar;
        return $this;
    }
    /**
     * Get taxFiscalCalendar value
     * @return \StructType\RecordRef|null
     */
    public function getTaxFiscalCalendar()
    {
        return $this->taxFiscalCalendar;
    }
    /**
     * Set taxFiscalCalendar value
     * @param \StructType\RecordRef $taxFiscalCalendar
     * @return \StructType\Subsidiary
     */
    public function setTaxFiscalCalendar(\StructType\RecordRef $taxFiscalCalendar = null)
    {
        $this->taxFiscalCalendar = $taxFiscalCalendar;
        return $this;
    }
    /**
     * Get allowPayroll value
     * @return bool|null
     */
    public function getAllowPayroll()
    {
        return $this->allowPayroll;
    }
    /**
     * Set allowPayroll value
     * @param bool $allowPayroll
     * @return \StructType\Subsidiary
     */
    public function setAllowPayroll($allowPayroll = null)
    {
        // validation for constraint: boolean
        if (!is_null($allowPayroll) && !is_bool($allowPayroll)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($allowPayroll, true), gettype($allowPayroll)), __LINE__);
        }
        $this->allowPayroll = $allowPayroll;
        return $this;
    }
    /**
     * Get email value
     * @return string|null
     */
    public function getEmail()
    {
        return $this->email;
    }
    /**
     * Set email value
     * @param string $email
     * @return \StructType\Subsidiary
     */
    public function setEmail($email = null)
    {
        // validation for constraint: string
        if (!is_null($email) && !is_string($email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($email, true), gettype($email)), __LINE__);
        }
        $this->email = $email;
        return $this;
    }
    /**
     * Get currency value
     * @return \StructType\RecordRef|null
     */
    public function getCurrency()
    {
        return $this->currency;
    }
    /**
     * Set currency value
     * @param \StructType\RecordRef $currency
     * @return \StructType\Subsidiary
     */
    public function setCurrency(\StructType\RecordRef $currency = null)
    {
        $this->currency = $currency;
        return $this;
    }
    /**
     * Get purchaseOrderQuantity value
     * @return float|null
     */
    public function getPurchaseOrderQuantity()
    {
        return $this->purchaseOrderQuantity;
    }
    /**
     * Set purchaseOrderQuantity value
     * @param float $purchaseOrderQuantity
     * @return \StructType\Subsidiary
     */
    public function setPurchaseOrderQuantity($purchaseOrderQuantity = null)
    {
        // validation for constraint: float
        if (!is_null($purchaseOrderQuantity) && !(is_float($purchaseOrderQuantity) || is_numeric($purchaseOrderQuantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($purchaseOrderQuantity, true), gettype($purchaseOrderQuantity)), __LINE__);
        }
        $this->purchaseOrderQuantity = $purchaseOrderQuantity;
        return $this;
    }
    /**
     * Get purchaseOrderAmount value
     * @return float|null
     */
    public function getPurchaseOrderAmount()
    {
        return $this->purchaseOrderAmount;
    }
    /**
     * Set purchaseOrderAmount value
     * @param float $purchaseOrderAmount
     * @return \StructType\Subsidiary
     */
    public function setPurchaseOrderAmount($purchaseOrderAmount = null)
    {
        // validation for constraint: float
        if (!is_null($purchaseOrderAmount) && !(is_float($purchaseOrderAmount) || is_numeric($purchaseOrderAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($purchaseOrderAmount, true), gettype($purchaseOrderAmount)), __LINE__);
        }
        $this->purchaseOrderAmount = $purchaseOrderAmount;
        return $this;
    }
    /**
     * Get purchaseOrderQuantityDiff value
     * @return float|null
     */
    public function getPurchaseOrderQuantityDiff()
    {
        return $this->purchaseOrderQuantityDiff;
    }
    /**
     * Set purchaseOrderQuantityDiff value
     * @param float $purchaseOrderQuantityDiff
     * @return \StructType\Subsidiary
     */
    public function setPurchaseOrderQuantityDiff($purchaseOrderQuantityDiff = null)
    {
        // validation for constraint: float
        if (!is_null($purchaseOrderQuantityDiff) && !(is_float($purchaseOrderQuantityDiff) || is_numeric($purchaseOrderQuantityDiff))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($purchaseOrderQuantityDiff, true), gettype($purchaseOrderQuantityDiff)), __LINE__);
        }
        $this->purchaseOrderQuantityDiff = $purchaseOrderQuantityDiff;
        return $this;
    }
    /**
     * Get receiptQuantity value
     * @return float|null
     */
    public function getReceiptQuantity()
    {
        return $this->receiptQuantity;
    }
    /**
     * Set receiptQuantity value
     * @param float $receiptQuantity
     * @return \StructType\Subsidiary
     */
    public function setReceiptQuantity($receiptQuantity = null)
    {
        // validation for constraint: float
        if (!is_null($receiptQuantity) && !(is_float($receiptQuantity) || is_numeric($receiptQuantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($receiptQuantity, true), gettype($receiptQuantity)), __LINE__);
        }
        $this->receiptQuantity = $receiptQuantity;
        return $this;
    }
    /**
     * Get receiptAmount value
     * @return float|null
     */
    public function getReceiptAmount()
    {
        return $this->receiptAmount;
    }
    /**
     * Set receiptAmount value
     * @param float $receiptAmount
     * @return \StructType\Subsidiary
     */
    public function setReceiptAmount($receiptAmount = null)
    {
        // validation for constraint: float
        if (!is_null($receiptAmount) && !(is_float($receiptAmount) || is_numeric($receiptAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($receiptAmount, true), gettype($receiptAmount)), __LINE__);
        }
        $this->receiptAmount = $receiptAmount;
        return $this;
    }
    /**
     * Get receiptQuantityDiff value
     * @return float|null
     */
    public function getReceiptQuantityDiff()
    {
        return $this->receiptQuantityDiff;
    }
    /**
     * Set receiptQuantityDiff value
     * @param float $receiptQuantityDiff
     * @return \StructType\Subsidiary
     */
    public function setReceiptQuantityDiff($receiptQuantityDiff = null)
    {
        // validation for constraint: float
        if (!is_null($receiptQuantityDiff) && !(is_float($receiptQuantityDiff) || is_numeric($receiptQuantityDiff))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($receiptQuantityDiff, true), gettype($receiptQuantityDiff)), __LINE__);
        }
        $this->receiptQuantityDiff = $receiptQuantityDiff;
        return $this;
    }
    /**
     * Get fax value
     * @return string|null
     */
    public function getFax()
    {
        return $this->fax;
    }
    /**
     * Set fax value
     * @param string $fax
     * @return \StructType\Subsidiary
     */
    public function setFax($fax = null)
    {
        // validation for constraint: string
        if (!is_null($fax) && !is_string($fax)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fax, true), gettype($fax)), __LINE__);
        }
        $this->fax = $fax;
        return $this;
    }
    /**
     * Get edition value
     * @return string|null
     */
    public function getEdition()
    {
        return $this->edition;
    }
    /**
     * Set edition value
     * @param string $edition
     * @return \StructType\Subsidiary
     */
    public function setEdition($edition = null)
    {
        // validation for constraint: string
        if (!is_null($edition) && !is_string($edition)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($edition, true), gettype($edition)), __LINE__);
        }
        $this->edition = $edition;
        return $this;
    }
    /**
     * Get federalIdNumber value
     * @return string|null
     */
    public function getFederalIdNumber()
    {
        return $this->federalIdNumber;
    }
    /**
     * Set federalIdNumber value
     * @param string $federalIdNumber
     * @return \StructType\Subsidiary
     */
    public function setFederalIdNumber($federalIdNumber = null)
    {
        // validation for constraint: string
        if (!is_null($federalIdNumber) && !is_string($federalIdNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($federalIdNumber, true), gettype($federalIdNumber)), __LINE__);
        }
        $this->federalIdNumber = $federalIdNumber;
        return $this;
    }
    /**
     * Get addrLanguage value
     * @return string|null
     */
    public function getAddrLanguage()
    {
        return $this->addrLanguage;
    }
    /**
     * Set addrLanguage value
     * @param string $addrLanguage
     * @return \StructType\Subsidiary
     */
    public function setAddrLanguage($addrLanguage = null)
    {
        // validation for constraint: string
        if (!is_null($addrLanguage) && !is_string($addrLanguage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($addrLanguage, true), gettype($addrLanguage)), __LINE__);
        }
        $this->addrLanguage = $addrLanguage;
        return $this;
    }
    /**
     * Get nonConsol value
     * @return string|null
     */
    public function getNonConsol()
    {
        return $this->nonConsol;
    }
    /**
     * Set nonConsol value
     * @param string $nonConsol
     * @return \StructType\Subsidiary
     */
    public function setNonConsol($nonConsol = null)
    {
        // validation for constraint: string
        if (!is_null($nonConsol) && !is_string($nonConsol)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nonConsol, true), gettype($nonConsol)), __LINE__);
        }
        $this->nonConsol = $nonConsol;
        return $this;
    }
    /**
     * Get consol value
     * @return string|null
     */
    public function getConsol()
    {
        return $this->consol;
    }
    /**
     * Set consol value
     * @param string $consol
     * @return \StructType\Subsidiary
     */
    public function setConsol($consol = null)
    {
        // validation for constraint: string
        if (!is_null($consol) && !is_string($consol)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($consol, true), gettype($consol)), __LINE__);
        }
        $this->consol = $consol;
        return $this;
    }
    /**
     * Get state1TaxNumber value
     * @return string|null
     */
    public function getState1TaxNumber()
    {
        return $this->state1TaxNumber;
    }
    /**
     * Set state1TaxNumber value
     * @param string $state1TaxNumber
     * @return \StructType\Subsidiary
     */
    public function setState1TaxNumber($state1TaxNumber = null)
    {
        // validation for constraint: string
        if (!is_null($state1TaxNumber) && !is_string($state1TaxNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($state1TaxNumber, true), gettype($state1TaxNumber)), __LINE__);
        }
        $this->state1TaxNumber = $state1TaxNumber;
        return $this;
    }
    /**
     * Get taxRegistrationList value
     * @return \StructType\SubsidiaryTaxRegistrationList|null
     */
    public function getTaxRegistrationList()
    {
        return $this->taxRegistrationList;
    }
    /**
     * Set taxRegistrationList value
     * @param \StructType\SubsidiaryTaxRegistrationList $taxRegistrationList
     * @return \StructType\Subsidiary
     */
    public function setTaxRegistrationList(\StructType\SubsidiaryTaxRegistrationList $taxRegistrationList = null)
    {
        $this->taxRegistrationList = $taxRegistrationList;
        return $this;
    }
    /**
     * Get ssnOrTin value
     * @return string|null
     */
    public function getSsnOrTin()
    {
        return $this->ssnOrTin;
    }
    /**
     * Set ssnOrTin value
     * @param string $ssnOrTin
     * @return \StructType\Subsidiary
     */
    public function setSsnOrTin($ssnOrTin = null)
    {
        // validation for constraint: string
        if (!is_null($ssnOrTin) && !is_string($ssnOrTin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ssnOrTin, true), gettype($ssnOrTin)), __LINE__);
        }
        $this->ssnOrTin = $ssnOrTin;
        return $this;
    }
    /**
     * Get interCoAccount value
     * @return \StructType\RecordRef|null
     */
    public function getInterCoAccount()
    {
        return $this->interCoAccount;
    }
    /**
     * Set interCoAccount value
     * @param \StructType\RecordRef $interCoAccount
     * @return \StructType\Subsidiary
     */
    public function setInterCoAccount(\StructType\RecordRef $interCoAccount = null)
    {
        $this->interCoAccount = $interCoAccount;
        return $this;
    }
    /**
     * Get nexusList value
     * @return \StructType\SubsidiaryNexusList|null
     */
    public function getNexusList()
    {
        return $this->nexusList;
    }
    /**
     * Set nexusList value
     * @param \StructType\SubsidiaryNexusList $nexusList
     * @return \StructType\Subsidiary
     */
    public function setNexusList(\StructType\SubsidiaryNexusList $nexusList = null)
    {
        $this->nexusList = $nexusList;
        return $this;
    }
    /**
     * Get accountingBookDetailList value
     * @return \StructType\SubsidiaryAccountingBookDetailList|null
     */
    public function getAccountingBookDetailList()
    {
        return $this->accountingBookDetailList;
    }
    /**
     * Set accountingBookDetailList value
     * @param \StructType\SubsidiaryAccountingBookDetailList $accountingBookDetailList
     * @return \StructType\Subsidiary
     */
    public function setAccountingBookDetailList(\StructType\SubsidiaryAccountingBookDetailList $accountingBookDetailList = null)
    {
        $this->accountingBookDetailList = $accountingBookDetailList;
        return $this;
    }
    /**
     * Get checkLayout value
     * @return \StructType\RecordRef|null
     */
    public function getCheckLayout()
    {
        return $this->checkLayout;
    }
    /**
     * Set checkLayout value
     * @param \StructType\RecordRef $checkLayout
     * @return \StructType\Subsidiary
     */
    public function setCheckLayout(\StructType\RecordRef $checkLayout = null)
    {
        $this->checkLayout = $checkLayout;
        return $this;
    }
    /**
     * Get inboundEmail value
     * @return string|null
     */
    public function getInboundEmail()
    {
        return $this->inboundEmail;
    }
    /**
     * Set inboundEmail value
     * @param string $inboundEmail
     * @return \StructType\Subsidiary
     */
    public function setInboundEmail($inboundEmail = null)
    {
        // validation for constraint: string
        if (!is_null($inboundEmail) && !is_string($inboundEmail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inboundEmail, true), gettype($inboundEmail)), __LINE__);
        }
        $this->inboundEmail = $inboundEmail;
        return $this;
    }
    /**
     * Get classTranslationList value
     * @return \StructType\ClassTranslationList|null
     */
    public function getClassTranslationList()
    {
        return $this->classTranslationList;
    }
    /**
     * Set classTranslationList value
     * @param \StructType\ClassTranslationList $classTranslationList
     * @return \StructType\Subsidiary
     */
    public function setClassTranslationList(\StructType\ClassTranslationList $classTranslationList = null)
    {
        $this->classTranslationList = $classTranslationList;
        return $this;
    }
    /**
     * Get customFieldList value
     * @return \StructType\CustomFieldList|null
     */
    public function getCustomFieldList()
    {
        return $this->customFieldList;
    }
    /**
     * Set customFieldList value
     * @param \StructType\CustomFieldList $customFieldList
     * @return \StructType\Subsidiary
     */
    public function setCustomFieldList(\StructType\CustomFieldList $customFieldList = null)
    {
        $this->customFieldList = $customFieldList;
        return $this;
    }
    /**
     * Get internalId value
     * @return string|null
     */
    public function getInternalId()
    {
        return $this->internalId;
    }
    /**
     * Set internalId value
     * @param string $internalId
     * @return \StructType\Subsidiary
     */
    public function setInternalId($internalId = null)
    {
        // validation for constraint: string
        if (!is_null($internalId) && !is_string($internalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($internalId, true), gettype($internalId)), __LINE__);
        }
        $this->internalId = $internalId;
        return $this;
    }
    /**
     * Get externalId value
     * @return string|null
     */
    public function getExternalId()
    {
        return $this->externalId;
    }
    /**
     * Set externalId value
     * @param string $externalId
     * @return \StructType\Subsidiary
     */
    public function setExternalId($externalId = null)
    {
        // validation for constraint: string
        if (!is_null($externalId) && !is_string($externalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($externalId, true), gettype($externalId)), __LINE__);
        }
        $this->externalId = $externalId;
        return $this;
    }
}
