<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Status StructType
 * @subpackage Structs
 */
class Status extends AbstractStructBase
{
    /**
     * The statusDetail
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\StatusDetail[]
     */
    public $statusDetail;
    /**
     * The isSuccess
     * @var bool
     */
    public $isSuccess;
    /**
     * Constructor method for Status
     * @uses Status::setStatusDetail()
     * @uses Status::setIsSuccess()
     * @param \StructType\StatusDetail[] $statusDetail
     * @param bool $isSuccess
     */
    public function __construct(array $statusDetail = array(), $isSuccess = null)
    {
        $this
            ->setStatusDetail($statusDetail)
            ->setIsSuccess($isSuccess);
    }
    /**
     * Get statusDetail value
     * @return \StructType\StatusDetail[]|null
     */
    public function getStatusDetail()
    {
        return $this->statusDetail;
    }
    /**
     * This method is responsible for validating the values passed to the setStatusDetail method
     * This method is willingly generated in order to preserve the one-line inline validation within the setStatusDetail method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateStatusDetailForArrayConstraintsFromSetStatusDetail(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $statusStatusDetailItem) {
            // validation for constraint: itemType
            if (!$statusStatusDetailItem instanceof \StructType\StatusDetail) {
                $invalidValues[] = is_object($statusStatusDetailItem) ? get_class($statusStatusDetailItem) : sprintf('%s(%s)', gettype($statusStatusDetailItem), var_export($statusStatusDetailItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The statusDetail property can only contain items of type \StructType\StatusDetail, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set statusDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\StatusDetail[] $statusDetail
     * @return \StructType\Status
     */
    public function setStatusDetail(array $statusDetail = array())
    {
        // validation for constraint: array
        if ('' !== ($statusDetailArrayErrorMessage = self::validateStatusDetailForArrayConstraintsFromSetStatusDetail($statusDetail))) {
            throw new \InvalidArgumentException($statusDetailArrayErrorMessage, __LINE__);
        }
        $this->statusDetail = $statusDetail;
        return $this;
    }
    /**
     * Add item to statusDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\StatusDetail $item
     * @return \StructType\Status
     */
    public function addToStatusDetail(\StructType\StatusDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\StatusDetail) {
            throw new \InvalidArgumentException(sprintf('The statusDetail property can only contain items of type \StructType\StatusDetail, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->statusDetail[] = $item;
        return $this;
    }
    /**
     * Get isSuccess value
     * @return bool|null
     */
    public function getIsSuccess()
    {
        return $this->isSuccess;
    }
    /**
     * Set isSuccess value
     * @param bool $isSuccess
     * @return \StructType\Status
     */
    public function setIsSuccess($isSuccess = null)
    {
        // validation for constraint: boolean
        if (!is_null($isSuccess) && !is_bool($isSuccess)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isSuccess, true), gettype($isSuccess)), __LINE__);
        }
        $this->isSuccess = $isSuccess;
        return $this;
    }
}
