<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SolutionsList StructType
 * @subpackage Structs
 */
class SolutionsList extends AbstractStructBase
{
    /**
     * The solutions
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Solutions[]
     */
    public $solutions;
    /**
     * The replaceAll
     * Meta information extracted from the WSDL
     * - default: true
     * @var bool
     */
    public $replaceAll;
    /**
     * Constructor method for SolutionsList
     * @uses SolutionsList::setSolutions()
     * @uses SolutionsList::setReplaceAll()
     * @param \StructType\Solutions[] $solutions
     * @param bool $replaceAll
     */
    public function __construct(array $solutions = array(), $replaceAll = true)
    {
        $this
            ->setSolutions($solutions)
            ->setReplaceAll($replaceAll);
    }
    /**
     * Get solutions value
     * @return \StructType\Solutions[]|null
     */
    public function getSolutions()
    {
        return $this->solutions;
    }
    /**
     * This method is responsible for validating the values passed to the setSolutions method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSolutions method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSolutionsForArrayConstraintsFromSetSolutions(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $solutionsListSolutionsItem) {
            // validation for constraint: itemType
            if (!$solutionsListSolutionsItem instanceof \StructType\Solutions) {
                $invalidValues[] = is_object($solutionsListSolutionsItem) ? get_class($solutionsListSolutionsItem) : sprintf('%s(%s)', gettype($solutionsListSolutionsItem), var_export($solutionsListSolutionsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The solutions property can only contain items of type \StructType\Solutions, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set solutions value
     * @throws \InvalidArgumentException
     * @param \StructType\Solutions[] $solutions
     * @return \StructType\SolutionsList
     */
    public function setSolutions(array $solutions = array())
    {
        // validation for constraint: array
        if ('' !== ($solutionsArrayErrorMessage = self::validateSolutionsForArrayConstraintsFromSetSolutions($solutions))) {
            throw new \InvalidArgumentException($solutionsArrayErrorMessage, __LINE__);
        }
        $this->solutions = $solutions;
        return $this;
    }
    /**
     * Add item to solutions value
     * @throws \InvalidArgumentException
     * @param \StructType\Solutions $item
     * @return \StructType\SolutionsList
     */
    public function addToSolutions(\StructType\Solutions $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Solutions) {
            throw new \InvalidArgumentException(sprintf('The solutions property can only contain items of type \StructType\Solutions, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->solutions[] = $item;
        return $this;
    }
    /**
     * Get replaceAll value
     * @return bool|null
     */
    public function getReplaceAll()
    {
        return $this->replaceAll;
    }
    /**
     * Set replaceAll value
     * @param bool $replaceAll
     * @return \StructType\SolutionsList
     */
    public function setReplaceAll($replaceAll = true)
    {
        // validation for constraint: boolean
        if (!is_null($replaceAll) && !is_bool($replaceAll)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($replaceAll, true), gettype($replaceAll)), __LINE__);
        }
        $this->replaceAll = $replaceAll;
        return $this;
    }
}
