<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SiteCategoryTranslationList StructType
 * @subpackage Structs
 */
class SiteCategoryTranslationList extends AbstractStructBase
{
    /**
     * The translation
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SiteCategoryTranslation[]
     */
    public $translation;
    /**
     * The replaceAll
     * Meta information extracted from the WSDL
     * - default: true
     * @var bool
     */
    public $replaceAll;
    /**
     * Constructor method for SiteCategoryTranslationList
     * @uses SiteCategoryTranslationList::setTranslation()
     * @uses SiteCategoryTranslationList::setReplaceAll()
     * @param \StructType\SiteCategoryTranslation[] $translation
     * @param bool $replaceAll
     */
    public function __construct(array $translation = array(), $replaceAll = true)
    {
        $this
            ->setTranslation($translation)
            ->setReplaceAll($replaceAll);
    }
    /**
     * Get translation value
     * @return \StructType\SiteCategoryTranslation[]|null
     */
    public function getTranslation()
    {
        return $this->translation;
    }
    /**
     * This method is responsible for validating the values passed to the setTranslation method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTranslation method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTranslationForArrayConstraintsFromSetTranslation(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $siteCategoryTranslationListTranslationItem) {
            // validation for constraint: itemType
            if (!$siteCategoryTranslationListTranslationItem instanceof \StructType\SiteCategoryTranslation) {
                $invalidValues[] = is_object($siteCategoryTranslationListTranslationItem) ? get_class($siteCategoryTranslationListTranslationItem) : sprintf('%s(%s)', gettype($siteCategoryTranslationListTranslationItem), var_export($siteCategoryTranslationListTranslationItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The translation property can only contain items of type \StructType\SiteCategoryTranslation, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set translation value
     * @throws \InvalidArgumentException
     * @param \StructType\SiteCategoryTranslation[] $translation
     * @return \StructType\SiteCategoryTranslationList
     */
    public function setTranslation(array $translation = array())
    {
        // validation for constraint: array
        if ('' !== ($translationArrayErrorMessage = self::validateTranslationForArrayConstraintsFromSetTranslation($translation))) {
            throw new \InvalidArgumentException($translationArrayErrorMessage, __LINE__);
        }
        $this->translation = $translation;
        return $this;
    }
    /**
     * Add item to translation value
     * @throws \InvalidArgumentException
     * @param \StructType\SiteCategoryTranslation $item
     * @return \StructType\SiteCategoryTranslationList
     */
    public function addToTranslation(\StructType\SiteCategoryTranslation $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SiteCategoryTranslation) {
            throw new \InvalidArgumentException(sprintf('The translation property can only contain items of type \StructType\SiteCategoryTranslation, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->translation[] = $item;
        return $this;
    }
    /**
     * Get replaceAll value
     * @return bool|null
     */
    public function getReplaceAll()
    {
        return $this->replaceAll;
    }
    /**
     * Set replaceAll value
     * @param bool $replaceAll
     * @return \StructType\SiteCategoryTranslationList
     */
    public function setReplaceAll($replaceAll = true)
    {
        // validation for constraint: boolean
        if (!is_null($replaceAll) && !is_bool($replaceAll)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($replaceAll, true), gettype($replaceAll)), __LINE__);
        }
        $this->replaceAll = $replaceAll;
        return $this;
    }
}
