<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SiteCategoryPresentationItemList StructType
 * @subpackage Structs
 */
class SiteCategoryPresentationItemList extends AbstractStructBase
{
    /**
     * The presentationItem
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\PresentationItem[]
     */
    public $presentationItem;
    /**
     * The replaceAll
     * Meta information extracted from the WSDL
     * - default: true
     * @var bool
     */
    public $replaceAll;
    /**
     * Constructor method for SiteCategoryPresentationItemList
     * @uses SiteCategoryPresentationItemList::setPresentationItem()
     * @uses SiteCategoryPresentationItemList::setReplaceAll()
     * @param \StructType\PresentationItem[] $presentationItem
     * @param bool $replaceAll
     */
    public function __construct(array $presentationItem = array(), $replaceAll = true)
    {
        $this
            ->setPresentationItem($presentationItem)
            ->setReplaceAll($replaceAll);
    }
    /**
     * Get presentationItem value
     * @return \StructType\PresentationItem[]|null
     */
    public function getPresentationItem()
    {
        return $this->presentationItem;
    }
    /**
     * This method is responsible for validating the values passed to the setPresentationItem method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPresentationItem method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePresentationItemForArrayConstraintsFromSetPresentationItem(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $siteCategoryPresentationItemListPresentationItemItem) {
            // validation for constraint: itemType
            if (!$siteCategoryPresentationItemListPresentationItemItem instanceof \StructType\PresentationItem) {
                $invalidValues[] = is_object($siteCategoryPresentationItemListPresentationItemItem) ? get_class($siteCategoryPresentationItemListPresentationItemItem) : sprintf('%s(%s)', gettype($siteCategoryPresentationItemListPresentationItemItem), var_export($siteCategoryPresentationItemListPresentationItemItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The presentationItem property can only contain items of type \StructType\PresentationItem, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set presentationItem value
     * @throws \InvalidArgumentException
     * @param \StructType\PresentationItem[] $presentationItem
     * @return \StructType\SiteCategoryPresentationItemList
     */
    public function setPresentationItem(array $presentationItem = array())
    {
        // validation for constraint: array
        if ('' !== ($presentationItemArrayErrorMessage = self::validatePresentationItemForArrayConstraintsFromSetPresentationItem($presentationItem))) {
            throw new \InvalidArgumentException($presentationItemArrayErrorMessage, __LINE__);
        }
        $this->presentationItem = $presentationItem;
        return $this;
    }
    /**
     * Add item to presentationItem value
     * @throws \InvalidArgumentException
     * @param \StructType\PresentationItem $item
     * @return \StructType\SiteCategoryPresentationItemList
     */
    public function addToPresentationItem(\StructType\PresentationItem $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PresentationItem) {
            throw new \InvalidArgumentException(sprintf('The presentationItem property can only contain items of type \StructType\PresentationItem, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->presentationItem[] = $item;
        return $this;
    }
    /**
     * Get replaceAll value
     * @return bool|null
     */
    public function getReplaceAll()
    {
        return $this->replaceAll;
    }
    /**
     * Set replaceAll value
     * @param bool $replaceAll
     * @return \StructType\SiteCategoryPresentationItemList
     */
    public function setReplaceAll($replaceAll = true)
    {
        // validation for constraint: boolean
        if (!is_null($replaceAll) && !is_bool($replaceAll)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($replaceAll, true), gettype($replaceAll)), __LINE__);
        }
        $this->replaceAll = $replaceAll;
        return $this;
    }
}
