<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SiteCategory StructType
 * Meta information extracted from the WSDL
 * - type: listSite:SiteCategory
 * @subpackage Structs
 */
class SiteCategory extends Record
{
    /**
     * The website
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $website;
    /**
     * The category
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $category;
    /**
     * The isDefault
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $isDefault;
    /**
     * The categoryDescription
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $categoryDescription;
    /**
     * The itemId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $itemId;
    /**
     * The parentCategory
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $parentCategory;
    /**
     * The categoryListLayout
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $categoryListLayout;
    /**
     * The itemListLayout
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $itemListLayout;
    /**
     * The relatedItemsListLayout
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $relatedItemsListLayout;
    /**
     * The correlatedItemsListLayout
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $correlatedItemsListLayout;
    /**
     * The isOnline
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $isOnline;
    /**
     * The isInactive
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $isInactive;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $description;
    /**
     * The storeDetailedDescription
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $storeDetailedDescription;
    /**
     * The storeDisplayThumbnail
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $storeDisplayThumbnail;
    /**
     * The storeDisplayImage
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $storeDisplayImage;
    /**
     * The pageTitle
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $pageTitle;
    /**
     * The metaTagHtml
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $metaTagHtml;
    /**
     * The excludeFromSitemap
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $excludeFromSitemap;
    /**
     * The urlComponent
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $urlComponent;
    /**
     * The sitemapPriority
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $sitemapPriority;
    /**
     * The searchKeywords
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $searchKeywords;
    /**
     * The presentationItemList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SiteCategoryPresentationItemList
     */
    public $presentationItemList;
    /**
     * The translationsList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SiteCategoryTranslationList
     */
    public $translationsList;
    /**
     * The internalId
     * @var string
     */
    public $internalId;
    /**
     * The externalId
     * @var string
     */
    public $externalId;
    /**
     * Constructor method for SiteCategory
     * @uses SiteCategory::setWebsite()
     * @uses SiteCategory::setCategory()
     * @uses SiteCategory::setIsDefault()
     * @uses SiteCategory::setCategoryDescription()
     * @uses SiteCategory::setItemId()
     * @uses SiteCategory::setParentCategory()
     * @uses SiteCategory::setCategoryListLayout()
     * @uses SiteCategory::setItemListLayout()
     * @uses SiteCategory::setRelatedItemsListLayout()
     * @uses SiteCategory::setCorrelatedItemsListLayout()
     * @uses SiteCategory::setIsOnline()
     * @uses SiteCategory::setIsInactive()
     * @uses SiteCategory::setDescription()
     * @uses SiteCategory::setStoreDetailedDescription()
     * @uses SiteCategory::setStoreDisplayThumbnail()
     * @uses SiteCategory::setStoreDisplayImage()
     * @uses SiteCategory::setPageTitle()
     * @uses SiteCategory::setMetaTagHtml()
     * @uses SiteCategory::setExcludeFromSitemap()
     * @uses SiteCategory::setUrlComponent()
     * @uses SiteCategory::setSitemapPriority()
     * @uses SiteCategory::setSearchKeywords()
     * @uses SiteCategory::setPresentationItemList()
     * @uses SiteCategory::setTranslationsList()
     * @uses SiteCategory::setInternalId()
     * @uses SiteCategory::setExternalId()
     * @param \StructType\RecordRef $website
     * @param \StructType\RecordRef $category
     * @param bool $isDefault
     * @param string $categoryDescription
     * @param string $itemId
     * @param \StructType\RecordRef $parentCategory
     * @param \StructType\RecordRef $categoryListLayout
     * @param \StructType\RecordRef $itemListLayout
     * @param \StructType\RecordRef $relatedItemsListLayout
     * @param \StructType\RecordRef $correlatedItemsListLayout
     * @param bool $isOnline
     * @param bool $isInactive
     * @param string $description
     * @param string $storeDetailedDescription
     * @param \StructType\RecordRef $storeDisplayThumbnail
     * @param \StructType\RecordRef $storeDisplayImage
     * @param string $pageTitle
     * @param string $metaTagHtml
     * @param bool $excludeFromSitemap
     * @param string $urlComponent
     * @param string $sitemapPriority
     * @param string $searchKeywords
     * @param \StructType\SiteCategoryPresentationItemList $presentationItemList
     * @param \StructType\SiteCategoryTranslationList $translationsList
     * @param string $internalId
     * @param string $externalId
     */
    public function __construct(\StructType\RecordRef $website = null, \StructType\RecordRef $category = null, $isDefault = null, $categoryDescription = null, $itemId = null, \StructType\RecordRef $parentCategory = null, \StructType\RecordRef $categoryListLayout = null, \StructType\RecordRef $itemListLayout = null, \StructType\RecordRef $relatedItemsListLayout = null, \StructType\RecordRef $correlatedItemsListLayout = null, $isOnline = null, $isInactive = null, $description = null, $storeDetailedDescription = null, \StructType\RecordRef $storeDisplayThumbnail = null, \StructType\RecordRef $storeDisplayImage = null, $pageTitle = null, $metaTagHtml = null, $excludeFromSitemap = null, $urlComponent = null, $sitemapPriority = null, $searchKeywords = null, \StructType\SiteCategoryPresentationItemList $presentationItemList = null, \StructType\SiteCategoryTranslationList $translationsList = null, $internalId = null, $externalId = null)
    {
        $this
            ->setWebsite($website)
            ->setCategory($category)
            ->setIsDefault($isDefault)
            ->setCategoryDescription($categoryDescription)
            ->setItemId($itemId)
            ->setParentCategory($parentCategory)
            ->setCategoryListLayout($categoryListLayout)
            ->setItemListLayout($itemListLayout)
            ->setRelatedItemsListLayout($relatedItemsListLayout)
            ->setCorrelatedItemsListLayout($correlatedItemsListLayout)
            ->setIsOnline($isOnline)
            ->setIsInactive($isInactive)
            ->setDescription($description)
            ->setStoreDetailedDescription($storeDetailedDescription)
            ->setStoreDisplayThumbnail($storeDisplayThumbnail)
            ->setStoreDisplayImage($storeDisplayImage)
            ->setPageTitle($pageTitle)
            ->setMetaTagHtml($metaTagHtml)
            ->setExcludeFromSitemap($excludeFromSitemap)
            ->setUrlComponent($urlComponent)
            ->setSitemapPriority($sitemapPriority)
            ->setSearchKeywords($searchKeywords)
            ->setPresentationItemList($presentationItemList)
            ->setTranslationsList($translationsList)
            ->setInternalId($internalId)
            ->setExternalId($externalId);
    }
    /**
     * Get website value
     * @return \StructType\RecordRef|null
     */
    public function getWebsite()
    {
        return $this->website;
    }
    /**
     * Set website value
     * @param \StructType\RecordRef $website
     * @return \StructType\SiteCategory
     */
    public function setWebsite(\StructType\RecordRef $website = null)
    {
        $this->website = $website;
        return $this;
    }
    /**
     * Get category value
     * @return \StructType\RecordRef|null
     */
    public function getCategory()
    {
        return $this->category;
    }
    /**
     * Set category value
     * @param \StructType\RecordRef $category
     * @return \StructType\SiteCategory
     */
    public function setCategory(\StructType\RecordRef $category = null)
    {
        $this->category = $category;
        return $this;
    }
    /**
     * Get isDefault value
     * @return bool|null
     */
    public function getIsDefault()
    {
        return $this->isDefault;
    }
    /**
     * Set isDefault value
     * @param bool $isDefault
     * @return \StructType\SiteCategory
     */
    public function setIsDefault($isDefault = null)
    {
        // validation for constraint: boolean
        if (!is_null($isDefault) && !is_bool($isDefault)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isDefault, true), gettype($isDefault)), __LINE__);
        }
        $this->isDefault = $isDefault;
        return $this;
    }
    /**
     * Get categoryDescription value
     * @return string|null
     */
    public function getCategoryDescription()
    {
        return $this->categoryDescription;
    }
    /**
     * Set categoryDescription value
     * @param string $categoryDescription
     * @return \StructType\SiteCategory
     */
    public function setCategoryDescription($categoryDescription = null)
    {
        // validation for constraint: string
        if (!is_null($categoryDescription) && !is_string($categoryDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($categoryDescription, true), gettype($categoryDescription)), __LINE__);
        }
        $this->categoryDescription = $categoryDescription;
        return $this;
    }
    /**
     * Get itemId value
     * @return string|null
     */
    public function getItemId()
    {
        return $this->itemId;
    }
    /**
     * Set itemId value
     * @param string $itemId
     * @return \StructType\SiteCategory
     */
    public function setItemId($itemId = null)
    {
        // validation for constraint: string
        if (!is_null($itemId) && !is_string($itemId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($itemId, true), gettype($itemId)), __LINE__);
        }
        $this->itemId = $itemId;
        return $this;
    }
    /**
     * Get parentCategory value
     * @return \StructType\RecordRef|null
     */
    public function getParentCategory()
    {
        return $this->parentCategory;
    }
    /**
     * Set parentCategory value
     * @param \StructType\RecordRef $parentCategory
     * @return \StructType\SiteCategory
     */
    public function setParentCategory(\StructType\RecordRef $parentCategory = null)
    {
        $this->parentCategory = $parentCategory;
        return $this;
    }
    /**
     * Get categoryListLayout value
     * @return \StructType\RecordRef|null
     */
    public function getCategoryListLayout()
    {
        return $this->categoryListLayout;
    }
    /**
     * Set categoryListLayout value
     * @param \StructType\RecordRef $categoryListLayout
     * @return \StructType\SiteCategory
     */
    public function setCategoryListLayout(\StructType\RecordRef $categoryListLayout = null)
    {
        $this->categoryListLayout = $categoryListLayout;
        return $this;
    }
    /**
     * Get itemListLayout value
     * @return \StructType\RecordRef|null
     */
    public function getItemListLayout()
    {
        return $this->itemListLayout;
    }
    /**
     * Set itemListLayout value
     * @param \StructType\RecordRef $itemListLayout
     * @return \StructType\SiteCategory
     */
    public function setItemListLayout(\StructType\RecordRef $itemListLayout = null)
    {
        $this->itemListLayout = $itemListLayout;
        return $this;
    }
    /**
     * Get relatedItemsListLayout value
     * @return \StructType\RecordRef|null
     */
    public function getRelatedItemsListLayout()
    {
        return $this->relatedItemsListLayout;
    }
    /**
     * Set relatedItemsListLayout value
     * @param \StructType\RecordRef $relatedItemsListLayout
     * @return \StructType\SiteCategory
     */
    public function setRelatedItemsListLayout(\StructType\RecordRef $relatedItemsListLayout = null)
    {
        $this->relatedItemsListLayout = $relatedItemsListLayout;
        return $this;
    }
    /**
     * Get correlatedItemsListLayout value
     * @return \StructType\RecordRef|null
     */
    public function getCorrelatedItemsListLayout()
    {
        return $this->correlatedItemsListLayout;
    }
    /**
     * Set correlatedItemsListLayout value
     * @param \StructType\RecordRef $correlatedItemsListLayout
     * @return \StructType\SiteCategory
     */
    public function setCorrelatedItemsListLayout(\StructType\RecordRef $correlatedItemsListLayout = null)
    {
        $this->correlatedItemsListLayout = $correlatedItemsListLayout;
        return $this;
    }
    /**
     * Get isOnline value
     * @return bool|null
     */
    public function getIsOnline()
    {
        return $this->isOnline;
    }
    /**
     * Set isOnline value
     * @param bool $isOnline
     * @return \StructType\SiteCategory
     */
    public function setIsOnline($isOnline = null)
    {
        // validation for constraint: boolean
        if (!is_null($isOnline) && !is_bool($isOnline)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isOnline, true), gettype($isOnline)), __LINE__);
        }
        $this->isOnline = $isOnline;
        return $this;
    }
    /**
     * Get isInactive value
     * @return bool|null
     */
    public function getIsInactive()
    {
        return $this->isInactive;
    }
    /**
     * Set isInactive value
     * @param bool $isInactive
     * @return \StructType\SiteCategory
     */
    public function setIsInactive($isInactive = null)
    {
        // validation for constraint: boolean
        if (!is_null($isInactive) && !is_bool($isInactive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isInactive, true), gettype($isInactive)), __LINE__);
        }
        $this->isInactive = $isInactive;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\SiteCategory
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get storeDetailedDescription value
     * @return string|null
     */
    public function getStoreDetailedDescription()
    {
        return $this->storeDetailedDescription;
    }
    /**
     * Set storeDetailedDescription value
     * @param string $storeDetailedDescription
     * @return \StructType\SiteCategory
     */
    public function setStoreDetailedDescription($storeDetailedDescription = null)
    {
        // validation for constraint: string
        if (!is_null($storeDetailedDescription) && !is_string($storeDetailedDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($storeDetailedDescription, true), gettype($storeDetailedDescription)), __LINE__);
        }
        $this->storeDetailedDescription = $storeDetailedDescription;
        return $this;
    }
    /**
     * Get storeDisplayThumbnail value
     * @return \StructType\RecordRef|null
     */
    public function getStoreDisplayThumbnail()
    {
        return $this->storeDisplayThumbnail;
    }
    /**
     * Set storeDisplayThumbnail value
     * @param \StructType\RecordRef $storeDisplayThumbnail
     * @return \StructType\SiteCategory
     */
    public function setStoreDisplayThumbnail(\StructType\RecordRef $storeDisplayThumbnail = null)
    {
        $this->storeDisplayThumbnail = $storeDisplayThumbnail;
        return $this;
    }
    /**
     * Get storeDisplayImage value
     * @return \StructType\RecordRef|null
     */
    public function getStoreDisplayImage()
    {
        return $this->storeDisplayImage;
    }
    /**
     * Set storeDisplayImage value
     * @param \StructType\RecordRef $storeDisplayImage
     * @return \StructType\SiteCategory
     */
    public function setStoreDisplayImage(\StructType\RecordRef $storeDisplayImage = null)
    {
        $this->storeDisplayImage = $storeDisplayImage;
        return $this;
    }
    /**
     * Get pageTitle value
     * @return string|null
     */
    public function getPageTitle()
    {
        return $this->pageTitle;
    }
    /**
     * Set pageTitle value
     * @param string $pageTitle
     * @return \StructType\SiteCategory
     */
    public function setPageTitle($pageTitle = null)
    {
        // validation for constraint: string
        if (!is_null($pageTitle) && !is_string($pageTitle)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pageTitle, true), gettype($pageTitle)), __LINE__);
        }
        $this->pageTitle = $pageTitle;
        return $this;
    }
    /**
     * Get metaTagHtml value
     * @return string|null
     */
    public function getMetaTagHtml()
    {
        return $this->metaTagHtml;
    }
    /**
     * Set metaTagHtml value
     * @param string $metaTagHtml
     * @return \StructType\SiteCategory
     */
    public function setMetaTagHtml($metaTagHtml = null)
    {
        // validation for constraint: string
        if (!is_null($metaTagHtml) && !is_string($metaTagHtml)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($metaTagHtml, true), gettype($metaTagHtml)), __LINE__);
        }
        $this->metaTagHtml = $metaTagHtml;
        return $this;
    }
    /**
     * Get excludeFromSitemap value
     * @return bool|null
     */
    public function getExcludeFromSitemap()
    {
        return $this->excludeFromSitemap;
    }
    /**
     * Set excludeFromSitemap value
     * @param bool $excludeFromSitemap
     * @return \StructType\SiteCategory
     */
    public function setExcludeFromSitemap($excludeFromSitemap = null)
    {
        // validation for constraint: boolean
        if (!is_null($excludeFromSitemap) && !is_bool($excludeFromSitemap)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($excludeFromSitemap, true), gettype($excludeFromSitemap)), __LINE__);
        }
        $this->excludeFromSitemap = $excludeFromSitemap;
        return $this;
    }
    /**
     * Get urlComponent value
     * @return string|null
     */
    public function getUrlComponent()
    {
        return $this->urlComponent;
    }
    /**
     * Set urlComponent value
     * @param string $urlComponent
     * @return \StructType\SiteCategory
     */
    public function setUrlComponent($urlComponent = null)
    {
        // validation for constraint: string
        if (!is_null($urlComponent) && !is_string($urlComponent)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($urlComponent, true), gettype($urlComponent)), __LINE__);
        }
        $this->urlComponent = $urlComponent;
        return $this;
    }
    /**
     * Get sitemapPriority value
     * @return string|null
     */
    public function getSitemapPriority()
    {
        return $this->sitemapPriority;
    }
    /**
     * Set sitemapPriority value
     * @uses \EnumType\SitemapPriority::valueIsValid()
     * @uses \EnumType\SitemapPriority::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $sitemapPriority
     * @return \StructType\SiteCategory
     */
    public function setSitemapPriority($sitemapPriority = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\SitemapPriority::valueIsValid($sitemapPriority)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\SitemapPriority', is_array($sitemapPriority) ? implode(', ', $sitemapPriority) : var_export($sitemapPriority, true), implode(', ', \EnumType\SitemapPriority::getValidValues())), __LINE__);
        }
        $this->sitemapPriority = $sitemapPriority;
        return $this;
    }
    /**
     * Get searchKeywords value
     * @return string|null
     */
    public function getSearchKeywords()
    {
        return $this->searchKeywords;
    }
    /**
     * Set searchKeywords value
     * @param string $searchKeywords
     * @return \StructType\SiteCategory
     */
    public function setSearchKeywords($searchKeywords = null)
    {
        // validation for constraint: string
        if (!is_null($searchKeywords) && !is_string($searchKeywords)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($searchKeywords, true), gettype($searchKeywords)), __LINE__);
        }
        $this->searchKeywords = $searchKeywords;
        return $this;
    }
    /**
     * Get presentationItemList value
     * @return \StructType\SiteCategoryPresentationItemList|null
     */
    public function getPresentationItemList()
    {
        return $this->presentationItemList;
    }
    /**
     * Set presentationItemList value
     * @param \StructType\SiteCategoryPresentationItemList $presentationItemList
     * @return \StructType\SiteCategory
     */
    public function setPresentationItemList(\StructType\SiteCategoryPresentationItemList $presentationItemList = null)
    {
        $this->presentationItemList = $presentationItemList;
        return $this;
    }
    /**
     * Get translationsList value
     * @return \StructType\SiteCategoryTranslationList|null
     */
    public function getTranslationsList()
    {
        return $this->translationsList;
    }
    /**
     * Set translationsList value
     * @param \StructType\SiteCategoryTranslationList $translationsList
     * @return \StructType\SiteCategory
     */
    public function setTranslationsList(\StructType\SiteCategoryTranslationList $translationsList = null)
    {
        $this->translationsList = $translationsList;
        return $this;
    }
    /**
     * Get internalId value
     * @return string|null
     */
    public function getInternalId()
    {
        return $this->internalId;
    }
    /**
     * Set internalId value
     * @param string $internalId
     * @return \StructType\SiteCategory
     */
    public function setInternalId($internalId = null)
    {
        // validation for constraint: string
        if (!is_null($internalId) && !is_string($internalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($internalId, true), gettype($internalId)), __LINE__);
        }
        $this->internalId = $internalId;
        return $this;
    }
    /**
     * Get externalId value
     * @return string|null
     */
    public function getExternalId()
    {
        return $this->externalId;
    }
    /**
     * Set externalId value
     * @param string $externalId
     * @return \StructType\SiteCategory
     */
    public function setExternalId($externalId = null)
    {
        // validation for constraint: string
        if (!is_null($externalId) && !is_string($externalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($externalId, true), gettype($externalId)), __LINE__);
        }
        $this->externalId = $externalId;
        return $this;
    }
}
