<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ServiceItemTaskTemplatesList StructType
 * @subpackage Structs
 */
class ServiceItemTaskTemplatesList extends AbstractStructBase
{
    /**
     * The taskTemplates
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ServiceItemTaskTemplates[]
     */
    public $taskTemplates;
    /**
     * The replaceAll
     * Meta information extracted from the WSDL
     * - default: true
     * @var bool
     */
    public $replaceAll;
    /**
     * Constructor method for ServiceItemTaskTemplatesList
     * @uses ServiceItemTaskTemplatesList::setTaskTemplates()
     * @uses ServiceItemTaskTemplatesList::setReplaceAll()
     * @param \StructType\ServiceItemTaskTemplates[] $taskTemplates
     * @param bool $replaceAll
     */
    public function __construct(array $taskTemplates = array(), $replaceAll = true)
    {
        $this
            ->setTaskTemplates($taskTemplates)
            ->setReplaceAll($replaceAll);
    }
    /**
     * Get taskTemplates value
     * @return \StructType\ServiceItemTaskTemplates[]|null
     */
    public function getTaskTemplates()
    {
        return $this->taskTemplates;
    }
    /**
     * This method is responsible for validating the values passed to the setTaskTemplates method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTaskTemplates method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTaskTemplatesForArrayConstraintsFromSetTaskTemplates(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $serviceItemTaskTemplatesListTaskTemplatesItem) {
            // validation for constraint: itemType
            if (!$serviceItemTaskTemplatesListTaskTemplatesItem instanceof \StructType\ServiceItemTaskTemplates) {
                $invalidValues[] = is_object($serviceItemTaskTemplatesListTaskTemplatesItem) ? get_class($serviceItemTaskTemplatesListTaskTemplatesItem) : sprintf('%s(%s)', gettype($serviceItemTaskTemplatesListTaskTemplatesItem), var_export($serviceItemTaskTemplatesListTaskTemplatesItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The taskTemplates property can only contain items of type \StructType\ServiceItemTaskTemplates, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set taskTemplates value
     * @throws \InvalidArgumentException
     * @param \StructType\ServiceItemTaskTemplates[] $taskTemplates
     * @return \StructType\ServiceItemTaskTemplatesList
     */
    public function setTaskTemplates(array $taskTemplates = array())
    {
        // validation for constraint: array
        if ('' !== ($taskTemplatesArrayErrorMessage = self::validateTaskTemplatesForArrayConstraintsFromSetTaskTemplates($taskTemplates))) {
            throw new \InvalidArgumentException($taskTemplatesArrayErrorMessage, __LINE__);
        }
        $this->taskTemplates = $taskTemplates;
        return $this;
    }
    /**
     * Add item to taskTemplates value
     * @throws \InvalidArgumentException
     * @param \StructType\ServiceItemTaskTemplates $item
     * @return \StructType\ServiceItemTaskTemplatesList
     */
    public function addToTaskTemplates(\StructType\ServiceItemTaskTemplates $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ServiceItemTaskTemplates) {
            throw new \InvalidArgumentException(sprintf('The taskTemplates property can only contain items of type \StructType\ServiceItemTaskTemplates, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->taskTemplates[] = $item;
        return $this;
    }
    /**
     * Get replaceAll value
     * @return bool|null
     */
    public function getReplaceAll()
    {
        return $this->replaceAll;
    }
    /**
     * Set replaceAll value
     * @param bool $replaceAll
     * @return \StructType\ServiceItemTaskTemplatesList
     */
    public function setReplaceAll($replaceAll = true)
    {
        // validation for constraint: boolean
        if (!is_null($replaceAll) && !is_bool($replaceAll)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($replaceAll, true), gettype($replaceAll)), __LINE__);
        }
        $this->replaceAll = $replaceAll;
        return $this;
    }
}
