<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SerializedInventoryItemLocations StructType
 * @subpackage Structs
 */
class SerializedInventoryItemLocations extends AbstractStructBase
{
    /**
     * The location
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $location;
    /**
     * The quantityOnHand
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $quantityOnHand;
    /**
     * The onHandValueMli
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $onHandValueMli;
    /**
     * The serialNumbers
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $serialNumbers;
    /**
     * The averageCostMli
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $averageCostMli;
    /**
     * The lastPurchasePriceMli
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $lastPurchasePriceMli;
    /**
     * The reorderPoint
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $reorderPoint;
    /**
     * The locationAllowStorePickup
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $locationAllowStorePickup;
    /**
     * The locationStorePickupBufferStock
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $locationStorePickupBufferStock;
    /**
     * The locationQtyAvailForStorePickup
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $locationQtyAvailForStorePickup;
    /**
     * The preferredStockLevel
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $preferredStockLevel;
    /**
     * The leadTime
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $leadTime;
    /**
     * The defaultReturnCost
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $defaultReturnCost;
    /**
     * The isWip
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $isWip;
    /**
     * The safetyStockLevel
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $safetyStockLevel;
    /**
     * The cost
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $cost;
    /**
     * The inventoryCostTemplate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $inventoryCostTemplate;
    /**
     * The buildTime
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $buildTime;
    /**
     * The lastInvtCountDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $lastInvtCountDate;
    /**
     * The nextInvtCountDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $nextInvtCountDate;
    /**
     * The invtCountInterval
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $invtCountInterval;
    /**
     * The invtClassification
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $invtClassification;
    /**
     * The costingLotSize
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $costingLotSize;
    /**
     * The quantityOnOrder
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $quantityOnOrder;
    /**
     * The quantityCommitted
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $quantityCommitted;
    /**
     * The quantityAvailable
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $quantityAvailable;
    /**
     * The quantityBackOrdered
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $quantityBackOrdered;
    /**
     * The locationId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $locationId;
    /**
     * The supplyReplenishmentMethod
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $supplyReplenishmentMethod;
    /**
     * The alternateDemandSourceItem
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $alternateDemandSourceItem;
    /**
     * The fixedLotSize
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $fixedLotSize;
    /**
     * The periodicLotSizeType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $periodicLotSizeType;
    /**
     * The periodicLotSizeDays
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $periodicLotSizeDays;
    /**
     * The supplyType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $supplyType;
    /**
     * The supplyLotSizingMethod
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $supplyLotSizingMethod;
    /**
     * The demandSource
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $demandSource;
    /**
     * The backwardConsumptionDays
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $backwardConsumptionDays;
    /**
     * The forwardConsumptionDays
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $forwardConsumptionDays;
    /**
     * The demandTimeFence
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $demandTimeFence;
    /**
     * The supplyTimeFence
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $supplyTimeFence;
    /**
     * The rescheduleInDays
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $rescheduleInDays;
    /**
     * The rescheduleOutDays
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $rescheduleOutDays;
    /**
     * Constructor method for SerializedInventoryItemLocations
     * @uses SerializedInventoryItemLocations::setLocation()
     * @uses SerializedInventoryItemLocations::setQuantityOnHand()
     * @uses SerializedInventoryItemLocations::setOnHandValueMli()
     * @uses SerializedInventoryItemLocations::setSerialNumbers()
     * @uses SerializedInventoryItemLocations::setAverageCostMli()
     * @uses SerializedInventoryItemLocations::setLastPurchasePriceMli()
     * @uses SerializedInventoryItemLocations::setReorderPoint()
     * @uses SerializedInventoryItemLocations::setLocationAllowStorePickup()
     * @uses SerializedInventoryItemLocations::setLocationStorePickupBufferStock()
     * @uses SerializedInventoryItemLocations::setLocationQtyAvailForStorePickup()
     * @uses SerializedInventoryItemLocations::setPreferredStockLevel()
     * @uses SerializedInventoryItemLocations::setLeadTime()
     * @uses SerializedInventoryItemLocations::setDefaultReturnCost()
     * @uses SerializedInventoryItemLocations::setIsWip()
     * @uses SerializedInventoryItemLocations::setSafetyStockLevel()
     * @uses SerializedInventoryItemLocations::setCost()
     * @uses SerializedInventoryItemLocations::setInventoryCostTemplate()
     * @uses SerializedInventoryItemLocations::setBuildTime()
     * @uses SerializedInventoryItemLocations::setLastInvtCountDate()
     * @uses SerializedInventoryItemLocations::setNextInvtCountDate()
     * @uses SerializedInventoryItemLocations::setInvtCountInterval()
     * @uses SerializedInventoryItemLocations::setInvtClassification()
     * @uses SerializedInventoryItemLocations::setCostingLotSize()
     * @uses SerializedInventoryItemLocations::setQuantityOnOrder()
     * @uses SerializedInventoryItemLocations::setQuantityCommitted()
     * @uses SerializedInventoryItemLocations::setQuantityAvailable()
     * @uses SerializedInventoryItemLocations::setQuantityBackOrdered()
     * @uses SerializedInventoryItemLocations::setLocationId()
     * @uses SerializedInventoryItemLocations::setSupplyReplenishmentMethod()
     * @uses SerializedInventoryItemLocations::setAlternateDemandSourceItem()
     * @uses SerializedInventoryItemLocations::setFixedLotSize()
     * @uses SerializedInventoryItemLocations::setPeriodicLotSizeType()
     * @uses SerializedInventoryItemLocations::setPeriodicLotSizeDays()
     * @uses SerializedInventoryItemLocations::setSupplyType()
     * @uses SerializedInventoryItemLocations::setSupplyLotSizingMethod()
     * @uses SerializedInventoryItemLocations::setDemandSource()
     * @uses SerializedInventoryItemLocations::setBackwardConsumptionDays()
     * @uses SerializedInventoryItemLocations::setForwardConsumptionDays()
     * @uses SerializedInventoryItemLocations::setDemandTimeFence()
     * @uses SerializedInventoryItemLocations::setSupplyTimeFence()
     * @uses SerializedInventoryItemLocations::setRescheduleInDays()
     * @uses SerializedInventoryItemLocations::setRescheduleOutDays()
     * @param string $location
     * @param float $quantityOnHand
     * @param float $onHandValueMli
     * @param string $serialNumbers
     * @param float $averageCostMli
     * @param float $lastPurchasePriceMli
     * @param float $reorderPoint
     * @param bool $locationAllowStorePickup
     * @param float $locationStorePickupBufferStock
     * @param float $locationQtyAvailForStorePickup
     * @param float $preferredStockLevel
     * @param int $leadTime
     * @param float $defaultReturnCost
     * @param bool $isWip
     * @param float $safetyStockLevel
     * @param float $cost
     * @param \StructType\RecordRef $inventoryCostTemplate
     * @param float $buildTime
     * @param string $lastInvtCountDate
     * @param string $nextInvtCountDate
     * @param int $invtCountInterval
     * @param string $invtClassification
     * @param float $costingLotSize
     * @param float $quantityOnOrder
     * @param float $quantityCommitted
     * @param float $quantityAvailable
     * @param float $quantityBackOrdered
     * @param \StructType\RecordRef $locationId
     * @param \StructType\RecordRef $supplyReplenishmentMethod
     * @param \StructType\RecordRef $alternateDemandSourceItem
     * @param float $fixedLotSize
     * @param string $periodicLotSizeType
     * @param int $periodicLotSizeDays
     * @param \StructType\RecordRef $supplyType
     * @param \StructType\RecordRef $supplyLotSizingMethod
     * @param \StructType\RecordRef $demandSource
     * @param int $backwardConsumptionDays
     * @param int $forwardConsumptionDays
     * @param int $demandTimeFence
     * @param int $supplyTimeFence
     * @param int $rescheduleInDays
     * @param int $rescheduleOutDays
     */
    public function __construct($location = null, $quantityOnHand = null, $onHandValueMli = null, $serialNumbers = null, $averageCostMli = null, $lastPurchasePriceMli = null, $reorderPoint = null, $locationAllowStorePickup = null, $locationStorePickupBufferStock = null, $locationQtyAvailForStorePickup = null, $preferredStockLevel = null, $leadTime = null, $defaultReturnCost = null, $isWip = null, $safetyStockLevel = null, $cost = null, \StructType\RecordRef $inventoryCostTemplate = null, $buildTime = null, $lastInvtCountDate = null, $nextInvtCountDate = null, $invtCountInterval = null, $invtClassification = null, $costingLotSize = null, $quantityOnOrder = null, $quantityCommitted = null, $quantityAvailable = null, $quantityBackOrdered = null, \StructType\RecordRef $locationId = null, \StructType\RecordRef $supplyReplenishmentMethod = null, \StructType\RecordRef $alternateDemandSourceItem = null, $fixedLotSize = null, $periodicLotSizeType = null, $periodicLotSizeDays = null, \StructType\RecordRef $supplyType = null, \StructType\RecordRef $supplyLotSizingMethod = null, \StructType\RecordRef $demandSource = null, $backwardConsumptionDays = null, $forwardConsumptionDays = null, $demandTimeFence = null, $supplyTimeFence = null, $rescheduleInDays = null, $rescheduleOutDays = null)
    {
        $this
            ->setLocation($location)
            ->setQuantityOnHand($quantityOnHand)
            ->setOnHandValueMli($onHandValueMli)
            ->setSerialNumbers($serialNumbers)
            ->setAverageCostMli($averageCostMli)
            ->setLastPurchasePriceMli($lastPurchasePriceMli)
            ->setReorderPoint($reorderPoint)
            ->setLocationAllowStorePickup($locationAllowStorePickup)
            ->setLocationStorePickupBufferStock($locationStorePickupBufferStock)
            ->setLocationQtyAvailForStorePickup($locationQtyAvailForStorePickup)
            ->setPreferredStockLevel($preferredStockLevel)
            ->setLeadTime($leadTime)
            ->setDefaultReturnCost($defaultReturnCost)
            ->setIsWip($isWip)
            ->setSafetyStockLevel($safetyStockLevel)
            ->setCost($cost)
            ->setInventoryCostTemplate($inventoryCostTemplate)
            ->setBuildTime($buildTime)
            ->setLastInvtCountDate($lastInvtCountDate)
            ->setNextInvtCountDate($nextInvtCountDate)
            ->setInvtCountInterval($invtCountInterval)
            ->setInvtClassification($invtClassification)
            ->setCostingLotSize($costingLotSize)
            ->setQuantityOnOrder($quantityOnOrder)
            ->setQuantityCommitted($quantityCommitted)
            ->setQuantityAvailable($quantityAvailable)
            ->setQuantityBackOrdered($quantityBackOrdered)
            ->setLocationId($locationId)
            ->setSupplyReplenishmentMethod($supplyReplenishmentMethod)
            ->setAlternateDemandSourceItem($alternateDemandSourceItem)
            ->setFixedLotSize($fixedLotSize)
            ->setPeriodicLotSizeType($periodicLotSizeType)
            ->setPeriodicLotSizeDays($periodicLotSizeDays)
            ->setSupplyType($supplyType)
            ->setSupplyLotSizingMethod($supplyLotSizingMethod)
            ->setDemandSource($demandSource)
            ->setBackwardConsumptionDays($backwardConsumptionDays)
            ->setForwardConsumptionDays($forwardConsumptionDays)
            ->setDemandTimeFence($demandTimeFence)
            ->setSupplyTimeFence($supplyTimeFence)
            ->setRescheduleInDays($rescheduleInDays)
            ->setRescheduleOutDays($rescheduleOutDays);
    }
    /**
     * Get location value
     * @return string|null
     */
    public function getLocation()
    {
        return $this->location;
    }
    /**
     * Set location value
     * @param string $location
     * @return \StructType\SerializedInventoryItemLocations
     */
    public function setLocation($location = null)
    {
        // validation for constraint: string
        if (!is_null($location) && !is_string($location)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($location, true), gettype($location)), __LINE__);
        }
        $this->location = $location;
        return $this;
    }
    /**
     * Get quantityOnHand value
     * @return float|null
     */
    public function getQuantityOnHand()
    {
        return $this->quantityOnHand;
    }
    /**
     * Set quantityOnHand value
     * @param float $quantityOnHand
     * @return \StructType\SerializedInventoryItemLocations
     */
    public function setQuantityOnHand($quantityOnHand = null)
    {
        // validation for constraint: float
        if (!is_null($quantityOnHand) && !(is_float($quantityOnHand) || is_numeric($quantityOnHand))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($quantityOnHand, true), gettype($quantityOnHand)), __LINE__);
        }
        $this->quantityOnHand = $quantityOnHand;
        return $this;
    }
    /**
     * Get onHandValueMli value
     * @return float|null
     */
    public function getOnHandValueMli()
    {
        return $this->onHandValueMli;
    }
    /**
     * Set onHandValueMli value
     * @param float $onHandValueMli
     * @return \StructType\SerializedInventoryItemLocations
     */
    public function setOnHandValueMli($onHandValueMli = null)
    {
        // validation for constraint: float
        if (!is_null($onHandValueMli) && !(is_float($onHandValueMli) || is_numeric($onHandValueMli))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($onHandValueMli, true), gettype($onHandValueMli)), __LINE__);
        }
        $this->onHandValueMli = $onHandValueMli;
        return $this;
    }
    /**
     * Get serialNumbers value
     * @return string|null
     */
    public function getSerialNumbers()
    {
        return $this->serialNumbers;
    }
    /**
     * Set serialNumbers value
     * @param string $serialNumbers
     * @return \StructType\SerializedInventoryItemLocations
     */
    public function setSerialNumbers($serialNumbers = null)
    {
        // validation for constraint: string
        if (!is_null($serialNumbers) && !is_string($serialNumbers)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serialNumbers, true), gettype($serialNumbers)), __LINE__);
        }
        $this->serialNumbers = $serialNumbers;
        return $this;
    }
    /**
     * Get averageCostMli value
     * @return float|null
     */
    public function getAverageCostMli()
    {
        return $this->averageCostMli;
    }
    /**
     * Set averageCostMli value
     * @param float $averageCostMli
     * @return \StructType\SerializedInventoryItemLocations
     */
    public function setAverageCostMli($averageCostMli = null)
    {
        // validation for constraint: float
        if (!is_null($averageCostMli) && !(is_float($averageCostMli) || is_numeric($averageCostMli))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($averageCostMli, true), gettype($averageCostMli)), __LINE__);
        }
        $this->averageCostMli = $averageCostMli;
        return $this;
    }
    /**
     * Get lastPurchasePriceMli value
     * @return float|null
     */
    public function getLastPurchasePriceMli()
    {
        return $this->lastPurchasePriceMli;
    }
    /**
     * Set lastPurchasePriceMli value
     * @param float $lastPurchasePriceMli
     * @return \StructType\SerializedInventoryItemLocations
     */
    public function setLastPurchasePriceMli($lastPurchasePriceMli = null)
    {
        // validation for constraint: float
        if (!is_null($lastPurchasePriceMli) && !(is_float($lastPurchasePriceMli) || is_numeric($lastPurchasePriceMli))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($lastPurchasePriceMli, true), gettype($lastPurchasePriceMli)), __LINE__);
        }
        $this->lastPurchasePriceMli = $lastPurchasePriceMli;
        return $this;
    }
    /**
     * Get reorderPoint value
     * @return float|null
     */
    public function getReorderPoint()
    {
        return $this->reorderPoint;
    }
    /**
     * Set reorderPoint value
     * @param float $reorderPoint
     * @return \StructType\SerializedInventoryItemLocations
     */
    public function setReorderPoint($reorderPoint = null)
    {
        // validation for constraint: float
        if (!is_null($reorderPoint) && !(is_float($reorderPoint) || is_numeric($reorderPoint))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($reorderPoint, true), gettype($reorderPoint)), __LINE__);
        }
        $this->reorderPoint = $reorderPoint;
        return $this;
    }
    /**
     * Get locationAllowStorePickup value
     * @return bool|null
     */
    public function getLocationAllowStorePickup()
    {
        return $this->locationAllowStorePickup;
    }
    /**
     * Set locationAllowStorePickup value
     * @param bool $locationAllowStorePickup
     * @return \StructType\SerializedInventoryItemLocations
     */
    public function setLocationAllowStorePickup($locationAllowStorePickup = null)
    {
        // validation for constraint: boolean
        if (!is_null($locationAllowStorePickup) && !is_bool($locationAllowStorePickup)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($locationAllowStorePickup, true), gettype($locationAllowStorePickup)), __LINE__);
        }
        $this->locationAllowStorePickup = $locationAllowStorePickup;
        return $this;
    }
    /**
     * Get locationStorePickupBufferStock value
     * @return float|null
     */
    public function getLocationStorePickupBufferStock()
    {
        return $this->locationStorePickupBufferStock;
    }
    /**
     * Set locationStorePickupBufferStock value
     * @param float $locationStorePickupBufferStock
     * @return \StructType\SerializedInventoryItemLocations
     */
    public function setLocationStorePickupBufferStock($locationStorePickupBufferStock = null)
    {
        // validation for constraint: float
        if (!is_null($locationStorePickupBufferStock) && !(is_float($locationStorePickupBufferStock) || is_numeric($locationStorePickupBufferStock))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($locationStorePickupBufferStock, true), gettype($locationStorePickupBufferStock)), __LINE__);
        }
        $this->locationStorePickupBufferStock = $locationStorePickupBufferStock;
        return $this;
    }
    /**
     * Get locationQtyAvailForStorePickup value
     * @return float|null
     */
    public function getLocationQtyAvailForStorePickup()
    {
        return $this->locationQtyAvailForStorePickup;
    }
    /**
     * Set locationQtyAvailForStorePickup value
     * @param float $locationQtyAvailForStorePickup
     * @return \StructType\SerializedInventoryItemLocations
     */
    public function setLocationQtyAvailForStorePickup($locationQtyAvailForStorePickup = null)
    {
        // validation for constraint: float
        if (!is_null($locationQtyAvailForStorePickup) && !(is_float($locationQtyAvailForStorePickup) || is_numeric($locationQtyAvailForStorePickup))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($locationQtyAvailForStorePickup, true), gettype($locationQtyAvailForStorePickup)), __LINE__);
        }
        $this->locationQtyAvailForStorePickup = $locationQtyAvailForStorePickup;
        return $this;
    }
    /**
     * Get preferredStockLevel value
     * @return float|null
     */
    public function getPreferredStockLevel()
    {
        return $this->preferredStockLevel;
    }
    /**
     * Set preferredStockLevel value
     * @param float $preferredStockLevel
     * @return \StructType\SerializedInventoryItemLocations
     */
    public function setPreferredStockLevel($preferredStockLevel = null)
    {
        // validation for constraint: float
        if (!is_null($preferredStockLevel) && !(is_float($preferredStockLevel) || is_numeric($preferredStockLevel))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($preferredStockLevel, true), gettype($preferredStockLevel)), __LINE__);
        }
        $this->preferredStockLevel = $preferredStockLevel;
        return $this;
    }
    /**
     * Get leadTime value
     * @return int|null
     */
    public function getLeadTime()
    {
        return $this->leadTime;
    }
    /**
     * Set leadTime value
     * @param int $leadTime
     * @return \StructType\SerializedInventoryItemLocations
     */
    public function setLeadTime($leadTime = null)
    {
        // validation for constraint: int
        if (!is_null($leadTime) && !(is_int($leadTime) || ctype_digit($leadTime))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($leadTime, true), gettype($leadTime)), __LINE__);
        }
        $this->leadTime = $leadTime;
        return $this;
    }
    /**
     * Get defaultReturnCost value
     * @return float|null
     */
    public function getDefaultReturnCost()
    {
        return $this->defaultReturnCost;
    }
    /**
     * Set defaultReturnCost value
     * @param float $defaultReturnCost
     * @return \StructType\SerializedInventoryItemLocations
     */
    public function setDefaultReturnCost($defaultReturnCost = null)
    {
        // validation for constraint: float
        if (!is_null($defaultReturnCost) && !(is_float($defaultReturnCost) || is_numeric($defaultReturnCost))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($defaultReturnCost, true), gettype($defaultReturnCost)), __LINE__);
        }
        $this->defaultReturnCost = $defaultReturnCost;
        return $this;
    }
    /**
     * Get isWip value
     * @return bool|null
     */
    public function getIsWip()
    {
        return $this->isWip;
    }
    /**
     * Set isWip value
     * @param bool $isWip
     * @return \StructType\SerializedInventoryItemLocations
     */
    public function setIsWip($isWip = null)
    {
        // validation for constraint: boolean
        if (!is_null($isWip) && !is_bool($isWip)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isWip, true), gettype($isWip)), __LINE__);
        }
        $this->isWip = $isWip;
        return $this;
    }
    /**
     * Get safetyStockLevel value
     * @return float|null
     */
    public function getSafetyStockLevel()
    {
        return $this->safetyStockLevel;
    }
    /**
     * Set safetyStockLevel value
     * @param float $safetyStockLevel
     * @return \StructType\SerializedInventoryItemLocations
     */
    public function setSafetyStockLevel($safetyStockLevel = null)
    {
        // validation for constraint: float
        if (!is_null($safetyStockLevel) && !(is_float($safetyStockLevel) || is_numeric($safetyStockLevel))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($safetyStockLevel, true), gettype($safetyStockLevel)), __LINE__);
        }
        $this->safetyStockLevel = $safetyStockLevel;
        return $this;
    }
    /**
     * Get cost value
     * @return float|null
     */
    public function getCost()
    {
        return $this->cost;
    }
    /**
     * Set cost value
     * @param float $cost
     * @return \StructType\SerializedInventoryItemLocations
     */
    public function setCost($cost = null)
    {
        // validation for constraint: float
        if (!is_null($cost) && !(is_float($cost) || is_numeric($cost))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($cost, true), gettype($cost)), __LINE__);
        }
        $this->cost = $cost;
        return $this;
    }
    /**
     * Get inventoryCostTemplate value
     * @return \StructType\RecordRef|null
     */
    public function getInventoryCostTemplate()
    {
        return $this->inventoryCostTemplate;
    }
    /**
     * Set inventoryCostTemplate value
     * @param \StructType\RecordRef $inventoryCostTemplate
     * @return \StructType\SerializedInventoryItemLocations
     */
    public function setInventoryCostTemplate(\StructType\RecordRef $inventoryCostTemplate = null)
    {
        $this->inventoryCostTemplate = $inventoryCostTemplate;
        return $this;
    }
    /**
     * Get buildTime value
     * @return float|null
     */
    public function getBuildTime()
    {
        return $this->buildTime;
    }
    /**
     * Set buildTime value
     * @param float $buildTime
     * @return \StructType\SerializedInventoryItemLocations
     */
    public function setBuildTime($buildTime = null)
    {
        // validation for constraint: float
        if (!is_null($buildTime) && !(is_float($buildTime) || is_numeric($buildTime))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($buildTime, true), gettype($buildTime)), __LINE__);
        }
        $this->buildTime = $buildTime;
        return $this;
    }
    /**
     * Get lastInvtCountDate value
     * @return string|null
     */
    public function getLastInvtCountDate()
    {
        return $this->lastInvtCountDate;
    }
    /**
     * Set lastInvtCountDate value
     * @param string $lastInvtCountDate
     * @return \StructType\SerializedInventoryItemLocations
     */
    public function setLastInvtCountDate($lastInvtCountDate = null)
    {
        // validation for constraint: string
        if (!is_null($lastInvtCountDate) && !is_string($lastInvtCountDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastInvtCountDate, true), gettype($lastInvtCountDate)), __LINE__);
        }
        $this->lastInvtCountDate = $lastInvtCountDate;
        return $this;
    }
    /**
     * Get nextInvtCountDate value
     * @return string|null
     */
    public function getNextInvtCountDate()
    {
        return $this->nextInvtCountDate;
    }
    /**
     * Set nextInvtCountDate value
     * @param string $nextInvtCountDate
     * @return \StructType\SerializedInventoryItemLocations
     */
    public function setNextInvtCountDate($nextInvtCountDate = null)
    {
        // validation for constraint: string
        if (!is_null($nextInvtCountDate) && !is_string($nextInvtCountDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nextInvtCountDate, true), gettype($nextInvtCountDate)), __LINE__);
        }
        $this->nextInvtCountDate = $nextInvtCountDate;
        return $this;
    }
    /**
     * Get invtCountInterval value
     * @return int|null
     */
    public function getInvtCountInterval()
    {
        return $this->invtCountInterval;
    }
    /**
     * Set invtCountInterval value
     * @param int $invtCountInterval
     * @return \StructType\SerializedInventoryItemLocations
     */
    public function setInvtCountInterval($invtCountInterval = null)
    {
        // validation for constraint: int
        if (!is_null($invtCountInterval) && !(is_int($invtCountInterval) || ctype_digit($invtCountInterval))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($invtCountInterval, true), gettype($invtCountInterval)), __LINE__);
        }
        $this->invtCountInterval = $invtCountInterval;
        return $this;
    }
    /**
     * Get invtClassification value
     * @return string|null
     */
    public function getInvtClassification()
    {
        return $this->invtClassification;
    }
    /**
     * Set invtClassification value
     * @uses \EnumType\ItemInvtClassification::valueIsValid()
     * @uses \EnumType\ItemInvtClassification::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $invtClassification
     * @return \StructType\SerializedInventoryItemLocations
     */
    public function setInvtClassification($invtClassification = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ItemInvtClassification::valueIsValid($invtClassification)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\ItemInvtClassification', is_array($invtClassification) ? implode(', ', $invtClassification) : var_export($invtClassification, true), implode(', ', \EnumType\ItemInvtClassification::getValidValues())), __LINE__);
        }
        $this->invtClassification = $invtClassification;
        return $this;
    }
    /**
     * Get costingLotSize value
     * @return float|null
     */
    public function getCostingLotSize()
    {
        return $this->costingLotSize;
    }
    /**
     * Set costingLotSize value
     * @param float $costingLotSize
     * @return \StructType\SerializedInventoryItemLocations
     */
    public function setCostingLotSize($costingLotSize = null)
    {
        // validation for constraint: float
        if (!is_null($costingLotSize) && !(is_float($costingLotSize) || is_numeric($costingLotSize))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($costingLotSize, true), gettype($costingLotSize)), __LINE__);
        }
        $this->costingLotSize = $costingLotSize;
        return $this;
    }
    /**
     * Get quantityOnOrder value
     * @return float|null
     */
    public function getQuantityOnOrder()
    {
        return $this->quantityOnOrder;
    }
    /**
     * Set quantityOnOrder value
     * @param float $quantityOnOrder
     * @return \StructType\SerializedInventoryItemLocations
     */
    public function setQuantityOnOrder($quantityOnOrder = null)
    {
        // validation for constraint: float
        if (!is_null($quantityOnOrder) && !(is_float($quantityOnOrder) || is_numeric($quantityOnOrder))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($quantityOnOrder, true), gettype($quantityOnOrder)), __LINE__);
        }
        $this->quantityOnOrder = $quantityOnOrder;
        return $this;
    }
    /**
     * Get quantityCommitted value
     * @return float|null
     */
    public function getQuantityCommitted()
    {
        return $this->quantityCommitted;
    }
    /**
     * Set quantityCommitted value
     * @param float $quantityCommitted
     * @return \StructType\SerializedInventoryItemLocations
     */
    public function setQuantityCommitted($quantityCommitted = null)
    {
        // validation for constraint: float
        if (!is_null($quantityCommitted) && !(is_float($quantityCommitted) || is_numeric($quantityCommitted))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($quantityCommitted, true), gettype($quantityCommitted)), __LINE__);
        }
        $this->quantityCommitted = $quantityCommitted;
        return $this;
    }
    /**
     * Get quantityAvailable value
     * @return float|null
     */
    public function getQuantityAvailable()
    {
        return $this->quantityAvailable;
    }
    /**
     * Set quantityAvailable value
     * @param float $quantityAvailable
     * @return \StructType\SerializedInventoryItemLocations
     */
    public function setQuantityAvailable($quantityAvailable = null)
    {
        // validation for constraint: float
        if (!is_null($quantityAvailable) && !(is_float($quantityAvailable) || is_numeric($quantityAvailable))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($quantityAvailable, true), gettype($quantityAvailable)), __LINE__);
        }
        $this->quantityAvailable = $quantityAvailable;
        return $this;
    }
    /**
     * Get quantityBackOrdered value
     * @return float|null
     */
    public function getQuantityBackOrdered()
    {
        return $this->quantityBackOrdered;
    }
    /**
     * Set quantityBackOrdered value
     * @param float $quantityBackOrdered
     * @return \StructType\SerializedInventoryItemLocations
     */
    public function setQuantityBackOrdered($quantityBackOrdered = null)
    {
        // validation for constraint: float
        if (!is_null($quantityBackOrdered) && !(is_float($quantityBackOrdered) || is_numeric($quantityBackOrdered))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($quantityBackOrdered, true), gettype($quantityBackOrdered)), __LINE__);
        }
        $this->quantityBackOrdered = $quantityBackOrdered;
        return $this;
    }
    /**
     * Get locationId value
     * @return \StructType\RecordRef|null
     */
    public function getLocationId()
    {
        return $this->locationId;
    }
    /**
     * Set locationId value
     * @param \StructType\RecordRef $locationId
     * @return \StructType\SerializedInventoryItemLocations
     */
    public function setLocationId(\StructType\RecordRef $locationId = null)
    {
        $this->locationId = $locationId;
        return $this;
    }
    /**
     * Get supplyReplenishmentMethod value
     * @return \StructType\RecordRef|null
     */
    public function getSupplyReplenishmentMethod()
    {
        return $this->supplyReplenishmentMethod;
    }
    /**
     * Set supplyReplenishmentMethod value
     * @param \StructType\RecordRef $supplyReplenishmentMethod
     * @return \StructType\SerializedInventoryItemLocations
     */
    public function setSupplyReplenishmentMethod(\StructType\RecordRef $supplyReplenishmentMethod = null)
    {
        $this->supplyReplenishmentMethod = $supplyReplenishmentMethod;
        return $this;
    }
    /**
     * Get alternateDemandSourceItem value
     * @return \StructType\RecordRef|null
     */
    public function getAlternateDemandSourceItem()
    {
        return $this->alternateDemandSourceItem;
    }
    /**
     * Set alternateDemandSourceItem value
     * @param \StructType\RecordRef $alternateDemandSourceItem
     * @return \StructType\SerializedInventoryItemLocations
     */
    public function setAlternateDemandSourceItem(\StructType\RecordRef $alternateDemandSourceItem = null)
    {
        $this->alternateDemandSourceItem = $alternateDemandSourceItem;
        return $this;
    }
    /**
     * Get fixedLotSize value
     * @return float|null
     */
    public function getFixedLotSize()
    {
        return $this->fixedLotSize;
    }
    /**
     * Set fixedLotSize value
     * @param float $fixedLotSize
     * @return \StructType\SerializedInventoryItemLocations
     */
    public function setFixedLotSize($fixedLotSize = null)
    {
        // validation for constraint: float
        if (!is_null($fixedLotSize) && !(is_float($fixedLotSize) || is_numeric($fixedLotSize))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($fixedLotSize, true), gettype($fixedLotSize)), __LINE__);
        }
        $this->fixedLotSize = $fixedLotSize;
        return $this;
    }
    /**
     * Get periodicLotSizeType value
     * @return string|null
     */
    public function getPeriodicLotSizeType()
    {
        return $this->periodicLotSizeType;
    }
    /**
     * Set periodicLotSizeType value
     * @uses \EnumType\PeriodicLotSizeType::valueIsValid()
     * @uses \EnumType\PeriodicLotSizeType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $periodicLotSizeType
     * @return \StructType\SerializedInventoryItemLocations
     */
    public function setPeriodicLotSizeType($periodicLotSizeType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\PeriodicLotSizeType::valueIsValid($periodicLotSizeType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\PeriodicLotSizeType', is_array($periodicLotSizeType) ? implode(', ', $periodicLotSizeType) : var_export($periodicLotSizeType, true), implode(', ', \EnumType\PeriodicLotSizeType::getValidValues())), __LINE__);
        }
        $this->periodicLotSizeType = $periodicLotSizeType;
        return $this;
    }
    /**
     * Get periodicLotSizeDays value
     * @return int|null
     */
    public function getPeriodicLotSizeDays()
    {
        return $this->periodicLotSizeDays;
    }
    /**
     * Set periodicLotSizeDays value
     * @param int $periodicLotSizeDays
     * @return \StructType\SerializedInventoryItemLocations
     */
    public function setPeriodicLotSizeDays($periodicLotSizeDays = null)
    {
        // validation for constraint: int
        if (!is_null($periodicLotSizeDays) && !(is_int($periodicLotSizeDays) || ctype_digit($periodicLotSizeDays))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($periodicLotSizeDays, true), gettype($periodicLotSizeDays)), __LINE__);
        }
        $this->periodicLotSizeDays = $periodicLotSizeDays;
        return $this;
    }
    /**
     * Get supplyType value
     * @return \StructType\RecordRef|null
     */
    public function getSupplyType()
    {
        return $this->supplyType;
    }
    /**
     * Set supplyType value
     * @param \StructType\RecordRef $supplyType
     * @return \StructType\SerializedInventoryItemLocations
     */
    public function setSupplyType(\StructType\RecordRef $supplyType = null)
    {
        $this->supplyType = $supplyType;
        return $this;
    }
    /**
     * Get supplyLotSizingMethod value
     * @return \StructType\RecordRef|null
     */
    public function getSupplyLotSizingMethod()
    {
        return $this->supplyLotSizingMethod;
    }
    /**
     * Set supplyLotSizingMethod value
     * @param \StructType\RecordRef $supplyLotSizingMethod
     * @return \StructType\SerializedInventoryItemLocations
     */
    public function setSupplyLotSizingMethod(\StructType\RecordRef $supplyLotSizingMethod = null)
    {
        $this->supplyLotSizingMethod = $supplyLotSizingMethod;
        return $this;
    }
    /**
     * Get demandSource value
     * @return \StructType\RecordRef|null
     */
    public function getDemandSource()
    {
        return $this->demandSource;
    }
    /**
     * Set demandSource value
     * @param \StructType\RecordRef $demandSource
     * @return \StructType\SerializedInventoryItemLocations
     */
    public function setDemandSource(\StructType\RecordRef $demandSource = null)
    {
        $this->demandSource = $demandSource;
        return $this;
    }
    /**
     * Get backwardConsumptionDays value
     * @return int|null
     */
    public function getBackwardConsumptionDays()
    {
        return $this->backwardConsumptionDays;
    }
    /**
     * Set backwardConsumptionDays value
     * @param int $backwardConsumptionDays
     * @return \StructType\SerializedInventoryItemLocations
     */
    public function setBackwardConsumptionDays($backwardConsumptionDays = null)
    {
        // validation for constraint: int
        if (!is_null($backwardConsumptionDays) && !(is_int($backwardConsumptionDays) || ctype_digit($backwardConsumptionDays))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($backwardConsumptionDays, true), gettype($backwardConsumptionDays)), __LINE__);
        }
        $this->backwardConsumptionDays = $backwardConsumptionDays;
        return $this;
    }
    /**
     * Get forwardConsumptionDays value
     * @return int|null
     */
    public function getForwardConsumptionDays()
    {
        return $this->forwardConsumptionDays;
    }
    /**
     * Set forwardConsumptionDays value
     * @param int $forwardConsumptionDays
     * @return \StructType\SerializedInventoryItemLocations
     */
    public function setForwardConsumptionDays($forwardConsumptionDays = null)
    {
        // validation for constraint: int
        if (!is_null($forwardConsumptionDays) && !(is_int($forwardConsumptionDays) || ctype_digit($forwardConsumptionDays))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($forwardConsumptionDays, true), gettype($forwardConsumptionDays)), __LINE__);
        }
        $this->forwardConsumptionDays = $forwardConsumptionDays;
        return $this;
    }
    /**
     * Get demandTimeFence value
     * @return int|null
     */
    public function getDemandTimeFence()
    {
        return $this->demandTimeFence;
    }
    /**
     * Set demandTimeFence value
     * @param int $demandTimeFence
     * @return \StructType\SerializedInventoryItemLocations
     */
    public function setDemandTimeFence($demandTimeFence = null)
    {
        // validation for constraint: int
        if (!is_null($demandTimeFence) && !(is_int($demandTimeFence) || ctype_digit($demandTimeFence))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($demandTimeFence, true), gettype($demandTimeFence)), __LINE__);
        }
        $this->demandTimeFence = $demandTimeFence;
        return $this;
    }
    /**
     * Get supplyTimeFence value
     * @return int|null
     */
    public function getSupplyTimeFence()
    {
        return $this->supplyTimeFence;
    }
    /**
     * Set supplyTimeFence value
     * @param int $supplyTimeFence
     * @return \StructType\SerializedInventoryItemLocations
     */
    public function setSupplyTimeFence($supplyTimeFence = null)
    {
        // validation for constraint: int
        if (!is_null($supplyTimeFence) && !(is_int($supplyTimeFence) || ctype_digit($supplyTimeFence))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($supplyTimeFence, true), gettype($supplyTimeFence)), __LINE__);
        }
        $this->supplyTimeFence = $supplyTimeFence;
        return $this;
    }
    /**
     * Get rescheduleInDays value
     * @return int|null
     */
    public function getRescheduleInDays()
    {
        return $this->rescheduleInDays;
    }
    /**
     * Set rescheduleInDays value
     * @param int $rescheduleInDays
     * @return \StructType\SerializedInventoryItemLocations
     */
    public function setRescheduleInDays($rescheduleInDays = null)
    {
        // validation for constraint: int
        if (!is_null($rescheduleInDays) && !(is_int($rescheduleInDays) || ctype_digit($rescheduleInDays))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($rescheduleInDays, true), gettype($rescheduleInDays)), __LINE__);
        }
        $this->rescheduleInDays = $rescheduleInDays;
        return $this;
    }
    /**
     * Get rescheduleOutDays value
     * @return int|null
     */
    public function getRescheduleOutDays()
    {
        return $this->rescheduleOutDays;
    }
    /**
     * Set rescheduleOutDays value
     * @param int $rescheduleOutDays
     * @return \StructType\SerializedInventoryItemLocations
     */
    public function setRescheduleOutDays($rescheduleOutDays = null)
    {
        // validation for constraint: int
        if (!is_null($rescheduleOutDays) && !(is_int($rescheduleOutDays) || ctype_digit($rescheduleOutDays))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($rescheduleOutDays, true), gettype($rescheduleOutDays)), __LINE__);
        }
        $this->rescheduleOutDays = $rescheduleOutDays;
        return $this;
    }
}
