<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SearchMoreWithIdRequest StructType
 * @subpackage Structs
 */
class SearchMoreWithIdRequest extends AbstractStructBase
{
    /**
     * The searchId
     * @var string
     */
    public $searchId;
    /**
     * The pageIndex
     * @var int
     */
    public $pageIndex;
    /**
     * Constructor method for SearchMoreWithIdRequest
     * @uses SearchMoreWithIdRequest::setSearchId()
     * @uses SearchMoreWithIdRequest::setPageIndex()
     * @param string $searchId
     * @param int $pageIndex
     */
    public function __construct($searchId = null, $pageIndex = null)
    {
        $this
            ->setSearchId($searchId)
            ->setPageIndex($pageIndex);
    }
    /**
     * Get searchId value
     * @return string|null
     */
    public function getSearchId()
    {
        return $this->searchId;
    }
    /**
     * Set searchId value
     * @param string $searchId
     * @return \StructType\SearchMoreWithIdRequest
     */
    public function setSearchId($searchId = null)
    {
        // validation for constraint: string
        if (!is_null($searchId) && !is_string($searchId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($searchId, true), gettype($searchId)), __LINE__);
        }
        $this->searchId = $searchId;
        return $this;
    }
    /**
     * Get pageIndex value
     * @return int|null
     */
    public function getPageIndex()
    {
        return $this->pageIndex;
    }
    /**
     * Set pageIndex value
     * @param int $pageIndex
     * @return \StructType\SearchMoreWithIdRequest
     */
    public function setPageIndex($pageIndex = null)
    {
        // validation for constraint: int
        if (!is_null($pageIndex) && !(is_int($pageIndex) || ctype_digit($pageIndex))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($pageIndex, true), gettype($pageIndex)), __LINE__);
        }
        $this->pageIndex = $pageIndex;
        return $this;
    }
}
