<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SalesTeamList StructType
 * @subpackage Structs
 */
class SalesTeamList extends AbstractStructBase
{
    /**
     * The salesTeam
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\CustomerSalesTeam[]
     */
    public $salesTeam;
    /**
     * The replaceAll
     * Meta information extracted from the WSDL
     * - default: true
     * @var bool
     */
    public $replaceAll;
    /**
     * Constructor method for SalesTeamList
     * @uses SalesTeamList::setSalesTeam()
     * @uses SalesTeamList::setReplaceAll()
     * @param \StructType\CustomerSalesTeam[] $salesTeam
     * @param bool $replaceAll
     */
    public function __construct(array $salesTeam = array(), $replaceAll = true)
    {
        $this
            ->setSalesTeam($salesTeam)
            ->setReplaceAll($replaceAll);
    }
    /**
     * Get salesTeam value
     * @return \StructType\CustomerSalesTeam[]|null
     */
    public function getSalesTeam()
    {
        return $this->salesTeam;
    }
    /**
     * This method is responsible for validating the values passed to the setSalesTeam method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSalesTeam method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSalesTeamForArrayConstraintsFromSetSalesTeam(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $salesTeamListSalesTeamItem) {
            // validation for constraint: itemType
            if (!$salesTeamListSalesTeamItem instanceof \StructType\CustomerSalesTeam) {
                $invalidValues[] = is_object($salesTeamListSalesTeamItem) ? get_class($salesTeamListSalesTeamItem) : sprintf('%s(%s)', gettype($salesTeamListSalesTeamItem), var_export($salesTeamListSalesTeamItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The salesTeam property can only contain items of type \StructType\CustomerSalesTeam, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set salesTeam value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomerSalesTeam[] $salesTeam
     * @return \StructType\SalesTeamList
     */
    public function setSalesTeam(array $salesTeam = array())
    {
        // validation for constraint: array
        if ('' !== ($salesTeamArrayErrorMessage = self::validateSalesTeamForArrayConstraintsFromSetSalesTeam($salesTeam))) {
            throw new \InvalidArgumentException($salesTeamArrayErrorMessage, __LINE__);
        }
        $this->salesTeam = $salesTeam;
        return $this;
    }
    /**
     * Add item to salesTeam value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomerSalesTeam $item
     * @return \StructType\SalesTeamList
     */
    public function addToSalesTeam(\StructType\CustomerSalesTeam $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CustomerSalesTeam) {
            throw new \InvalidArgumentException(sprintf('The salesTeam property can only contain items of type \StructType\CustomerSalesTeam, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->salesTeam[] = $item;
        return $this;
    }
    /**
     * Get replaceAll value
     * @return bool|null
     */
    public function getReplaceAll()
    {
        return $this->replaceAll;
    }
    /**
     * Set replaceAll value
     * @param bool $replaceAll
     * @return \StructType\SalesTeamList
     */
    public function setReplaceAll($replaceAll = true)
    {
        // validation for constraint: boolean
        if (!is_null($replaceAll) && !is_bool($replaceAll)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($replaceAll, true), gettype($replaceAll)), __LINE__);
        }
        $this->replaceAll = $replaceAll;
        return $this;
    }
}
