<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SalesTaxItemSearchRowBasic StructType
 * @subpackage Structs
 */
class SalesTaxItemSearchRowBasic extends SearchRowBasic
{
    /**
     * The description
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnStringField[]
     */
    public $description;
    /**
     * The externalId
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnSelectField[]
     */
    public $externalId;
    /**
     * The internalId
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnSelectField[]
     */
    public $internalId;
    /**
     * The isInactive
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnBooleanField[]
     */
    public $isInactive;
    /**
     * The itemId
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnStringField[]
     */
    public $itemId;
    /**
     * The name
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnStringField[]
     */
    public $name;
    /**
     * The taxType
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnSelectField[]
     */
    public $taxType;
    /**
     * Constructor method for SalesTaxItemSearchRowBasic
     * @uses SalesTaxItemSearchRowBasic::setDescription()
     * @uses SalesTaxItemSearchRowBasic::setExternalId()
     * @uses SalesTaxItemSearchRowBasic::setInternalId()
     * @uses SalesTaxItemSearchRowBasic::setIsInactive()
     * @uses SalesTaxItemSearchRowBasic::setItemId()
     * @uses SalesTaxItemSearchRowBasic::setName()
     * @uses SalesTaxItemSearchRowBasic::setTaxType()
     * @param \StructType\SearchColumnStringField[] $description
     * @param \StructType\SearchColumnSelectField[] $externalId
     * @param \StructType\SearchColumnSelectField[] $internalId
     * @param \StructType\SearchColumnBooleanField[] $isInactive
     * @param \StructType\SearchColumnStringField[] $itemId
     * @param \StructType\SearchColumnStringField[] $name
     * @param \StructType\SearchColumnSelectField[] $taxType
     */
    public function __construct(array $description = array(), array $externalId = array(), array $internalId = array(), array $isInactive = array(), array $itemId = array(), array $name = array(), array $taxType = array())
    {
        $this
            ->setDescription($description)
            ->setExternalId($externalId)
            ->setInternalId($internalId)
            ->setIsInactive($isInactive)
            ->setItemId($itemId)
            ->setName($name)
            ->setTaxType($taxType);
    }
    /**
     * Get description value
     * @return \StructType\SearchColumnStringField[]|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * This method is responsible for validating the values passed to the setDescription method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDescription method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDescriptionForArrayConstraintsFromSetDescription(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $salesTaxItemSearchRowBasicDescriptionItem) {
            // validation for constraint: itemType
            if (!$salesTaxItemSearchRowBasicDescriptionItem instanceof \StructType\SearchColumnStringField) {
                $invalidValues[] = is_object($salesTaxItemSearchRowBasicDescriptionItem) ? get_class($salesTaxItemSearchRowBasicDescriptionItem) : sprintf('%s(%s)', gettype($salesTaxItemSearchRowBasicDescriptionItem), var_export($salesTaxItemSearchRowBasicDescriptionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The description property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set description value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField[] $description
     * @return \StructType\SalesTaxItemSearchRowBasic
     */
    public function setDescription(array $description = array())
    {
        // validation for constraint: array
        if ('' !== ($descriptionArrayErrorMessage = self::validateDescriptionForArrayConstraintsFromSetDescription($description))) {
            throw new \InvalidArgumentException($descriptionArrayErrorMessage, __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Add item to description value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField $item
     * @return \StructType\SalesTaxItemSearchRowBasic
     */
    public function addToDescription(\StructType\SearchColumnStringField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnStringField) {
            throw new \InvalidArgumentException(sprintf('The description property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->description[] = $item;
        return $this;
    }
    /**
     * Get externalId value
     * @return \StructType\SearchColumnSelectField[]|null
     */
    public function getExternalId()
    {
        return $this->externalId;
    }
    /**
     * This method is responsible for validating the values passed to the setExternalId method
     * This method is willingly generated in order to preserve the one-line inline validation within the setExternalId method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateExternalIdForArrayConstraintsFromSetExternalId(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $salesTaxItemSearchRowBasicExternalIdItem) {
            // validation for constraint: itemType
            if (!$salesTaxItemSearchRowBasicExternalIdItem instanceof \StructType\SearchColumnSelectField) {
                $invalidValues[] = is_object($salesTaxItemSearchRowBasicExternalIdItem) ? get_class($salesTaxItemSearchRowBasicExternalIdItem) : sprintf('%s(%s)', gettype($salesTaxItemSearchRowBasicExternalIdItem), var_export($salesTaxItemSearchRowBasicExternalIdItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The externalId property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set externalId value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField[] $externalId
     * @return \StructType\SalesTaxItemSearchRowBasic
     */
    public function setExternalId(array $externalId = array())
    {
        // validation for constraint: array
        if ('' !== ($externalIdArrayErrorMessage = self::validateExternalIdForArrayConstraintsFromSetExternalId($externalId))) {
            throw new \InvalidArgumentException($externalIdArrayErrorMessage, __LINE__);
        }
        $this->externalId = $externalId;
        return $this;
    }
    /**
     * Add item to externalId value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField $item
     * @return \StructType\SalesTaxItemSearchRowBasic
     */
    public function addToExternalId(\StructType\SearchColumnSelectField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnSelectField) {
            throw new \InvalidArgumentException(sprintf('The externalId property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->externalId[] = $item;
        return $this;
    }
    /**
     * Get internalId value
     * @return \StructType\SearchColumnSelectField[]|null
     */
    public function getInternalId()
    {
        return $this->internalId;
    }
    /**
     * This method is responsible for validating the values passed to the setInternalId method
     * This method is willingly generated in order to preserve the one-line inline validation within the setInternalId method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateInternalIdForArrayConstraintsFromSetInternalId(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $salesTaxItemSearchRowBasicInternalIdItem) {
            // validation for constraint: itemType
            if (!$salesTaxItemSearchRowBasicInternalIdItem instanceof \StructType\SearchColumnSelectField) {
                $invalidValues[] = is_object($salesTaxItemSearchRowBasicInternalIdItem) ? get_class($salesTaxItemSearchRowBasicInternalIdItem) : sprintf('%s(%s)', gettype($salesTaxItemSearchRowBasicInternalIdItem), var_export($salesTaxItemSearchRowBasicInternalIdItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The internalId property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set internalId value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField[] $internalId
     * @return \StructType\SalesTaxItemSearchRowBasic
     */
    public function setInternalId(array $internalId = array())
    {
        // validation for constraint: array
        if ('' !== ($internalIdArrayErrorMessage = self::validateInternalIdForArrayConstraintsFromSetInternalId($internalId))) {
            throw new \InvalidArgumentException($internalIdArrayErrorMessage, __LINE__);
        }
        $this->internalId = $internalId;
        return $this;
    }
    /**
     * Add item to internalId value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField $item
     * @return \StructType\SalesTaxItemSearchRowBasic
     */
    public function addToInternalId(\StructType\SearchColumnSelectField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnSelectField) {
            throw new \InvalidArgumentException(sprintf('The internalId property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->internalId[] = $item;
        return $this;
    }
    /**
     * Get isInactive value
     * @return \StructType\SearchColumnBooleanField[]|null
     */
    public function getIsInactive()
    {
        return $this->isInactive;
    }
    /**
     * This method is responsible for validating the values passed to the setIsInactive method
     * This method is willingly generated in order to preserve the one-line inline validation within the setIsInactive method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateIsInactiveForArrayConstraintsFromSetIsInactive(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $salesTaxItemSearchRowBasicIsInactiveItem) {
            // validation for constraint: itemType
            if (!$salesTaxItemSearchRowBasicIsInactiveItem instanceof \StructType\SearchColumnBooleanField) {
                $invalidValues[] = is_object($salesTaxItemSearchRowBasicIsInactiveItem) ? get_class($salesTaxItemSearchRowBasicIsInactiveItem) : sprintf('%s(%s)', gettype($salesTaxItemSearchRowBasicIsInactiveItem), var_export($salesTaxItemSearchRowBasicIsInactiveItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The isInactive property can only contain items of type \StructType\SearchColumnBooleanField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set isInactive value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnBooleanField[] $isInactive
     * @return \StructType\SalesTaxItemSearchRowBasic
     */
    public function setIsInactive(array $isInactive = array())
    {
        // validation for constraint: array
        if ('' !== ($isInactiveArrayErrorMessage = self::validateIsInactiveForArrayConstraintsFromSetIsInactive($isInactive))) {
            throw new \InvalidArgumentException($isInactiveArrayErrorMessage, __LINE__);
        }
        $this->isInactive = $isInactive;
        return $this;
    }
    /**
     * Add item to isInactive value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnBooleanField $item
     * @return \StructType\SalesTaxItemSearchRowBasic
     */
    public function addToIsInactive(\StructType\SearchColumnBooleanField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnBooleanField) {
            throw new \InvalidArgumentException(sprintf('The isInactive property can only contain items of type \StructType\SearchColumnBooleanField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->isInactive[] = $item;
        return $this;
    }
    /**
     * Get itemId value
     * @return \StructType\SearchColumnStringField[]|null
     */
    public function getItemId()
    {
        return $this->itemId;
    }
    /**
     * This method is responsible for validating the values passed to the setItemId method
     * This method is willingly generated in order to preserve the one-line inline validation within the setItemId method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateItemIdForArrayConstraintsFromSetItemId(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $salesTaxItemSearchRowBasicItemIdItem) {
            // validation for constraint: itemType
            if (!$salesTaxItemSearchRowBasicItemIdItem instanceof \StructType\SearchColumnStringField) {
                $invalidValues[] = is_object($salesTaxItemSearchRowBasicItemIdItem) ? get_class($salesTaxItemSearchRowBasicItemIdItem) : sprintf('%s(%s)', gettype($salesTaxItemSearchRowBasicItemIdItem), var_export($salesTaxItemSearchRowBasicItemIdItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The itemId property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set itemId value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField[] $itemId
     * @return \StructType\SalesTaxItemSearchRowBasic
     */
    public function setItemId(array $itemId = array())
    {
        // validation for constraint: array
        if ('' !== ($itemIdArrayErrorMessage = self::validateItemIdForArrayConstraintsFromSetItemId($itemId))) {
            throw new \InvalidArgumentException($itemIdArrayErrorMessage, __LINE__);
        }
        $this->itemId = $itemId;
        return $this;
    }
    /**
     * Add item to itemId value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField $item
     * @return \StructType\SalesTaxItemSearchRowBasic
     */
    public function addToItemId(\StructType\SearchColumnStringField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnStringField) {
            throw new \InvalidArgumentException(sprintf('The itemId property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->itemId[] = $item;
        return $this;
    }
    /**
     * Get name value
     * @return \StructType\SearchColumnStringField[]|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * This method is responsible for validating the values passed to the setName method
     * This method is willingly generated in order to preserve the one-line inline validation within the setName method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateNameForArrayConstraintsFromSetName(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $salesTaxItemSearchRowBasicNameItem) {
            // validation for constraint: itemType
            if (!$salesTaxItemSearchRowBasicNameItem instanceof \StructType\SearchColumnStringField) {
                $invalidValues[] = is_object($salesTaxItemSearchRowBasicNameItem) ? get_class($salesTaxItemSearchRowBasicNameItem) : sprintf('%s(%s)', gettype($salesTaxItemSearchRowBasicNameItem), var_export($salesTaxItemSearchRowBasicNameItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The name property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set name value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField[] $name
     * @return \StructType\SalesTaxItemSearchRowBasic
     */
    public function setName(array $name = array())
    {
        // validation for constraint: array
        if ('' !== ($nameArrayErrorMessage = self::validateNameForArrayConstraintsFromSetName($name))) {
            throw new \InvalidArgumentException($nameArrayErrorMessage, __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Add item to name value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField $item
     * @return \StructType\SalesTaxItemSearchRowBasic
     */
    public function addToName(\StructType\SearchColumnStringField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnStringField) {
            throw new \InvalidArgumentException(sprintf('The name property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->name[] = $item;
        return $this;
    }
    /**
     * Get taxType value
     * @return \StructType\SearchColumnSelectField[]|null
     */
    public function getTaxType()
    {
        return $this->taxType;
    }
    /**
     * This method is responsible for validating the values passed to the setTaxType method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTaxType method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTaxTypeForArrayConstraintsFromSetTaxType(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $salesTaxItemSearchRowBasicTaxTypeItem) {
            // validation for constraint: itemType
            if (!$salesTaxItemSearchRowBasicTaxTypeItem instanceof \StructType\SearchColumnSelectField) {
                $invalidValues[] = is_object($salesTaxItemSearchRowBasicTaxTypeItem) ? get_class($salesTaxItemSearchRowBasicTaxTypeItem) : sprintf('%s(%s)', gettype($salesTaxItemSearchRowBasicTaxTypeItem), var_export($salesTaxItemSearchRowBasicTaxTypeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The taxType property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set taxType value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField[] $taxType
     * @return \StructType\SalesTaxItemSearchRowBasic
     */
    public function setTaxType(array $taxType = array())
    {
        // validation for constraint: array
        if ('' !== ($taxTypeArrayErrorMessage = self::validateTaxTypeForArrayConstraintsFromSetTaxType($taxType))) {
            throw new \InvalidArgumentException($taxTypeArrayErrorMessage, __LINE__);
        }
        $this->taxType = $taxType;
        return $this;
    }
    /**
     * Add item to taxType value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField $item
     * @return \StructType\SalesTaxItemSearchRowBasic
     */
    public function addToTaxType(\StructType\SearchColumnSelectField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnSelectField) {
            throw new \InvalidArgumentException(sprintf('The taxType property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->taxType[] = $item;
        return $this;
    }
}
