<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SalesTaxItem StructType
 * Meta information extracted from the WSDL
 * - type: listAcct:SalesTaxItem
 * @subpackage Structs
 */
class SalesTaxItem extends Record
{
    /**
     * The itemId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $itemId;
    /**
     * The displayName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $displayName;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $description;
    /**
     * The rate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $rate;
    /**
     * The taxType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $taxType;
    /**
     * The taxAgency
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $taxAgency;
    /**
     * The purchaseAccount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $purchaseAccount;
    /**
     * The saleAccount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $saleAccount;
    /**
     * The isInactive
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $isInactive;
    /**
     * The effectiveFrom
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $effectiveFrom;
    /**
     * The validUntil
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $validUntil;
    /**
     * The subsidiaryList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRefList
     */
    public $subsidiaryList;
    /**
     * The includeChildren
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $includeChildren;
    /**
     * The eccode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $eccode;
    /**
     * The reverseCharge
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $reverseCharge;
    /**
     * The parent
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $parent;
    /**
     * The service
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $service;
    /**
     * The exempt
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $exempt;
    /**
     * The isDefault
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $isDefault;
    /**
     * The excludeFromTaxReports
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $excludeFromTaxReports;
    /**
     * The available
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $available;
    /**
     * The export
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $export;
    /**
     * The taxAccount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $taxAccount;
    /**
     * The county
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $county;
    /**
     * The city
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $city;
    /**
     * The state
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $state;
    /**
     * The zip
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $zip;
    /**
     * The nexusCountry
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $nexusCountry;
    /**
     * The name
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $name;
    /**
     * The customFieldList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CustomFieldList
     */
    public $customFieldList;
    /**
     * The internalId
     * @var string
     */
    public $internalId;
    /**
     * The externalId
     * @var string
     */
    public $externalId;
    /**
     * Constructor method for SalesTaxItem
     * @uses SalesTaxItem::setItemId()
     * @uses SalesTaxItem::setDisplayName()
     * @uses SalesTaxItem::setDescription()
     * @uses SalesTaxItem::setRate()
     * @uses SalesTaxItem::setTaxType()
     * @uses SalesTaxItem::setTaxAgency()
     * @uses SalesTaxItem::setPurchaseAccount()
     * @uses SalesTaxItem::setSaleAccount()
     * @uses SalesTaxItem::setIsInactive()
     * @uses SalesTaxItem::setEffectiveFrom()
     * @uses SalesTaxItem::setValidUntil()
     * @uses SalesTaxItem::setSubsidiaryList()
     * @uses SalesTaxItem::setIncludeChildren()
     * @uses SalesTaxItem::setEccode()
     * @uses SalesTaxItem::setReverseCharge()
     * @uses SalesTaxItem::setParent()
     * @uses SalesTaxItem::setService()
     * @uses SalesTaxItem::setExempt()
     * @uses SalesTaxItem::setIsDefault()
     * @uses SalesTaxItem::setExcludeFromTaxReports()
     * @uses SalesTaxItem::setAvailable()
     * @uses SalesTaxItem::setExport()
     * @uses SalesTaxItem::setTaxAccount()
     * @uses SalesTaxItem::setCounty()
     * @uses SalesTaxItem::setCity()
     * @uses SalesTaxItem::setState()
     * @uses SalesTaxItem::setZip()
     * @uses SalesTaxItem::setNexusCountry()
     * @uses SalesTaxItem::setName()
     * @uses SalesTaxItem::setCustomFieldList()
     * @uses SalesTaxItem::setInternalId()
     * @uses SalesTaxItem::setExternalId()
     * @param string $itemId
     * @param string $displayName
     * @param string $description
     * @param string $rate
     * @param \StructType\RecordRef $taxType
     * @param \StructType\RecordRef $taxAgency
     * @param \StructType\RecordRef $purchaseAccount
     * @param \StructType\RecordRef $saleAccount
     * @param bool $isInactive
     * @param string $effectiveFrom
     * @param string $validUntil
     * @param \StructType\RecordRefList $subsidiaryList
     * @param bool $includeChildren
     * @param bool $eccode
     * @param bool $reverseCharge
     * @param \StructType\RecordRef $parent
     * @param bool $service
     * @param bool $exempt
     * @param bool $isDefault
     * @param bool $excludeFromTaxReports
     * @param string $available
     * @param bool $export
     * @param \StructType\RecordRef $taxAccount
     * @param string $county
     * @param string $city
     * @param string $state
     * @param string $zip
     * @param \StructType\RecordRef $nexusCountry
     * @param string $name
     * @param \StructType\CustomFieldList $customFieldList
     * @param string $internalId
     * @param string $externalId
     */
    public function __construct($itemId = null, $displayName = null, $description = null, $rate = null, \StructType\RecordRef $taxType = null, \StructType\RecordRef $taxAgency = null, \StructType\RecordRef $purchaseAccount = null, \StructType\RecordRef $saleAccount = null, $isInactive = null, $effectiveFrom = null, $validUntil = null, \StructType\RecordRefList $subsidiaryList = null, $includeChildren = null, $eccode = null, $reverseCharge = null, \StructType\RecordRef $parent = null, $service = null, $exempt = null, $isDefault = null, $excludeFromTaxReports = null, $available = null, $export = null, \StructType\RecordRef $taxAccount = null, $county = null, $city = null, $state = null, $zip = null, \StructType\RecordRef $nexusCountry = null, $name = null, \StructType\CustomFieldList $customFieldList = null, $internalId = null, $externalId = null)
    {
        $this
            ->setItemId($itemId)
            ->setDisplayName($displayName)
            ->setDescription($description)
            ->setRate($rate)
            ->setTaxType($taxType)
            ->setTaxAgency($taxAgency)
            ->setPurchaseAccount($purchaseAccount)
            ->setSaleAccount($saleAccount)
            ->setIsInactive($isInactive)
            ->setEffectiveFrom($effectiveFrom)
            ->setValidUntil($validUntil)
            ->setSubsidiaryList($subsidiaryList)
            ->setIncludeChildren($includeChildren)
            ->setEccode($eccode)
            ->setReverseCharge($reverseCharge)
            ->setParent($parent)
            ->setService($service)
            ->setExempt($exempt)
            ->setIsDefault($isDefault)
            ->setExcludeFromTaxReports($excludeFromTaxReports)
            ->setAvailable($available)
            ->setExport($export)
            ->setTaxAccount($taxAccount)
            ->setCounty($county)
            ->setCity($city)
            ->setState($state)
            ->setZip($zip)
            ->setNexusCountry($nexusCountry)
            ->setName($name)
            ->setCustomFieldList($customFieldList)
            ->setInternalId($internalId)
            ->setExternalId($externalId);
    }
    /**
     * Get itemId value
     * @return string|null
     */
    public function getItemId()
    {
        return $this->itemId;
    }
    /**
     * Set itemId value
     * @param string $itemId
     * @return \StructType\SalesTaxItem
     */
    public function setItemId($itemId = null)
    {
        // validation for constraint: string
        if (!is_null($itemId) && !is_string($itemId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($itemId, true), gettype($itemId)), __LINE__);
        }
        $this->itemId = $itemId;
        return $this;
    }
    /**
     * Get displayName value
     * @return string|null
     */
    public function getDisplayName()
    {
        return $this->displayName;
    }
    /**
     * Set displayName value
     * @param string $displayName
     * @return \StructType\SalesTaxItem
     */
    public function setDisplayName($displayName = null)
    {
        // validation for constraint: string
        if (!is_null($displayName) && !is_string($displayName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($displayName, true), gettype($displayName)), __LINE__);
        }
        $this->displayName = $displayName;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\SalesTaxItem
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get rate value
     * @return string|null
     */
    public function getRate()
    {
        return $this->rate;
    }
    /**
     * Set rate value
     * @param string $rate
     * @return \StructType\SalesTaxItem
     */
    public function setRate($rate = null)
    {
        // validation for constraint: string
        if (!is_null($rate) && !is_string($rate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rate, true), gettype($rate)), __LINE__);
        }
        $this->rate = $rate;
        return $this;
    }
    /**
     * Get taxType value
     * @return \StructType\RecordRef|null
     */
    public function getTaxType()
    {
        return $this->taxType;
    }
    /**
     * Set taxType value
     * @param \StructType\RecordRef $taxType
     * @return \StructType\SalesTaxItem
     */
    public function setTaxType(\StructType\RecordRef $taxType = null)
    {
        $this->taxType = $taxType;
        return $this;
    }
    /**
     * Get taxAgency value
     * @return \StructType\RecordRef|null
     */
    public function getTaxAgency()
    {
        return $this->taxAgency;
    }
    /**
     * Set taxAgency value
     * @param \StructType\RecordRef $taxAgency
     * @return \StructType\SalesTaxItem
     */
    public function setTaxAgency(\StructType\RecordRef $taxAgency = null)
    {
        $this->taxAgency = $taxAgency;
        return $this;
    }
    /**
     * Get purchaseAccount value
     * @return \StructType\RecordRef|null
     */
    public function getPurchaseAccount()
    {
        return $this->purchaseAccount;
    }
    /**
     * Set purchaseAccount value
     * @param \StructType\RecordRef $purchaseAccount
     * @return \StructType\SalesTaxItem
     */
    public function setPurchaseAccount(\StructType\RecordRef $purchaseAccount = null)
    {
        $this->purchaseAccount = $purchaseAccount;
        return $this;
    }
    /**
     * Get saleAccount value
     * @return \StructType\RecordRef|null
     */
    public function getSaleAccount()
    {
        return $this->saleAccount;
    }
    /**
     * Set saleAccount value
     * @param \StructType\RecordRef $saleAccount
     * @return \StructType\SalesTaxItem
     */
    public function setSaleAccount(\StructType\RecordRef $saleAccount = null)
    {
        $this->saleAccount = $saleAccount;
        return $this;
    }
    /**
     * Get isInactive value
     * @return bool|null
     */
    public function getIsInactive()
    {
        return $this->isInactive;
    }
    /**
     * Set isInactive value
     * @param bool $isInactive
     * @return \StructType\SalesTaxItem
     */
    public function setIsInactive($isInactive = null)
    {
        // validation for constraint: boolean
        if (!is_null($isInactive) && !is_bool($isInactive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isInactive, true), gettype($isInactive)), __LINE__);
        }
        $this->isInactive = $isInactive;
        return $this;
    }
    /**
     * Get effectiveFrom value
     * @return string|null
     */
    public function getEffectiveFrom()
    {
        return $this->effectiveFrom;
    }
    /**
     * Set effectiveFrom value
     * @param string $effectiveFrom
     * @return \StructType\SalesTaxItem
     */
    public function setEffectiveFrom($effectiveFrom = null)
    {
        // validation for constraint: string
        if (!is_null($effectiveFrom) && !is_string($effectiveFrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($effectiveFrom, true), gettype($effectiveFrom)), __LINE__);
        }
        $this->effectiveFrom = $effectiveFrom;
        return $this;
    }
    /**
     * Get validUntil value
     * @return string|null
     */
    public function getValidUntil()
    {
        return $this->validUntil;
    }
    /**
     * Set validUntil value
     * @param string $validUntil
     * @return \StructType\SalesTaxItem
     */
    public function setValidUntil($validUntil = null)
    {
        // validation for constraint: string
        if (!is_null($validUntil) && !is_string($validUntil)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($validUntil, true), gettype($validUntil)), __LINE__);
        }
        $this->validUntil = $validUntil;
        return $this;
    }
    /**
     * Get subsidiaryList value
     * @return \StructType\RecordRefList|null
     */
    public function getSubsidiaryList()
    {
        return $this->subsidiaryList;
    }
    /**
     * Set subsidiaryList value
     * @param \StructType\RecordRefList $subsidiaryList
     * @return \StructType\SalesTaxItem
     */
    public function setSubsidiaryList(\StructType\RecordRefList $subsidiaryList = null)
    {
        $this->subsidiaryList = $subsidiaryList;
        return $this;
    }
    /**
     * Get includeChildren value
     * @return bool|null
     */
    public function getIncludeChildren()
    {
        return $this->includeChildren;
    }
    /**
     * Set includeChildren value
     * @param bool $includeChildren
     * @return \StructType\SalesTaxItem
     */
    public function setIncludeChildren($includeChildren = null)
    {
        // validation for constraint: boolean
        if (!is_null($includeChildren) && !is_bool($includeChildren)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($includeChildren, true), gettype($includeChildren)), __LINE__);
        }
        $this->includeChildren = $includeChildren;
        return $this;
    }
    /**
     * Get eccode value
     * @return bool|null
     */
    public function getEccode()
    {
        return $this->eccode;
    }
    /**
     * Set eccode value
     * @param bool $eccode
     * @return \StructType\SalesTaxItem
     */
    public function setEccode($eccode = null)
    {
        // validation for constraint: boolean
        if (!is_null($eccode) && !is_bool($eccode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($eccode, true), gettype($eccode)), __LINE__);
        }
        $this->eccode = $eccode;
        return $this;
    }
    /**
     * Get reverseCharge value
     * @return bool|null
     */
    public function getReverseCharge()
    {
        return $this->reverseCharge;
    }
    /**
     * Set reverseCharge value
     * @param bool $reverseCharge
     * @return \StructType\SalesTaxItem
     */
    public function setReverseCharge($reverseCharge = null)
    {
        // validation for constraint: boolean
        if (!is_null($reverseCharge) && !is_bool($reverseCharge)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($reverseCharge, true), gettype($reverseCharge)), __LINE__);
        }
        $this->reverseCharge = $reverseCharge;
        return $this;
    }
    /**
     * Get parent value
     * @return \StructType\RecordRef|null
     */
    public function getParent()
    {
        return $this->parent;
    }
    /**
     * Set parent value
     * @param \StructType\RecordRef $parent
     * @return \StructType\SalesTaxItem
     */
    public function setParent(\StructType\RecordRef $parent = null)
    {
        $this->parent = $parent;
        return $this;
    }
    /**
     * Get service value
     * @return bool|null
     */
    public function getService()
    {
        return $this->service;
    }
    /**
     * Set service value
     * @param bool $service
     * @return \StructType\SalesTaxItem
     */
    public function setService($service = null)
    {
        // validation for constraint: boolean
        if (!is_null($service) && !is_bool($service)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($service, true), gettype($service)), __LINE__);
        }
        $this->service = $service;
        return $this;
    }
    /**
     * Get exempt value
     * @return bool|null
     */
    public function getExempt()
    {
        return $this->exempt;
    }
    /**
     * Set exempt value
     * @param bool $exempt
     * @return \StructType\SalesTaxItem
     */
    public function setExempt($exempt = null)
    {
        // validation for constraint: boolean
        if (!is_null($exempt) && !is_bool($exempt)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($exempt, true), gettype($exempt)), __LINE__);
        }
        $this->exempt = $exempt;
        return $this;
    }
    /**
     * Get isDefault value
     * @return bool|null
     */
    public function getIsDefault()
    {
        return $this->isDefault;
    }
    /**
     * Set isDefault value
     * @param bool $isDefault
     * @return \StructType\SalesTaxItem
     */
    public function setIsDefault($isDefault = null)
    {
        // validation for constraint: boolean
        if (!is_null($isDefault) && !is_bool($isDefault)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isDefault, true), gettype($isDefault)), __LINE__);
        }
        $this->isDefault = $isDefault;
        return $this;
    }
    /**
     * Get excludeFromTaxReports value
     * @return bool|null
     */
    public function getExcludeFromTaxReports()
    {
        return $this->excludeFromTaxReports;
    }
    /**
     * Set excludeFromTaxReports value
     * @param bool $excludeFromTaxReports
     * @return \StructType\SalesTaxItem
     */
    public function setExcludeFromTaxReports($excludeFromTaxReports = null)
    {
        // validation for constraint: boolean
        if (!is_null($excludeFromTaxReports) && !is_bool($excludeFromTaxReports)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($excludeFromTaxReports, true), gettype($excludeFromTaxReports)), __LINE__);
        }
        $this->excludeFromTaxReports = $excludeFromTaxReports;
        return $this;
    }
    /**
     * Get available value
     * @return string|null
     */
    public function getAvailable()
    {
        return $this->available;
    }
    /**
     * Set available value
     * @uses \EnumType\SalesTaxItemAvailable::valueIsValid()
     * @uses \EnumType\SalesTaxItemAvailable::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $available
     * @return \StructType\SalesTaxItem
     */
    public function setAvailable($available = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\SalesTaxItemAvailable::valueIsValid($available)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\SalesTaxItemAvailable', is_array($available) ? implode(', ', $available) : var_export($available, true), implode(', ', \EnumType\SalesTaxItemAvailable::getValidValues())), __LINE__);
        }
        $this->available = $available;
        return $this;
    }
    /**
     * Get export value
     * @return bool|null
     */
    public function getExport()
    {
        return $this->export;
    }
    /**
     * Set export value
     * @param bool $export
     * @return \StructType\SalesTaxItem
     */
    public function setExport($export = null)
    {
        // validation for constraint: boolean
        if (!is_null($export) && !is_bool($export)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($export, true), gettype($export)), __LINE__);
        }
        $this->export = $export;
        return $this;
    }
    /**
     * Get taxAccount value
     * @return \StructType\RecordRef|null
     */
    public function getTaxAccount()
    {
        return $this->taxAccount;
    }
    /**
     * Set taxAccount value
     * @param \StructType\RecordRef $taxAccount
     * @return \StructType\SalesTaxItem
     */
    public function setTaxAccount(\StructType\RecordRef $taxAccount = null)
    {
        $this->taxAccount = $taxAccount;
        return $this;
    }
    /**
     * Get county value
     * @return string|null
     */
    public function getCounty()
    {
        return $this->county;
    }
    /**
     * Set county value
     * @param string $county
     * @return \StructType\SalesTaxItem
     */
    public function setCounty($county = null)
    {
        // validation for constraint: string
        if (!is_null($county) && !is_string($county)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($county, true), gettype($county)), __LINE__);
        }
        $this->county = $county;
        return $this;
    }
    /**
     * Get city value
     * @return string|null
     */
    public function getCity()
    {
        return $this->city;
    }
    /**
     * Set city value
     * @param string $city
     * @return \StructType\SalesTaxItem
     */
    public function setCity($city = null)
    {
        // validation for constraint: string
        if (!is_null($city) && !is_string($city)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($city, true), gettype($city)), __LINE__);
        }
        $this->city = $city;
        return $this;
    }
    /**
     * Get state value
     * @return string|null
     */
    public function getState()
    {
        return $this->state;
    }
    /**
     * Set state value
     * @param string $state
     * @return \StructType\SalesTaxItem
     */
    public function setState($state = null)
    {
        // validation for constraint: string
        if (!is_null($state) && !is_string($state)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($state, true), gettype($state)), __LINE__);
        }
        $this->state = $state;
        return $this;
    }
    /**
     * Get zip value
     * @return string|null
     */
    public function getZip()
    {
        return $this->zip;
    }
    /**
     * Set zip value
     * @param string $zip
     * @return \StructType\SalesTaxItem
     */
    public function setZip($zip = null)
    {
        // validation for constraint: string
        if (!is_null($zip) && !is_string($zip)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($zip, true), gettype($zip)), __LINE__);
        }
        $this->zip = $zip;
        return $this;
    }
    /**
     * Get nexusCountry value
     * @return \StructType\RecordRef|null
     */
    public function getNexusCountry()
    {
        return $this->nexusCountry;
    }
    /**
     * Set nexusCountry value
     * @param \StructType\RecordRef $nexusCountry
     * @return \StructType\SalesTaxItem
     */
    public function setNexusCountry(\StructType\RecordRef $nexusCountry = null)
    {
        $this->nexusCountry = $nexusCountry;
        return $this;
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\SalesTaxItem
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get customFieldList value
     * @return \StructType\CustomFieldList|null
     */
    public function getCustomFieldList()
    {
        return $this->customFieldList;
    }
    /**
     * Set customFieldList value
     * @param \StructType\CustomFieldList $customFieldList
     * @return \StructType\SalesTaxItem
     */
    public function setCustomFieldList(\StructType\CustomFieldList $customFieldList = null)
    {
        $this->customFieldList = $customFieldList;
        return $this;
    }
    /**
     * Get internalId value
     * @return string|null
     */
    public function getInternalId()
    {
        return $this->internalId;
    }
    /**
     * Set internalId value
     * @param string $internalId
     * @return \StructType\SalesTaxItem
     */
    public function setInternalId($internalId = null)
    {
        // validation for constraint: string
        if (!is_null($internalId) && !is_string($internalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($internalId, true), gettype($internalId)), __LINE__);
        }
        $this->internalId = $internalId;
        return $this;
    }
    /**
     * Get externalId value
     * @return string|null
     */
    public function getExternalId()
    {
        return $this->externalId;
    }
    /**
     * Set externalId value
     * @param string $externalId
     * @return \StructType\SalesTaxItem
     */
    public function setExternalId($externalId = null)
    {
        // validation for constraint: string
        if (!is_null($externalId) && !is_string($externalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($externalId, true), gettype($externalId)), __LINE__);
        }
        $this->externalId = $externalId;
        return $this;
    }
}
