<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SalesRoleSearchAdvanced StructType
 * @subpackage Structs
 */
class SalesRoleSearchAdvanced extends SearchRecord
{
    /**
     * The criteria
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SalesRoleSearch
     */
    public $criteria;
    /**
     * The columns
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SalesRoleSearchRow
     */
    public $columns;
    /**
     * The savedSearchId
     * @var string
     */
    public $savedSearchId;
    /**
     * The savedSearchScriptId
     * @var string
     */
    public $savedSearchScriptId;
    /**
     * Constructor method for SalesRoleSearchAdvanced
     * @uses SalesRoleSearchAdvanced::setCriteria()
     * @uses SalesRoleSearchAdvanced::setColumns()
     * @uses SalesRoleSearchAdvanced::setSavedSearchId()
     * @uses SalesRoleSearchAdvanced::setSavedSearchScriptId()
     * @param \StructType\SalesRoleSearch $criteria
     * @param \StructType\SalesRoleSearchRow $columns
     * @param string $savedSearchId
     * @param string $savedSearchScriptId
     */
    public function __construct(\StructType\SalesRoleSearch $criteria = null, \StructType\SalesRoleSearchRow $columns = null, $savedSearchId = null, $savedSearchScriptId = null)
    {
        $this
            ->setCriteria($criteria)
            ->setColumns($columns)
            ->setSavedSearchId($savedSearchId)
            ->setSavedSearchScriptId($savedSearchScriptId);
    }
    /**
     * Get criteria value
     * @return \StructType\SalesRoleSearch|null
     */
    public function getCriteria()
    {
        return $this->criteria;
    }
    /**
     * Set criteria value
     * @param \StructType\SalesRoleSearch $criteria
     * @return \StructType\SalesRoleSearchAdvanced
     */
    public function setCriteria(\StructType\SalesRoleSearch $criteria = null)
    {
        $this->criteria = $criteria;
        return $this;
    }
    /**
     * Get columns value
     * @return \StructType\SalesRoleSearchRow|null
     */
    public function getColumns()
    {
        return $this->columns;
    }
    /**
     * Set columns value
     * @param \StructType\SalesRoleSearchRow $columns
     * @return \StructType\SalesRoleSearchAdvanced
     */
    public function setColumns(\StructType\SalesRoleSearchRow $columns = null)
    {
        $this->columns = $columns;
        return $this;
    }
    /**
     * Get savedSearchId value
     * @return string|null
     */
    public function getSavedSearchId()
    {
        return $this->savedSearchId;
    }
    /**
     * Set savedSearchId value
     * @param string $savedSearchId
     * @return \StructType\SalesRoleSearchAdvanced
     */
    public function setSavedSearchId($savedSearchId = null)
    {
        // validation for constraint: string
        if (!is_null($savedSearchId) && !is_string($savedSearchId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($savedSearchId, true), gettype($savedSearchId)), __LINE__);
        }
        $this->savedSearchId = $savedSearchId;
        return $this;
    }
    /**
     * Get savedSearchScriptId value
     * @return string|null
     */
    public function getSavedSearchScriptId()
    {
        return $this->savedSearchScriptId;
    }
    /**
     * Set savedSearchScriptId value
     * @param string $savedSearchScriptId
     * @return \StructType\SalesRoleSearchAdvanced
     */
    public function setSavedSearchScriptId($savedSearchScriptId = null)
    {
        // validation for constraint: string
        if (!is_null($savedSearchScriptId) && !is_string($savedSearchScriptId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($savedSearchScriptId, true), gettype($savedSearchScriptId)), __LINE__);
        }
        $this->savedSearchScriptId = $savedSearchScriptId;
        return $this;
    }
}
