<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SalesRole StructType
 * Meta information extracted from the WSDL
 * - type: listAcct:SalesRole
 * @subpackage Structs
 */
class SalesRole extends Record
{
    /**
     * The name
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $name;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $description;
    /**
     * The isSalesRep
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $isSalesRep;
    /**
     * The isInactive
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $isInactive;
    /**
     * The internalId
     * @var string
     */
    public $internalId;
    /**
     * The externalId
     * @var string
     */
    public $externalId;
    /**
     * Constructor method for SalesRole
     * @uses SalesRole::setName()
     * @uses SalesRole::setDescription()
     * @uses SalesRole::setIsSalesRep()
     * @uses SalesRole::setIsInactive()
     * @uses SalesRole::setInternalId()
     * @uses SalesRole::setExternalId()
     * @param string $name
     * @param string $description
     * @param bool $isSalesRep
     * @param bool $isInactive
     * @param string $internalId
     * @param string $externalId
     */
    public function __construct($name = null, $description = null, $isSalesRep = null, $isInactive = null, $internalId = null, $externalId = null)
    {
        $this
            ->setName($name)
            ->setDescription($description)
            ->setIsSalesRep($isSalesRep)
            ->setIsInactive($isInactive)
            ->setInternalId($internalId)
            ->setExternalId($externalId);
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\SalesRole
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\SalesRole
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get isSalesRep value
     * @return bool|null
     */
    public function getIsSalesRep()
    {
        return $this->isSalesRep;
    }
    /**
     * Set isSalesRep value
     * @param bool $isSalesRep
     * @return \StructType\SalesRole
     */
    public function setIsSalesRep($isSalesRep = null)
    {
        // validation for constraint: boolean
        if (!is_null($isSalesRep) && !is_bool($isSalesRep)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isSalesRep, true), gettype($isSalesRep)), __LINE__);
        }
        $this->isSalesRep = $isSalesRep;
        return $this;
    }
    /**
     * Get isInactive value
     * @return bool|null
     */
    public function getIsInactive()
    {
        return $this->isInactive;
    }
    /**
     * Set isInactive value
     * @param bool $isInactive
     * @return \StructType\SalesRole
     */
    public function setIsInactive($isInactive = null)
    {
        // validation for constraint: boolean
        if (!is_null($isInactive) && !is_bool($isInactive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isInactive, true), gettype($isInactive)), __LINE__);
        }
        $this->isInactive = $isInactive;
        return $this;
    }
    /**
     * Get internalId value
     * @return string|null
     */
    public function getInternalId()
    {
        return $this->internalId;
    }
    /**
     * Set internalId value
     * @param string $internalId
     * @return \StructType\SalesRole
     */
    public function setInternalId($internalId = null)
    {
        // validation for constraint: string
        if (!is_null($internalId) && !is_string($internalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($internalId, true), gettype($internalId)), __LINE__);
        }
        $this->internalId = $internalId;
        return $this;
    }
    /**
     * Get externalId value
     * @return string|null
     */
    public function getExternalId()
    {
        return $this->externalId;
    }
    /**
     * Set externalId value
     * @param string $externalId
     * @return \StructType\SalesRole
     */
    public function setExternalId($externalId = null)
    {
        // validation for constraint: string
        if (!is_null($externalId) && !is_string($externalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($externalId, true), gettype($externalId)), __LINE__);
        }
        $this->externalId = $externalId;
        return $this;
    }
}
