<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ReturnAuthorizationSalesTeamList StructType
 * @subpackage Structs
 */
class ReturnAuthorizationSalesTeamList extends AbstractStructBase
{
    /**
     * The salesTeam
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ReturnAuthorizationSalesTeam[]
     */
    public $salesTeam;
    /**
     * The replaceAll
     * Meta information extracted from the WSDL
     * - default: true
     * @var bool
     */
    public $replaceAll;
    /**
     * Constructor method for ReturnAuthorizationSalesTeamList
     * @uses ReturnAuthorizationSalesTeamList::setSalesTeam()
     * @uses ReturnAuthorizationSalesTeamList::setReplaceAll()
     * @param \StructType\ReturnAuthorizationSalesTeam[] $salesTeam
     * @param bool $replaceAll
     */
    public function __construct(array $salesTeam = array(), $replaceAll = true)
    {
        $this
            ->setSalesTeam($salesTeam)
            ->setReplaceAll($replaceAll);
    }
    /**
     * Get salesTeam value
     * @return \StructType\ReturnAuthorizationSalesTeam[]|null
     */
    public function getSalesTeam()
    {
        return $this->salesTeam;
    }
    /**
     * This method is responsible for validating the values passed to the setSalesTeam method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSalesTeam method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSalesTeamForArrayConstraintsFromSetSalesTeam(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $returnAuthorizationSalesTeamListSalesTeamItem) {
            // validation for constraint: itemType
            if (!$returnAuthorizationSalesTeamListSalesTeamItem instanceof \StructType\ReturnAuthorizationSalesTeam) {
                $invalidValues[] = is_object($returnAuthorizationSalesTeamListSalesTeamItem) ? get_class($returnAuthorizationSalesTeamListSalesTeamItem) : sprintf('%s(%s)', gettype($returnAuthorizationSalesTeamListSalesTeamItem), var_export($returnAuthorizationSalesTeamListSalesTeamItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The salesTeam property can only contain items of type \StructType\ReturnAuthorizationSalesTeam, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set salesTeam value
     * @throws \InvalidArgumentException
     * @param \StructType\ReturnAuthorizationSalesTeam[] $salesTeam
     * @return \StructType\ReturnAuthorizationSalesTeamList
     */
    public function setSalesTeam(array $salesTeam = array())
    {
        // validation for constraint: array
        if ('' !== ($salesTeamArrayErrorMessage = self::validateSalesTeamForArrayConstraintsFromSetSalesTeam($salesTeam))) {
            throw new \InvalidArgumentException($salesTeamArrayErrorMessage, __LINE__);
        }
        $this->salesTeam = $salesTeam;
        return $this;
    }
    /**
     * Add item to salesTeam value
     * @throws \InvalidArgumentException
     * @param \StructType\ReturnAuthorizationSalesTeam $item
     * @return \StructType\ReturnAuthorizationSalesTeamList
     */
    public function addToSalesTeam(\StructType\ReturnAuthorizationSalesTeam $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ReturnAuthorizationSalesTeam) {
            throw new \InvalidArgumentException(sprintf('The salesTeam property can only contain items of type \StructType\ReturnAuthorizationSalesTeam, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->salesTeam[] = $item;
        return $this;
    }
    /**
     * Get replaceAll value
     * @return bool|null
     */
    public function getReplaceAll()
    {
        return $this->replaceAll;
    }
    /**
     * Set replaceAll value
     * @param bool $replaceAll
     * @return \StructType\ReturnAuthorizationSalesTeamList
     */
    public function setReplaceAll($replaceAll = true)
    {
        // validation for constraint: boolean
        if (!is_null($replaceAll) && !is_bool($replaceAll)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($replaceAll, true), gettype($replaceAll)), __LINE__);
        }
        $this->replaceAll = $replaceAll;
        return $this;
    }
}
