<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ResourceAllocationSearchRowBasic StructType
 * @subpackage Structs
 */
class ResourceAllocationSearchRowBasic extends SearchRowBasic
{
    /**
     * The allocationType
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnSelectField[]
     */
    public $allocationType;
    /**
     * The allocationUnit
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnEnumSelectField[]
     */
    public $allocationUnit;
    /**
     * The approvalStatus
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnEnumSelectField[]
     */
    public $approvalStatus;
    /**
     * The project
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnSelectField[]
     */
    public $project;
    /**
     * The customer
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnSelectField[]
     */
    public $customer;
    /**
     * The endDate
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnDateField[]
     */
    public $endDate;
    /**
     * The externalId
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnSelectField[]
     */
    public $externalId;
    /**
     * The internalId
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnSelectField[]
     */
    public $internalId;
    /**
     * The nextApprover
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnSelectField[]
     */
    public $nextApprover;
    /**
     * The notes
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnStringField[]
     */
    public $notes;
    /**
     * The numberHours
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnDoubleField[]
     */
    public $numberHours;
    /**
     * The percentOfTime
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnDoubleField[]
     */
    public $percentOfTime;
    /**
     * The requestedBy
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnSelectField[]
     */
    public $requestedBy;
    /**
     * The resource
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnSelectField[]
     */
    public $resource;
    /**
     * The startDate
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnDateField[]
     */
    public $startDate;
    /**
     * The customFieldList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SearchColumnCustomFieldList
     */
    public $customFieldList;
    /**
     * Constructor method for ResourceAllocationSearchRowBasic
     * @uses ResourceAllocationSearchRowBasic::setAllocationType()
     * @uses ResourceAllocationSearchRowBasic::setAllocationUnit()
     * @uses ResourceAllocationSearchRowBasic::setApprovalStatus()
     * @uses ResourceAllocationSearchRowBasic::setProject()
     * @uses ResourceAllocationSearchRowBasic::setCustomer()
     * @uses ResourceAllocationSearchRowBasic::setEndDate()
     * @uses ResourceAllocationSearchRowBasic::setExternalId()
     * @uses ResourceAllocationSearchRowBasic::setInternalId()
     * @uses ResourceAllocationSearchRowBasic::setNextApprover()
     * @uses ResourceAllocationSearchRowBasic::setNotes()
     * @uses ResourceAllocationSearchRowBasic::setNumberHours()
     * @uses ResourceAllocationSearchRowBasic::setPercentOfTime()
     * @uses ResourceAllocationSearchRowBasic::setRequestedBy()
     * @uses ResourceAllocationSearchRowBasic::setResource()
     * @uses ResourceAllocationSearchRowBasic::setStartDate()
     * @uses ResourceAllocationSearchRowBasic::setCustomFieldList()
     * @param \StructType\SearchColumnSelectField[] $allocationType
     * @param \StructType\SearchColumnEnumSelectField[] $allocationUnit
     * @param \StructType\SearchColumnEnumSelectField[] $approvalStatus
     * @param \StructType\SearchColumnSelectField[] $project
     * @param \StructType\SearchColumnSelectField[] $customer
     * @param \StructType\SearchColumnDateField[] $endDate
     * @param \StructType\SearchColumnSelectField[] $externalId
     * @param \StructType\SearchColumnSelectField[] $internalId
     * @param \StructType\SearchColumnSelectField[] $nextApprover
     * @param \StructType\SearchColumnStringField[] $notes
     * @param \StructType\SearchColumnDoubleField[] $numberHours
     * @param \StructType\SearchColumnDoubleField[] $percentOfTime
     * @param \StructType\SearchColumnSelectField[] $requestedBy
     * @param \StructType\SearchColumnSelectField[] $resource
     * @param \StructType\SearchColumnDateField[] $startDate
     * @param \StructType\SearchColumnCustomFieldList $customFieldList
     */
    public function __construct(array $allocationType = array(), array $allocationUnit = array(), array $approvalStatus = array(), array $project = array(), array $customer = array(), array $endDate = array(), array $externalId = array(), array $internalId = array(), array $nextApprover = array(), array $notes = array(), array $numberHours = array(), array $percentOfTime = array(), array $requestedBy = array(), array $resource = array(), array $startDate = array(), \StructType\SearchColumnCustomFieldList $customFieldList = null)
    {
        $this
            ->setAllocationType($allocationType)
            ->setAllocationUnit($allocationUnit)
            ->setApprovalStatus($approvalStatus)
            ->setProject($project)
            ->setCustomer($customer)
            ->setEndDate($endDate)
            ->setExternalId($externalId)
            ->setInternalId($internalId)
            ->setNextApprover($nextApprover)
            ->setNotes($notes)
            ->setNumberHours($numberHours)
            ->setPercentOfTime($percentOfTime)
            ->setRequestedBy($requestedBy)
            ->setResource($resource)
            ->setStartDate($startDate)
            ->setCustomFieldList($customFieldList);
    }
    /**
     * Get allocationType value
     * @return \StructType\SearchColumnSelectField[]|null
     */
    public function getAllocationType()
    {
        return $this->allocationType;
    }
    /**
     * This method is responsible for validating the values passed to the setAllocationType method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAllocationType method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAllocationTypeForArrayConstraintsFromSetAllocationType(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $resourceAllocationSearchRowBasicAllocationTypeItem) {
            // validation for constraint: itemType
            if (!$resourceAllocationSearchRowBasicAllocationTypeItem instanceof \StructType\SearchColumnSelectField) {
                $invalidValues[] = is_object($resourceAllocationSearchRowBasicAllocationTypeItem) ? get_class($resourceAllocationSearchRowBasicAllocationTypeItem) : sprintf('%s(%s)', gettype($resourceAllocationSearchRowBasicAllocationTypeItem), var_export($resourceAllocationSearchRowBasicAllocationTypeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The allocationType property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set allocationType value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField[] $allocationType
     * @return \StructType\ResourceAllocationSearchRowBasic
     */
    public function setAllocationType(array $allocationType = array())
    {
        // validation for constraint: array
        if ('' !== ($allocationTypeArrayErrorMessage = self::validateAllocationTypeForArrayConstraintsFromSetAllocationType($allocationType))) {
            throw new \InvalidArgumentException($allocationTypeArrayErrorMessage, __LINE__);
        }
        $this->allocationType = $allocationType;
        return $this;
    }
    /**
     * Add item to allocationType value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField $item
     * @return \StructType\ResourceAllocationSearchRowBasic
     */
    public function addToAllocationType(\StructType\SearchColumnSelectField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnSelectField) {
            throw new \InvalidArgumentException(sprintf('The allocationType property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->allocationType[] = $item;
        return $this;
    }
    /**
     * Get allocationUnit value
     * @return \StructType\SearchColumnEnumSelectField[]|null
     */
    public function getAllocationUnit()
    {
        return $this->allocationUnit;
    }
    /**
     * This method is responsible for validating the values passed to the setAllocationUnit method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAllocationUnit method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAllocationUnitForArrayConstraintsFromSetAllocationUnit(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $resourceAllocationSearchRowBasicAllocationUnitItem) {
            // validation for constraint: itemType
            if (!$resourceAllocationSearchRowBasicAllocationUnitItem instanceof \StructType\SearchColumnEnumSelectField) {
                $invalidValues[] = is_object($resourceAllocationSearchRowBasicAllocationUnitItem) ? get_class($resourceAllocationSearchRowBasicAllocationUnitItem) : sprintf('%s(%s)', gettype($resourceAllocationSearchRowBasicAllocationUnitItem), var_export($resourceAllocationSearchRowBasicAllocationUnitItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The allocationUnit property can only contain items of type \StructType\SearchColumnEnumSelectField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set allocationUnit value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnEnumSelectField[] $allocationUnit
     * @return \StructType\ResourceAllocationSearchRowBasic
     */
    public function setAllocationUnit(array $allocationUnit = array())
    {
        // validation for constraint: array
        if ('' !== ($allocationUnitArrayErrorMessage = self::validateAllocationUnitForArrayConstraintsFromSetAllocationUnit($allocationUnit))) {
            throw new \InvalidArgumentException($allocationUnitArrayErrorMessage, __LINE__);
        }
        $this->allocationUnit = $allocationUnit;
        return $this;
    }
    /**
     * Add item to allocationUnit value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnEnumSelectField $item
     * @return \StructType\ResourceAllocationSearchRowBasic
     */
    public function addToAllocationUnit(\StructType\SearchColumnEnumSelectField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnEnumSelectField) {
            throw new \InvalidArgumentException(sprintf('The allocationUnit property can only contain items of type \StructType\SearchColumnEnumSelectField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->allocationUnit[] = $item;
        return $this;
    }
    /**
     * Get approvalStatus value
     * @return \StructType\SearchColumnEnumSelectField[]|null
     */
    public function getApprovalStatus()
    {
        return $this->approvalStatus;
    }
    /**
     * This method is responsible for validating the values passed to the setApprovalStatus method
     * This method is willingly generated in order to preserve the one-line inline validation within the setApprovalStatus method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateApprovalStatusForArrayConstraintsFromSetApprovalStatus(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $resourceAllocationSearchRowBasicApprovalStatusItem) {
            // validation for constraint: itemType
            if (!$resourceAllocationSearchRowBasicApprovalStatusItem instanceof \StructType\SearchColumnEnumSelectField) {
                $invalidValues[] = is_object($resourceAllocationSearchRowBasicApprovalStatusItem) ? get_class($resourceAllocationSearchRowBasicApprovalStatusItem) : sprintf('%s(%s)', gettype($resourceAllocationSearchRowBasicApprovalStatusItem), var_export($resourceAllocationSearchRowBasicApprovalStatusItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The approvalStatus property can only contain items of type \StructType\SearchColumnEnumSelectField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set approvalStatus value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnEnumSelectField[] $approvalStatus
     * @return \StructType\ResourceAllocationSearchRowBasic
     */
    public function setApprovalStatus(array $approvalStatus = array())
    {
        // validation for constraint: array
        if ('' !== ($approvalStatusArrayErrorMessage = self::validateApprovalStatusForArrayConstraintsFromSetApprovalStatus($approvalStatus))) {
            throw new \InvalidArgumentException($approvalStatusArrayErrorMessage, __LINE__);
        }
        $this->approvalStatus = $approvalStatus;
        return $this;
    }
    /**
     * Add item to approvalStatus value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnEnumSelectField $item
     * @return \StructType\ResourceAllocationSearchRowBasic
     */
    public function addToApprovalStatus(\StructType\SearchColumnEnumSelectField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnEnumSelectField) {
            throw new \InvalidArgumentException(sprintf('The approvalStatus property can only contain items of type \StructType\SearchColumnEnumSelectField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->approvalStatus[] = $item;
        return $this;
    }
    /**
     * Get project value
     * @return \StructType\SearchColumnSelectField[]|null
     */
    public function getProject()
    {
        return $this->project;
    }
    /**
     * This method is responsible for validating the values passed to the setProject method
     * This method is willingly generated in order to preserve the one-line inline validation within the setProject method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateProjectForArrayConstraintsFromSetProject(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $resourceAllocationSearchRowBasicProjectItem) {
            // validation for constraint: itemType
            if (!$resourceAllocationSearchRowBasicProjectItem instanceof \StructType\SearchColumnSelectField) {
                $invalidValues[] = is_object($resourceAllocationSearchRowBasicProjectItem) ? get_class($resourceAllocationSearchRowBasicProjectItem) : sprintf('%s(%s)', gettype($resourceAllocationSearchRowBasicProjectItem), var_export($resourceAllocationSearchRowBasicProjectItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The project property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set project value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField[] $project
     * @return \StructType\ResourceAllocationSearchRowBasic
     */
    public function setProject(array $project = array())
    {
        // validation for constraint: array
        if ('' !== ($projectArrayErrorMessage = self::validateProjectForArrayConstraintsFromSetProject($project))) {
            throw new \InvalidArgumentException($projectArrayErrorMessage, __LINE__);
        }
        $this->project = $project;
        return $this;
    }
    /**
     * Add item to project value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField $item
     * @return \StructType\ResourceAllocationSearchRowBasic
     */
    public function addToProject(\StructType\SearchColumnSelectField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnSelectField) {
            throw new \InvalidArgumentException(sprintf('The project property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->project[] = $item;
        return $this;
    }
    /**
     * Get customer value
     * @return \StructType\SearchColumnSelectField[]|null
     */
    public function getCustomer()
    {
        return $this->customer;
    }
    /**
     * This method is responsible for validating the values passed to the setCustomer method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCustomer method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCustomerForArrayConstraintsFromSetCustomer(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $resourceAllocationSearchRowBasicCustomerItem) {
            // validation for constraint: itemType
            if (!$resourceAllocationSearchRowBasicCustomerItem instanceof \StructType\SearchColumnSelectField) {
                $invalidValues[] = is_object($resourceAllocationSearchRowBasicCustomerItem) ? get_class($resourceAllocationSearchRowBasicCustomerItem) : sprintf('%s(%s)', gettype($resourceAllocationSearchRowBasicCustomerItem), var_export($resourceAllocationSearchRowBasicCustomerItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The customer property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set customer value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField[] $customer
     * @return \StructType\ResourceAllocationSearchRowBasic
     */
    public function setCustomer(array $customer = array())
    {
        // validation for constraint: array
        if ('' !== ($customerArrayErrorMessage = self::validateCustomerForArrayConstraintsFromSetCustomer($customer))) {
            throw new \InvalidArgumentException($customerArrayErrorMessage, __LINE__);
        }
        $this->customer = $customer;
        return $this;
    }
    /**
     * Add item to customer value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField $item
     * @return \StructType\ResourceAllocationSearchRowBasic
     */
    public function addToCustomer(\StructType\SearchColumnSelectField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnSelectField) {
            throw new \InvalidArgumentException(sprintf('The customer property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->customer[] = $item;
        return $this;
    }
    /**
     * Get endDate value
     * @return \StructType\SearchColumnDateField[]|null
     */
    public function getEndDate()
    {
        return $this->endDate;
    }
    /**
     * This method is responsible for validating the values passed to the setEndDate method
     * This method is willingly generated in order to preserve the one-line inline validation within the setEndDate method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateEndDateForArrayConstraintsFromSetEndDate(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $resourceAllocationSearchRowBasicEndDateItem) {
            // validation for constraint: itemType
            if (!$resourceAllocationSearchRowBasicEndDateItem instanceof \StructType\SearchColumnDateField) {
                $invalidValues[] = is_object($resourceAllocationSearchRowBasicEndDateItem) ? get_class($resourceAllocationSearchRowBasicEndDateItem) : sprintf('%s(%s)', gettype($resourceAllocationSearchRowBasicEndDateItem), var_export($resourceAllocationSearchRowBasicEndDateItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The endDate property can only contain items of type \StructType\SearchColumnDateField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set endDate value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDateField[] $endDate
     * @return \StructType\ResourceAllocationSearchRowBasic
     */
    public function setEndDate(array $endDate = array())
    {
        // validation for constraint: array
        if ('' !== ($endDateArrayErrorMessage = self::validateEndDateForArrayConstraintsFromSetEndDate($endDate))) {
            throw new \InvalidArgumentException($endDateArrayErrorMessage, __LINE__);
        }
        $this->endDate = $endDate;
        return $this;
    }
    /**
     * Add item to endDate value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDateField $item
     * @return \StructType\ResourceAllocationSearchRowBasic
     */
    public function addToEndDate(\StructType\SearchColumnDateField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnDateField) {
            throw new \InvalidArgumentException(sprintf('The endDate property can only contain items of type \StructType\SearchColumnDateField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->endDate[] = $item;
        return $this;
    }
    /**
     * Get externalId value
     * @return \StructType\SearchColumnSelectField[]|null
     */
    public function getExternalId()
    {
        return $this->externalId;
    }
    /**
     * This method is responsible for validating the values passed to the setExternalId method
     * This method is willingly generated in order to preserve the one-line inline validation within the setExternalId method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateExternalIdForArrayConstraintsFromSetExternalId(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $resourceAllocationSearchRowBasicExternalIdItem) {
            // validation for constraint: itemType
            if (!$resourceAllocationSearchRowBasicExternalIdItem instanceof \StructType\SearchColumnSelectField) {
                $invalidValues[] = is_object($resourceAllocationSearchRowBasicExternalIdItem) ? get_class($resourceAllocationSearchRowBasicExternalIdItem) : sprintf('%s(%s)', gettype($resourceAllocationSearchRowBasicExternalIdItem), var_export($resourceAllocationSearchRowBasicExternalIdItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The externalId property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set externalId value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField[] $externalId
     * @return \StructType\ResourceAllocationSearchRowBasic
     */
    public function setExternalId(array $externalId = array())
    {
        // validation for constraint: array
        if ('' !== ($externalIdArrayErrorMessage = self::validateExternalIdForArrayConstraintsFromSetExternalId($externalId))) {
            throw new \InvalidArgumentException($externalIdArrayErrorMessage, __LINE__);
        }
        $this->externalId = $externalId;
        return $this;
    }
    /**
     * Add item to externalId value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField $item
     * @return \StructType\ResourceAllocationSearchRowBasic
     */
    public function addToExternalId(\StructType\SearchColumnSelectField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnSelectField) {
            throw new \InvalidArgumentException(sprintf('The externalId property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->externalId[] = $item;
        return $this;
    }
    /**
     * Get internalId value
     * @return \StructType\SearchColumnSelectField[]|null
     */
    public function getInternalId()
    {
        return $this->internalId;
    }
    /**
     * This method is responsible for validating the values passed to the setInternalId method
     * This method is willingly generated in order to preserve the one-line inline validation within the setInternalId method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateInternalIdForArrayConstraintsFromSetInternalId(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $resourceAllocationSearchRowBasicInternalIdItem) {
            // validation for constraint: itemType
            if (!$resourceAllocationSearchRowBasicInternalIdItem instanceof \StructType\SearchColumnSelectField) {
                $invalidValues[] = is_object($resourceAllocationSearchRowBasicInternalIdItem) ? get_class($resourceAllocationSearchRowBasicInternalIdItem) : sprintf('%s(%s)', gettype($resourceAllocationSearchRowBasicInternalIdItem), var_export($resourceAllocationSearchRowBasicInternalIdItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The internalId property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set internalId value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField[] $internalId
     * @return \StructType\ResourceAllocationSearchRowBasic
     */
    public function setInternalId(array $internalId = array())
    {
        // validation for constraint: array
        if ('' !== ($internalIdArrayErrorMessage = self::validateInternalIdForArrayConstraintsFromSetInternalId($internalId))) {
            throw new \InvalidArgumentException($internalIdArrayErrorMessage, __LINE__);
        }
        $this->internalId = $internalId;
        return $this;
    }
    /**
     * Add item to internalId value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField $item
     * @return \StructType\ResourceAllocationSearchRowBasic
     */
    public function addToInternalId(\StructType\SearchColumnSelectField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnSelectField) {
            throw new \InvalidArgumentException(sprintf('The internalId property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->internalId[] = $item;
        return $this;
    }
    /**
     * Get nextApprover value
     * @return \StructType\SearchColumnSelectField[]|null
     */
    public function getNextApprover()
    {
        return $this->nextApprover;
    }
    /**
     * This method is responsible for validating the values passed to the setNextApprover method
     * This method is willingly generated in order to preserve the one-line inline validation within the setNextApprover method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateNextApproverForArrayConstraintsFromSetNextApprover(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $resourceAllocationSearchRowBasicNextApproverItem) {
            // validation for constraint: itemType
            if (!$resourceAllocationSearchRowBasicNextApproverItem instanceof \StructType\SearchColumnSelectField) {
                $invalidValues[] = is_object($resourceAllocationSearchRowBasicNextApproverItem) ? get_class($resourceAllocationSearchRowBasicNextApproverItem) : sprintf('%s(%s)', gettype($resourceAllocationSearchRowBasicNextApproverItem), var_export($resourceAllocationSearchRowBasicNextApproverItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The nextApprover property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set nextApprover value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField[] $nextApprover
     * @return \StructType\ResourceAllocationSearchRowBasic
     */
    public function setNextApprover(array $nextApprover = array())
    {
        // validation for constraint: array
        if ('' !== ($nextApproverArrayErrorMessage = self::validateNextApproverForArrayConstraintsFromSetNextApprover($nextApprover))) {
            throw new \InvalidArgumentException($nextApproverArrayErrorMessage, __LINE__);
        }
        $this->nextApprover = $nextApprover;
        return $this;
    }
    /**
     * Add item to nextApprover value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField $item
     * @return \StructType\ResourceAllocationSearchRowBasic
     */
    public function addToNextApprover(\StructType\SearchColumnSelectField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnSelectField) {
            throw new \InvalidArgumentException(sprintf('The nextApprover property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->nextApprover[] = $item;
        return $this;
    }
    /**
     * Get notes value
     * @return \StructType\SearchColumnStringField[]|null
     */
    public function getNotes()
    {
        return $this->notes;
    }
    /**
     * This method is responsible for validating the values passed to the setNotes method
     * This method is willingly generated in order to preserve the one-line inline validation within the setNotes method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateNotesForArrayConstraintsFromSetNotes(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $resourceAllocationSearchRowBasicNotesItem) {
            // validation for constraint: itemType
            if (!$resourceAllocationSearchRowBasicNotesItem instanceof \StructType\SearchColumnStringField) {
                $invalidValues[] = is_object($resourceAllocationSearchRowBasicNotesItem) ? get_class($resourceAllocationSearchRowBasicNotesItem) : sprintf('%s(%s)', gettype($resourceAllocationSearchRowBasicNotesItem), var_export($resourceAllocationSearchRowBasicNotesItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The notes property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set notes value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField[] $notes
     * @return \StructType\ResourceAllocationSearchRowBasic
     */
    public function setNotes(array $notes = array())
    {
        // validation for constraint: array
        if ('' !== ($notesArrayErrorMessage = self::validateNotesForArrayConstraintsFromSetNotes($notes))) {
            throw new \InvalidArgumentException($notesArrayErrorMessage, __LINE__);
        }
        $this->notes = $notes;
        return $this;
    }
    /**
     * Add item to notes value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField $item
     * @return \StructType\ResourceAllocationSearchRowBasic
     */
    public function addToNotes(\StructType\SearchColumnStringField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnStringField) {
            throw new \InvalidArgumentException(sprintf('The notes property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->notes[] = $item;
        return $this;
    }
    /**
     * Get numberHours value
     * @return \StructType\SearchColumnDoubleField[]|null
     */
    public function getNumberHours()
    {
        return $this->numberHours;
    }
    /**
     * This method is responsible for validating the values passed to the setNumberHours method
     * This method is willingly generated in order to preserve the one-line inline validation within the setNumberHours method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateNumberHoursForArrayConstraintsFromSetNumberHours(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $resourceAllocationSearchRowBasicNumberHoursItem) {
            // validation for constraint: itemType
            if (!$resourceAllocationSearchRowBasicNumberHoursItem instanceof \StructType\SearchColumnDoubleField) {
                $invalidValues[] = is_object($resourceAllocationSearchRowBasicNumberHoursItem) ? get_class($resourceAllocationSearchRowBasicNumberHoursItem) : sprintf('%s(%s)', gettype($resourceAllocationSearchRowBasicNumberHoursItem), var_export($resourceAllocationSearchRowBasicNumberHoursItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The numberHours property can only contain items of type \StructType\SearchColumnDoubleField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set numberHours value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDoubleField[] $numberHours
     * @return \StructType\ResourceAllocationSearchRowBasic
     */
    public function setNumberHours(array $numberHours = array())
    {
        // validation for constraint: array
        if ('' !== ($numberHoursArrayErrorMessage = self::validateNumberHoursForArrayConstraintsFromSetNumberHours($numberHours))) {
            throw new \InvalidArgumentException($numberHoursArrayErrorMessage, __LINE__);
        }
        $this->numberHours = $numberHours;
        return $this;
    }
    /**
     * Add item to numberHours value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDoubleField $item
     * @return \StructType\ResourceAllocationSearchRowBasic
     */
    public function addToNumberHours(\StructType\SearchColumnDoubleField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnDoubleField) {
            throw new \InvalidArgumentException(sprintf('The numberHours property can only contain items of type \StructType\SearchColumnDoubleField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->numberHours[] = $item;
        return $this;
    }
    /**
     * Get percentOfTime value
     * @return \StructType\SearchColumnDoubleField[]|null
     */
    public function getPercentOfTime()
    {
        return $this->percentOfTime;
    }
    /**
     * This method is responsible for validating the values passed to the setPercentOfTime method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPercentOfTime method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePercentOfTimeForArrayConstraintsFromSetPercentOfTime(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $resourceAllocationSearchRowBasicPercentOfTimeItem) {
            // validation for constraint: itemType
            if (!$resourceAllocationSearchRowBasicPercentOfTimeItem instanceof \StructType\SearchColumnDoubleField) {
                $invalidValues[] = is_object($resourceAllocationSearchRowBasicPercentOfTimeItem) ? get_class($resourceAllocationSearchRowBasicPercentOfTimeItem) : sprintf('%s(%s)', gettype($resourceAllocationSearchRowBasicPercentOfTimeItem), var_export($resourceAllocationSearchRowBasicPercentOfTimeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The percentOfTime property can only contain items of type \StructType\SearchColumnDoubleField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set percentOfTime value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDoubleField[] $percentOfTime
     * @return \StructType\ResourceAllocationSearchRowBasic
     */
    public function setPercentOfTime(array $percentOfTime = array())
    {
        // validation for constraint: array
        if ('' !== ($percentOfTimeArrayErrorMessage = self::validatePercentOfTimeForArrayConstraintsFromSetPercentOfTime($percentOfTime))) {
            throw new \InvalidArgumentException($percentOfTimeArrayErrorMessage, __LINE__);
        }
        $this->percentOfTime = $percentOfTime;
        return $this;
    }
    /**
     * Add item to percentOfTime value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDoubleField $item
     * @return \StructType\ResourceAllocationSearchRowBasic
     */
    public function addToPercentOfTime(\StructType\SearchColumnDoubleField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnDoubleField) {
            throw new \InvalidArgumentException(sprintf('The percentOfTime property can only contain items of type \StructType\SearchColumnDoubleField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->percentOfTime[] = $item;
        return $this;
    }
    /**
     * Get requestedBy value
     * @return \StructType\SearchColumnSelectField[]|null
     */
    public function getRequestedBy()
    {
        return $this->requestedBy;
    }
    /**
     * This method is responsible for validating the values passed to the setRequestedBy method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRequestedBy method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRequestedByForArrayConstraintsFromSetRequestedBy(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $resourceAllocationSearchRowBasicRequestedByItem) {
            // validation for constraint: itemType
            if (!$resourceAllocationSearchRowBasicRequestedByItem instanceof \StructType\SearchColumnSelectField) {
                $invalidValues[] = is_object($resourceAllocationSearchRowBasicRequestedByItem) ? get_class($resourceAllocationSearchRowBasicRequestedByItem) : sprintf('%s(%s)', gettype($resourceAllocationSearchRowBasicRequestedByItem), var_export($resourceAllocationSearchRowBasicRequestedByItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The requestedBy property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set requestedBy value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField[] $requestedBy
     * @return \StructType\ResourceAllocationSearchRowBasic
     */
    public function setRequestedBy(array $requestedBy = array())
    {
        // validation for constraint: array
        if ('' !== ($requestedByArrayErrorMessage = self::validateRequestedByForArrayConstraintsFromSetRequestedBy($requestedBy))) {
            throw new \InvalidArgumentException($requestedByArrayErrorMessage, __LINE__);
        }
        $this->requestedBy = $requestedBy;
        return $this;
    }
    /**
     * Add item to requestedBy value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField $item
     * @return \StructType\ResourceAllocationSearchRowBasic
     */
    public function addToRequestedBy(\StructType\SearchColumnSelectField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnSelectField) {
            throw new \InvalidArgumentException(sprintf('The requestedBy property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->requestedBy[] = $item;
        return $this;
    }
    /**
     * Get resource value
     * @return \StructType\SearchColumnSelectField[]|null
     */
    public function getResource()
    {
        return $this->resource;
    }
    /**
     * This method is responsible for validating the values passed to the setResource method
     * This method is willingly generated in order to preserve the one-line inline validation within the setResource method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateResourceForArrayConstraintsFromSetResource(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $resourceAllocationSearchRowBasicResourceItem) {
            // validation for constraint: itemType
            if (!$resourceAllocationSearchRowBasicResourceItem instanceof \StructType\SearchColumnSelectField) {
                $invalidValues[] = is_object($resourceAllocationSearchRowBasicResourceItem) ? get_class($resourceAllocationSearchRowBasicResourceItem) : sprintf('%s(%s)', gettype($resourceAllocationSearchRowBasicResourceItem), var_export($resourceAllocationSearchRowBasicResourceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The resource property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set resource value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField[] $resource
     * @return \StructType\ResourceAllocationSearchRowBasic
     */
    public function setResource(array $resource = array())
    {
        // validation for constraint: array
        if ('' !== ($resourceArrayErrorMessage = self::validateResourceForArrayConstraintsFromSetResource($resource))) {
            throw new \InvalidArgumentException($resourceArrayErrorMessage, __LINE__);
        }
        $this->resource = $resource;
        return $this;
    }
    /**
     * Add item to resource value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField $item
     * @return \StructType\ResourceAllocationSearchRowBasic
     */
    public function addToResource(\StructType\SearchColumnSelectField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnSelectField) {
            throw new \InvalidArgumentException(sprintf('The resource property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->resource[] = $item;
        return $this;
    }
    /**
     * Get startDate value
     * @return \StructType\SearchColumnDateField[]|null
     */
    public function getStartDate()
    {
        return $this->startDate;
    }
    /**
     * This method is responsible for validating the values passed to the setStartDate method
     * This method is willingly generated in order to preserve the one-line inline validation within the setStartDate method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateStartDateForArrayConstraintsFromSetStartDate(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $resourceAllocationSearchRowBasicStartDateItem) {
            // validation for constraint: itemType
            if (!$resourceAllocationSearchRowBasicStartDateItem instanceof \StructType\SearchColumnDateField) {
                $invalidValues[] = is_object($resourceAllocationSearchRowBasicStartDateItem) ? get_class($resourceAllocationSearchRowBasicStartDateItem) : sprintf('%s(%s)', gettype($resourceAllocationSearchRowBasicStartDateItem), var_export($resourceAllocationSearchRowBasicStartDateItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The startDate property can only contain items of type \StructType\SearchColumnDateField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set startDate value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDateField[] $startDate
     * @return \StructType\ResourceAllocationSearchRowBasic
     */
    public function setStartDate(array $startDate = array())
    {
        // validation for constraint: array
        if ('' !== ($startDateArrayErrorMessage = self::validateStartDateForArrayConstraintsFromSetStartDate($startDate))) {
            throw new \InvalidArgumentException($startDateArrayErrorMessage, __LINE__);
        }
        $this->startDate = $startDate;
        return $this;
    }
    /**
     * Add item to startDate value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDateField $item
     * @return \StructType\ResourceAllocationSearchRowBasic
     */
    public function addToStartDate(\StructType\SearchColumnDateField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnDateField) {
            throw new \InvalidArgumentException(sprintf('The startDate property can only contain items of type \StructType\SearchColumnDateField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->startDate[] = $item;
        return $this;
    }
    /**
     * Get customFieldList value
     * @return \StructType\SearchColumnCustomFieldList|null
     */
    public function getCustomFieldList()
    {
        return $this->customFieldList;
    }
    /**
     * Set customFieldList value
     * @param \StructType\SearchColumnCustomFieldList $customFieldList
     * @return \StructType\ResourceAllocationSearchRowBasic
     */
    public function setCustomFieldList(\StructType\SearchColumnCustomFieldList $customFieldList = null)
    {
        $this->customFieldList = $customFieldList;
        return $this;
    }
}
