<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RecordRef StructType
 * @subpackage Structs
 */
class RecordRef extends BaseRef
{
    /**
     * The internalId
     * @var string
     */
    public $internalId;
    /**
     * The externalId
     * @var string
     */
    public $externalId;
    /**
     * The type
     * @var string
     */
    public $type;
    /**
     * Constructor method for RecordRef
     * @uses RecordRef::setInternalId()
     * @uses RecordRef::setExternalId()
     * @uses RecordRef::setType()
     * @param string $internalId
     * @param string $externalId
     * @param string $type
     */
    public function __construct($internalId = null, $externalId = null, $type = null)
    {
        $this
            ->setInternalId($internalId)
            ->setExternalId($externalId)
            ->setType($type);
    }
    /**
     * Get internalId value
     * @return string|null
     */
    public function getInternalId()
    {
        return $this->internalId;
    }
    /**
     * Set internalId value
     * @param string $internalId
     * @return \StructType\RecordRef
     */
    public function setInternalId($internalId = null)
    {
        // validation for constraint: string
        if (!is_null($internalId) && !is_string($internalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($internalId, true), gettype($internalId)), __LINE__);
        }
        $this->internalId = $internalId;
        return $this;
    }
    /**
     * Get externalId value
     * @return string|null
     */
    public function getExternalId()
    {
        return $this->externalId;
    }
    /**
     * Set externalId value
     * @param string $externalId
     * @return \StructType\RecordRef
     */
    public function setExternalId($externalId = null)
    {
        // validation for constraint: string
        if (!is_null($externalId) && !is_string($externalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($externalId, true), gettype($externalId)), __LINE__);
        }
        $this->externalId = $externalId;
        return $this;
    }
    /**
     * Get type value
     * @return string|null
     */
    public function getType()
    {
        return $this->type;
    }
    /**
     * Set type value
     * @uses \EnumType\RecordType::valueIsValid()
     * @uses \EnumType\RecordType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $type
     * @return \StructType\RecordRef
     */
    public function setType($type = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\RecordType::valueIsValid($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\RecordType', is_array($type) ? implode(', ', $type) : var_export($type, true), implode(', ', \EnumType\RecordType::getValidValues())), __LINE__);
        }
        $this->type = $type;
        return $this;
    }
}
