<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PurchaseRequisitionExpense StructType
 * @subpackage Structs
 */
class PurchaseRequisitionExpense extends AbstractStructBase
{
    /**
     * The line
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $line;
    /**
     * The category
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $category;
    /**
     * The location
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $location;
    /**
     * The isClosed
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $isClosed;
    /**
     * The account
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $account;
    /**
     * The poVendor
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $poVendor;
    /**
     * The estimatedAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $estimatedAmount;
    /**
     * The amount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $amount;
    /**
     * The memo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $memo;
    /**
     * The department
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $department;
    /**
     * The class
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $class;
    /**
     * The customer
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $customer;
    /**
     * The linkedOrderList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRefList
     */
    public $linkedOrderList;
    /**
     * The linkedOrderStatus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $linkedOrderStatus;
    /**
     * The isBillable
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $isBillable;
    /**
     * Constructor method for PurchaseRequisitionExpense
     * @uses PurchaseRequisitionExpense::setLine()
     * @uses PurchaseRequisitionExpense::setCategory()
     * @uses PurchaseRequisitionExpense::setLocation()
     * @uses PurchaseRequisitionExpense::setIsClosed()
     * @uses PurchaseRequisitionExpense::setAccount()
     * @uses PurchaseRequisitionExpense::setPoVendor()
     * @uses PurchaseRequisitionExpense::setEstimatedAmount()
     * @uses PurchaseRequisitionExpense::setAmount()
     * @uses PurchaseRequisitionExpense::setMemo()
     * @uses PurchaseRequisitionExpense::setDepartment()
     * @uses PurchaseRequisitionExpense::setClass()
     * @uses PurchaseRequisitionExpense::setCustomer()
     * @uses PurchaseRequisitionExpense::setLinkedOrderList()
     * @uses PurchaseRequisitionExpense::setLinkedOrderStatus()
     * @uses PurchaseRequisitionExpense::setIsBillable()
     * @param int $line
     * @param \StructType\RecordRef $category
     * @param \StructType\RecordRef $location
     * @param bool $isClosed
     * @param \StructType\RecordRef $account
     * @param \StructType\RecordRef $poVendor
     * @param float $estimatedAmount
     * @param float $amount
     * @param string $memo
     * @param \StructType\RecordRef $department
     * @param \StructType\RecordRef $class
     * @param \StructType\RecordRef $customer
     * @param \StructType\RecordRefList $linkedOrderList
     * @param string $linkedOrderStatus
     * @param bool $isBillable
     */
    public function __construct($line = null, \StructType\RecordRef $category = null, \StructType\RecordRef $location = null, $isClosed = null, \StructType\RecordRef $account = null, \StructType\RecordRef $poVendor = null, $estimatedAmount = null, $amount = null, $memo = null, \StructType\RecordRef $department = null, \StructType\RecordRef $class = null, \StructType\RecordRef $customer = null, \StructType\RecordRefList $linkedOrderList = null, $linkedOrderStatus = null, $isBillable = null)
    {
        $this
            ->setLine($line)
            ->setCategory($category)
            ->setLocation($location)
            ->setIsClosed($isClosed)
            ->setAccount($account)
            ->setPoVendor($poVendor)
            ->setEstimatedAmount($estimatedAmount)
            ->setAmount($amount)
            ->setMemo($memo)
            ->setDepartment($department)
            ->setClass($class)
            ->setCustomer($customer)
            ->setLinkedOrderList($linkedOrderList)
            ->setLinkedOrderStatus($linkedOrderStatus)
            ->setIsBillable($isBillable);
    }
    /**
     * Get line value
     * @return int|null
     */
    public function getLine()
    {
        return $this->line;
    }
    /**
     * Set line value
     * @param int $line
     * @return \StructType\PurchaseRequisitionExpense
     */
    public function setLine($line = null)
    {
        // validation for constraint: int
        if (!is_null($line) && !(is_int($line) || ctype_digit($line))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($line, true), gettype($line)), __LINE__);
        }
        $this->line = $line;
        return $this;
    }
    /**
     * Get category value
     * @return \StructType\RecordRef|null
     */
    public function getCategory()
    {
        return $this->category;
    }
    /**
     * Set category value
     * @param \StructType\RecordRef $category
     * @return \StructType\PurchaseRequisitionExpense
     */
    public function setCategory(\StructType\RecordRef $category = null)
    {
        $this->category = $category;
        return $this;
    }
    /**
     * Get location value
     * @return \StructType\RecordRef|null
     */
    public function getLocation()
    {
        return $this->location;
    }
    /**
     * Set location value
     * @param \StructType\RecordRef $location
     * @return \StructType\PurchaseRequisitionExpense
     */
    public function setLocation(\StructType\RecordRef $location = null)
    {
        $this->location = $location;
        return $this;
    }
    /**
     * Get isClosed value
     * @return bool|null
     */
    public function getIsClosed()
    {
        return $this->isClosed;
    }
    /**
     * Set isClosed value
     * @param bool $isClosed
     * @return \StructType\PurchaseRequisitionExpense
     */
    public function setIsClosed($isClosed = null)
    {
        // validation for constraint: boolean
        if (!is_null($isClosed) && !is_bool($isClosed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isClosed, true), gettype($isClosed)), __LINE__);
        }
        $this->isClosed = $isClosed;
        return $this;
    }
    /**
     * Get account value
     * @return \StructType\RecordRef|null
     */
    public function getAccount()
    {
        return $this->account;
    }
    /**
     * Set account value
     * @param \StructType\RecordRef $account
     * @return \StructType\PurchaseRequisitionExpense
     */
    public function setAccount(\StructType\RecordRef $account = null)
    {
        $this->account = $account;
        return $this;
    }
    /**
     * Get poVendor value
     * @return \StructType\RecordRef|null
     */
    public function getPoVendor()
    {
        return $this->poVendor;
    }
    /**
     * Set poVendor value
     * @param \StructType\RecordRef $poVendor
     * @return \StructType\PurchaseRequisitionExpense
     */
    public function setPoVendor(\StructType\RecordRef $poVendor = null)
    {
        $this->poVendor = $poVendor;
        return $this;
    }
    /**
     * Get estimatedAmount value
     * @return float|null
     */
    public function getEstimatedAmount()
    {
        return $this->estimatedAmount;
    }
    /**
     * Set estimatedAmount value
     * @param float $estimatedAmount
     * @return \StructType\PurchaseRequisitionExpense
     */
    public function setEstimatedAmount($estimatedAmount = null)
    {
        // validation for constraint: float
        if (!is_null($estimatedAmount) && !(is_float($estimatedAmount) || is_numeric($estimatedAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($estimatedAmount, true), gettype($estimatedAmount)), __LINE__);
        }
        $this->estimatedAmount = $estimatedAmount;
        return $this;
    }
    /**
     * Get amount value
     * @return float|null
     */
    public function getAmount()
    {
        return $this->amount;
    }
    /**
     * Set amount value
     * @param float $amount
     * @return \StructType\PurchaseRequisitionExpense
     */
    public function setAmount($amount = null)
    {
        // validation for constraint: float
        if (!is_null($amount) && !(is_float($amount) || is_numeric($amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($amount, true), gettype($amount)), __LINE__);
        }
        $this->amount = $amount;
        return $this;
    }
    /**
     * Get memo value
     * @return string|null
     */
    public function getMemo()
    {
        return $this->memo;
    }
    /**
     * Set memo value
     * @param string $memo
     * @return \StructType\PurchaseRequisitionExpense
     */
    public function setMemo($memo = null)
    {
        // validation for constraint: string
        if (!is_null($memo) && !is_string($memo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($memo, true), gettype($memo)), __LINE__);
        }
        $this->memo = $memo;
        return $this;
    }
    /**
     * Get department value
     * @return \StructType\RecordRef|null
     */
    public function getDepartment()
    {
        return $this->department;
    }
    /**
     * Set department value
     * @param \StructType\RecordRef $department
     * @return \StructType\PurchaseRequisitionExpense
     */
    public function setDepartment(\StructType\RecordRef $department = null)
    {
        $this->department = $department;
        return $this;
    }
    /**
     * Get class value
     * @return \StructType\RecordRef|null
     */
    public function getClass()
    {
        return $this->class;
    }
    /**
     * Set class value
     * @param \StructType\RecordRef $class
     * @return \StructType\PurchaseRequisitionExpense
     */
    public function setClass(\StructType\RecordRef $class = null)
    {
        $this->class = $class;
        return $this;
    }
    /**
     * Get customer value
     * @return \StructType\RecordRef|null
     */
    public function getCustomer()
    {
        return $this->customer;
    }
    /**
     * Set customer value
     * @param \StructType\RecordRef $customer
     * @return \StructType\PurchaseRequisitionExpense
     */
    public function setCustomer(\StructType\RecordRef $customer = null)
    {
        $this->customer = $customer;
        return $this;
    }
    /**
     * Get linkedOrderList value
     * @return \StructType\RecordRefList|null
     */
    public function getLinkedOrderList()
    {
        return $this->linkedOrderList;
    }
    /**
     * Set linkedOrderList value
     * @param \StructType\RecordRefList $linkedOrderList
     * @return \StructType\PurchaseRequisitionExpense
     */
    public function setLinkedOrderList(\StructType\RecordRefList $linkedOrderList = null)
    {
        $this->linkedOrderList = $linkedOrderList;
        return $this;
    }
    /**
     * Get linkedOrderStatus value
     * @return string|null
     */
    public function getLinkedOrderStatus()
    {
        return $this->linkedOrderStatus;
    }
    /**
     * Set linkedOrderStatus value
     * @param string $linkedOrderStatus
     * @return \StructType\PurchaseRequisitionExpense
     */
    public function setLinkedOrderStatus($linkedOrderStatus = null)
    {
        // validation for constraint: string
        if (!is_null($linkedOrderStatus) && !is_string($linkedOrderStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($linkedOrderStatus, true), gettype($linkedOrderStatus)), __LINE__);
        }
        $this->linkedOrderStatus = $linkedOrderStatus;
        return $this;
    }
    /**
     * Get isBillable value
     * @return bool|null
     */
    public function getIsBillable()
    {
        return $this->isBillable;
    }
    /**
     * Set isBillable value
     * @param bool $isBillable
     * @return \StructType\PurchaseRequisitionExpense
     */
    public function setIsBillable($isBillable = null)
    {
        // validation for constraint: boolean
        if (!is_null($isBillable) && !is_bool($isBillable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isBillable, true), gettype($isBillable)), __LINE__);
        }
        $this->isBillable = $isBillable;
        return $this;
    }
}
