<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PromotionsList StructType
 * @subpackage Structs
 */
class PromotionsList extends AbstractStructBase
{
    /**
     * The promotions
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Promotions[]
     */
    public $promotions;
    /**
     * The replaceAll
     * Meta information extracted from the WSDL
     * - default: true
     * @var bool
     */
    public $replaceAll;
    /**
     * Constructor method for PromotionsList
     * @uses PromotionsList::setPromotions()
     * @uses PromotionsList::setReplaceAll()
     * @param \StructType\Promotions[] $promotions
     * @param bool $replaceAll
     */
    public function __construct(array $promotions = array(), $replaceAll = true)
    {
        $this
            ->setPromotions($promotions)
            ->setReplaceAll($replaceAll);
    }
    /**
     * Get promotions value
     * @return \StructType\Promotions[]|null
     */
    public function getPromotions()
    {
        return $this->promotions;
    }
    /**
     * This method is responsible for validating the values passed to the setPromotions method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPromotions method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePromotionsForArrayConstraintsFromSetPromotions(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $promotionsListPromotionsItem) {
            // validation for constraint: itemType
            if (!$promotionsListPromotionsItem instanceof \StructType\Promotions) {
                $invalidValues[] = is_object($promotionsListPromotionsItem) ? get_class($promotionsListPromotionsItem) : sprintf('%s(%s)', gettype($promotionsListPromotionsItem), var_export($promotionsListPromotionsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The promotions property can only contain items of type \StructType\Promotions, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set promotions value
     * @throws \InvalidArgumentException
     * @param \StructType\Promotions[] $promotions
     * @return \StructType\PromotionsList
     */
    public function setPromotions(array $promotions = array())
    {
        // validation for constraint: array
        if ('' !== ($promotionsArrayErrorMessage = self::validatePromotionsForArrayConstraintsFromSetPromotions($promotions))) {
            throw new \InvalidArgumentException($promotionsArrayErrorMessage, __LINE__);
        }
        $this->promotions = $promotions;
        return $this;
    }
    /**
     * Add item to promotions value
     * @throws \InvalidArgumentException
     * @param \StructType\Promotions $item
     * @return \StructType\PromotionsList
     */
    public function addToPromotions(\StructType\Promotions $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Promotions) {
            throw new \InvalidArgumentException(sprintf('The promotions property can only contain items of type \StructType\Promotions, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->promotions[] = $item;
        return $this;
    }
    /**
     * Get replaceAll value
     * @return bool|null
     */
    public function getReplaceAll()
    {
        return $this->replaceAll;
    }
    /**
     * Set replaceAll value
     * @param bool $replaceAll
     * @return \StructType\PromotionsList
     */
    public function setReplaceAll($replaceAll = true)
    {
        // validation for constraint: boolean
        if (!is_null($replaceAll) && !is_bool($replaceAll)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($replaceAll, true), gettype($replaceAll)), __LINE__);
        }
        $this->replaceAll = $replaceAll;
        return $this;
    }
}
