<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PromotionCodeCurrencyList StructType
 * @subpackage Structs
 */
class PromotionCodeCurrencyList extends AbstractStructBase
{
    /**
     * The currency
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\PromotionCodeCurrency[]
     */
    public $currency;
    /**
     * The replaceAll
     * Meta information extracted from the WSDL
     * - default: true
     * @var bool
     */
    public $replaceAll;
    /**
     * Constructor method for PromotionCodeCurrencyList
     * @uses PromotionCodeCurrencyList::setCurrency()
     * @uses PromotionCodeCurrencyList::setReplaceAll()
     * @param \StructType\PromotionCodeCurrency[] $currency
     * @param bool $replaceAll
     */
    public function __construct(array $currency = array(), $replaceAll = true)
    {
        $this
            ->setCurrency($currency)
            ->setReplaceAll($replaceAll);
    }
    /**
     * Get currency value
     * @return \StructType\PromotionCodeCurrency[]|null
     */
    public function getCurrency()
    {
        return $this->currency;
    }
    /**
     * This method is responsible for validating the values passed to the setCurrency method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCurrency method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCurrencyForArrayConstraintsFromSetCurrency(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $promotionCodeCurrencyListCurrencyItem) {
            // validation for constraint: itemType
            if (!$promotionCodeCurrencyListCurrencyItem instanceof \StructType\PromotionCodeCurrency) {
                $invalidValues[] = is_object($promotionCodeCurrencyListCurrencyItem) ? get_class($promotionCodeCurrencyListCurrencyItem) : sprintf('%s(%s)', gettype($promotionCodeCurrencyListCurrencyItem), var_export($promotionCodeCurrencyListCurrencyItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The currency property can only contain items of type \StructType\PromotionCodeCurrency, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set currency value
     * @throws \InvalidArgumentException
     * @param \StructType\PromotionCodeCurrency[] $currency
     * @return \StructType\PromotionCodeCurrencyList
     */
    public function setCurrency(array $currency = array())
    {
        // validation for constraint: array
        if ('' !== ($currencyArrayErrorMessage = self::validateCurrencyForArrayConstraintsFromSetCurrency($currency))) {
            throw new \InvalidArgumentException($currencyArrayErrorMessage, __LINE__);
        }
        $this->currency = $currency;
        return $this;
    }
    /**
     * Add item to currency value
     * @throws \InvalidArgumentException
     * @param \StructType\PromotionCodeCurrency $item
     * @return \StructType\PromotionCodeCurrencyList
     */
    public function addToCurrency(\StructType\PromotionCodeCurrency $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PromotionCodeCurrency) {
            throw new \InvalidArgumentException(sprintf('The currency property can only contain items of type \StructType\PromotionCodeCurrency, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->currency[] = $item;
        return $this;
    }
    /**
     * Get replaceAll value
     * @return bool|null
     */
    public function getReplaceAll()
    {
        return $this->replaceAll;
    }
    /**
     * Set replaceAll value
     * @param bool $replaceAll
     * @return \StructType\PromotionCodeCurrencyList
     */
    public function setReplaceAll($replaceAll = true)
    {
        // validation for constraint: boolean
        if (!is_null($replaceAll) && !is_bool($replaceAll)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($replaceAll, true), gettype($replaceAll)), __LINE__);
        }
        $this->replaceAll = $replaceAll;
        return $this;
    }
}
