<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PromotionCodeCurrency StructType
 * @subpackage Structs
 */
class PromotionCodeCurrency extends AbstractStructBase
{
    /**
     * The currency
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $currency;
    /**
     * The minimumOrderAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $minimumOrderAmount;
    /**
     * Constructor method for PromotionCodeCurrency
     * @uses PromotionCodeCurrency::setCurrency()
     * @uses PromotionCodeCurrency::setMinimumOrderAmount()
     * @param \StructType\RecordRef $currency
     * @param float $minimumOrderAmount
     */
    public function __construct(\StructType\RecordRef $currency = null, $minimumOrderAmount = null)
    {
        $this
            ->setCurrency($currency)
            ->setMinimumOrderAmount($minimumOrderAmount);
    }
    /**
     * Get currency value
     * @return \StructType\RecordRef|null
     */
    public function getCurrency()
    {
        return $this->currency;
    }
    /**
     * Set currency value
     * @param \StructType\RecordRef $currency
     * @return \StructType\PromotionCodeCurrency
     */
    public function setCurrency(\StructType\RecordRef $currency = null)
    {
        $this->currency = $currency;
        return $this;
    }
    /**
     * Get minimumOrderAmount value
     * @return float|null
     */
    public function getMinimumOrderAmount()
    {
        return $this->minimumOrderAmount;
    }
    /**
     * Set minimumOrderAmount value
     * @param float $minimumOrderAmount
     * @return \StructType\PromotionCodeCurrency
     */
    public function setMinimumOrderAmount($minimumOrderAmount = null)
    {
        // validation for constraint: float
        if (!is_null($minimumOrderAmount) && !(is_float($minimumOrderAmount) || is_numeric($minimumOrderAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($minimumOrderAmount, true), gettype($minimumOrderAmount)), __LINE__);
        }
        $this->minimumOrderAmount = $minimumOrderAmount;
        return $this;
    }
}
