<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProjectTaskAssignee StructType
 * @subpackage Structs
 */
class ProjectTaskAssignee extends AbstractStructBase
{
    /**
     * The resource
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $resource;
    /**
     * The units
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $units;
    /**
     * The serviceItem
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $serviceItem;
    /**
     * The estimatedWork
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $estimatedWork;
    /**
     * The unitCost
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $unitCost;
    /**
     * The unitPrice
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $unitPrice;
    /**
     * The cost
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $cost;
    /**
     * The price
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $price;
    /**
     * The plannedWork
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $plannedWork;
    /**
     * Constructor method for ProjectTaskAssignee
     * @uses ProjectTaskAssignee::setResource()
     * @uses ProjectTaskAssignee::setUnits()
     * @uses ProjectTaskAssignee::setServiceItem()
     * @uses ProjectTaskAssignee::setEstimatedWork()
     * @uses ProjectTaskAssignee::setUnitCost()
     * @uses ProjectTaskAssignee::setUnitPrice()
     * @uses ProjectTaskAssignee::setCost()
     * @uses ProjectTaskAssignee::setPrice()
     * @uses ProjectTaskAssignee::setPlannedWork()
     * @param \StructType\RecordRef $resource
     * @param float $units
     * @param \StructType\RecordRef $serviceItem
     * @param float $estimatedWork
     * @param float $unitCost
     * @param float $unitPrice
     * @param float $cost
     * @param float $price
     * @param float $plannedWork
     */
    public function __construct(\StructType\RecordRef $resource = null, $units = null, \StructType\RecordRef $serviceItem = null, $estimatedWork = null, $unitCost = null, $unitPrice = null, $cost = null, $price = null, $plannedWork = null)
    {
        $this
            ->setResource($resource)
            ->setUnits($units)
            ->setServiceItem($serviceItem)
            ->setEstimatedWork($estimatedWork)
            ->setUnitCost($unitCost)
            ->setUnitPrice($unitPrice)
            ->setCost($cost)
            ->setPrice($price)
            ->setPlannedWork($plannedWork);
    }
    /**
     * Get resource value
     * @return \StructType\RecordRef|null
     */
    public function getResource()
    {
        return $this->resource;
    }
    /**
     * Set resource value
     * @param \StructType\RecordRef $resource
     * @return \StructType\ProjectTaskAssignee
     */
    public function setResource(\StructType\RecordRef $resource = null)
    {
        $this->resource = $resource;
        return $this;
    }
    /**
     * Get units value
     * @return float|null
     */
    public function getUnits()
    {
        return $this->units;
    }
    /**
     * Set units value
     * @param float $units
     * @return \StructType\ProjectTaskAssignee
     */
    public function setUnits($units = null)
    {
        // validation for constraint: float
        if (!is_null($units) && !(is_float($units) || is_numeric($units))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($units, true), gettype($units)), __LINE__);
        }
        $this->units = $units;
        return $this;
    }
    /**
     * Get serviceItem value
     * @return \StructType\RecordRef|null
     */
    public function getServiceItem()
    {
        return $this->serviceItem;
    }
    /**
     * Set serviceItem value
     * @param \StructType\RecordRef $serviceItem
     * @return \StructType\ProjectTaskAssignee
     */
    public function setServiceItem(\StructType\RecordRef $serviceItem = null)
    {
        $this->serviceItem = $serviceItem;
        return $this;
    }
    /**
     * Get estimatedWork value
     * @return float|null
     */
    public function getEstimatedWork()
    {
        return $this->estimatedWork;
    }
    /**
     * Set estimatedWork value
     * @param float $estimatedWork
     * @return \StructType\ProjectTaskAssignee
     */
    public function setEstimatedWork($estimatedWork = null)
    {
        // validation for constraint: float
        if (!is_null($estimatedWork) && !(is_float($estimatedWork) || is_numeric($estimatedWork))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($estimatedWork, true), gettype($estimatedWork)), __LINE__);
        }
        $this->estimatedWork = $estimatedWork;
        return $this;
    }
    /**
     * Get unitCost value
     * @return float|null
     */
    public function getUnitCost()
    {
        return $this->unitCost;
    }
    /**
     * Set unitCost value
     * @param float $unitCost
     * @return \StructType\ProjectTaskAssignee
     */
    public function setUnitCost($unitCost = null)
    {
        // validation for constraint: float
        if (!is_null($unitCost) && !(is_float($unitCost) || is_numeric($unitCost))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($unitCost, true), gettype($unitCost)), __LINE__);
        }
        $this->unitCost = $unitCost;
        return $this;
    }
    /**
     * Get unitPrice value
     * @return float|null
     */
    public function getUnitPrice()
    {
        return $this->unitPrice;
    }
    /**
     * Set unitPrice value
     * @param float $unitPrice
     * @return \StructType\ProjectTaskAssignee
     */
    public function setUnitPrice($unitPrice = null)
    {
        // validation for constraint: float
        if (!is_null($unitPrice) && !(is_float($unitPrice) || is_numeric($unitPrice))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($unitPrice, true), gettype($unitPrice)), __LINE__);
        }
        $this->unitPrice = $unitPrice;
        return $this;
    }
    /**
     * Get cost value
     * @return float|null
     */
    public function getCost()
    {
        return $this->cost;
    }
    /**
     * Set cost value
     * @param float $cost
     * @return \StructType\ProjectTaskAssignee
     */
    public function setCost($cost = null)
    {
        // validation for constraint: float
        if (!is_null($cost) && !(is_float($cost) || is_numeric($cost))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($cost, true), gettype($cost)), __LINE__);
        }
        $this->cost = $cost;
        return $this;
    }
    /**
     * Get price value
     * @return float|null
     */
    public function getPrice()
    {
        return $this->price;
    }
    /**
     * Set price value
     * @param float $price
     * @return \StructType\ProjectTaskAssignee
     */
    public function setPrice($price = null)
    {
        // validation for constraint: float
        if (!is_null($price) && !(is_float($price) || is_numeric($price))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($price, true), gettype($price)), __LINE__);
        }
        $this->price = $price;
        return $this;
    }
    /**
     * Get plannedWork value
     * @return float|null
     */
    public function getPlannedWork()
    {
        return $this->plannedWork;
    }
    /**
     * Set plannedWork value
     * @param float $plannedWork
     * @return \StructType\ProjectTaskAssignee
     */
    public function setPlannedWork($plannedWork = null)
    {
        // validation for constraint: float
        if (!is_null($plannedWork) && !(is_float($plannedWork) || is_numeric($plannedWork))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($plannedWork, true), gettype($plannedWork)), __LINE__);
        }
        $this->plannedWork = $plannedWork;
        return $this;
    }
}
