<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProjectTask StructType
 * @subpackage Structs
 */
class ProjectTask extends Record
{
    /**
     * The customForm
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $customForm;
    /**
     * The eventId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $eventId;
    /**
     * The percentTimeComplete
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $percentTimeComplete;
    /**
     * The title
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $title;
    /**
     * The company
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $company;
    /**
     * The contact
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $contact;
    /**
     * The order
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $order;
    /**
     * The owner
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $owner;
    /**
     * The parent
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $parent;
    /**
     * The priority
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $priority;
    /**
     * The estimatedWork
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $estimatedWork;
    /**
     * The estimatedWorkBaseline
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $estimatedWorkBaseline;
    /**
     * The constraintType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $constraintType;
    /**
     * The startDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $startDate;
    /**
     * The startDateBaseline
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $startDateBaseline;
    /**
     * The endDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $endDate;
    /**
     * The finishByDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $finishByDate;
    /**
     * The endDateBaseline
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $endDateBaseline;
    /**
     * The actualWork
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Duration
     */
    public $actualWork;
    /**
     * The remainingWork
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Duration
     */
    public $remainingWork;
    /**
     * The message
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $message;
    /**
     * The isMilestone
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $isMilestone;
    /**
     * The isOnCriticalPath
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $isOnCriticalPath;
    /**
     * The slackMinutes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $slackMinutes;
    /**
     * The lateEnd
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $lateEnd;
    /**
     * The lateStart
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $lateStart;
    /**
     * The status
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $status;
    /**
     * The nonBillableTask
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $nonBillableTask;
    /**
     * The assigneeList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ProjectTaskAssigneeList
     */
    public $assigneeList;
    /**
     * The predecessorList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ProjectTaskPredecessorList
     */
    public $predecessorList;
    /**
     * The timeItemList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ProjectTaskTimeItemList
     */
    public $timeItemList;
    /**
     * The plannedWork
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $plannedWork;
    /**
     * The plannedWorkBaseline
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $plannedWorkBaseline;
    /**
     * The customFieldList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CustomFieldList
     */
    public $customFieldList;
    /**
     * The internalId
     * @var string
     */
    public $internalId;
    /**
     * The externalId
     * @var string
     */
    public $externalId;
    /**
     * Constructor method for ProjectTask
     * @uses ProjectTask::setCustomForm()
     * @uses ProjectTask::setEventId()
     * @uses ProjectTask::setPercentTimeComplete()
     * @uses ProjectTask::setTitle()
     * @uses ProjectTask::setCompany()
     * @uses ProjectTask::setContact()
     * @uses ProjectTask::setOrder()
     * @uses ProjectTask::setOwner()
     * @uses ProjectTask::setParent()
     * @uses ProjectTask::setPriority()
     * @uses ProjectTask::setEstimatedWork()
     * @uses ProjectTask::setEstimatedWorkBaseline()
     * @uses ProjectTask::setConstraintType()
     * @uses ProjectTask::setStartDate()
     * @uses ProjectTask::setStartDateBaseline()
     * @uses ProjectTask::setEndDate()
     * @uses ProjectTask::setFinishByDate()
     * @uses ProjectTask::setEndDateBaseline()
     * @uses ProjectTask::setActualWork()
     * @uses ProjectTask::setRemainingWork()
     * @uses ProjectTask::setMessage()
     * @uses ProjectTask::setIsMilestone()
     * @uses ProjectTask::setIsOnCriticalPath()
     * @uses ProjectTask::setSlackMinutes()
     * @uses ProjectTask::setLateEnd()
     * @uses ProjectTask::setLateStart()
     * @uses ProjectTask::setStatus()
     * @uses ProjectTask::setNonBillableTask()
     * @uses ProjectTask::setAssigneeList()
     * @uses ProjectTask::setPredecessorList()
     * @uses ProjectTask::setTimeItemList()
     * @uses ProjectTask::setPlannedWork()
     * @uses ProjectTask::setPlannedWorkBaseline()
     * @uses ProjectTask::setCustomFieldList()
     * @uses ProjectTask::setInternalId()
     * @uses ProjectTask::setExternalId()
     * @param \StructType\RecordRef $customForm
     * @param \StructType\RecordRef $eventId
     * @param float $percentTimeComplete
     * @param string $title
     * @param \StructType\RecordRef $company
     * @param \StructType\RecordRef $contact
     * @param \StructType\RecordRef $order
     * @param \StructType\RecordRef $owner
     * @param \StructType\RecordRef $parent
     * @param \StructType\RecordRef $priority
     * @param float $estimatedWork
     * @param float $estimatedWorkBaseline
     * @param string $constraintType
     * @param string $startDate
     * @param string $startDateBaseline
     * @param string $endDate
     * @param string $finishByDate
     * @param string $endDateBaseline
     * @param \StructType\Duration $actualWork
     * @param \StructType\Duration $remainingWork
     * @param string $message
     * @param bool $isMilestone
     * @param string $isOnCriticalPath
     * @param float $slackMinutes
     * @param string $lateEnd
     * @param string $lateStart
     * @param string $status
     * @param bool $nonBillableTask
     * @param \StructType\ProjectTaskAssigneeList $assigneeList
     * @param \StructType\ProjectTaskPredecessorList $predecessorList
     * @param \StructType\ProjectTaskTimeItemList $timeItemList
     * @param float $plannedWork
     * @param float $plannedWorkBaseline
     * @param \StructType\CustomFieldList $customFieldList
     * @param string $internalId
     * @param string $externalId
     */
    public function __construct(\StructType\RecordRef $customForm = null, \StructType\RecordRef $eventId = null, $percentTimeComplete = null, $title = null, \StructType\RecordRef $company = null, \StructType\RecordRef $contact = null, \StructType\RecordRef $order = null, \StructType\RecordRef $owner = null, \StructType\RecordRef $parent = null, \StructType\RecordRef $priority = null, $estimatedWork = null, $estimatedWorkBaseline = null, $constraintType = null, $startDate = null, $startDateBaseline = null, $endDate = null, $finishByDate = null, $endDateBaseline = null, \StructType\Duration $actualWork = null, \StructType\Duration $remainingWork = null, $message = null, $isMilestone = null, $isOnCriticalPath = null, $slackMinutes = null, $lateEnd = null, $lateStart = null, $status = null, $nonBillableTask = null, \StructType\ProjectTaskAssigneeList $assigneeList = null, \StructType\ProjectTaskPredecessorList $predecessorList = null, \StructType\ProjectTaskTimeItemList $timeItemList = null, $plannedWork = null, $plannedWorkBaseline = null, \StructType\CustomFieldList $customFieldList = null, $internalId = null, $externalId = null)
    {
        $this
            ->setCustomForm($customForm)
            ->setEventId($eventId)
            ->setPercentTimeComplete($percentTimeComplete)
            ->setTitle($title)
            ->setCompany($company)
            ->setContact($contact)
            ->setOrder($order)
            ->setOwner($owner)
            ->setParent($parent)
            ->setPriority($priority)
            ->setEstimatedWork($estimatedWork)
            ->setEstimatedWorkBaseline($estimatedWorkBaseline)
            ->setConstraintType($constraintType)
            ->setStartDate($startDate)
            ->setStartDateBaseline($startDateBaseline)
            ->setEndDate($endDate)
            ->setFinishByDate($finishByDate)
            ->setEndDateBaseline($endDateBaseline)
            ->setActualWork($actualWork)
            ->setRemainingWork($remainingWork)
            ->setMessage($message)
            ->setIsMilestone($isMilestone)
            ->setIsOnCriticalPath($isOnCriticalPath)
            ->setSlackMinutes($slackMinutes)
            ->setLateEnd($lateEnd)
            ->setLateStart($lateStart)
            ->setStatus($status)
            ->setNonBillableTask($nonBillableTask)
            ->setAssigneeList($assigneeList)
            ->setPredecessorList($predecessorList)
            ->setTimeItemList($timeItemList)
            ->setPlannedWork($plannedWork)
            ->setPlannedWorkBaseline($plannedWorkBaseline)
            ->setCustomFieldList($customFieldList)
            ->setInternalId($internalId)
            ->setExternalId($externalId);
    }
    /**
     * Get customForm value
     * @return \StructType\RecordRef|null
     */
    public function getCustomForm()
    {
        return $this->customForm;
    }
    /**
     * Set customForm value
     * @param \StructType\RecordRef $customForm
     * @return \StructType\ProjectTask
     */
    public function setCustomForm(\StructType\RecordRef $customForm = null)
    {
        $this->customForm = $customForm;
        return $this;
    }
    /**
     * Get eventId value
     * @return \StructType\RecordRef|null
     */
    public function getEventId()
    {
        return $this->eventId;
    }
    /**
     * Set eventId value
     * @param \StructType\RecordRef $eventId
     * @return \StructType\ProjectTask
     */
    public function setEventId(\StructType\RecordRef $eventId = null)
    {
        $this->eventId = $eventId;
        return $this;
    }
    /**
     * Get percentTimeComplete value
     * @return float|null
     */
    public function getPercentTimeComplete()
    {
        return $this->percentTimeComplete;
    }
    /**
     * Set percentTimeComplete value
     * @param float $percentTimeComplete
     * @return \StructType\ProjectTask
     */
    public function setPercentTimeComplete($percentTimeComplete = null)
    {
        // validation for constraint: float
        if (!is_null($percentTimeComplete) && !(is_float($percentTimeComplete) || is_numeric($percentTimeComplete))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($percentTimeComplete, true), gettype($percentTimeComplete)), __LINE__);
        }
        $this->percentTimeComplete = $percentTimeComplete;
        return $this;
    }
    /**
     * Get title value
     * @return string|null
     */
    public function getTitle()
    {
        return $this->title;
    }
    /**
     * Set title value
     * @param string $title
     * @return \StructType\ProjectTask
     */
    public function setTitle($title = null)
    {
        // validation for constraint: string
        if (!is_null($title) && !is_string($title)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($title, true), gettype($title)), __LINE__);
        }
        $this->title = $title;
        return $this;
    }
    /**
     * Get company value
     * @return \StructType\RecordRef|null
     */
    public function getCompany()
    {
        return $this->company;
    }
    /**
     * Set company value
     * @param \StructType\RecordRef $company
     * @return \StructType\ProjectTask
     */
    public function setCompany(\StructType\RecordRef $company = null)
    {
        $this->company = $company;
        return $this;
    }
    /**
     * Get contact value
     * @return \StructType\RecordRef|null
     */
    public function getContact()
    {
        return $this->contact;
    }
    /**
     * Set contact value
     * @param \StructType\RecordRef $contact
     * @return \StructType\ProjectTask
     */
    public function setContact(\StructType\RecordRef $contact = null)
    {
        $this->contact = $contact;
        return $this;
    }
    /**
     * Get order value
     * @return \StructType\RecordRef|null
     */
    public function getOrder()
    {
        return $this->order;
    }
    /**
     * Set order value
     * @param \StructType\RecordRef $order
     * @return \StructType\ProjectTask
     */
    public function setOrder(\StructType\RecordRef $order = null)
    {
        $this->order = $order;
        return $this;
    }
    /**
     * Get owner value
     * @return \StructType\RecordRef|null
     */
    public function getOwner()
    {
        return $this->owner;
    }
    /**
     * Set owner value
     * @param \StructType\RecordRef $owner
     * @return \StructType\ProjectTask
     */
    public function setOwner(\StructType\RecordRef $owner = null)
    {
        $this->owner = $owner;
        return $this;
    }
    /**
     * Get parent value
     * @return \StructType\RecordRef|null
     */
    public function getParent()
    {
        return $this->parent;
    }
    /**
     * Set parent value
     * @param \StructType\RecordRef $parent
     * @return \StructType\ProjectTask
     */
    public function setParent(\StructType\RecordRef $parent = null)
    {
        $this->parent = $parent;
        return $this;
    }
    /**
     * Get priority value
     * @return \StructType\RecordRef|null
     */
    public function getPriority()
    {
        return $this->priority;
    }
    /**
     * Set priority value
     * @param \StructType\RecordRef $priority
     * @return \StructType\ProjectTask
     */
    public function setPriority(\StructType\RecordRef $priority = null)
    {
        $this->priority = $priority;
        return $this;
    }
    /**
     * Get estimatedWork value
     * @return float|null
     */
    public function getEstimatedWork()
    {
        return $this->estimatedWork;
    }
    /**
     * Set estimatedWork value
     * @param float $estimatedWork
     * @return \StructType\ProjectTask
     */
    public function setEstimatedWork($estimatedWork = null)
    {
        // validation for constraint: float
        if (!is_null($estimatedWork) && !(is_float($estimatedWork) || is_numeric($estimatedWork))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($estimatedWork, true), gettype($estimatedWork)), __LINE__);
        }
        $this->estimatedWork = $estimatedWork;
        return $this;
    }
    /**
     * Get estimatedWorkBaseline value
     * @return float|null
     */
    public function getEstimatedWorkBaseline()
    {
        return $this->estimatedWorkBaseline;
    }
    /**
     * Set estimatedWorkBaseline value
     * @param float $estimatedWorkBaseline
     * @return \StructType\ProjectTask
     */
    public function setEstimatedWorkBaseline($estimatedWorkBaseline = null)
    {
        // validation for constraint: float
        if (!is_null($estimatedWorkBaseline) && !(is_float($estimatedWorkBaseline) || is_numeric($estimatedWorkBaseline))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($estimatedWorkBaseline, true), gettype($estimatedWorkBaseline)), __LINE__);
        }
        $this->estimatedWorkBaseline = $estimatedWorkBaseline;
        return $this;
    }
    /**
     * Get constraintType value
     * @return string|null
     */
    public function getConstraintType()
    {
        return $this->constraintType;
    }
    /**
     * Set constraintType value
     * @uses \EnumType\ProjectTaskConstraintType::valueIsValid()
     * @uses \EnumType\ProjectTaskConstraintType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $constraintType
     * @return \StructType\ProjectTask
     */
    public function setConstraintType($constraintType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ProjectTaskConstraintType::valueIsValid($constraintType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\ProjectTaskConstraintType', is_array($constraintType) ? implode(', ', $constraintType) : var_export($constraintType, true), implode(', ', \EnumType\ProjectTaskConstraintType::getValidValues())), __LINE__);
        }
        $this->constraintType = $constraintType;
        return $this;
    }
    /**
     * Get startDate value
     * @return string|null
     */
    public function getStartDate()
    {
        return $this->startDate;
    }
    /**
     * Set startDate value
     * @param string $startDate
     * @return \StructType\ProjectTask
     */
    public function setStartDate($startDate = null)
    {
        // validation for constraint: string
        if (!is_null($startDate) && !is_string($startDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($startDate, true), gettype($startDate)), __LINE__);
        }
        $this->startDate = $startDate;
        return $this;
    }
    /**
     * Get startDateBaseline value
     * @return string|null
     */
    public function getStartDateBaseline()
    {
        return $this->startDateBaseline;
    }
    /**
     * Set startDateBaseline value
     * @param string $startDateBaseline
     * @return \StructType\ProjectTask
     */
    public function setStartDateBaseline($startDateBaseline = null)
    {
        // validation for constraint: string
        if (!is_null($startDateBaseline) && !is_string($startDateBaseline)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($startDateBaseline, true), gettype($startDateBaseline)), __LINE__);
        }
        $this->startDateBaseline = $startDateBaseline;
        return $this;
    }
    /**
     * Get endDate value
     * @return string|null
     */
    public function getEndDate()
    {
        return $this->endDate;
    }
    /**
     * Set endDate value
     * @param string $endDate
     * @return \StructType\ProjectTask
     */
    public function setEndDate($endDate = null)
    {
        // validation for constraint: string
        if (!is_null($endDate) && !is_string($endDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($endDate, true), gettype($endDate)), __LINE__);
        }
        $this->endDate = $endDate;
        return $this;
    }
    /**
     * Get finishByDate value
     * @return string|null
     */
    public function getFinishByDate()
    {
        return $this->finishByDate;
    }
    /**
     * Set finishByDate value
     * @param string $finishByDate
     * @return \StructType\ProjectTask
     */
    public function setFinishByDate($finishByDate = null)
    {
        // validation for constraint: string
        if (!is_null($finishByDate) && !is_string($finishByDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($finishByDate, true), gettype($finishByDate)), __LINE__);
        }
        $this->finishByDate = $finishByDate;
        return $this;
    }
    /**
     * Get endDateBaseline value
     * @return string|null
     */
    public function getEndDateBaseline()
    {
        return $this->endDateBaseline;
    }
    /**
     * Set endDateBaseline value
     * @param string $endDateBaseline
     * @return \StructType\ProjectTask
     */
    public function setEndDateBaseline($endDateBaseline = null)
    {
        // validation for constraint: string
        if (!is_null($endDateBaseline) && !is_string($endDateBaseline)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($endDateBaseline, true), gettype($endDateBaseline)), __LINE__);
        }
        $this->endDateBaseline = $endDateBaseline;
        return $this;
    }
    /**
     * Get actualWork value
     * @return \StructType\Duration|null
     */
    public function getActualWork()
    {
        return $this->actualWork;
    }
    /**
     * Set actualWork value
     * @param \StructType\Duration $actualWork
     * @return \StructType\ProjectTask
     */
    public function setActualWork(\StructType\Duration $actualWork = null)
    {
        $this->actualWork = $actualWork;
        return $this;
    }
    /**
     * Get remainingWork value
     * @return \StructType\Duration|null
     */
    public function getRemainingWork()
    {
        return $this->remainingWork;
    }
    /**
     * Set remainingWork value
     * @param \StructType\Duration $remainingWork
     * @return \StructType\ProjectTask
     */
    public function setRemainingWork(\StructType\Duration $remainingWork = null)
    {
        $this->remainingWork = $remainingWork;
        return $this;
    }
    /**
     * Get message value
     * @return string|null
     */
    public function getMessage()
    {
        return $this->message;
    }
    /**
     * Set message value
     * @param string $message
     * @return \StructType\ProjectTask
     */
    public function setMessage($message = null)
    {
        // validation for constraint: string
        if (!is_null($message) && !is_string($message)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($message, true), gettype($message)), __LINE__);
        }
        $this->message = $message;
        return $this;
    }
    /**
     * Get isMilestone value
     * @return bool|null
     */
    public function getIsMilestone()
    {
        return $this->isMilestone;
    }
    /**
     * Set isMilestone value
     * @param bool $isMilestone
     * @return \StructType\ProjectTask
     */
    public function setIsMilestone($isMilestone = null)
    {
        // validation for constraint: boolean
        if (!is_null($isMilestone) && !is_bool($isMilestone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isMilestone, true), gettype($isMilestone)), __LINE__);
        }
        $this->isMilestone = $isMilestone;
        return $this;
    }
    /**
     * Get isOnCriticalPath value
     * @return string|null
     */
    public function getIsOnCriticalPath()
    {
        return $this->isOnCriticalPath;
    }
    /**
     * Set isOnCriticalPath value
     * @param string $isOnCriticalPath
     * @return \StructType\ProjectTask
     */
    public function setIsOnCriticalPath($isOnCriticalPath = null)
    {
        // validation for constraint: string
        if (!is_null($isOnCriticalPath) && !is_string($isOnCriticalPath)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($isOnCriticalPath, true), gettype($isOnCriticalPath)), __LINE__);
        }
        $this->isOnCriticalPath = $isOnCriticalPath;
        return $this;
    }
    /**
     * Get slackMinutes value
     * @return float|null
     */
    public function getSlackMinutes()
    {
        return $this->slackMinutes;
    }
    /**
     * Set slackMinutes value
     * @param float $slackMinutes
     * @return \StructType\ProjectTask
     */
    public function setSlackMinutes($slackMinutes = null)
    {
        // validation for constraint: float
        if (!is_null($slackMinutes) && !(is_float($slackMinutes) || is_numeric($slackMinutes))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($slackMinutes, true), gettype($slackMinutes)), __LINE__);
        }
        $this->slackMinutes = $slackMinutes;
        return $this;
    }
    /**
     * Get lateEnd value
     * @return string|null
     */
    public function getLateEnd()
    {
        return $this->lateEnd;
    }
    /**
     * Set lateEnd value
     * @param string $lateEnd
     * @return \StructType\ProjectTask
     */
    public function setLateEnd($lateEnd = null)
    {
        // validation for constraint: string
        if (!is_null($lateEnd) && !is_string($lateEnd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lateEnd, true), gettype($lateEnd)), __LINE__);
        }
        $this->lateEnd = $lateEnd;
        return $this;
    }
    /**
     * Get lateStart value
     * @return string|null
     */
    public function getLateStart()
    {
        return $this->lateStart;
    }
    /**
     * Set lateStart value
     * @param string $lateStart
     * @return \StructType\ProjectTask
     */
    public function setLateStart($lateStart = null)
    {
        // validation for constraint: string
        if (!is_null($lateStart) && !is_string($lateStart)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lateStart, true), gettype($lateStart)), __LINE__);
        }
        $this->lateStart = $lateStart;
        return $this;
    }
    /**
     * Get status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->status;
    }
    /**
     * Set status value
     * @uses \EnumType\ProjectTaskStatus::valueIsValid()
     * @uses \EnumType\ProjectTaskStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \StructType\ProjectTask
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ProjectTaskStatus::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\ProjectTaskStatus', is_array($status) ? implode(', ', $status) : var_export($status, true), implode(', ', \EnumType\ProjectTaskStatus::getValidValues())), __LINE__);
        }
        $this->status = $status;
        return $this;
    }
    /**
     * Get nonBillableTask value
     * @return bool|null
     */
    public function getNonBillableTask()
    {
        return $this->nonBillableTask;
    }
    /**
     * Set nonBillableTask value
     * @param bool $nonBillableTask
     * @return \StructType\ProjectTask
     */
    public function setNonBillableTask($nonBillableTask = null)
    {
        // validation for constraint: boolean
        if (!is_null($nonBillableTask) && !is_bool($nonBillableTask)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($nonBillableTask, true), gettype($nonBillableTask)), __LINE__);
        }
        $this->nonBillableTask = $nonBillableTask;
        return $this;
    }
    /**
     * Get assigneeList value
     * @return \StructType\ProjectTaskAssigneeList|null
     */
    public function getAssigneeList()
    {
        return $this->assigneeList;
    }
    /**
     * Set assigneeList value
     * @param \StructType\ProjectTaskAssigneeList $assigneeList
     * @return \StructType\ProjectTask
     */
    public function setAssigneeList(\StructType\ProjectTaskAssigneeList $assigneeList = null)
    {
        $this->assigneeList = $assigneeList;
        return $this;
    }
    /**
     * Get predecessorList value
     * @return \StructType\ProjectTaskPredecessorList|null
     */
    public function getPredecessorList()
    {
        return $this->predecessorList;
    }
    /**
     * Set predecessorList value
     * @param \StructType\ProjectTaskPredecessorList $predecessorList
     * @return \StructType\ProjectTask
     */
    public function setPredecessorList(\StructType\ProjectTaskPredecessorList $predecessorList = null)
    {
        $this->predecessorList = $predecessorList;
        return $this;
    }
    /**
     * Get timeItemList value
     * @return \StructType\ProjectTaskTimeItemList|null
     */
    public function getTimeItemList()
    {
        return $this->timeItemList;
    }
    /**
     * Set timeItemList value
     * @param \StructType\ProjectTaskTimeItemList $timeItemList
     * @return \StructType\ProjectTask
     */
    public function setTimeItemList(\StructType\ProjectTaskTimeItemList $timeItemList = null)
    {
        $this->timeItemList = $timeItemList;
        return $this;
    }
    /**
     * Get plannedWork value
     * @return float|null
     */
    public function getPlannedWork()
    {
        return $this->plannedWork;
    }
    /**
     * Set plannedWork value
     * @param float $plannedWork
     * @return \StructType\ProjectTask
     */
    public function setPlannedWork($plannedWork = null)
    {
        // validation for constraint: float
        if (!is_null($plannedWork) && !(is_float($plannedWork) || is_numeric($plannedWork))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($plannedWork, true), gettype($plannedWork)), __LINE__);
        }
        $this->plannedWork = $plannedWork;
        return $this;
    }
    /**
     * Get plannedWorkBaseline value
     * @return float|null
     */
    public function getPlannedWorkBaseline()
    {
        return $this->plannedWorkBaseline;
    }
    /**
     * Set plannedWorkBaseline value
     * @param float $plannedWorkBaseline
     * @return \StructType\ProjectTask
     */
    public function setPlannedWorkBaseline($plannedWorkBaseline = null)
    {
        // validation for constraint: float
        if (!is_null($plannedWorkBaseline) && !(is_float($plannedWorkBaseline) || is_numeric($plannedWorkBaseline))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($plannedWorkBaseline, true), gettype($plannedWorkBaseline)), __LINE__);
        }
        $this->plannedWorkBaseline = $plannedWorkBaseline;
        return $this;
    }
    /**
     * Get customFieldList value
     * @return \StructType\CustomFieldList|null
     */
    public function getCustomFieldList()
    {
        return $this->customFieldList;
    }
    /**
     * Set customFieldList value
     * @param \StructType\CustomFieldList $customFieldList
     * @return \StructType\ProjectTask
     */
    public function setCustomFieldList(\StructType\CustomFieldList $customFieldList = null)
    {
        $this->customFieldList = $customFieldList;
        return $this;
    }
    /**
     * Get internalId value
     * @return string|null
     */
    public function getInternalId()
    {
        return $this->internalId;
    }
    /**
     * Set internalId value
     * @param string $internalId
     * @return \StructType\ProjectTask
     */
    public function setInternalId($internalId = null)
    {
        // validation for constraint: string
        if (!is_null($internalId) && !is_string($internalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($internalId, true), gettype($internalId)), __LINE__);
        }
        $this->internalId = $internalId;
        return $this;
    }
    /**
     * Get externalId value
     * @return string|null
     */
    public function getExternalId()
    {
        return $this->externalId;
    }
    /**
     * Set externalId value
     * @param string $externalId
     * @return \StructType\ProjectTask
     */
    public function setExternalId($externalId = null)
    {
        // validation for constraint: string
        if (!is_null($externalId) && !is_string($externalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($externalId, true), gettype($externalId)), __LINE__);
        }
        $this->externalId = $externalId;
        return $this;
    }
}
