<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PhoneCallContactList StructType
 * @subpackage Structs
 */
class PhoneCallContactList extends AbstractStructBase
{
    /**
     * The contact
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\PhoneCallContact[]
     */
    public $contact;
    /**
     * The replaceAll
     * Meta information extracted from the WSDL
     * - default: true
     * @var bool
     */
    public $replaceAll;
    /**
     * Constructor method for PhoneCallContactList
     * @uses PhoneCallContactList::setContact()
     * @uses PhoneCallContactList::setReplaceAll()
     * @param \StructType\PhoneCallContact[] $contact
     * @param bool $replaceAll
     */
    public function __construct(array $contact = array(), $replaceAll = true)
    {
        $this
            ->setContact($contact)
            ->setReplaceAll($replaceAll);
    }
    /**
     * Get contact value
     * @return \StructType\PhoneCallContact[]|null
     */
    public function getContact()
    {
        return $this->contact;
    }
    /**
     * This method is responsible for validating the values passed to the setContact method
     * This method is willingly generated in order to preserve the one-line inline validation within the setContact method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateContactForArrayConstraintsFromSetContact(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $phoneCallContactListContactItem) {
            // validation for constraint: itemType
            if (!$phoneCallContactListContactItem instanceof \StructType\PhoneCallContact) {
                $invalidValues[] = is_object($phoneCallContactListContactItem) ? get_class($phoneCallContactListContactItem) : sprintf('%s(%s)', gettype($phoneCallContactListContactItem), var_export($phoneCallContactListContactItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The contact property can only contain items of type \StructType\PhoneCallContact, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set contact value
     * @throws \InvalidArgumentException
     * @param \StructType\PhoneCallContact[] $contact
     * @return \StructType\PhoneCallContactList
     */
    public function setContact(array $contact = array())
    {
        // validation for constraint: array
        if ('' !== ($contactArrayErrorMessage = self::validateContactForArrayConstraintsFromSetContact($contact))) {
            throw new \InvalidArgumentException($contactArrayErrorMessage, __LINE__);
        }
        $this->contact = $contact;
        return $this;
    }
    /**
     * Add item to contact value
     * @throws \InvalidArgumentException
     * @param \StructType\PhoneCallContact $item
     * @return \StructType\PhoneCallContactList
     */
    public function addToContact(\StructType\PhoneCallContact $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PhoneCallContact) {
            throw new \InvalidArgumentException(sprintf('The contact property can only contain items of type \StructType\PhoneCallContact, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->contact[] = $item;
        return $this;
    }
    /**
     * Get replaceAll value
     * @return bool|null
     */
    public function getReplaceAll()
    {
        return $this->replaceAll;
    }
    /**
     * Set replaceAll value
     * @param bool $replaceAll
     * @return \StructType\PhoneCallContactList
     */
    public function setReplaceAll($replaceAll = true)
    {
        // validation for constraint: boolean
        if (!is_null($replaceAll) && !is_bool($replaceAll)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($replaceAll, true), gettype($replaceAll)), __LINE__);
        }
        $this->replaceAll = $replaceAll;
        return $this;
    }
}
