<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PeriodDemandPlan StructType
 * @subpackage Structs
 */
class PeriodDemandPlan extends AbstractStructBase
{
    /**
     * The quantity
     * Meta information extracted from the WSDL
     * - minOccurs: 1
     * @var float
     */
    public $quantity;
    /**
     * The dayOfTheWeek
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $dayOfTheWeek;
    /**
     * Constructor method for PeriodDemandPlan
     * @uses PeriodDemandPlan::setQuantity()
     * @uses PeriodDemandPlan::setDayOfTheWeek()
     * @param float $quantity
     * @param string $dayOfTheWeek
     */
    public function __construct($quantity = null, $dayOfTheWeek = null)
    {
        $this
            ->setQuantity($quantity)
            ->setDayOfTheWeek($dayOfTheWeek);
    }
    /**
     * Get quantity value
     * @return float
     */
    public function getQuantity()
    {
        return $this->quantity;
    }
    /**
     * Set quantity value
     * @param float $quantity
     * @return \StructType\PeriodDemandPlan
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: float
        if (!is_null($quantity) && !(is_float($quantity) || is_numeric($quantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($quantity, true), gettype($quantity)), __LINE__);
        }
        $this->quantity = $quantity;
        return $this;
    }
    /**
     * Get dayOfTheWeek value
     * @return string|null
     */
    public function getDayOfTheWeek()
    {
        return $this->dayOfTheWeek;
    }
    /**
     * Set dayOfTheWeek value
     * @uses \EnumType\DayOfTheWeek::valueIsValid()
     * @uses \EnumType\DayOfTheWeek::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $dayOfTheWeek
     * @return \StructType\PeriodDemandPlan
     */
    public function setDayOfTheWeek($dayOfTheWeek = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\DayOfTheWeek::valueIsValid($dayOfTheWeek)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\DayOfTheWeek', is_array($dayOfTheWeek) ? implode(', ', $dayOfTheWeek) : var_export($dayOfTheWeek, true), implode(', ', \EnumType\DayOfTheWeek::getValidValues())), __LINE__);
        }
        $this->dayOfTheWeek = $dayOfTheWeek;
        return $this;
    }
}
