<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PaycheckPayTax StructType
 * @subpackage Structs
 */
class PaycheckPayTax extends AbstractStructBase
{
    /**
     * The line
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $line;
    /**
     * The apply
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $apply;
    /**
     * The payTax
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $payTax;
    /**
     * The payItem
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $payItem;
    /**
     * The taxableWageBase
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $taxableWageBase;
    /**
     * The taxedWageBase
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $taxedWageBase;
    /**
     * The reportableWageBase
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $reportableWageBase;
    /**
     * The isExempt
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $isExempt;
    /**
     * The isResidentTax
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $isResidentTax;
    /**
     * The amount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $amount;
    /**
     * Constructor method for PaycheckPayTax
     * @uses PaycheckPayTax::setLine()
     * @uses PaycheckPayTax::setApply()
     * @uses PaycheckPayTax::setPayTax()
     * @uses PaycheckPayTax::setPayItem()
     * @uses PaycheckPayTax::setTaxableWageBase()
     * @uses PaycheckPayTax::setTaxedWageBase()
     * @uses PaycheckPayTax::setReportableWageBase()
     * @uses PaycheckPayTax::setIsExempt()
     * @uses PaycheckPayTax::setIsResidentTax()
     * @uses PaycheckPayTax::setAmount()
     * @param int $line
     * @param bool $apply
     * @param string $payTax
     * @param int $payItem
     * @param float $taxableWageBase
     * @param float $taxedWageBase
     * @param float $reportableWageBase
     * @param bool $isExempt
     * @param bool $isResidentTax
     * @param float $amount
     */
    public function __construct($line = null, $apply = null, $payTax = null, $payItem = null, $taxableWageBase = null, $taxedWageBase = null, $reportableWageBase = null, $isExempt = null, $isResidentTax = null, $amount = null)
    {
        $this
            ->setLine($line)
            ->setApply($apply)
            ->setPayTax($payTax)
            ->setPayItem($payItem)
            ->setTaxableWageBase($taxableWageBase)
            ->setTaxedWageBase($taxedWageBase)
            ->setReportableWageBase($reportableWageBase)
            ->setIsExempt($isExempt)
            ->setIsResidentTax($isResidentTax)
            ->setAmount($amount);
    }
    /**
     * Get line value
     * @return int|null
     */
    public function getLine()
    {
        return $this->line;
    }
    /**
     * Set line value
     * @param int $line
     * @return \StructType\PaycheckPayTax
     */
    public function setLine($line = null)
    {
        // validation for constraint: int
        if (!is_null($line) && !(is_int($line) || ctype_digit($line))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($line, true), gettype($line)), __LINE__);
        }
        $this->line = $line;
        return $this;
    }
    /**
     * Get apply value
     * @return bool|null
     */
    public function getApply()
    {
        return $this->apply;
    }
    /**
     * Set apply value
     * @param bool $apply
     * @return \StructType\PaycheckPayTax
     */
    public function setApply($apply = null)
    {
        // validation for constraint: boolean
        if (!is_null($apply) && !is_bool($apply)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($apply, true), gettype($apply)), __LINE__);
        }
        $this->apply = $apply;
        return $this;
    }
    /**
     * Get payTax value
     * @return string|null
     */
    public function getPayTax()
    {
        return $this->payTax;
    }
    /**
     * Set payTax value
     * @param string $payTax
     * @return \StructType\PaycheckPayTax
     */
    public function setPayTax($payTax = null)
    {
        // validation for constraint: string
        if (!is_null($payTax) && !is_string($payTax)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($payTax, true), gettype($payTax)), __LINE__);
        }
        $this->payTax = $payTax;
        return $this;
    }
    /**
     * Get payItem value
     * @return int|null
     */
    public function getPayItem()
    {
        return $this->payItem;
    }
    /**
     * Set payItem value
     * @param int $payItem
     * @return \StructType\PaycheckPayTax
     */
    public function setPayItem($payItem = null)
    {
        // validation for constraint: int
        if (!is_null($payItem) && !(is_int($payItem) || ctype_digit($payItem))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($payItem, true), gettype($payItem)), __LINE__);
        }
        $this->payItem = $payItem;
        return $this;
    }
    /**
     * Get taxableWageBase value
     * @return float|null
     */
    public function getTaxableWageBase()
    {
        return $this->taxableWageBase;
    }
    /**
     * Set taxableWageBase value
     * @param float $taxableWageBase
     * @return \StructType\PaycheckPayTax
     */
    public function setTaxableWageBase($taxableWageBase = null)
    {
        // validation for constraint: float
        if (!is_null($taxableWageBase) && !(is_float($taxableWageBase) || is_numeric($taxableWageBase))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($taxableWageBase, true), gettype($taxableWageBase)), __LINE__);
        }
        $this->taxableWageBase = $taxableWageBase;
        return $this;
    }
    /**
     * Get taxedWageBase value
     * @return float|null
     */
    public function getTaxedWageBase()
    {
        return $this->taxedWageBase;
    }
    /**
     * Set taxedWageBase value
     * @param float $taxedWageBase
     * @return \StructType\PaycheckPayTax
     */
    public function setTaxedWageBase($taxedWageBase = null)
    {
        // validation for constraint: float
        if (!is_null($taxedWageBase) && !(is_float($taxedWageBase) || is_numeric($taxedWageBase))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($taxedWageBase, true), gettype($taxedWageBase)), __LINE__);
        }
        $this->taxedWageBase = $taxedWageBase;
        return $this;
    }
    /**
     * Get reportableWageBase value
     * @return float|null
     */
    public function getReportableWageBase()
    {
        return $this->reportableWageBase;
    }
    /**
     * Set reportableWageBase value
     * @param float $reportableWageBase
     * @return \StructType\PaycheckPayTax
     */
    public function setReportableWageBase($reportableWageBase = null)
    {
        // validation for constraint: float
        if (!is_null($reportableWageBase) && !(is_float($reportableWageBase) || is_numeric($reportableWageBase))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($reportableWageBase, true), gettype($reportableWageBase)), __LINE__);
        }
        $this->reportableWageBase = $reportableWageBase;
        return $this;
    }
    /**
     * Get isExempt value
     * @return bool|null
     */
    public function getIsExempt()
    {
        return $this->isExempt;
    }
    /**
     * Set isExempt value
     * @param bool $isExempt
     * @return \StructType\PaycheckPayTax
     */
    public function setIsExempt($isExempt = null)
    {
        // validation for constraint: boolean
        if (!is_null($isExempt) && !is_bool($isExempt)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isExempt, true), gettype($isExempt)), __LINE__);
        }
        $this->isExempt = $isExempt;
        return $this;
    }
    /**
     * Get isResidentTax value
     * @return bool|null
     */
    public function getIsResidentTax()
    {
        return $this->isResidentTax;
    }
    /**
     * Set isResidentTax value
     * @param bool $isResidentTax
     * @return \StructType\PaycheckPayTax
     */
    public function setIsResidentTax($isResidentTax = null)
    {
        // validation for constraint: boolean
        if (!is_null($isResidentTax) && !is_bool($isResidentTax)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isResidentTax, true), gettype($isResidentTax)), __LINE__);
        }
        $this->isResidentTax = $isResidentTax;
        return $this;
    }
    /**
     * Get amount value
     * @return float|null
     */
    public function getAmount()
    {
        return $this->amount;
    }
    /**
     * Set amount value
     * @param float $amount
     * @return \StructType\PaycheckPayTax
     */
    public function setAmount($amount = null)
    {
        // validation for constraint: float
        if (!is_null($amount) && !(is_float($amount) || is_numeric($amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($amount, true), gettype($amount)), __LINE__);
        }
        $this->amount = $amount;
        return $this;
    }
}
