<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PaycheckJournal StructType
 * @subpackage Structs
 */
class PaycheckJournal extends Record
{
    /**
     * The subsidiary
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $subsidiary;
    /**
     * The currency
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $currency;
    /**
     * The exchangeRate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $exchangeRate;
    /**
     * The createdDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $createdDate;
    /**
     * The lastModifiedDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $lastModifiedDate;
    /**
     * The customForm
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $customForm;
    /**
     * The tranId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $tranId;
    /**
     * The employee
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $employee;
    /**
     * The tranDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $tranDate;
    /**
     * The postingPeriod
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $postingPeriod;
    /**
     * The account
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $account;
    /**
     * The department
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $department;
    /**
     * The class
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $class;
    /**
     * The location
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $location;
    /**
     * The companyContributionList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\PaycheckJournalCompanyContributionList
     */
    public $companyContributionList;
    /**
     * The deductionList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\PaycheckJournalDeductionList
     */
    public $deductionList;
    /**
     * The employeeTaxList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\PaycheckJournalEmployeeTaxList
     */
    public $employeeTaxList;
    /**
     * The companyTaxList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\PaycheckJournalCompanyTaxList
     */
    public $companyTaxList;
    /**
     * The earningList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\PaycheckJournalEarningList
     */
    public $earningList;
    /**
     * The customFieldList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CustomFieldList
     */
    public $customFieldList;
    /**
     * The internalId
     * @var string
     */
    public $internalId;
    /**
     * The externalId
     * @var string
     */
    public $externalId;
    /**
     * Constructor method for PaycheckJournal
     * @uses PaycheckJournal::setSubsidiary()
     * @uses PaycheckJournal::setCurrency()
     * @uses PaycheckJournal::setExchangeRate()
     * @uses PaycheckJournal::setCreatedDate()
     * @uses PaycheckJournal::setLastModifiedDate()
     * @uses PaycheckJournal::setCustomForm()
     * @uses PaycheckJournal::setTranId()
     * @uses PaycheckJournal::setEmployee()
     * @uses PaycheckJournal::setTranDate()
     * @uses PaycheckJournal::setPostingPeriod()
     * @uses PaycheckJournal::setAccount()
     * @uses PaycheckJournal::setDepartment()
     * @uses PaycheckJournal::setClass()
     * @uses PaycheckJournal::setLocation()
     * @uses PaycheckJournal::setCompanyContributionList()
     * @uses PaycheckJournal::setDeductionList()
     * @uses PaycheckJournal::setEmployeeTaxList()
     * @uses PaycheckJournal::setCompanyTaxList()
     * @uses PaycheckJournal::setEarningList()
     * @uses PaycheckJournal::setCustomFieldList()
     * @uses PaycheckJournal::setInternalId()
     * @uses PaycheckJournal::setExternalId()
     * @param \StructType\RecordRef $subsidiary
     * @param \StructType\RecordRef $currency
     * @param float $exchangeRate
     * @param string $createdDate
     * @param string $lastModifiedDate
     * @param \StructType\RecordRef $customForm
     * @param string $tranId
     * @param \StructType\RecordRef $employee
     * @param string $tranDate
     * @param \StructType\RecordRef $postingPeriod
     * @param \StructType\RecordRef $account
     * @param \StructType\RecordRef $department
     * @param \StructType\RecordRef $class
     * @param \StructType\RecordRef $location
     * @param \StructType\PaycheckJournalCompanyContributionList $companyContributionList
     * @param \StructType\PaycheckJournalDeductionList $deductionList
     * @param \StructType\PaycheckJournalEmployeeTaxList $employeeTaxList
     * @param \StructType\PaycheckJournalCompanyTaxList $companyTaxList
     * @param \StructType\PaycheckJournalEarningList $earningList
     * @param \StructType\CustomFieldList $customFieldList
     * @param string $internalId
     * @param string $externalId
     */
    public function __construct(\StructType\RecordRef $subsidiary = null, \StructType\RecordRef $currency = null, $exchangeRate = null, $createdDate = null, $lastModifiedDate = null, \StructType\RecordRef $customForm = null, $tranId = null, \StructType\RecordRef $employee = null, $tranDate = null, \StructType\RecordRef $postingPeriod = null, \StructType\RecordRef $account = null, \StructType\RecordRef $department = null, \StructType\RecordRef $class = null, \StructType\RecordRef $location = null, \StructType\PaycheckJournalCompanyContributionList $companyContributionList = null, \StructType\PaycheckJournalDeductionList $deductionList = null, \StructType\PaycheckJournalEmployeeTaxList $employeeTaxList = null, \StructType\PaycheckJournalCompanyTaxList $companyTaxList = null, \StructType\PaycheckJournalEarningList $earningList = null, \StructType\CustomFieldList $customFieldList = null, $internalId = null, $externalId = null)
    {
        $this
            ->setSubsidiary($subsidiary)
            ->setCurrency($currency)
            ->setExchangeRate($exchangeRate)
            ->setCreatedDate($createdDate)
            ->setLastModifiedDate($lastModifiedDate)
            ->setCustomForm($customForm)
            ->setTranId($tranId)
            ->setEmployee($employee)
            ->setTranDate($tranDate)
            ->setPostingPeriod($postingPeriod)
            ->setAccount($account)
            ->setDepartment($department)
            ->setClass($class)
            ->setLocation($location)
            ->setCompanyContributionList($companyContributionList)
            ->setDeductionList($deductionList)
            ->setEmployeeTaxList($employeeTaxList)
            ->setCompanyTaxList($companyTaxList)
            ->setEarningList($earningList)
            ->setCustomFieldList($customFieldList)
            ->setInternalId($internalId)
            ->setExternalId($externalId);
    }
    /**
     * Get subsidiary value
     * @return \StructType\RecordRef|null
     */
    public function getSubsidiary()
    {
        return $this->subsidiary;
    }
    /**
     * Set subsidiary value
     * @param \StructType\RecordRef $subsidiary
     * @return \StructType\PaycheckJournal
     */
    public function setSubsidiary(\StructType\RecordRef $subsidiary = null)
    {
        $this->subsidiary = $subsidiary;
        return $this;
    }
    /**
     * Get currency value
     * @return \StructType\RecordRef|null
     */
    public function getCurrency()
    {
        return $this->currency;
    }
    /**
     * Set currency value
     * @param \StructType\RecordRef $currency
     * @return \StructType\PaycheckJournal
     */
    public function setCurrency(\StructType\RecordRef $currency = null)
    {
        $this->currency = $currency;
        return $this;
    }
    /**
     * Get exchangeRate value
     * @return float|null
     */
    public function getExchangeRate()
    {
        return $this->exchangeRate;
    }
    /**
     * Set exchangeRate value
     * @param float $exchangeRate
     * @return \StructType\PaycheckJournal
     */
    public function setExchangeRate($exchangeRate = null)
    {
        // validation for constraint: float
        if (!is_null($exchangeRate) && !(is_float($exchangeRate) || is_numeric($exchangeRate))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($exchangeRate, true), gettype($exchangeRate)), __LINE__);
        }
        $this->exchangeRate = $exchangeRate;
        return $this;
    }
    /**
     * Get createdDate value
     * @return string|null
     */
    public function getCreatedDate()
    {
        return $this->createdDate;
    }
    /**
     * Set createdDate value
     * @param string $createdDate
     * @return \StructType\PaycheckJournal
     */
    public function setCreatedDate($createdDate = null)
    {
        // validation for constraint: string
        if (!is_null($createdDate) && !is_string($createdDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createdDate, true), gettype($createdDate)), __LINE__);
        }
        $this->createdDate = $createdDate;
        return $this;
    }
    /**
     * Get lastModifiedDate value
     * @return string|null
     */
    public function getLastModifiedDate()
    {
        return $this->lastModifiedDate;
    }
    /**
     * Set lastModifiedDate value
     * @param string $lastModifiedDate
     * @return \StructType\PaycheckJournal
     */
    public function setLastModifiedDate($lastModifiedDate = null)
    {
        // validation for constraint: string
        if (!is_null($lastModifiedDate) && !is_string($lastModifiedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastModifiedDate, true), gettype($lastModifiedDate)), __LINE__);
        }
        $this->lastModifiedDate = $lastModifiedDate;
        return $this;
    }
    /**
     * Get customForm value
     * @return \StructType\RecordRef|null
     */
    public function getCustomForm()
    {
        return $this->customForm;
    }
    /**
     * Set customForm value
     * @param \StructType\RecordRef $customForm
     * @return \StructType\PaycheckJournal
     */
    public function setCustomForm(\StructType\RecordRef $customForm = null)
    {
        $this->customForm = $customForm;
        return $this;
    }
    /**
     * Get tranId value
     * @return string|null
     */
    public function getTranId()
    {
        return $this->tranId;
    }
    /**
     * Set tranId value
     * @param string $tranId
     * @return \StructType\PaycheckJournal
     */
    public function setTranId($tranId = null)
    {
        // validation for constraint: string
        if (!is_null($tranId) && !is_string($tranId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tranId, true), gettype($tranId)), __LINE__);
        }
        $this->tranId = $tranId;
        return $this;
    }
    /**
     * Get employee value
     * @return \StructType\RecordRef|null
     */
    public function getEmployee()
    {
        return $this->employee;
    }
    /**
     * Set employee value
     * @param \StructType\RecordRef $employee
     * @return \StructType\PaycheckJournal
     */
    public function setEmployee(\StructType\RecordRef $employee = null)
    {
        $this->employee = $employee;
        return $this;
    }
    /**
     * Get tranDate value
     * @return string|null
     */
    public function getTranDate()
    {
        return $this->tranDate;
    }
    /**
     * Set tranDate value
     * @param string $tranDate
     * @return \StructType\PaycheckJournal
     */
    public function setTranDate($tranDate = null)
    {
        // validation for constraint: string
        if (!is_null($tranDate) && !is_string($tranDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tranDate, true), gettype($tranDate)), __LINE__);
        }
        $this->tranDate = $tranDate;
        return $this;
    }
    /**
     * Get postingPeriod value
     * @return \StructType\RecordRef|null
     */
    public function getPostingPeriod()
    {
        return $this->postingPeriod;
    }
    /**
     * Set postingPeriod value
     * @param \StructType\RecordRef $postingPeriod
     * @return \StructType\PaycheckJournal
     */
    public function setPostingPeriod(\StructType\RecordRef $postingPeriod = null)
    {
        $this->postingPeriod = $postingPeriod;
        return $this;
    }
    /**
     * Get account value
     * @return \StructType\RecordRef|null
     */
    public function getAccount()
    {
        return $this->account;
    }
    /**
     * Set account value
     * @param \StructType\RecordRef $account
     * @return \StructType\PaycheckJournal
     */
    public function setAccount(\StructType\RecordRef $account = null)
    {
        $this->account = $account;
        return $this;
    }
    /**
     * Get department value
     * @return \StructType\RecordRef|null
     */
    public function getDepartment()
    {
        return $this->department;
    }
    /**
     * Set department value
     * @param \StructType\RecordRef $department
     * @return \StructType\PaycheckJournal
     */
    public function setDepartment(\StructType\RecordRef $department = null)
    {
        $this->department = $department;
        return $this;
    }
    /**
     * Get class value
     * @return \StructType\RecordRef|null
     */
    public function getClass()
    {
        return $this->class;
    }
    /**
     * Set class value
     * @param \StructType\RecordRef $class
     * @return \StructType\PaycheckJournal
     */
    public function setClass(\StructType\RecordRef $class = null)
    {
        $this->class = $class;
        return $this;
    }
    /**
     * Get location value
     * @return \StructType\RecordRef|null
     */
    public function getLocation()
    {
        return $this->location;
    }
    /**
     * Set location value
     * @param \StructType\RecordRef $location
     * @return \StructType\PaycheckJournal
     */
    public function setLocation(\StructType\RecordRef $location = null)
    {
        $this->location = $location;
        return $this;
    }
    /**
     * Get companyContributionList value
     * @return \StructType\PaycheckJournalCompanyContributionList|null
     */
    public function getCompanyContributionList()
    {
        return $this->companyContributionList;
    }
    /**
     * Set companyContributionList value
     * @param \StructType\PaycheckJournalCompanyContributionList $companyContributionList
     * @return \StructType\PaycheckJournal
     */
    public function setCompanyContributionList(\StructType\PaycheckJournalCompanyContributionList $companyContributionList = null)
    {
        $this->companyContributionList = $companyContributionList;
        return $this;
    }
    /**
     * Get deductionList value
     * @return \StructType\PaycheckJournalDeductionList|null
     */
    public function getDeductionList()
    {
        return $this->deductionList;
    }
    /**
     * Set deductionList value
     * @param \StructType\PaycheckJournalDeductionList $deductionList
     * @return \StructType\PaycheckJournal
     */
    public function setDeductionList(\StructType\PaycheckJournalDeductionList $deductionList = null)
    {
        $this->deductionList = $deductionList;
        return $this;
    }
    /**
     * Get employeeTaxList value
     * @return \StructType\PaycheckJournalEmployeeTaxList|null
     */
    public function getEmployeeTaxList()
    {
        return $this->employeeTaxList;
    }
    /**
     * Set employeeTaxList value
     * @param \StructType\PaycheckJournalEmployeeTaxList $employeeTaxList
     * @return \StructType\PaycheckJournal
     */
    public function setEmployeeTaxList(\StructType\PaycheckJournalEmployeeTaxList $employeeTaxList = null)
    {
        $this->employeeTaxList = $employeeTaxList;
        return $this;
    }
    /**
     * Get companyTaxList value
     * @return \StructType\PaycheckJournalCompanyTaxList|null
     */
    public function getCompanyTaxList()
    {
        return $this->companyTaxList;
    }
    /**
     * Set companyTaxList value
     * @param \StructType\PaycheckJournalCompanyTaxList $companyTaxList
     * @return \StructType\PaycheckJournal
     */
    public function setCompanyTaxList(\StructType\PaycheckJournalCompanyTaxList $companyTaxList = null)
    {
        $this->companyTaxList = $companyTaxList;
        return $this;
    }
    /**
     * Get earningList value
     * @return \StructType\PaycheckJournalEarningList|null
     */
    public function getEarningList()
    {
        return $this->earningList;
    }
    /**
     * Set earningList value
     * @param \StructType\PaycheckJournalEarningList $earningList
     * @return \StructType\PaycheckJournal
     */
    public function setEarningList(\StructType\PaycheckJournalEarningList $earningList = null)
    {
        $this->earningList = $earningList;
        return $this;
    }
    /**
     * Get customFieldList value
     * @return \StructType\CustomFieldList|null
     */
    public function getCustomFieldList()
    {
        return $this->customFieldList;
    }
    /**
     * Set customFieldList value
     * @param \StructType\CustomFieldList $customFieldList
     * @return \StructType\PaycheckJournal
     */
    public function setCustomFieldList(\StructType\CustomFieldList $customFieldList = null)
    {
        $this->customFieldList = $customFieldList;
        return $this;
    }
    /**
     * Get internalId value
     * @return string|null
     */
    public function getInternalId()
    {
        return $this->internalId;
    }
    /**
     * Set internalId value
     * @param string $internalId
     * @return \StructType\PaycheckJournal
     */
    public function setInternalId($internalId = null)
    {
        // validation for constraint: string
        if (!is_null($internalId) && !is_string($internalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($internalId, true), gettype($internalId)), __LINE__);
        }
        $this->internalId = $internalId;
        return $this;
    }
    /**
     * Get externalId value
     * @return string|null
     */
    public function getExternalId()
    {
        return $this->externalId;
    }
    /**
     * Set externalId value
     * @param string $externalId
     * @return \StructType\PaycheckJournal
     */
    public function setExternalId($externalId = null)
    {
        // validation for constraint: string
        if (!is_null($externalId) && !is_string($externalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($externalId, true), gettype($externalId)), __LINE__);
        }
        $this->externalId = $externalId;
        return $this;
    }
}
