<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Paycheck StructType
 * @subpackage Structs
 */
class Paycheck extends Record
{
    /**
     * The batchNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $batchNumber;
    /**
     * The createdDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $createdDate;
    /**
     * The lastModifiedDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $lastModifiedDate;
    /**
     * The status
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $status;
    /**
     * The entity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $entity;
    /**
     * The address
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $address;
    /**
     * The department
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $department;
    /**
     * The location
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $location;
    /**
     * The class
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $class;
    /**
     * The workplace
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $workplace;
    /**
     * The tranId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $tranId;
    /**
     * The userAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $userAmount;
    /**
     * The memo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $memo;
    /**
     * The account
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $account;
    /**
     * The payFrequency
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $payFrequency;
    /**
     * The balance
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $balance;
    /**
     * The tranDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $tranDate;
    /**
     * The postingPeriod
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $postingPeriod;
    /**
     * The periodEnding
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $periodEnding;
    /**
     * The payEarnList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\PaycheckPayEarnList
     */
    public $payEarnList;
    /**
     * The payTimeList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\PaycheckPayTimeList
     */
    public $payTimeList;
    /**
     * The payExpList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\PaycheckPayExpList
     */
    public $payExpList;
    /**
     * The payPtoList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\PaycheckPayPtoList
     */
    public $payPtoList;
    /**
     * The payDeductList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\PaycheckPayDeductList
     */
    public $payDeductList;
    /**
     * The payContribList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\PaycheckPayContribList
     */
    public $payContribList;
    /**
     * The payTaxList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\PaycheckPayTaxList
     */
    public $payTaxList;
    /**
     * The paySummaryList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\PaycheckPaySummaryList
     */
    public $paySummaryList;
    /**
     * The payDisburseList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\PaycheckPayDisburseList
     */
    public $payDisburseList;
    /**
     * The internalId
     * @var string
     */
    public $internalId;
    /**
     * The externalId
     * @var string
     */
    public $externalId;
    /**
     * Constructor method for Paycheck
     * @uses Paycheck::setBatchNumber()
     * @uses Paycheck::setCreatedDate()
     * @uses Paycheck::setLastModifiedDate()
     * @uses Paycheck::setStatus()
     * @uses Paycheck::setEntity()
     * @uses Paycheck::setAddress()
     * @uses Paycheck::setDepartment()
     * @uses Paycheck::setLocation()
     * @uses Paycheck::setClass()
     * @uses Paycheck::setWorkplace()
     * @uses Paycheck::setTranId()
     * @uses Paycheck::setUserAmount()
     * @uses Paycheck::setMemo()
     * @uses Paycheck::setAccount()
     * @uses Paycheck::setPayFrequency()
     * @uses Paycheck::setBalance()
     * @uses Paycheck::setTranDate()
     * @uses Paycheck::setPostingPeriod()
     * @uses Paycheck::setPeriodEnding()
     * @uses Paycheck::setPayEarnList()
     * @uses Paycheck::setPayTimeList()
     * @uses Paycheck::setPayExpList()
     * @uses Paycheck::setPayPtoList()
     * @uses Paycheck::setPayDeductList()
     * @uses Paycheck::setPayContribList()
     * @uses Paycheck::setPayTaxList()
     * @uses Paycheck::setPaySummaryList()
     * @uses Paycheck::setPayDisburseList()
     * @uses Paycheck::setInternalId()
     * @uses Paycheck::setExternalId()
     * @param string $batchNumber
     * @param string $createdDate
     * @param string $lastModifiedDate
     * @param string $status
     * @param \StructType\RecordRef $entity
     * @param string $address
     * @param \StructType\RecordRef $department
     * @param \StructType\RecordRef $location
     * @param \StructType\RecordRef $class
     * @param \StructType\RecordRef $workplace
     * @param string $tranId
     * @param float $userAmount
     * @param string $memo
     * @param \StructType\RecordRef $account
     * @param string $payFrequency
     * @param float $balance
     * @param string $tranDate
     * @param \StructType\RecordRef $postingPeriod
     * @param string $periodEnding
     * @param \StructType\PaycheckPayEarnList $payEarnList
     * @param \StructType\PaycheckPayTimeList $payTimeList
     * @param \StructType\PaycheckPayExpList $payExpList
     * @param \StructType\PaycheckPayPtoList $payPtoList
     * @param \StructType\PaycheckPayDeductList $payDeductList
     * @param \StructType\PaycheckPayContribList $payContribList
     * @param \StructType\PaycheckPayTaxList $payTaxList
     * @param \StructType\PaycheckPaySummaryList $paySummaryList
     * @param \StructType\PaycheckPayDisburseList $payDisburseList
     * @param string $internalId
     * @param string $externalId
     */
    public function __construct($batchNumber = null, $createdDate = null, $lastModifiedDate = null, $status = null, \StructType\RecordRef $entity = null, $address = null, \StructType\RecordRef $department = null, \StructType\RecordRef $location = null, \StructType\RecordRef $class = null, \StructType\RecordRef $workplace = null, $tranId = null, $userAmount = null, $memo = null, \StructType\RecordRef $account = null, $payFrequency = null, $balance = null, $tranDate = null, \StructType\RecordRef $postingPeriod = null, $periodEnding = null, \StructType\PaycheckPayEarnList $payEarnList = null, \StructType\PaycheckPayTimeList $payTimeList = null, \StructType\PaycheckPayExpList $payExpList = null, \StructType\PaycheckPayPtoList $payPtoList = null, \StructType\PaycheckPayDeductList $payDeductList = null, \StructType\PaycheckPayContribList $payContribList = null, \StructType\PaycheckPayTaxList $payTaxList = null, \StructType\PaycheckPaySummaryList $paySummaryList = null, \StructType\PaycheckPayDisburseList $payDisburseList = null, $internalId = null, $externalId = null)
    {
        $this
            ->setBatchNumber($batchNumber)
            ->setCreatedDate($createdDate)
            ->setLastModifiedDate($lastModifiedDate)
            ->setStatus($status)
            ->setEntity($entity)
            ->setAddress($address)
            ->setDepartment($department)
            ->setLocation($location)
            ->setClass($class)
            ->setWorkplace($workplace)
            ->setTranId($tranId)
            ->setUserAmount($userAmount)
            ->setMemo($memo)
            ->setAccount($account)
            ->setPayFrequency($payFrequency)
            ->setBalance($balance)
            ->setTranDate($tranDate)
            ->setPostingPeriod($postingPeriod)
            ->setPeriodEnding($periodEnding)
            ->setPayEarnList($payEarnList)
            ->setPayTimeList($payTimeList)
            ->setPayExpList($payExpList)
            ->setPayPtoList($payPtoList)
            ->setPayDeductList($payDeductList)
            ->setPayContribList($payContribList)
            ->setPayTaxList($payTaxList)
            ->setPaySummaryList($paySummaryList)
            ->setPayDisburseList($payDisburseList)
            ->setInternalId($internalId)
            ->setExternalId($externalId);
    }
    /**
     * Get batchNumber value
     * @return string|null
     */
    public function getBatchNumber()
    {
        return $this->batchNumber;
    }
    /**
     * Set batchNumber value
     * @param string $batchNumber
     * @return \StructType\Paycheck
     */
    public function setBatchNumber($batchNumber = null)
    {
        // validation for constraint: string
        if (!is_null($batchNumber) && !is_string($batchNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($batchNumber, true), gettype($batchNumber)), __LINE__);
        }
        $this->batchNumber = $batchNumber;
        return $this;
    }
    /**
     * Get createdDate value
     * @return string|null
     */
    public function getCreatedDate()
    {
        return $this->createdDate;
    }
    /**
     * Set createdDate value
     * @param string $createdDate
     * @return \StructType\Paycheck
     */
    public function setCreatedDate($createdDate = null)
    {
        // validation for constraint: string
        if (!is_null($createdDate) && !is_string($createdDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createdDate, true), gettype($createdDate)), __LINE__);
        }
        $this->createdDate = $createdDate;
        return $this;
    }
    /**
     * Get lastModifiedDate value
     * @return string|null
     */
    public function getLastModifiedDate()
    {
        return $this->lastModifiedDate;
    }
    /**
     * Set lastModifiedDate value
     * @param string $lastModifiedDate
     * @return \StructType\Paycheck
     */
    public function setLastModifiedDate($lastModifiedDate = null)
    {
        // validation for constraint: string
        if (!is_null($lastModifiedDate) && !is_string($lastModifiedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastModifiedDate, true), gettype($lastModifiedDate)), __LINE__);
        }
        $this->lastModifiedDate = $lastModifiedDate;
        return $this;
    }
    /**
     * Get status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->status;
    }
    /**
     * Set status value
     * @param string $status
     * @return \StructType\Paycheck
     */
    public function setStatus($status = null)
    {
        // validation for constraint: string
        if (!is_null($status) && !is_string($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($status, true), gettype($status)), __LINE__);
        }
        $this->status = $status;
        return $this;
    }
    /**
     * Get entity value
     * @return \StructType\RecordRef|null
     */
    public function getEntity()
    {
        return $this->entity;
    }
    /**
     * Set entity value
     * @param \StructType\RecordRef $entity
     * @return \StructType\Paycheck
     */
    public function setEntity(\StructType\RecordRef $entity = null)
    {
        $this->entity = $entity;
        return $this;
    }
    /**
     * Get address value
     * @return string|null
     */
    public function getAddress()
    {
        return $this->address;
    }
    /**
     * Set address value
     * @param string $address
     * @return \StructType\Paycheck
     */
    public function setAddress($address = null)
    {
        // validation for constraint: string
        if (!is_null($address) && !is_string($address)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($address, true), gettype($address)), __LINE__);
        }
        $this->address = $address;
        return $this;
    }
    /**
     * Get department value
     * @return \StructType\RecordRef|null
     */
    public function getDepartment()
    {
        return $this->department;
    }
    /**
     * Set department value
     * @param \StructType\RecordRef $department
     * @return \StructType\Paycheck
     */
    public function setDepartment(\StructType\RecordRef $department = null)
    {
        $this->department = $department;
        return $this;
    }
    /**
     * Get location value
     * @return \StructType\RecordRef|null
     */
    public function getLocation()
    {
        return $this->location;
    }
    /**
     * Set location value
     * @param \StructType\RecordRef $location
     * @return \StructType\Paycheck
     */
    public function setLocation(\StructType\RecordRef $location = null)
    {
        $this->location = $location;
        return $this;
    }
    /**
     * Get class value
     * @return \StructType\RecordRef|null
     */
    public function getClass()
    {
        return $this->class;
    }
    /**
     * Set class value
     * @param \StructType\RecordRef $class
     * @return \StructType\Paycheck
     */
    public function setClass(\StructType\RecordRef $class = null)
    {
        $this->class = $class;
        return $this;
    }
    /**
     * Get workplace value
     * @return \StructType\RecordRef|null
     */
    public function getWorkplace()
    {
        return $this->workplace;
    }
    /**
     * Set workplace value
     * @param \StructType\RecordRef $workplace
     * @return \StructType\Paycheck
     */
    public function setWorkplace(\StructType\RecordRef $workplace = null)
    {
        $this->workplace = $workplace;
        return $this;
    }
    /**
     * Get tranId value
     * @return string|null
     */
    public function getTranId()
    {
        return $this->tranId;
    }
    /**
     * Set tranId value
     * @param string $tranId
     * @return \StructType\Paycheck
     */
    public function setTranId($tranId = null)
    {
        // validation for constraint: string
        if (!is_null($tranId) && !is_string($tranId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tranId, true), gettype($tranId)), __LINE__);
        }
        $this->tranId = $tranId;
        return $this;
    }
    /**
     * Get userAmount value
     * @return float|null
     */
    public function getUserAmount()
    {
        return $this->userAmount;
    }
    /**
     * Set userAmount value
     * @param float $userAmount
     * @return \StructType\Paycheck
     */
    public function setUserAmount($userAmount = null)
    {
        // validation for constraint: float
        if (!is_null($userAmount) && !(is_float($userAmount) || is_numeric($userAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($userAmount, true), gettype($userAmount)), __LINE__);
        }
        $this->userAmount = $userAmount;
        return $this;
    }
    /**
     * Get memo value
     * @return string|null
     */
    public function getMemo()
    {
        return $this->memo;
    }
    /**
     * Set memo value
     * @param string $memo
     * @return \StructType\Paycheck
     */
    public function setMemo($memo = null)
    {
        // validation for constraint: string
        if (!is_null($memo) && !is_string($memo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($memo, true), gettype($memo)), __LINE__);
        }
        $this->memo = $memo;
        return $this;
    }
    /**
     * Get account value
     * @return \StructType\RecordRef|null
     */
    public function getAccount()
    {
        return $this->account;
    }
    /**
     * Set account value
     * @param \StructType\RecordRef $account
     * @return \StructType\Paycheck
     */
    public function setAccount(\StructType\RecordRef $account = null)
    {
        $this->account = $account;
        return $this;
    }
    /**
     * Get payFrequency value
     * @return string|null
     */
    public function getPayFrequency()
    {
        return $this->payFrequency;
    }
    /**
     * Set payFrequency value
     * @param string $payFrequency
     * @return \StructType\Paycheck
     */
    public function setPayFrequency($payFrequency = null)
    {
        // validation for constraint: string
        if (!is_null($payFrequency) && !is_string($payFrequency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($payFrequency, true), gettype($payFrequency)), __LINE__);
        }
        $this->payFrequency = $payFrequency;
        return $this;
    }
    /**
     * Get balance value
     * @return float|null
     */
    public function getBalance()
    {
        return $this->balance;
    }
    /**
     * Set balance value
     * @param float $balance
     * @return \StructType\Paycheck
     */
    public function setBalance($balance = null)
    {
        // validation for constraint: float
        if (!is_null($balance) && !(is_float($balance) || is_numeric($balance))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($balance, true), gettype($balance)), __LINE__);
        }
        $this->balance = $balance;
        return $this;
    }
    /**
     * Get tranDate value
     * @return string|null
     */
    public function getTranDate()
    {
        return $this->tranDate;
    }
    /**
     * Set tranDate value
     * @param string $tranDate
     * @return \StructType\Paycheck
     */
    public function setTranDate($tranDate = null)
    {
        // validation for constraint: string
        if (!is_null($tranDate) && !is_string($tranDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tranDate, true), gettype($tranDate)), __LINE__);
        }
        $this->tranDate = $tranDate;
        return $this;
    }
    /**
     * Get postingPeriod value
     * @return \StructType\RecordRef|null
     */
    public function getPostingPeriod()
    {
        return $this->postingPeriod;
    }
    /**
     * Set postingPeriod value
     * @param \StructType\RecordRef $postingPeriod
     * @return \StructType\Paycheck
     */
    public function setPostingPeriod(\StructType\RecordRef $postingPeriod = null)
    {
        $this->postingPeriod = $postingPeriod;
        return $this;
    }
    /**
     * Get periodEnding value
     * @return string|null
     */
    public function getPeriodEnding()
    {
        return $this->periodEnding;
    }
    /**
     * Set periodEnding value
     * @param string $periodEnding
     * @return \StructType\Paycheck
     */
    public function setPeriodEnding($periodEnding = null)
    {
        // validation for constraint: string
        if (!is_null($periodEnding) && !is_string($periodEnding)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($periodEnding, true), gettype($periodEnding)), __LINE__);
        }
        $this->periodEnding = $periodEnding;
        return $this;
    }
    /**
     * Get payEarnList value
     * @return \StructType\PaycheckPayEarnList|null
     */
    public function getPayEarnList()
    {
        return $this->payEarnList;
    }
    /**
     * Set payEarnList value
     * @param \StructType\PaycheckPayEarnList $payEarnList
     * @return \StructType\Paycheck
     */
    public function setPayEarnList(\StructType\PaycheckPayEarnList $payEarnList = null)
    {
        $this->payEarnList = $payEarnList;
        return $this;
    }
    /**
     * Get payTimeList value
     * @return \StructType\PaycheckPayTimeList|null
     */
    public function getPayTimeList()
    {
        return $this->payTimeList;
    }
    /**
     * Set payTimeList value
     * @param \StructType\PaycheckPayTimeList $payTimeList
     * @return \StructType\Paycheck
     */
    public function setPayTimeList(\StructType\PaycheckPayTimeList $payTimeList = null)
    {
        $this->payTimeList = $payTimeList;
        return $this;
    }
    /**
     * Get payExpList value
     * @return \StructType\PaycheckPayExpList|null
     */
    public function getPayExpList()
    {
        return $this->payExpList;
    }
    /**
     * Set payExpList value
     * @param \StructType\PaycheckPayExpList $payExpList
     * @return \StructType\Paycheck
     */
    public function setPayExpList(\StructType\PaycheckPayExpList $payExpList = null)
    {
        $this->payExpList = $payExpList;
        return $this;
    }
    /**
     * Get payPtoList value
     * @return \StructType\PaycheckPayPtoList|null
     */
    public function getPayPtoList()
    {
        return $this->payPtoList;
    }
    /**
     * Set payPtoList value
     * @param \StructType\PaycheckPayPtoList $payPtoList
     * @return \StructType\Paycheck
     */
    public function setPayPtoList(\StructType\PaycheckPayPtoList $payPtoList = null)
    {
        $this->payPtoList = $payPtoList;
        return $this;
    }
    /**
     * Get payDeductList value
     * @return \StructType\PaycheckPayDeductList|null
     */
    public function getPayDeductList()
    {
        return $this->payDeductList;
    }
    /**
     * Set payDeductList value
     * @param \StructType\PaycheckPayDeductList $payDeductList
     * @return \StructType\Paycheck
     */
    public function setPayDeductList(\StructType\PaycheckPayDeductList $payDeductList = null)
    {
        $this->payDeductList = $payDeductList;
        return $this;
    }
    /**
     * Get payContribList value
     * @return \StructType\PaycheckPayContribList|null
     */
    public function getPayContribList()
    {
        return $this->payContribList;
    }
    /**
     * Set payContribList value
     * @param \StructType\PaycheckPayContribList $payContribList
     * @return \StructType\Paycheck
     */
    public function setPayContribList(\StructType\PaycheckPayContribList $payContribList = null)
    {
        $this->payContribList = $payContribList;
        return $this;
    }
    /**
     * Get payTaxList value
     * @return \StructType\PaycheckPayTaxList|null
     */
    public function getPayTaxList()
    {
        return $this->payTaxList;
    }
    /**
     * Set payTaxList value
     * @param \StructType\PaycheckPayTaxList $payTaxList
     * @return \StructType\Paycheck
     */
    public function setPayTaxList(\StructType\PaycheckPayTaxList $payTaxList = null)
    {
        $this->payTaxList = $payTaxList;
        return $this;
    }
    /**
     * Get paySummaryList value
     * @return \StructType\PaycheckPaySummaryList|null
     */
    public function getPaySummaryList()
    {
        return $this->paySummaryList;
    }
    /**
     * Set paySummaryList value
     * @param \StructType\PaycheckPaySummaryList $paySummaryList
     * @return \StructType\Paycheck
     */
    public function setPaySummaryList(\StructType\PaycheckPaySummaryList $paySummaryList = null)
    {
        $this->paySummaryList = $paySummaryList;
        return $this;
    }
    /**
     * Get payDisburseList value
     * @return \StructType\PaycheckPayDisburseList|null
     */
    public function getPayDisburseList()
    {
        return $this->payDisburseList;
    }
    /**
     * Set payDisburseList value
     * @param \StructType\PaycheckPayDisburseList $payDisburseList
     * @return \StructType\Paycheck
     */
    public function setPayDisburseList(\StructType\PaycheckPayDisburseList $payDisburseList = null)
    {
        $this->payDisburseList = $payDisburseList;
        return $this;
    }
    /**
     * Get internalId value
     * @return string|null
     */
    public function getInternalId()
    {
        return $this->internalId;
    }
    /**
     * Set internalId value
     * @param string $internalId
     * @return \StructType\Paycheck
     */
    public function setInternalId($internalId = null)
    {
        // validation for constraint: string
        if (!is_null($internalId) && !is_string($internalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($internalId, true), gettype($internalId)), __LINE__);
        }
        $this->internalId = $internalId;
        return $this;
    }
    /**
     * Get externalId value
     * @return string|null
     */
    public function getExternalId()
    {
        return $this->externalId;
    }
    /**
     * Set externalId value
     * @param string $externalId
     * @return \StructType\Paycheck
     */
    public function setExternalId($externalId = null)
    {
        // validation for constraint: string
        if (!is_null($externalId) && !is_string($externalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($externalId, true), gettype($externalId)), __LINE__);
        }
        $this->externalId = $externalId;
        return $this;
    }
}
