<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Partners StructType
 * @subpackage Structs
 */
class Partners extends AbstractStructBase
{
    /**
     * The partner
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $partner;
    /**
     * The partnerRole
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $partnerRole;
    /**
     * The isPrimary
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $isPrimary;
    /**
     * The contribution
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $contribution;
    /**
     * Constructor method for Partners
     * @uses Partners::setPartner()
     * @uses Partners::setPartnerRole()
     * @uses Partners::setIsPrimary()
     * @uses Partners::setContribution()
     * @param \StructType\RecordRef $partner
     * @param \StructType\RecordRef $partnerRole
     * @param bool $isPrimary
     * @param float $contribution
     */
    public function __construct(\StructType\RecordRef $partner = null, \StructType\RecordRef $partnerRole = null, $isPrimary = null, $contribution = null)
    {
        $this
            ->setPartner($partner)
            ->setPartnerRole($partnerRole)
            ->setIsPrimary($isPrimary)
            ->setContribution($contribution);
    }
    /**
     * Get partner value
     * @return \StructType\RecordRef|null
     */
    public function getPartner()
    {
        return $this->partner;
    }
    /**
     * Set partner value
     * @param \StructType\RecordRef $partner
     * @return \StructType\Partners
     */
    public function setPartner(\StructType\RecordRef $partner = null)
    {
        $this->partner = $partner;
        return $this;
    }
    /**
     * Get partnerRole value
     * @return \StructType\RecordRef|null
     */
    public function getPartnerRole()
    {
        return $this->partnerRole;
    }
    /**
     * Set partnerRole value
     * @param \StructType\RecordRef $partnerRole
     * @return \StructType\Partners
     */
    public function setPartnerRole(\StructType\RecordRef $partnerRole = null)
    {
        $this->partnerRole = $partnerRole;
        return $this;
    }
    /**
     * Get isPrimary value
     * @return bool|null
     */
    public function getIsPrimary()
    {
        return $this->isPrimary;
    }
    /**
     * Set isPrimary value
     * @param bool $isPrimary
     * @return \StructType\Partners
     */
    public function setIsPrimary($isPrimary = null)
    {
        // validation for constraint: boolean
        if (!is_null($isPrimary) && !is_bool($isPrimary)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isPrimary, true), gettype($isPrimary)), __LINE__);
        }
        $this->isPrimary = $isPrimary;
        return $this;
    }
    /**
     * Get contribution value
     * @return float|null
     */
    public function getContribution()
    {
        return $this->contribution;
    }
    /**
     * Set contribution value
     * @param float $contribution
     * @return \StructType\Partners
     */
    public function setContribution($contribution = null)
    {
        // validation for constraint: float
        if (!is_null($contribution) && !(is_float($contribution) || is_numeric($contribution))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($contribution, true), gettype($contribution)), __LINE__);
        }
        $this->contribution = $contribution;
        return $this;
    }
}
