<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OtherChargeResaleItem StructType
 * Meta information extracted from the WSDL
 * - type: listAcct:OtherChargeResaleItem
 * @subpackage Structs
 */
class OtherChargeResaleItem extends Record
{
    /**
     * The createdDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $createdDate;
    /**
     * The lastModifiedDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $lastModifiedDate;
    /**
     * The purchaseDescription
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $purchaseDescription;
    /**
     * The manufacturingChargeItem
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $manufacturingChargeItem;
    /**
     * The cost
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $cost;
    /**
     * The costUnits
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $costUnits;
    /**
     * The expenseAccount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $expenseAccount;
    /**
     * The intercoExpenseAccount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $intercoExpenseAccount;
    /**
     * The salesDescription
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $salesDescription;
    /**
     * The includeChildren
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $includeChildren;
    /**
     * The incomeAccount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $incomeAccount;
    /**
     * The intercoIncomeAccount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $intercoIncomeAccount;
    /**
     * The isTaxable
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $isTaxable;
    /**
     * The matrixType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $matrixType;
    /**
     * The taxSchedule
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $taxSchedule;
    /**
     * The costEstimateType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $costEstimateType;
    /**
     * The costEstimate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $costEstimate;
    /**
     * The unitsType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $unitsType;
    /**
     * The purchaseUnit
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $purchaseUnit;
    /**
     * The saleUnit
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $saleUnit;
    /**
     * The costEstimateUnits
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $costEstimateUnits;
    /**
     * The issueProduct
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $issueProduct;
    /**
     * The billingSchedule
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $billingSchedule;
    /**
     * The deferredRevenueAccount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $deferredRevenueAccount;
    /**
     * The intercoDefRevAccount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $intercoDefRevAccount;
    /**
     * The revRecSchedule
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $revRecSchedule;
    /**
     * The deferralAccount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $deferralAccount;
    /**
     * The amortizationTemplate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $amortizationTemplate;
    /**
     * The residual
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $residual;
    /**
     * The deferRevRec
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $deferRevRec;
    /**
     * The revenueRecognitionRule
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $revenueRecognitionRule;
    /**
     * The revRecForecastRule
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $revRecForecastRule;
    /**
     * The revenueAllocationGroup
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $revenueAllocationGroup;
    /**
     * The createRevenuePlansOn
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $createRevenuePlansOn;
    /**
     * The directRevenuePosting
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $directRevenuePosting;
    /**
     * The contingentRevenueHandling
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $contingentRevenueHandling;
    /**
     * The revReclassFXAccount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $revReclassFXAccount;
    /**
     * The amortizationPeriod
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $amortizationPeriod;
    /**
     * The minimumQuantity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $minimumQuantity;
    /**
     * The minimumQuantityUnits
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $minimumQuantityUnits;
    /**
     * The enforceMinQtyInternally
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $enforceMinQtyInternally;
    /**
     * The maximumQuantity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $maximumQuantity;
    /**
     * The softDescriptor
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $softDescriptor;
    /**
     * The isFulfillable
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $isFulfillable;
    /**
     * The generateAccruals
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $generateAccruals;
    /**
     * The costCategory
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $costCategory;
    /**
     * The purchaseOrderQuantity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $purchaseOrderQuantity;
    /**
     * The purchaseOrderAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $purchaseOrderAmount;
    /**
     * The purchaseOrderQuantityDiff
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $purchaseOrderQuantityDiff;
    /**
     * The receiptQuantity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $receiptQuantity;
    /**
     * The receiptAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $receiptAmount;
    /**
     * The receiptQuantityDiff
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $receiptQuantityDiff;
    /**
     * The pricesIncludeTax
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $pricesIncludeTax;
    /**
     * The quantityPricingSchedule
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $quantityPricingSchedule;
    /**
     * The useMarginalRates
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $useMarginalRates;
    /**
     * The overallQuantityPricingType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $overallQuantityPricingType;
    /**
     * The pricingGroup
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $pricingGroup;
    /**
     * The customForm
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $customForm;
    /**
     * The itemId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $itemId;
    /**
     * The upcCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $upcCode;
    /**
     * The displayName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $displayName;
    /**
     * The vendorName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $vendorName;
    /**
     * The parent
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $parent;
    /**
     * The isOnline
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $isOnline;
    /**
     * The isGcoCompliant
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $isGcoCompliant;
    /**
     * The offerSupport
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $offerSupport;
    /**
     * The isInactive
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $isInactive;
    /**
     * The matrixItemNameTemplate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $matrixItemNameTemplate;
    /**
     * The availableToPartners
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $availableToPartners;
    /**
     * The department
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $department;
    /**
     * The class
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $class;
    /**
     * The location
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $location;
    /**
     * The subsidiaryList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRefList
     */
    public $subsidiaryList;
    /**
     * The vsoePrice
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $vsoePrice;
    /**
     * The vsoeSopGroup
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $vsoeSopGroup;
    /**
     * The vsoeDeferral
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $vsoeDeferral;
    /**
     * The vsoePermitDiscount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $vsoePermitDiscount;
    /**
     * The vsoeDelivered
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $vsoeDelivered;
    /**
     * The itemRevenueCategory
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $itemRevenueCategory;
    /**
     * The currency
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $currency;
    /**
     * The itemOptionsList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ItemOptionsList
     */
    public $itemOptionsList;
    /**
     * The matrixOptionList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\MatrixOptionList
     */
    public $matrixOptionList;
    /**
     * The itemVendorList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ItemVendorList
     */
    public $itemVendorList;
    /**
     * The pricingMatrix
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\PricingMatrix
     */
    public $pricingMatrix;
    /**
     * The accountingBookDetailList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ItemAccountingBookDetailList
     */
    public $accountingBookDetailList;
    /**
     * The purchaseTaxCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $purchaseTaxCode;
    /**
     * The rate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $rate;
    /**
     * The salesTaxCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $salesTaxCode;
    /**
     * The translationsList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\TranslationList
     */
    public $translationsList;
    /**
     * The vendor
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $vendor;
    /**
     * The hierarchyVersionsList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\OtherChargeResaleItemHierarchyVersionsList
     */
    public $hierarchyVersionsList;
    /**
     * The consumptionUnit
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $consumptionUnit;
    /**
     * The customFieldList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CustomFieldList
     */
    public $customFieldList;
    /**
     * The internalId
     * @var string
     */
    public $internalId;
    /**
     * The externalId
     * @var string
     */
    public $externalId;
    /**
     * Constructor method for OtherChargeResaleItem
     * @uses OtherChargeResaleItem::setCreatedDate()
     * @uses OtherChargeResaleItem::setLastModifiedDate()
     * @uses OtherChargeResaleItem::setPurchaseDescription()
     * @uses OtherChargeResaleItem::setManufacturingChargeItem()
     * @uses OtherChargeResaleItem::setCost()
     * @uses OtherChargeResaleItem::setCostUnits()
     * @uses OtherChargeResaleItem::setExpenseAccount()
     * @uses OtherChargeResaleItem::setIntercoExpenseAccount()
     * @uses OtherChargeResaleItem::setSalesDescription()
     * @uses OtherChargeResaleItem::setIncludeChildren()
     * @uses OtherChargeResaleItem::setIncomeAccount()
     * @uses OtherChargeResaleItem::setIntercoIncomeAccount()
     * @uses OtherChargeResaleItem::setIsTaxable()
     * @uses OtherChargeResaleItem::setMatrixType()
     * @uses OtherChargeResaleItem::setTaxSchedule()
     * @uses OtherChargeResaleItem::setCostEstimateType()
     * @uses OtherChargeResaleItem::setCostEstimate()
     * @uses OtherChargeResaleItem::setUnitsType()
     * @uses OtherChargeResaleItem::setPurchaseUnit()
     * @uses OtherChargeResaleItem::setSaleUnit()
     * @uses OtherChargeResaleItem::setCostEstimateUnits()
     * @uses OtherChargeResaleItem::setIssueProduct()
     * @uses OtherChargeResaleItem::setBillingSchedule()
     * @uses OtherChargeResaleItem::setDeferredRevenueAccount()
     * @uses OtherChargeResaleItem::setIntercoDefRevAccount()
     * @uses OtherChargeResaleItem::setRevRecSchedule()
     * @uses OtherChargeResaleItem::setDeferralAccount()
     * @uses OtherChargeResaleItem::setAmortizationTemplate()
     * @uses OtherChargeResaleItem::setResidual()
     * @uses OtherChargeResaleItem::setDeferRevRec()
     * @uses OtherChargeResaleItem::setRevenueRecognitionRule()
     * @uses OtherChargeResaleItem::setRevRecForecastRule()
     * @uses OtherChargeResaleItem::setRevenueAllocationGroup()
     * @uses OtherChargeResaleItem::setCreateRevenuePlansOn()
     * @uses OtherChargeResaleItem::setDirectRevenuePosting()
     * @uses OtherChargeResaleItem::setContingentRevenueHandling()
     * @uses OtherChargeResaleItem::setRevReclassFXAccount()
     * @uses OtherChargeResaleItem::setAmortizationPeriod()
     * @uses OtherChargeResaleItem::setMinimumQuantity()
     * @uses OtherChargeResaleItem::setMinimumQuantityUnits()
     * @uses OtherChargeResaleItem::setEnforceMinQtyInternally()
     * @uses OtherChargeResaleItem::setMaximumQuantity()
     * @uses OtherChargeResaleItem::setSoftDescriptor()
     * @uses OtherChargeResaleItem::setIsFulfillable()
     * @uses OtherChargeResaleItem::setGenerateAccruals()
     * @uses OtherChargeResaleItem::setCostCategory()
     * @uses OtherChargeResaleItem::setPurchaseOrderQuantity()
     * @uses OtherChargeResaleItem::setPurchaseOrderAmount()
     * @uses OtherChargeResaleItem::setPurchaseOrderQuantityDiff()
     * @uses OtherChargeResaleItem::setReceiptQuantity()
     * @uses OtherChargeResaleItem::setReceiptAmount()
     * @uses OtherChargeResaleItem::setReceiptQuantityDiff()
     * @uses OtherChargeResaleItem::setPricesIncludeTax()
     * @uses OtherChargeResaleItem::setQuantityPricingSchedule()
     * @uses OtherChargeResaleItem::setUseMarginalRates()
     * @uses OtherChargeResaleItem::setOverallQuantityPricingType()
     * @uses OtherChargeResaleItem::setPricingGroup()
     * @uses OtherChargeResaleItem::setCustomForm()
     * @uses OtherChargeResaleItem::setItemId()
     * @uses OtherChargeResaleItem::setUpcCode()
     * @uses OtherChargeResaleItem::setDisplayName()
     * @uses OtherChargeResaleItem::setVendorName()
     * @uses OtherChargeResaleItem::setParent()
     * @uses OtherChargeResaleItem::setIsOnline()
     * @uses OtherChargeResaleItem::setIsGcoCompliant()
     * @uses OtherChargeResaleItem::setOfferSupport()
     * @uses OtherChargeResaleItem::setIsInactive()
     * @uses OtherChargeResaleItem::setMatrixItemNameTemplate()
     * @uses OtherChargeResaleItem::setAvailableToPartners()
     * @uses OtherChargeResaleItem::setDepartment()
     * @uses OtherChargeResaleItem::setClass()
     * @uses OtherChargeResaleItem::setLocation()
     * @uses OtherChargeResaleItem::setSubsidiaryList()
     * @uses OtherChargeResaleItem::setVsoePrice()
     * @uses OtherChargeResaleItem::setVsoeSopGroup()
     * @uses OtherChargeResaleItem::setVsoeDeferral()
     * @uses OtherChargeResaleItem::setVsoePermitDiscount()
     * @uses OtherChargeResaleItem::setVsoeDelivered()
     * @uses OtherChargeResaleItem::setItemRevenueCategory()
     * @uses OtherChargeResaleItem::setCurrency()
     * @uses OtherChargeResaleItem::setItemOptionsList()
     * @uses OtherChargeResaleItem::setMatrixOptionList()
     * @uses OtherChargeResaleItem::setItemVendorList()
     * @uses OtherChargeResaleItem::setPricingMatrix()
     * @uses OtherChargeResaleItem::setAccountingBookDetailList()
     * @uses OtherChargeResaleItem::setPurchaseTaxCode()
     * @uses OtherChargeResaleItem::setRate()
     * @uses OtherChargeResaleItem::setSalesTaxCode()
     * @uses OtherChargeResaleItem::setTranslationsList()
     * @uses OtherChargeResaleItem::setVendor()
     * @uses OtherChargeResaleItem::setHierarchyVersionsList()
     * @uses OtherChargeResaleItem::setConsumptionUnit()
     * @uses OtherChargeResaleItem::setCustomFieldList()
     * @uses OtherChargeResaleItem::setInternalId()
     * @uses OtherChargeResaleItem::setExternalId()
     * @param string $createdDate
     * @param string $lastModifiedDate
     * @param string $purchaseDescription
     * @param bool $manufacturingChargeItem
     * @param float $cost
     * @param string $costUnits
     * @param \StructType\RecordRef $expenseAccount
     * @param \StructType\RecordRef $intercoExpenseAccount
     * @param string $salesDescription
     * @param bool $includeChildren
     * @param \StructType\RecordRef $incomeAccount
     * @param \StructType\RecordRef $intercoIncomeAccount
     * @param bool $isTaxable
     * @param string $matrixType
     * @param \StructType\RecordRef $taxSchedule
     * @param string $costEstimateType
     * @param float $costEstimate
     * @param \StructType\RecordRef $unitsType
     * @param \StructType\RecordRef $purchaseUnit
     * @param \StructType\RecordRef $saleUnit
     * @param string $costEstimateUnits
     * @param \StructType\RecordRef $issueProduct
     * @param \StructType\RecordRef $billingSchedule
     * @param \StructType\RecordRef $deferredRevenueAccount
     * @param \StructType\RecordRef $intercoDefRevAccount
     * @param \StructType\RecordRef $revRecSchedule
     * @param \StructType\RecordRef $deferralAccount
     * @param \StructType\RecordRef $amortizationTemplate
     * @param string $residual
     * @param bool $deferRevRec
     * @param \StructType\RecordRef $revenueRecognitionRule
     * @param \StructType\RecordRef $revRecForecastRule
     * @param \StructType\RecordRef $revenueAllocationGroup
     * @param \StructType\RecordRef $createRevenuePlansOn
     * @param bool $directRevenuePosting
     * @param bool $contingentRevenueHandling
     * @param \StructType\RecordRef $revReclassFXAccount
     * @param int $amortizationPeriod
     * @param int $minimumQuantity
     * @param string $minimumQuantityUnits
     * @param bool $enforceMinQtyInternally
     * @param int $maximumQuantity
     * @param string $softDescriptor
     * @param bool $isFulfillable
     * @param bool $generateAccruals
     * @param \StructType\RecordRef $costCategory
     * @param float $purchaseOrderQuantity
     * @param float $purchaseOrderAmount
     * @param float $purchaseOrderQuantityDiff
     * @param float $receiptQuantity
     * @param float $receiptAmount
     * @param float $receiptQuantityDiff
     * @param bool $pricesIncludeTax
     * @param \StructType\RecordRef $quantityPricingSchedule
     * @param bool $useMarginalRates
     * @param string $overallQuantityPricingType
     * @param \StructType\RecordRef $pricingGroup
     * @param \StructType\RecordRef $customForm
     * @param string $itemId
     * @param string $upcCode
     * @param string $displayName
     * @param string $vendorName
     * @param \StructType\RecordRef $parent
     * @param bool $isOnline
     * @param bool $isGcoCompliant
     * @param bool $offerSupport
     * @param bool $isInactive
     * @param string $matrixItemNameTemplate
     * @param bool $availableToPartners
     * @param \StructType\RecordRef $department
     * @param \StructType\RecordRef $class
     * @param \StructType\RecordRef $location
     * @param \StructType\RecordRefList $subsidiaryList
     * @param float $vsoePrice
     * @param string $vsoeSopGroup
     * @param string $vsoeDeferral
     * @param string $vsoePermitDiscount
     * @param bool $vsoeDelivered
     * @param \StructType\RecordRef $itemRevenueCategory
     * @param string $currency
     * @param \StructType\ItemOptionsList $itemOptionsList
     * @param \StructType\MatrixOptionList $matrixOptionList
     * @param \StructType\ItemVendorList $itemVendorList
     * @param \StructType\PricingMatrix $pricingMatrix
     * @param \StructType\ItemAccountingBookDetailList $accountingBookDetailList
     * @param \StructType\RecordRef $purchaseTaxCode
     * @param float $rate
     * @param \StructType\RecordRef $salesTaxCode
     * @param \StructType\TranslationList $translationsList
     * @param \StructType\RecordRef $vendor
     * @param \StructType\OtherChargeResaleItemHierarchyVersionsList $hierarchyVersionsList
     * @param \StructType\RecordRef $consumptionUnit
     * @param \StructType\CustomFieldList $customFieldList
     * @param string $internalId
     * @param string $externalId
     */
    public function __construct($createdDate = null, $lastModifiedDate = null, $purchaseDescription = null, $manufacturingChargeItem = null, $cost = null, $costUnits = null, \StructType\RecordRef $expenseAccount = null, \StructType\RecordRef $intercoExpenseAccount = null, $salesDescription = null, $includeChildren = null, \StructType\RecordRef $incomeAccount = null, \StructType\RecordRef $intercoIncomeAccount = null, $isTaxable = null, $matrixType = null, \StructType\RecordRef $taxSchedule = null, $costEstimateType = null, $costEstimate = null, \StructType\RecordRef $unitsType = null, \StructType\RecordRef $purchaseUnit = null, \StructType\RecordRef $saleUnit = null, $costEstimateUnits = null, \StructType\RecordRef $issueProduct = null, \StructType\RecordRef $billingSchedule = null, \StructType\RecordRef $deferredRevenueAccount = null, \StructType\RecordRef $intercoDefRevAccount = null, \StructType\RecordRef $revRecSchedule = null, \StructType\RecordRef $deferralAccount = null, \StructType\RecordRef $amortizationTemplate = null, $residual = null, $deferRevRec = null, \StructType\RecordRef $revenueRecognitionRule = null, \StructType\RecordRef $revRecForecastRule = null, \StructType\RecordRef $revenueAllocationGroup = null, \StructType\RecordRef $createRevenuePlansOn = null, $directRevenuePosting = null, $contingentRevenueHandling = null, \StructType\RecordRef $revReclassFXAccount = null, $amortizationPeriod = null, $minimumQuantity = null, $minimumQuantityUnits = null, $enforceMinQtyInternally = null, $maximumQuantity = null, $softDescriptor = null, $isFulfillable = null, $generateAccruals = null, \StructType\RecordRef $costCategory = null, $purchaseOrderQuantity = null, $purchaseOrderAmount = null, $purchaseOrderQuantityDiff = null, $receiptQuantity = null, $receiptAmount = null, $receiptQuantityDiff = null, $pricesIncludeTax = null, \StructType\RecordRef $quantityPricingSchedule = null, $useMarginalRates = null, $overallQuantityPricingType = null, \StructType\RecordRef $pricingGroup = null, \StructType\RecordRef $customForm = null, $itemId = null, $upcCode = null, $displayName = null, $vendorName = null, \StructType\RecordRef $parent = null, $isOnline = null, $isGcoCompliant = null, $offerSupport = null, $isInactive = null, $matrixItemNameTemplate = null, $availableToPartners = null, \StructType\RecordRef $department = null, \StructType\RecordRef $class = null, \StructType\RecordRef $location = null, \StructType\RecordRefList $subsidiaryList = null, $vsoePrice = null, $vsoeSopGroup = null, $vsoeDeferral = null, $vsoePermitDiscount = null, $vsoeDelivered = null, \StructType\RecordRef $itemRevenueCategory = null, $currency = null, \StructType\ItemOptionsList $itemOptionsList = null, \StructType\MatrixOptionList $matrixOptionList = null, \StructType\ItemVendorList $itemVendorList = null, \StructType\PricingMatrix $pricingMatrix = null, \StructType\ItemAccountingBookDetailList $accountingBookDetailList = null, \StructType\RecordRef $purchaseTaxCode = null, $rate = null, \StructType\RecordRef $salesTaxCode = null, \StructType\TranslationList $translationsList = null, \StructType\RecordRef $vendor = null, \StructType\OtherChargeResaleItemHierarchyVersionsList $hierarchyVersionsList = null, \StructType\RecordRef $consumptionUnit = null, \StructType\CustomFieldList $customFieldList = null, $internalId = null, $externalId = null)
    {
        $this
            ->setCreatedDate($createdDate)
            ->setLastModifiedDate($lastModifiedDate)
            ->setPurchaseDescription($purchaseDescription)
            ->setManufacturingChargeItem($manufacturingChargeItem)
            ->setCost($cost)
            ->setCostUnits($costUnits)
            ->setExpenseAccount($expenseAccount)
            ->setIntercoExpenseAccount($intercoExpenseAccount)
            ->setSalesDescription($salesDescription)
            ->setIncludeChildren($includeChildren)
            ->setIncomeAccount($incomeAccount)
            ->setIntercoIncomeAccount($intercoIncomeAccount)
            ->setIsTaxable($isTaxable)
            ->setMatrixType($matrixType)
            ->setTaxSchedule($taxSchedule)
            ->setCostEstimateType($costEstimateType)
            ->setCostEstimate($costEstimate)
            ->setUnitsType($unitsType)
            ->setPurchaseUnit($purchaseUnit)
            ->setSaleUnit($saleUnit)
            ->setCostEstimateUnits($costEstimateUnits)
            ->setIssueProduct($issueProduct)
            ->setBillingSchedule($billingSchedule)
            ->setDeferredRevenueAccount($deferredRevenueAccount)
            ->setIntercoDefRevAccount($intercoDefRevAccount)
            ->setRevRecSchedule($revRecSchedule)
            ->setDeferralAccount($deferralAccount)
            ->setAmortizationTemplate($amortizationTemplate)
            ->setResidual($residual)
            ->setDeferRevRec($deferRevRec)
            ->setRevenueRecognitionRule($revenueRecognitionRule)
            ->setRevRecForecastRule($revRecForecastRule)
            ->setRevenueAllocationGroup($revenueAllocationGroup)
            ->setCreateRevenuePlansOn($createRevenuePlansOn)
            ->setDirectRevenuePosting($directRevenuePosting)
            ->setContingentRevenueHandling($contingentRevenueHandling)
            ->setRevReclassFXAccount($revReclassFXAccount)
            ->setAmortizationPeriod($amortizationPeriod)
            ->setMinimumQuantity($minimumQuantity)
            ->setMinimumQuantityUnits($minimumQuantityUnits)
            ->setEnforceMinQtyInternally($enforceMinQtyInternally)
            ->setMaximumQuantity($maximumQuantity)
            ->setSoftDescriptor($softDescriptor)
            ->setIsFulfillable($isFulfillable)
            ->setGenerateAccruals($generateAccruals)
            ->setCostCategory($costCategory)
            ->setPurchaseOrderQuantity($purchaseOrderQuantity)
            ->setPurchaseOrderAmount($purchaseOrderAmount)
            ->setPurchaseOrderQuantityDiff($purchaseOrderQuantityDiff)
            ->setReceiptQuantity($receiptQuantity)
            ->setReceiptAmount($receiptAmount)
            ->setReceiptQuantityDiff($receiptQuantityDiff)
            ->setPricesIncludeTax($pricesIncludeTax)
            ->setQuantityPricingSchedule($quantityPricingSchedule)
            ->setUseMarginalRates($useMarginalRates)
            ->setOverallQuantityPricingType($overallQuantityPricingType)
            ->setPricingGroup($pricingGroup)
            ->setCustomForm($customForm)
            ->setItemId($itemId)
            ->setUpcCode($upcCode)
            ->setDisplayName($displayName)
            ->setVendorName($vendorName)
            ->setParent($parent)
            ->setIsOnline($isOnline)
            ->setIsGcoCompliant($isGcoCompliant)
            ->setOfferSupport($offerSupport)
            ->setIsInactive($isInactive)
            ->setMatrixItemNameTemplate($matrixItemNameTemplate)
            ->setAvailableToPartners($availableToPartners)
            ->setDepartment($department)
            ->setClass($class)
            ->setLocation($location)
            ->setSubsidiaryList($subsidiaryList)
            ->setVsoePrice($vsoePrice)
            ->setVsoeSopGroup($vsoeSopGroup)
            ->setVsoeDeferral($vsoeDeferral)
            ->setVsoePermitDiscount($vsoePermitDiscount)
            ->setVsoeDelivered($vsoeDelivered)
            ->setItemRevenueCategory($itemRevenueCategory)
            ->setCurrency($currency)
            ->setItemOptionsList($itemOptionsList)
            ->setMatrixOptionList($matrixOptionList)
            ->setItemVendorList($itemVendorList)
            ->setPricingMatrix($pricingMatrix)
            ->setAccountingBookDetailList($accountingBookDetailList)
            ->setPurchaseTaxCode($purchaseTaxCode)
            ->setRate($rate)
            ->setSalesTaxCode($salesTaxCode)
            ->setTranslationsList($translationsList)
            ->setVendor($vendor)
            ->setHierarchyVersionsList($hierarchyVersionsList)
            ->setConsumptionUnit($consumptionUnit)
            ->setCustomFieldList($customFieldList)
            ->setInternalId($internalId)
            ->setExternalId($externalId);
    }
    /**
     * Get createdDate value
     * @return string|null
     */
    public function getCreatedDate()
    {
        return $this->createdDate;
    }
    /**
     * Set createdDate value
     * @param string $createdDate
     * @return \StructType\OtherChargeResaleItem
     */
    public function setCreatedDate($createdDate = null)
    {
        // validation for constraint: string
        if (!is_null($createdDate) && !is_string($createdDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createdDate, true), gettype($createdDate)), __LINE__);
        }
        $this->createdDate = $createdDate;
        return $this;
    }
    /**
     * Get lastModifiedDate value
     * @return string|null
     */
    public function getLastModifiedDate()
    {
        return $this->lastModifiedDate;
    }
    /**
     * Set lastModifiedDate value
     * @param string $lastModifiedDate
     * @return \StructType\OtherChargeResaleItem
     */
    public function setLastModifiedDate($lastModifiedDate = null)
    {
        // validation for constraint: string
        if (!is_null($lastModifiedDate) && !is_string($lastModifiedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastModifiedDate, true), gettype($lastModifiedDate)), __LINE__);
        }
        $this->lastModifiedDate = $lastModifiedDate;
        return $this;
    }
    /**
     * Get purchaseDescription value
     * @return string|null
     */
    public function getPurchaseDescription()
    {
        return $this->purchaseDescription;
    }
    /**
     * Set purchaseDescription value
     * @param string $purchaseDescription
     * @return \StructType\OtherChargeResaleItem
     */
    public function setPurchaseDescription($purchaseDescription = null)
    {
        // validation for constraint: string
        if (!is_null($purchaseDescription) && !is_string($purchaseDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($purchaseDescription, true), gettype($purchaseDescription)), __LINE__);
        }
        $this->purchaseDescription = $purchaseDescription;
        return $this;
    }
    /**
     * Get manufacturingChargeItem value
     * @return bool|null
     */
    public function getManufacturingChargeItem()
    {
        return $this->manufacturingChargeItem;
    }
    /**
     * Set manufacturingChargeItem value
     * @param bool $manufacturingChargeItem
     * @return \StructType\OtherChargeResaleItem
     */
    public function setManufacturingChargeItem($manufacturingChargeItem = null)
    {
        // validation for constraint: boolean
        if (!is_null($manufacturingChargeItem) && !is_bool($manufacturingChargeItem)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($manufacturingChargeItem, true), gettype($manufacturingChargeItem)), __LINE__);
        }
        $this->manufacturingChargeItem = $manufacturingChargeItem;
        return $this;
    }
    /**
     * Get cost value
     * @return float|null
     */
    public function getCost()
    {
        return $this->cost;
    }
    /**
     * Set cost value
     * @param float $cost
     * @return \StructType\OtherChargeResaleItem
     */
    public function setCost($cost = null)
    {
        // validation for constraint: float
        if (!is_null($cost) && !(is_float($cost) || is_numeric($cost))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($cost, true), gettype($cost)), __LINE__);
        }
        $this->cost = $cost;
        return $this;
    }
    /**
     * Get costUnits value
     * @return string|null
     */
    public function getCostUnits()
    {
        return $this->costUnits;
    }
    /**
     * Set costUnits value
     * @param string $costUnits
     * @return \StructType\OtherChargeResaleItem
     */
    public function setCostUnits($costUnits = null)
    {
        // validation for constraint: string
        if (!is_null($costUnits) && !is_string($costUnits)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($costUnits, true), gettype($costUnits)), __LINE__);
        }
        $this->costUnits = $costUnits;
        return $this;
    }
    /**
     * Get expenseAccount value
     * @return \StructType\RecordRef|null
     */
    public function getExpenseAccount()
    {
        return $this->expenseAccount;
    }
    /**
     * Set expenseAccount value
     * @param \StructType\RecordRef $expenseAccount
     * @return \StructType\OtherChargeResaleItem
     */
    public function setExpenseAccount(\StructType\RecordRef $expenseAccount = null)
    {
        $this->expenseAccount = $expenseAccount;
        return $this;
    }
    /**
     * Get intercoExpenseAccount value
     * @return \StructType\RecordRef|null
     */
    public function getIntercoExpenseAccount()
    {
        return $this->intercoExpenseAccount;
    }
    /**
     * Set intercoExpenseAccount value
     * @param \StructType\RecordRef $intercoExpenseAccount
     * @return \StructType\OtherChargeResaleItem
     */
    public function setIntercoExpenseAccount(\StructType\RecordRef $intercoExpenseAccount = null)
    {
        $this->intercoExpenseAccount = $intercoExpenseAccount;
        return $this;
    }
    /**
     * Get salesDescription value
     * @return string|null
     */
    public function getSalesDescription()
    {
        return $this->salesDescription;
    }
    /**
     * Set salesDescription value
     * @param string $salesDescription
     * @return \StructType\OtherChargeResaleItem
     */
    public function setSalesDescription($salesDescription = null)
    {
        // validation for constraint: string
        if (!is_null($salesDescription) && !is_string($salesDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($salesDescription, true), gettype($salesDescription)), __LINE__);
        }
        $this->salesDescription = $salesDescription;
        return $this;
    }
    /**
     * Get includeChildren value
     * @return bool|null
     */
    public function getIncludeChildren()
    {
        return $this->includeChildren;
    }
    /**
     * Set includeChildren value
     * @param bool $includeChildren
     * @return \StructType\OtherChargeResaleItem
     */
    public function setIncludeChildren($includeChildren = null)
    {
        // validation for constraint: boolean
        if (!is_null($includeChildren) && !is_bool($includeChildren)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($includeChildren, true), gettype($includeChildren)), __LINE__);
        }
        $this->includeChildren = $includeChildren;
        return $this;
    }
    /**
     * Get incomeAccount value
     * @return \StructType\RecordRef|null
     */
    public function getIncomeAccount()
    {
        return $this->incomeAccount;
    }
    /**
     * Set incomeAccount value
     * @param \StructType\RecordRef $incomeAccount
     * @return \StructType\OtherChargeResaleItem
     */
    public function setIncomeAccount(\StructType\RecordRef $incomeAccount = null)
    {
        $this->incomeAccount = $incomeAccount;
        return $this;
    }
    /**
     * Get intercoIncomeAccount value
     * @return \StructType\RecordRef|null
     */
    public function getIntercoIncomeAccount()
    {
        return $this->intercoIncomeAccount;
    }
    /**
     * Set intercoIncomeAccount value
     * @param \StructType\RecordRef $intercoIncomeAccount
     * @return \StructType\OtherChargeResaleItem
     */
    public function setIntercoIncomeAccount(\StructType\RecordRef $intercoIncomeAccount = null)
    {
        $this->intercoIncomeAccount = $intercoIncomeAccount;
        return $this;
    }
    /**
     * Get isTaxable value
     * @return bool|null
     */
    public function getIsTaxable()
    {
        return $this->isTaxable;
    }
    /**
     * Set isTaxable value
     * @param bool $isTaxable
     * @return \StructType\OtherChargeResaleItem
     */
    public function setIsTaxable($isTaxable = null)
    {
        // validation for constraint: boolean
        if (!is_null($isTaxable) && !is_bool($isTaxable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isTaxable, true), gettype($isTaxable)), __LINE__);
        }
        $this->isTaxable = $isTaxable;
        return $this;
    }
    /**
     * Get matrixType value
     * @return string|null
     */
    public function getMatrixType()
    {
        return $this->matrixType;
    }
    /**
     * Set matrixType value
     * @uses \EnumType\ItemMatrixType::valueIsValid()
     * @uses \EnumType\ItemMatrixType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $matrixType
     * @return \StructType\OtherChargeResaleItem
     */
    public function setMatrixType($matrixType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ItemMatrixType::valueIsValid($matrixType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\ItemMatrixType', is_array($matrixType) ? implode(', ', $matrixType) : var_export($matrixType, true), implode(', ', \EnumType\ItemMatrixType::getValidValues())), __LINE__);
        }
        $this->matrixType = $matrixType;
        return $this;
    }
    /**
     * Get taxSchedule value
     * @return \StructType\RecordRef|null
     */
    public function getTaxSchedule()
    {
        return $this->taxSchedule;
    }
    /**
     * Set taxSchedule value
     * @param \StructType\RecordRef $taxSchedule
     * @return \StructType\OtherChargeResaleItem
     */
    public function setTaxSchedule(\StructType\RecordRef $taxSchedule = null)
    {
        $this->taxSchedule = $taxSchedule;
        return $this;
    }
    /**
     * Get costEstimateType value
     * @return string|null
     */
    public function getCostEstimateType()
    {
        return $this->costEstimateType;
    }
    /**
     * Set costEstimateType value
     * @uses \EnumType\ItemCostEstimateType::valueIsValid()
     * @uses \EnumType\ItemCostEstimateType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $costEstimateType
     * @return \StructType\OtherChargeResaleItem
     */
    public function setCostEstimateType($costEstimateType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ItemCostEstimateType::valueIsValid($costEstimateType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\ItemCostEstimateType', is_array($costEstimateType) ? implode(', ', $costEstimateType) : var_export($costEstimateType, true), implode(', ', \EnumType\ItemCostEstimateType::getValidValues())), __LINE__);
        }
        $this->costEstimateType = $costEstimateType;
        return $this;
    }
    /**
     * Get costEstimate value
     * @return float|null
     */
    public function getCostEstimate()
    {
        return $this->costEstimate;
    }
    /**
     * Set costEstimate value
     * @param float $costEstimate
     * @return \StructType\OtherChargeResaleItem
     */
    public function setCostEstimate($costEstimate = null)
    {
        // validation for constraint: float
        if (!is_null($costEstimate) && !(is_float($costEstimate) || is_numeric($costEstimate))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($costEstimate, true), gettype($costEstimate)), __LINE__);
        }
        $this->costEstimate = $costEstimate;
        return $this;
    }
    /**
     * Get unitsType value
     * @return \StructType\RecordRef|null
     */
    public function getUnitsType()
    {
        return $this->unitsType;
    }
    /**
     * Set unitsType value
     * @param \StructType\RecordRef $unitsType
     * @return \StructType\OtherChargeResaleItem
     */
    public function setUnitsType(\StructType\RecordRef $unitsType = null)
    {
        $this->unitsType = $unitsType;
        return $this;
    }
    /**
     * Get purchaseUnit value
     * @return \StructType\RecordRef|null
     */
    public function getPurchaseUnit()
    {
        return $this->purchaseUnit;
    }
    /**
     * Set purchaseUnit value
     * @param \StructType\RecordRef $purchaseUnit
     * @return \StructType\OtherChargeResaleItem
     */
    public function setPurchaseUnit(\StructType\RecordRef $purchaseUnit = null)
    {
        $this->purchaseUnit = $purchaseUnit;
        return $this;
    }
    /**
     * Get saleUnit value
     * @return \StructType\RecordRef|null
     */
    public function getSaleUnit()
    {
        return $this->saleUnit;
    }
    /**
     * Set saleUnit value
     * @param \StructType\RecordRef $saleUnit
     * @return \StructType\OtherChargeResaleItem
     */
    public function setSaleUnit(\StructType\RecordRef $saleUnit = null)
    {
        $this->saleUnit = $saleUnit;
        return $this;
    }
    /**
     * Get costEstimateUnits value
     * @return string|null
     */
    public function getCostEstimateUnits()
    {
        return $this->costEstimateUnits;
    }
    /**
     * Set costEstimateUnits value
     * @param string $costEstimateUnits
     * @return \StructType\OtherChargeResaleItem
     */
    public function setCostEstimateUnits($costEstimateUnits = null)
    {
        // validation for constraint: string
        if (!is_null($costEstimateUnits) && !is_string($costEstimateUnits)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($costEstimateUnits, true), gettype($costEstimateUnits)), __LINE__);
        }
        $this->costEstimateUnits = $costEstimateUnits;
        return $this;
    }
    /**
     * Get issueProduct value
     * @return \StructType\RecordRef|null
     */
    public function getIssueProduct()
    {
        return $this->issueProduct;
    }
    /**
     * Set issueProduct value
     * @param \StructType\RecordRef $issueProduct
     * @return \StructType\OtherChargeResaleItem
     */
    public function setIssueProduct(\StructType\RecordRef $issueProduct = null)
    {
        $this->issueProduct = $issueProduct;
        return $this;
    }
    /**
     * Get billingSchedule value
     * @return \StructType\RecordRef|null
     */
    public function getBillingSchedule()
    {
        return $this->billingSchedule;
    }
    /**
     * Set billingSchedule value
     * @param \StructType\RecordRef $billingSchedule
     * @return \StructType\OtherChargeResaleItem
     */
    public function setBillingSchedule(\StructType\RecordRef $billingSchedule = null)
    {
        $this->billingSchedule = $billingSchedule;
        return $this;
    }
    /**
     * Get deferredRevenueAccount value
     * @return \StructType\RecordRef|null
     */
    public function getDeferredRevenueAccount()
    {
        return $this->deferredRevenueAccount;
    }
    /**
     * Set deferredRevenueAccount value
     * @param \StructType\RecordRef $deferredRevenueAccount
     * @return \StructType\OtherChargeResaleItem
     */
    public function setDeferredRevenueAccount(\StructType\RecordRef $deferredRevenueAccount = null)
    {
        $this->deferredRevenueAccount = $deferredRevenueAccount;
        return $this;
    }
    /**
     * Get intercoDefRevAccount value
     * @return \StructType\RecordRef|null
     */
    public function getIntercoDefRevAccount()
    {
        return $this->intercoDefRevAccount;
    }
    /**
     * Set intercoDefRevAccount value
     * @param \StructType\RecordRef $intercoDefRevAccount
     * @return \StructType\OtherChargeResaleItem
     */
    public function setIntercoDefRevAccount(\StructType\RecordRef $intercoDefRevAccount = null)
    {
        $this->intercoDefRevAccount = $intercoDefRevAccount;
        return $this;
    }
    /**
     * Get revRecSchedule value
     * @return \StructType\RecordRef|null
     */
    public function getRevRecSchedule()
    {
        return $this->revRecSchedule;
    }
    /**
     * Set revRecSchedule value
     * @param \StructType\RecordRef $revRecSchedule
     * @return \StructType\OtherChargeResaleItem
     */
    public function setRevRecSchedule(\StructType\RecordRef $revRecSchedule = null)
    {
        $this->revRecSchedule = $revRecSchedule;
        return $this;
    }
    /**
     * Get deferralAccount value
     * @return \StructType\RecordRef|null
     */
    public function getDeferralAccount()
    {
        return $this->deferralAccount;
    }
    /**
     * Set deferralAccount value
     * @param \StructType\RecordRef $deferralAccount
     * @return \StructType\OtherChargeResaleItem
     */
    public function setDeferralAccount(\StructType\RecordRef $deferralAccount = null)
    {
        $this->deferralAccount = $deferralAccount;
        return $this;
    }
    /**
     * Get amortizationTemplate value
     * @return \StructType\RecordRef|null
     */
    public function getAmortizationTemplate()
    {
        return $this->amortizationTemplate;
    }
    /**
     * Set amortizationTemplate value
     * @param \StructType\RecordRef $amortizationTemplate
     * @return \StructType\OtherChargeResaleItem
     */
    public function setAmortizationTemplate(\StructType\RecordRef $amortizationTemplate = null)
    {
        $this->amortizationTemplate = $amortizationTemplate;
        return $this;
    }
    /**
     * Get residual value
     * @return string|null
     */
    public function getResidual()
    {
        return $this->residual;
    }
    /**
     * Set residual value
     * @param string $residual
     * @return \StructType\OtherChargeResaleItem
     */
    public function setResidual($residual = null)
    {
        // validation for constraint: string
        if (!is_null($residual) && !is_string($residual)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($residual, true), gettype($residual)), __LINE__);
        }
        $this->residual = $residual;
        return $this;
    }
    /**
     * Get deferRevRec value
     * @return bool|null
     */
    public function getDeferRevRec()
    {
        return $this->deferRevRec;
    }
    /**
     * Set deferRevRec value
     * @param bool $deferRevRec
     * @return \StructType\OtherChargeResaleItem
     */
    public function setDeferRevRec($deferRevRec = null)
    {
        // validation for constraint: boolean
        if (!is_null($deferRevRec) && !is_bool($deferRevRec)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($deferRevRec, true), gettype($deferRevRec)), __LINE__);
        }
        $this->deferRevRec = $deferRevRec;
        return $this;
    }
    /**
     * Get revenueRecognitionRule value
     * @return \StructType\RecordRef|null
     */
    public function getRevenueRecognitionRule()
    {
        return $this->revenueRecognitionRule;
    }
    /**
     * Set revenueRecognitionRule value
     * @param \StructType\RecordRef $revenueRecognitionRule
     * @return \StructType\OtherChargeResaleItem
     */
    public function setRevenueRecognitionRule(\StructType\RecordRef $revenueRecognitionRule = null)
    {
        $this->revenueRecognitionRule = $revenueRecognitionRule;
        return $this;
    }
    /**
     * Get revRecForecastRule value
     * @return \StructType\RecordRef|null
     */
    public function getRevRecForecastRule()
    {
        return $this->revRecForecastRule;
    }
    /**
     * Set revRecForecastRule value
     * @param \StructType\RecordRef $revRecForecastRule
     * @return \StructType\OtherChargeResaleItem
     */
    public function setRevRecForecastRule(\StructType\RecordRef $revRecForecastRule = null)
    {
        $this->revRecForecastRule = $revRecForecastRule;
        return $this;
    }
    /**
     * Get revenueAllocationGroup value
     * @return \StructType\RecordRef|null
     */
    public function getRevenueAllocationGroup()
    {
        return $this->revenueAllocationGroup;
    }
    /**
     * Set revenueAllocationGroup value
     * @param \StructType\RecordRef $revenueAllocationGroup
     * @return \StructType\OtherChargeResaleItem
     */
    public function setRevenueAllocationGroup(\StructType\RecordRef $revenueAllocationGroup = null)
    {
        $this->revenueAllocationGroup = $revenueAllocationGroup;
        return $this;
    }
    /**
     * Get createRevenuePlansOn value
     * @return \StructType\RecordRef|null
     */
    public function getCreateRevenuePlansOn()
    {
        return $this->createRevenuePlansOn;
    }
    /**
     * Set createRevenuePlansOn value
     * @param \StructType\RecordRef $createRevenuePlansOn
     * @return \StructType\OtherChargeResaleItem
     */
    public function setCreateRevenuePlansOn(\StructType\RecordRef $createRevenuePlansOn = null)
    {
        $this->createRevenuePlansOn = $createRevenuePlansOn;
        return $this;
    }
    /**
     * Get directRevenuePosting value
     * @return bool|null
     */
    public function getDirectRevenuePosting()
    {
        return $this->directRevenuePosting;
    }
    /**
     * Set directRevenuePosting value
     * @param bool $directRevenuePosting
     * @return \StructType\OtherChargeResaleItem
     */
    public function setDirectRevenuePosting($directRevenuePosting = null)
    {
        // validation for constraint: boolean
        if (!is_null($directRevenuePosting) && !is_bool($directRevenuePosting)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($directRevenuePosting, true), gettype($directRevenuePosting)), __LINE__);
        }
        $this->directRevenuePosting = $directRevenuePosting;
        return $this;
    }
    /**
     * Get contingentRevenueHandling value
     * @return bool|null
     */
    public function getContingentRevenueHandling()
    {
        return $this->contingentRevenueHandling;
    }
    /**
     * Set contingentRevenueHandling value
     * @param bool $contingentRevenueHandling
     * @return \StructType\OtherChargeResaleItem
     */
    public function setContingentRevenueHandling($contingentRevenueHandling = null)
    {
        // validation for constraint: boolean
        if (!is_null($contingentRevenueHandling) && !is_bool($contingentRevenueHandling)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($contingentRevenueHandling, true), gettype($contingentRevenueHandling)), __LINE__);
        }
        $this->contingentRevenueHandling = $contingentRevenueHandling;
        return $this;
    }
    /**
     * Get revReclassFXAccount value
     * @return \StructType\RecordRef|null
     */
    public function getRevReclassFXAccount()
    {
        return $this->revReclassFXAccount;
    }
    /**
     * Set revReclassFXAccount value
     * @param \StructType\RecordRef $revReclassFXAccount
     * @return \StructType\OtherChargeResaleItem
     */
    public function setRevReclassFXAccount(\StructType\RecordRef $revReclassFXAccount = null)
    {
        $this->revReclassFXAccount = $revReclassFXAccount;
        return $this;
    }
    /**
     * Get amortizationPeriod value
     * @return int|null
     */
    public function getAmortizationPeriod()
    {
        return $this->amortizationPeriod;
    }
    /**
     * Set amortizationPeriod value
     * @param int $amortizationPeriod
     * @return \StructType\OtherChargeResaleItem
     */
    public function setAmortizationPeriod($amortizationPeriod = null)
    {
        // validation for constraint: int
        if (!is_null($amortizationPeriod) && !(is_int($amortizationPeriod) || ctype_digit($amortizationPeriod))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($amortizationPeriod, true), gettype($amortizationPeriod)), __LINE__);
        }
        $this->amortizationPeriod = $amortizationPeriod;
        return $this;
    }
    /**
     * Get minimumQuantity value
     * @return int|null
     */
    public function getMinimumQuantity()
    {
        return $this->minimumQuantity;
    }
    /**
     * Set minimumQuantity value
     * @param int $minimumQuantity
     * @return \StructType\OtherChargeResaleItem
     */
    public function setMinimumQuantity($minimumQuantity = null)
    {
        // validation for constraint: int
        if (!is_null($minimumQuantity) && !(is_int($minimumQuantity) || ctype_digit($minimumQuantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($minimumQuantity, true), gettype($minimumQuantity)), __LINE__);
        }
        $this->minimumQuantity = $minimumQuantity;
        return $this;
    }
    /**
     * Get minimumQuantityUnits value
     * @return string|null
     */
    public function getMinimumQuantityUnits()
    {
        return $this->minimumQuantityUnits;
    }
    /**
     * Set minimumQuantityUnits value
     * @param string $minimumQuantityUnits
     * @return \StructType\OtherChargeResaleItem
     */
    public function setMinimumQuantityUnits($minimumQuantityUnits = null)
    {
        // validation for constraint: string
        if (!is_null($minimumQuantityUnits) && !is_string($minimumQuantityUnits)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($minimumQuantityUnits, true), gettype($minimumQuantityUnits)), __LINE__);
        }
        $this->minimumQuantityUnits = $minimumQuantityUnits;
        return $this;
    }
    /**
     * Get enforceMinQtyInternally value
     * @return bool|null
     */
    public function getEnforceMinQtyInternally()
    {
        return $this->enforceMinQtyInternally;
    }
    /**
     * Set enforceMinQtyInternally value
     * @param bool $enforceMinQtyInternally
     * @return \StructType\OtherChargeResaleItem
     */
    public function setEnforceMinQtyInternally($enforceMinQtyInternally = null)
    {
        // validation for constraint: boolean
        if (!is_null($enforceMinQtyInternally) && !is_bool($enforceMinQtyInternally)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($enforceMinQtyInternally, true), gettype($enforceMinQtyInternally)), __LINE__);
        }
        $this->enforceMinQtyInternally = $enforceMinQtyInternally;
        return $this;
    }
    /**
     * Get maximumQuantity value
     * @return int|null
     */
    public function getMaximumQuantity()
    {
        return $this->maximumQuantity;
    }
    /**
     * Set maximumQuantity value
     * @param int $maximumQuantity
     * @return \StructType\OtherChargeResaleItem
     */
    public function setMaximumQuantity($maximumQuantity = null)
    {
        // validation for constraint: int
        if (!is_null($maximumQuantity) && !(is_int($maximumQuantity) || ctype_digit($maximumQuantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maximumQuantity, true), gettype($maximumQuantity)), __LINE__);
        }
        $this->maximumQuantity = $maximumQuantity;
        return $this;
    }
    /**
     * Get softDescriptor value
     * @return string|null
     */
    public function getSoftDescriptor()
    {
        return $this->softDescriptor;
    }
    /**
     * Set softDescriptor value
     * @param string $softDescriptor
     * @return \StructType\OtherChargeResaleItem
     */
    public function setSoftDescriptor($softDescriptor = null)
    {
        // validation for constraint: string
        if (!is_null($softDescriptor) && !is_string($softDescriptor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($softDescriptor, true), gettype($softDescriptor)), __LINE__);
        }
        $this->softDescriptor = $softDescriptor;
        return $this;
    }
    /**
     * Get isFulfillable value
     * @return bool|null
     */
    public function getIsFulfillable()
    {
        return $this->isFulfillable;
    }
    /**
     * Set isFulfillable value
     * @param bool $isFulfillable
     * @return \StructType\OtherChargeResaleItem
     */
    public function setIsFulfillable($isFulfillable = null)
    {
        // validation for constraint: boolean
        if (!is_null($isFulfillable) && !is_bool($isFulfillable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isFulfillable, true), gettype($isFulfillable)), __LINE__);
        }
        $this->isFulfillable = $isFulfillable;
        return $this;
    }
    /**
     * Get generateAccruals value
     * @return bool|null
     */
    public function getGenerateAccruals()
    {
        return $this->generateAccruals;
    }
    /**
     * Set generateAccruals value
     * @param bool $generateAccruals
     * @return \StructType\OtherChargeResaleItem
     */
    public function setGenerateAccruals($generateAccruals = null)
    {
        // validation for constraint: boolean
        if (!is_null($generateAccruals) && !is_bool($generateAccruals)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($generateAccruals, true), gettype($generateAccruals)), __LINE__);
        }
        $this->generateAccruals = $generateAccruals;
        return $this;
    }
    /**
     * Get costCategory value
     * @return \StructType\RecordRef|null
     */
    public function getCostCategory()
    {
        return $this->costCategory;
    }
    /**
     * Set costCategory value
     * @param \StructType\RecordRef $costCategory
     * @return \StructType\OtherChargeResaleItem
     */
    public function setCostCategory(\StructType\RecordRef $costCategory = null)
    {
        $this->costCategory = $costCategory;
        return $this;
    }
    /**
     * Get purchaseOrderQuantity value
     * @return float|null
     */
    public function getPurchaseOrderQuantity()
    {
        return $this->purchaseOrderQuantity;
    }
    /**
     * Set purchaseOrderQuantity value
     * @param float $purchaseOrderQuantity
     * @return \StructType\OtherChargeResaleItem
     */
    public function setPurchaseOrderQuantity($purchaseOrderQuantity = null)
    {
        // validation for constraint: float
        if (!is_null($purchaseOrderQuantity) && !(is_float($purchaseOrderQuantity) || is_numeric($purchaseOrderQuantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($purchaseOrderQuantity, true), gettype($purchaseOrderQuantity)), __LINE__);
        }
        $this->purchaseOrderQuantity = $purchaseOrderQuantity;
        return $this;
    }
    /**
     * Get purchaseOrderAmount value
     * @return float|null
     */
    public function getPurchaseOrderAmount()
    {
        return $this->purchaseOrderAmount;
    }
    /**
     * Set purchaseOrderAmount value
     * @param float $purchaseOrderAmount
     * @return \StructType\OtherChargeResaleItem
     */
    public function setPurchaseOrderAmount($purchaseOrderAmount = null)
    {
        // validation for constraint: float
        if (!is_null($purchaseOrderAmount) && !(is_float($purchaseOrderAmount) || is_numeric($purchaseOrderAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($purchaseOrderAmount, true), gettype($purchaseOrderAmount)), __LINE__);
        }
        $this->purchaseOrderAmount = $purchaseOrderAmount;
        return $this;
    }
    /**
     * Get purchaseOrderQuantityDiff value
     * @return float|null
     */
    public function getPurchaseOrderQuantityDiff()
    {
        return $this->purchaseOrderQuantityDiff;
    }
    /**
     * Set purchaseOrderQuantityDiff value
     * @param float $purchaseOrderQuantityDiff
     * @return \StructType\OtherChargeResaleItem
     */
    public function setPurchaseOrderQuantityDiff($purchaseOrderQuantityDiff = null)
    {
        // validation for constraint: float
        if (!is_null($purchaseOrderQuantityDiff) && !(is_float($purchaseOrderQuantityDiff) || is_numeric($purchaseOrderQuantityDiff))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($purchaseOrderQuantityDiff, true), gettype($purchaseOrderQuantityDiff)), __LINE__);
        }
        $this->purchaseOrderQuantityDiff = $purchaseOrderQuantityDiff;
        return $this;
    }
    /**
     * Get receiptQuantity value
     * @return float|null
     */
    public function getReceiptQuantity()
    {
        return $this->receiptQuantity;
    }
    /**
     * Set receiptQuantity value
     * @param float $receiptQuantity
     * @return \StructType\OtherChargeResaleItem
     */
    public function setReceiptQuantity($receiptQuantity = null)
    {
        // validation for constraint: float
        if (!is_null($receiptQuantity) && !(is_float($receiptQuantity) || is_numeric($receiptQuantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($receiptQuantity, true), gettype($receiptQuantity)), __LINE__);
        }
        $this->receiptQuantity = $receiptQuantity;
        return $this;
    }
    /**
     * Get receiptAmount value
     * @return float|null
     */
    public function getReceiptAmount()
    {
        return $this->receiptAmount;
    }
    /**
     * Set receiptAmount value
     * @param float $receiptAmount
     * @return \StructType\OtherChargeResaleItem
     */
    public function setReceiptAmount($receiptAmount = null)
    {
        // validation for constraint: float
        if (!is_null($receiptAmount) && !(is_float($receiptAmount) || is_numeric($receiptAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($receiptAmount, true), gettype($receiptAmount)), __LINE__);
        }
        $this->receiptAmount = $receiptAmount;
        return $this;
    }
    /**
     * Get receiptQuantityDiff value
     * @return float|null
     */
    public function getReceiptQuantityDiff()
    {
        return $this->receiptQuantityDiff;
    }
    /**
     * Set receiptQuantityDiff value
     * @param float $receiptQuantityDiff
     * @return \StructType\OtherChargeResaleItem
     */
    public function setReceiptQuantityDiff($receiptQuantityDiff = null)
    {
        // validation for constraint: float
        if (!is_null($receiptQuantityDiff) && !(is_float($receiptQuantityDiff) || is_numeric($receiptQuantityDiff))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($receiptQuantityDiff, true), gettype($receiptQuantityDiff)), __LINE__);
        }
        $this->receiptQuantityDiff = $receiptQuantityDiff;
        return $this;
    }
    /**
     * Get pricesIncludeTax value
     * @return bool|null
     */
    public function getPricesIncludeTax()
    {
        return $this->pricesIncludeTax;
    }
    /**
     * Set pricesIncludeTax value
     * @param bool $pricesIncludeTax
     * @return \StructType\OtherChargeResaleItem
     */
    public function setPricesIncludeTax($pricesIncludeTax = null)
    {
        // validation for constraint: boolean
        if (!is_null($pricesIncludeTax) && !is_bool($pricesIncludeTax)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($pricesIncludeTax, true), gettype($pricesIncludeTax)), __LINE__);
        }
        $this->pricesIncludeTax = $pricesIncludeTax;
        return $this;
    }
    /**
     * Get quantityPricingSchedule value
     * @return \StructType\RecordRef|null
     */
    public function getQuantityPricingSchedule()
    {
        return $this->quantityPricingSchedule;
    }
    /**
     * Set quantityPricingSchedule value
     * @param \StructType\RecordRef $quantityPricingSchedule
     * @return \StructType\OtherChargeResaleItem
     */
    public function setQuantityPricingSchedule(\StructType\RecordRef $quantityPricingSchedule = null)
    {
        $this->quantityPricingSchedule = $quantityPricingSchedule;
        return $this;
    }
    /**
     * Get useMarginalRates value
     * @return bool|null
     */
    public function getUseMarginalRates()
    {
        return $this->useMarginalRates;
    }
    /**
     * Set useMarginalRates value
     * @param bool $useMarginalRates
     * @return \StructType\OtherChargeResaleItem
     */
    public function setUseMarginalRates($useMarginalRates = null)
    {
        // validation for constraint: boolean
        if (!is_null($useMarginalRates) && !is_bool($useMarginalRates)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($useMarginalRates, true), gettype($useMarginalRates)), __LINE__);
        }
        $this->useMarginalRates = $useMarginalRates;
        return $this;
    }
    /**
     * Get overallQuantityPricingType value
     * @return string|null
     */
    public function getOverallQuantityPricingType()
    {
        return $this->overallQuantityPricingType;
    }
    /**
     * Set overallQuantityPricingType value
     * @uses \EnumType\ItemOverallQuantityPricingType::valueIsValid()
     * @uses \EnumType\ItemOverallQuantityPricingType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $overallQuantityPricingType
     * @return \StructType\OtherChargeResaleItem
     */
    public function setOverallQuantityPricingType($overallQuantityPricingType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ItemOverallQuantityPricingType::valueIsValid($overallQuantityPricingType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\ItemOverallQuantityPricingType', is_array($overallQuantityPricingType) ? implode(', ', $overallQuantityPricingType) : var_export($overallQuantityPricingType, true), implode(', ', \EnumType\ItemOverallQuantityPricingType::getValidValues())), __LINE__);
        }
        $this->overallQuantityPricingType = $overallQuantityPricingType;
        return $this;
    }
    /**
     * Get pricingGroup value
     * @return \StructType\RecordRef|null
     */
    public function getPricingGroup()
    {
        return $this->pricingGroup;
    }
    /**
     * Set pricingGroup value
     * @param \StructType\RecordRef $pricingGroup
     * @return \StructType\OtherChargeResaleItem
     */
    public function setPricingGroup(\StructType\RecordRef $pricingGroup = null)
    {
        $this->pricingGroup = $pricingGroup;
        return $this;
    }
    /**
     * Get customForm value
     * @return \StructType\RecordRef|null
     */
    public function getCustomForm()
    {
        return $this->customForm;
    }
    /**
     * Set customForm value
     * @param \StructType\RecordRef $customForm
     * @return \StructType\OtherChargeResaleItem
     */
    public function setCustomForm(\StructType\RecordRef $customForm = null)
    {
        $this->customForm = $customForm;
        return $this;
    }
    /**
     * Get itemId value
     * @return string|null
     */
    public function getItemId()
    {
        return $this->itemId;
    }
    /**
     * Set itemId value
     * @param string $itemId
     * @return \StructType\OtherChargeResaleItem
     */
    public function setItemId($itemId = null)
    {
        // validation for constraint: string
        if (!is_null($itemId) && !is_string($itemId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($itemId, true), gettype($itemId)), __LINE__);
        }
        $this->itemId = $itemId;
        return $this;
    }
    /**
     * Get upcCode value
     * @return string|null
     */
    public function getUpcCode()
    {
        return $this->upcCode;
    }
    /**
     * Set upcCode value
     * @param string $upcCode
     * @return \StructType\OtherChargeResaleItem
     */
    public function setUpcCode($upcCode = null)
    {
        // validation for constraint: string
        if (!is_null($upcCode) && !is_string($upcCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($upcCode, true), gettype($upcCode)), __LINE__);
        }
        $this->upcCode = $upcCode;
        return $this;
    }
    /**
     * Get displayName value
     * @return string|null
     */
    public function getDisplayName()
    {
        return $this->displayName;
    }
    /**
     * Set displayName value
     * @param string $displayName
     * @return \StructType\OtherChargeResaleItem
     */
    public function setDisplayName($displayName = null)
    {
        // validation for constraint: string
        if (!is_null($displayName) && !is_string($displayName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($displayName, true), gettype($displayName)), __LINE__);
        }
        $this->displayName = $displayName;
        return $this;
    }
    /**
     * Get vendorName value
     * @return string|null
     */
    public function getVendorName()
    {
        return $this->vendorName;
    }
    /**
     * Set vendorName value
     * @param string $vendorName
     * @return \StructType\OtherChargeResaleItem
     */
    public function setVendorName($vendorName = null)
    {
        // validation for constraint: string
        if (!is_null($vendorName) && !is_string($vendorName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vendorName, true), gettype($vendorName)), __LINE__);
        }
        $this->vendorName = $vendorName;
        return $this;
    }
    /**
     * Get parent value
     * @return \StructType\RecordRef|null
     */
    public function getParent()
    {
        return $this->parent;
    }
    /**
     * Set parent value
     * @param \StructType\RecordRef $parent
     * @return \StructType\OtherChargeResaleItem
     */
    public function setParent(\StructType\RecordRef $parent = null)
    {
        $this->parent = $parent;
        return $this;
    }
    /**
     * Get isOnline value
     * @return bool|null
     */
    public function getIsOnline()
    {
        return $this->isOnline;
    }
    /**
     * Set isOnline value
     * @param bool $isOnline
     * @return \StructType\OtherChargeResaleItem
     */
    public function setIsOnline($isOnline = null)
    {
        // validation for constraint: boolean
        if (!is_null($isOnline) && !is_bool($isOnline)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isOnline, true), gettype($isOnline)), __LINE__);
        }
        $this->isOnline = $isOnline;
        return $this;
    }
    /**
     * Get isGcoCompliant value
     * @return bool|null
     */
    public function getIsGcoCompliant()
    {
        return $this->isGcoCompliant;
    }
    /**
     * Set isGcoCompliant value
     * @param bool $isGcoCompliant
     * @return \StructType\OtherChargeResaleItem
     */
    public function setIsGcoCompliant($isGcoCompliant = null)
    {
        // validation for constraint: boolean
        if (!is_null($isGcoCompliant) && !is_bool($isGcoCompliant)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isGcoCompliant, true), gettype($isGcoCompliant)), __LINE__);
        }
        $this->isGcoCompliant = $isGcoCompliant;
        return $this;
    }
    /**
     * Get offerSupport value
     * @return bool|null
     */
    public function getOfferSupport()
    {
        return $this->offerSupport;
    }
    /**
     * Set offerSupport value
     * @param bool $offerSupport
     * @return \StructType\OtherChargeResaleItem
     */
    public function setOfferSupport($offerSupport = null)
    {
        // validation for constraint: boolean
        if (!is_null($offerSupport) && !is_bool($offerSupport)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($offerSupport, true), gettype($offerSupport)), __LINE__);
        }
        $this->offerSupport = $offerSupport;
        return $this;
    }
    /**
     * Get isInactive value
     * @return bool|null
     */
    public function getIsInactive()
    {
        return $this->isInactive;
    }
    /**
     * Set isInactive value
     * @param bool $isInactive
     * @return \StructType\OtherChargeResaleItem
     */
    public function setIsInactive($isInactive = null)
    {
        // validation for constraint: boolean
        if (!is_null($isInactive) && !is_bool($isInactive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isInactive, true), gettype($isInactive)), __LINE__);
        }
        $this->isInactive = $isInactive;
        return $this;
    }
    /**
     * Get matrixItemNameTemplate value
     * @return string|null
     */
    public function getMatrixItemNameTemplate()
    {
        return $this->matrixItemNameTemplate;
    }
    /**
     * Set matrixItemNameTemplate value
     * @param string $matrixItemNameTemplate
     * @return \StructType\OtherChargeResaleItem
     */
    public function setMatrixItemNameTemplate($matrixItemNameTemplate = null)
    {
        // validation for constraint: string
        if (!is_null($matrixItemNameTemplate) && !is_string($matrixItemNameTemplate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($matrixItemNameTemplate, true), gettype($matrixItemNameTemplate)), __LINE__);
        }
        $this->matrixItemNameTemplate = $matrixItemNameTemplate;
        return $this;
    }
    /**
     * Get availableToPartners value
     * @return bool|null
     */
    public function getAvailableToPartners()
    {
        return $this->availableToPartners;
    }
    /**
     * Set availableToPartners value
     * @param bool $availableToPartners
     * @return \StructType\OtherChargeResaleItem
     */
    public function setAvailableToPartners($availableToPartners = null)
    {
        // validation for constraint: boolean
        if (!is_null($availableToPartners) && !is_bool($availableToPartners)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($availableToPartners, true), gettype($availableToPartners)), __LINE__);
        }
        $this->availableToPartners = $availableToPartners;
        return $this;
    }
    /**
     * Get department value
     * @return \StructType\RecordRef|null
     */
    public function getDepartment()
    {
        return $this->department;
    }
    /**
     * Set department value
     * @param \StructType\RecordRef $department
     * @return \StructType\OtherChargeResaleItem
     */
    public function setDepartment(\StructType\RecordRef $department = null)
    {
        $this->department = $department;
        return $this;
    }
    /**
     * Get class value
     * @return \StructType\RecordRef|null
     */
    public function getClass()
    {
        return $this->class;
    }
    /**
     * Set class value
     * @param \StructType\RecordRef $class
     * @return \StructType\OtherChargeResaleItem
     */
    public function setClass(\StructType\RecordRef $class = null)
    {
        $this->class = $class;
        return $this;
    }
    /**
     * Get location value
     * @return \StructType\RecordRef|null
     */
    public function getLocation()
    {
        return $this->location;
    }
    /**
     * Set location value
     * @param \StructType\RecordRef $location
     * @return \StructType\OtherChargeResaleItem
     */
    public function setLocation(\StructType\RecordRef $location = null)
    {
        $this->location = $location;
        return $this;
    }
    /**
     * Get subsidiaryList value
     * @return \StructType\RecordRefList|null
     */
    public function getSubsidiaryList()
    {
        return $this->subsidiaryList;
    }
    /**
     * Set subsidiaryList value
     * @param \StructType\RecordRefList $subsidiaryList
     * @return \StructType\OtherChargeResaleItem
     */
    public function setSubsidiaryList(\StructType\RecordRefList $subsidiaryList = null)
    {
        $this->subsidiaryList = $subsidiaryList;
        return $this;
    }
    /**
     * Get vsoePrice value
     * @return float|null
     */
    public function getVsoePrice()
    {
        return $this->vsoePrice;
    }
    /**
     * Set vsoePrice value
     * @param float $vsoePrice
     * @return \StructType\OtherChargeResaleItem
     */
    public function setVsoePrice($vsoePrice = null)
    {
        // validation for constraint: float
        if (!is_null($vsoePrice) && !(is_float($vsoePrice) || is_numeric($vsoePrice))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($vsoePrice, true), gettype($vsoePrice)), __LINE__);
        }
        $this->vsoePrice = $vsoePrice;
        return $this;
    }
    /**
     * Get vsoeSopGroup value
     * @return string|null
     */
    public function getVsoeSopGroup()
    {
        return $this->vsoeSopGroup;
    }
    /**
     * Set vsoeSopGroup value
     * @uses \EnumType\VsoeSopGroup::valueIsValid()
     * @uses \EnumType\VsoeSopGroup::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $vsoeSopGroup
     * @return \StructType\OtherChargeResaleItem
     */
    public function setVsoeSopGroup($vsoeSopGroup = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\VsoeSopGroup::valueIsValid($vsoeSopGroup)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\VsoeSopGroup', is_array($vsoeSopGroup) ? implode(', ', $vsoeSopGroup) : var_export($vsoeSopGroup, true), implode(', ', \EnumType\VsoeSopGroup::getValidValues())), __LINE__);
        }
        $this->vsoeSopGroup = $vsoeSopGroup;
        return $this;
    }
    /**
     * Get vsoeDeferral value
     * @return string|null
     */
    public function getVsoeDeferral()
    {
        return $this->vsoeDeferral;
    }
    /**
     * Set vsoeDeferral value
     * @uses \EnumType\VsoeDeferral::valueIsValid()
     * @uses \EnumType\VsoeDeferral::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $vsoeDeferral
     * @return \StructType\OtherChargeResaleItem
     */
    public function setVsoeDeferral($vsoeDeferral = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\VsoeDeferral::valueIsValid($vsoeDeferral)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\VsoeDeferral', is_array($vsoeDeferral) ? implode(', ', $vsoeDeferral) : var_export($vsoeDeferral, true), implode(', ', \EnumType\VsoeDeferral::getValidValues())), __LINE__);
        }
        $this->vsoeDeferral = $vsoeDeferral;
        return $this;
    }
    /**
     * Get vsoePermitDiscount value
     * @return string|null
     */
    public function getVsoePermitDiscount()
    {
        return $this->vsoePermitDiscount;
    }
    /**
     * Set vsoePermitDiscount value
     * @uses \EnumType\VsoePermitDiscount::valueIsValid()
     * @uses \EnumType\VsoePermitDiscount::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $vsoePermitDiscount
     * @return \StructType\OtherChargeResaleItem
     */
    public function setVsoePermitDiscount($vsoePermitDiscount = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\VsoePermitDiscount::valueIsValid($vsoePermitDiscount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\VsoePermitDiscount', is_array($vsoePermitDiscount) ? implode(', ', $vsoePermitDiscount) : var_export($vsoePermitDiscount, true), implode(', ', \EnumType\VsoePermitDiscount::getValidValues())), __LINE__);
        }
        $this->vsoePermitDiscount = $vsoePermitDiscount;
        return $this;
    }
    /**
     * Get vsoeDelivered value
     * @return bool|null
     */
    public function getVsoeDelivered()
    {
        return $this->vsoeDelivered;
    }
    /**
     * Set vsoeDelivered value
     * @param bool $vsoeDelivered
     * @return \StructType\OtherChargeResaleItem
     */
    public function setVsoeDelivered($vsoeDelivered = null)
    {
        // validation for constraint: boolean
        if (!is_null($vsoeDelivered) && !is_bool($vsoeDelivered)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($vsoeDelivered, true), gettype($vsoeDelivered)), __LINE__);
        }
        $this->vsoeDelivered = $vsoeDelivered;
        return $this;
    }
    /**
     * Get itemRevenueCategory value
     * @return \StructType\RecordRef|null
     */
    public function getItemRevenueCategory()
    {
        return $this->itemRevenueCategory;
    }
    /**
     * Set itemRevenueCategory value
     * @param \StructType\RecordRef $itemRevenueCategory
     * @return \StructType\OtherChargeResaleItem
     */
    public function setItemRevenueCategory(\StructType\RecordRef $itemRevenueCategory = null)
    {
        $this->itemRevenueCategory = $itemRevenueCategory;
        return $this;
    }
    /**
     * Get currency value
     * @return string|null
     */
    public function getCurrency()
    {
        return $this->currency;
    }
    /**
     * Set currency value
     * @param string $currency
     * @return \StructType\OtherChargeResaleItem
     */
    public function setCurrency($currency = null)
    {
        // validation for constraint: string
        if (!is_null($currency) && !is_string($currency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currency, true), gettype($currency)), __LINE__);
        }
        $this->currency = $currency;
        return $this;
    }
    /**
     * Get itemOptionsList value
     * @return \StructType\ItemOptionsList|null
     */
    public function getItemOptionsList()
    {
        return $this->itemOptionsList;
    }
    /**
     * Set itemOptionsList value
     * @param \StructType\ItemOptionsList $itemOptionsList
     * @return \StructType\OtherChargeResaleItem
     */
    public function setItemOptionsList(\StructType\ItemOptionsList $itemOptionsList = null)
    {
        $this->itemOptionsList = $itemOptionsList;
        return $this;
    }
    /**
     * Get matrixOptionList value
     * @return \StructType\MatrixOptionList|null
     */
    public function getMatrixOptionList()
    {
        return $this->matrixOptionList;
    }
    /**
     * Set matrixOptionList value
     * @param \StructType\MatrixOptionList $matrixOptionList
     * @return \StructType\OtherChargeResaleItem
     */
    public function setMatrixOptionList(\StructType\MatrixOptionList $matrixOptionList = null)
    {
        $this->matrixOptionList = $matrixOptionList;
        return $this;
    }
    /**
     * Get itemVendorList value
     * @return \StructType\ItemVendorList|null
     */
    public function getItemVendorList()
    {
        return $this->itemVendorList;
    }
    /**
     * Set itemVendorList value
     * @param \StructType\ItemVendorList $itemVendorList
     * @return \StructType\OtherChargeResaleItem
     */
    public function setItemVendorList(\StructType\ItemVendorList $itemVendorList = null)
    {
        $this->itemVendorList = $itemVendorList;
        return $this;
    }
    /**
     * Get pricingMatrix value
     * @return \StructType\PricingMatrix|null
     */
    public function getPricingMatrix()
    {
        return $this->pricingMatrix;
    }
    /**
     * Set pricingMatrix value
     * @param \StructType\PricingMatrix $pricingMatrix
     * @return \StructType\OtherChargeResaleItem
     */
    public function setPricingMatrix(\StructType\PricingMatrix $pricingMatrix = null)
    {
        $this->pricingMatrix = $pricingMatrix;
        return $this;
    }
    /**
     * Get accountingBookDetailList value
     * @return \StructType\ItemAccountingBookDetailList|null
     */
    public function getAccountingBookDetailList()
    {
        return $this->accountingBookDetailList;
    }
    /**
     * Set accountingBookDetailList value
     * @param \StructType\ItemAccountingBookDetailList $accountingBookDetailList
     * @return \StructType\OtherChargeResaleItem
     */
    public function setAccountingBookDetailList(\StructType\ItemAccountingBookDetailList $accountingBookDetailList = null)
    {
        $this->accountingBookDetailList = $accountingBookDetailList;
        return $this;
    }
    /**
     * Get purchaseTaxCode value
     * @return \StructType\RecordRef|null
     */
    public function getPurchaseTaxCode()
    {
        return $this->purchaseTaxCode;
    }
    /**
     * Set purchaseTaxCode value
     * @param \StructType\RecordRef $purchaseTaxCode
     * @return \StructType\OtherChargeResaleItem
     */
    public function setPurchaseTaxCode(\StructType\RecordRef $purchaseTaxCode = null)
    {
        $this->purchaseTaxCode = $purchaseTaxCode;
        return $this;
    }
    /**
     * Get rate value
     * @return float|null
     */
    public function getRate()
    {
        return $this->rate;
    }
    /**
     * Set rate value
     * @param float $rate
     * @return \StructType\OtherChargeResaleItem
     */
    public function setRate($rate = null)
    {
        // validation for constraint: float
        if (!is_null($rate) && !(is_float($rate) || is_numeric($rate))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($rate, true), gettype($rate)), __LINE__);
        }
        $this->rate = $rate;
        return $this;
    }
    /**
     * Get salesTaxCode value
     * @return \StructType\RecordRef|null
     */
    public function getSalesTaxCode()
    {
        return $this->salesTaxCode;
    }
    /**
     * Set salesTaxCode value
     * @param \StructType\RecordRef $salesTaxCode
     * @return \StructType\OtherChargeResaleItem
     */
    public function setSalesTaxCode(\StructType\RecordRef $salesTaxCode = null)
    {
        $this->salesTaxCode = $salesTaxCode;
        return $this;
    }
    /**
     * Get translationsList value
     * @return \StructType\TranslationList|null
     */
    public function getTranslationsList()
    {
        return $this->translationsList;
    }
    /**
     * Set translationsList value
     * @param \StructType\TranslationList $translationsList
     * @return \StructType\OtherChargeResaleItem
     */
    public function setTranslationsList(\StructType\TranslationList $translationsList = null)
    {
        $this->translationsList = $translationsList;
        return $this;
    }
    /**
     * Get vendor value
     * @return \StructType\RecordRef|null
     */
    public function getVendor()
    {
        return $this->vendor;
    }
    /**
     * Set vendor value
     * @param \StructType\RecordRef $vendor
     * @return \StructType\OtherChargeResaleItem
     */
    public function setVendor(\StructType\RecordRef $vendor = null)
    {
        $this->vendor = $vendor;
        return $this;
    }
    /**
     * Get hierarchyVersionsList value
     * @return \StructType\OtherChargeResaleItemHierarchyVersionsList|null
     */
    public function getHierarchyVersionsList()
    {
        return $this->hierarchyVersionsList;
    }
    /**
     * Set hierarchyVersionsList value
     * @param \StructType\OtherChargeResaleItemHierarchyVersionsList $hierarchyVersionsList
     * @return \StructType\OtherChargeResaleItem
     */
    public function setHierarchyVersionsList(\StructType\OtherChargeResaleItemHierarchyVersionsList $hierarchyVersionsList = null)
    {
        $this->hierarchyVersionsList = $hierarchyVersionsList;
        return $this;
    }
    /**
     * Get consumptionUnit value
     * @return \StructType\RecordRef|null
     */
    public function getConsumptionUnit()
    {
        return $this->consumptionUnit;
    }
    /**
     * Set consumptionUnit value
     * @param \StructType\RecordRef $consumptionUnit
     * @return \StructType\OtherChargeResaleItem
     */
    public function setConsumptionUnit(\StructType\RecordRef $consumptionUnit = null)
    {
        $this->consumptionUnit = $consumptionUnit;
        return $this;
    }
    /**
     * Get customFieldList value
     * @return \StructType\CustomFieldList|null
     */
    public function getCustomFieldList()
    {
        return $this->customFieldList;
    }
    /**
     * Set customFieldList value
     * @param \StructType\CustomFieldList $customFieldList
     * @return \StructType\OtherChargeResaleItem
     */
    public function setCustomFieldList(\StructType\CustomFieldList $customFieldList = null)
    {
        $this->customFieldList = $customFieldList;
        return $this;
    }
    /**
     * Get internalId value
     * @return string|null
     */
    public function getInternalId()
    {
        return $this->internalId;
    }
    /**
     * Set internalId value
     * @param string $internalId
     * @return \StructType\OtherChargeResaleItem
     */
    public function setInternalId($internalId = null)
    {
        // validation for constraint: string
        if (!is_null($internalId) && !is_string($internalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($internalId, true), gettype($internalId)), __LINE__);
        }
        $this->internalId = $internalId;
        return $this;
    }
    /**
     * Get externalId value
     * @return string|null
     */
    public function getExternalId()
    {
        return $this->externalId;
    }
    /**
     * Set externalId value
     * @param string $externalId
     * @return \StructType\OtherChargeResaleItem
     */
    public function setExternalId($externalId = null)
    {
        // validation for constraint: string
        if (!is_null($externalId) && !is_string($externalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($externalId, true), gettype($externalId)), __LINE__);
        }
        $this->externalId = $externalId;
        return $this;
    }
}
