<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OtherChargePurchaseItem StructType
 * Meta information extracted from the WSDL
 * - type: listAcct:OtherChargePurchaseItem
 * @subpackage Structs
 */
class OtherChargePurchaseItem extends Record
{
    /**
     * The createdDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $createdDate;
    /**
     * The lastModifiedDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $lastModifiedDate;
    /**
     * The purchaseDescription
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $purchaseDescription;
    /**
     * The manufacturingChargeItem
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $manufacturingChargeItem;
    /**
     * The cost
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $cost;
    /**
     * The costUnits
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $costUnits;
    /**
     * The expenseAccount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $expenseAccount;
    /**
     * The isTaxable
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $isTaxable;
    /**
     * The matrixType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $matrixType;
    /**
     * The unitsType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $unitsType;
    /**
     * The purchaseUnit
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $purchaseUnit;
    /**
     * The includeChildren
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $includeChildren;
    /**
     * The issueProduct
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $issueProduct;
    /**
     * The customForm
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $customForm;
    /**
     * The itemId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $itemId;
    /**
     * The upcCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $upcCode;
    /**
     * The displayName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $displayName;
    /**
     * The vendorName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $vendorName;
    /**
     * The parent
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $parent;
    /**
     * The isInactive
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $isInactive;
    /**
     * The matrixItemNameTemplate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $matrixItemNameTemplate;
    /**
     * The availableToPartners
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $availableToPartners;
    /**
     * The department
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $department;
    /**
     * The class
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $class;
    /**
     * The subsidiaryList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRefList
     */
    public $subsidiaryList;
    /**
     * The location
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $location;
    /**
     * The taxSchedule
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $taxSchedule;
    /**
     * The deferralAccount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $deferralAccount;
    /**
     * The amortizationTemplate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $amortizationTemplate;
    /**
     * The residual
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $residual;
    /**
     * The amortizationPeriod
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $amortizationPeriod;
    /**
     * The isFulfillable
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $isFulfillable;
    /**
     * The generateAccruals
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $generateAccruals;
    /**
     * The accountingBookDetailList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ItemAccountingBookDetailList
     */
    public $accountingBookDetailList;
    /**
     * The costCategory
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $costCategory;
    /**
     * The overheadType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $overheadType;
    /**
     * The purchaseOrderQuantity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $purchaseOrderQuantity;
    /**
     * The purchaseOrderAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $purchaseOrderAmount;
    /**
     * The purchaseOrderQuantityDiff
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $purchaseOrderQuantityDiff;
    /**
     * The receiptQuantity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $receiptQuantity;
    /**
     * The receiptAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $receiptAmount;
    /**
     * The receiptQuantityDiff
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $receiptQuantityDiff;
    /**
     * The currency
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $currency;
    /**
     * The itemOptionsList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ItemOptionsList
     */
    public $itemOptionsList;
    /**
     * The matrixOptionList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\MatrixOptionList
     */
    public $matrixOptionList;
    /**
     * The itemVendorList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ItemVendorList
     */
    public $itemVendorList;
    /**
     * The purchaseTaxCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $purchaseTaxCode;
    /**
     * The salesTaxCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $salesTaxCode;
    /**
     * The translationsList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\TranslationList
     */
    public $translationsList;
    /**
     * The vendor
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $vendor;
    /**
     * The hierarchyVersionsList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\OtherChargePurchaseItemHierarchyVersionsList
     */
    public $hierarchyVersionsList;
    /**
     * The consumptionUnit
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $consumptionUnit;
    /**
     * The customFieldList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CustomFieldList
     */
    public $customFieldList;
    /**
     * The internalId
     * @var string
     */
    public $internalId;
    /**
     * The externalId
     * @var string
     */
    public $externalId;
    /**
     * Constructor method for OtherChargePurchaseItem
     * @uses OtherChargePurchaseItem::setCreatedDate()
     * @uses OtherChargePurchaseItem::setLastModifiedDate()
     * @uses OtherChargePurchaseItem::setPurchaseDescription()
     * @uses OtherChargePurchaseItem::setManufacturingChargeItem()
     * @uses OtherChargePurchaseItem::setCost()
     * @uses OtherChargePurchaseItem::setCostUnits()
     * @uses OtherChargePurchaseItem::setExpenseAccount()
     * @uses OtherChargePurchaseItem::setIsTaxable()
     * @uses OtherChargePurchaseItem::setMatrixType()
     * @uses OtherChargePurchaseItem::setUnitsType()
     * @uses OtherChargePurchaseItem::setPurchaseUnit()
     * @uses OtherChargePurchaseItem::setIncludeChildren()
     * @uses OtherChargePurchaseItem::setIssueProduct()
     * @uses OtherChargePurchaseItem::setCustomForm()
     * @uses OtherChargePurchaseItem::setItemId()
     * @uses OtherChargePurchaseItem::setUpcCode()
     * @uses OtherChargePurchaseItem::setDisplayName()
     * @uses OtherChargePurchaseItem::setVendorName()
     * @uses OtherChargePurchaseItem::setParent()
     * @uses OtherChargePurchaseItem::setIsInactive()
     * @uses OtherChargePurchaseItem::setMatrixItemNameTemplate()
     * @uses OtherChargePurchaseItem::setAvailableToPartners()
     * @uses OtherChargePurchaseItem::setDepartment()
     * @uses OtherChargePurchaseItem::setClass()
     * @uses OtherChargePurchaseItem::setSubsidiaryList()
     * @uses OtherChargePurchaseItem::setLocation()
     * @uses OtherChargePurchaseItem::setTaxSchedule()
     * @uses OtherChargePurchaseItem::setDeferralAccount()
     * @uses OtherChargePurchaseItem::setAmortizationTemplate()
     * @uses OtherChargePurchaseItem::setResidual()
     * @uses OtherChargePurchaseItem::setAmortizationPeriod()
     * @uses OtherChargePurchaseItem::setIsFulfillable()
     * @uses OtherChargePurchaseItem::setGenerateAccruals()
     * @uses OtherChargePurchaseItem::setAccountingBookDetailList()
     * @uses OtherChargePurchaseItem::setCostCategory()
     * @uses OtherChargePurchaseItem::setOverheadType()
     * @uses OtherChargePurchaseItem::setPurchaseOrderQuantity()
     * @uses OtherChargePurchaseItem::setPurchaseOrderAmount()
     * @uses OtherChargePurchaseItem::setPurchaseOrderQuantityDiff()
     * @uses OtherChargePurchaseItem::setReceiptQuantity()
     * @uses OtherChargePurchaseItem::setReceiptAmount()
     * @uses OtherChargePurchaseItem::setReceiptQuantityDiff()
     * @uses OtherChargePurchaseItem::setCurrency()
     * @uses OtherChargePurchaseItem::setItemOptionsList()
     * @uses OtherChargePurchaseItem::setMatrixOptionList()
     * @uses OtherChargePurchaseItem::setItemVendorList()
     * @uses OtherChargePurchaseItem::setPurchaseTaxCode()
     * @uses OtherChargePurchaseItem::setSalesTaxCode()
     * @uses OtherChargePurchaseItem::setTranslationsList()
     * @uses OtherChargePurchaseItem::setVendor()
     * @uses OtherChargePurchaseItem::setHierarchyVersionsList()
     * @uses OtherChargePurchaseItem::setConsumptionUnit()
     * @uses OtherChargePurchaseItem::setCustomFieldList()
     * @uses OtherChargePurchaseItem::setInternalId()
     * @uses OtherChargePurchaseItem::setExternalId()
     * @param string $createdDate
     * @param string $lastModifiedDate
     * @param string $purchaseDescription
     * @param bool $manufacturingChargeItem
     * @param float $cost
     * @param string $costUnits
     * @param \StructType\RecordRef $expenseAccount
     * @param bool $isTaxable
     * @param string $matrixType
     * @param \StructType\RecordRef $unitsType
     * @param \StructType\RecordRef $purchaseUnit
     * @param bool $includeChildren
     * @param \StructType\RecordRef $issueProduct
     * @param \StructType\RecordRef $customForm
     * @param string $itemId
     * @param string $upcCode
     * @param string $displayName
     * @param string $vendorName
     * @param \StructType\RecordRef $parent
     * @param bool $isInactive
     * @param string $matrixItemNameTemplate
     * @param bool $availableToPartners
     * @param \StructType\RecordRef $department
     * @param \StructType\RecordRef $class
     * @param \StructType\RecordRefList $subsidiaryList
     * @param \StructType\RecordRef $location
     * @param \StructType\RecordRef $taxSchedule
     * @param \StructType\RecordRef $deferralAccount
     * @param \StructType\RecordRef $amortizationTemplate
     * @param string $residual
     * @param int $amortizationPeriod
     * @param bool $isFulfillable
     * @param bool $generateAccruals
     * @param \StructType\ItemAccountingBookDetailList $accountingBookDetailList
     * @param \StructType\RecordRef $costCategory
     * @param string $overheadType
     * @param float $purchaseOrderQuantity
     * @param float $purchaseOrderAmount
     * @param float $purchaseOrderQuantityDiff
     * @param float $receiptQuantity
     * @param float $receiptAmount
     * @param float $receiptQuantityDiff
     * @param string $currency
     * @param \StructType\ItemOptionsList $itemOptionsList
     * @param \StructType\MatrixOptionList $matrixOptionList
     * @param \StructType\ItemVendorList $itemVendorList
     * @param \StructType\RecordRef $purchaseTaxCode
     * @param \StructType\RecordRef $salesTaxCode
     * @param \StructType\TranslationList $translationsList
     * @param \StructType\RecordRef $vendor
     * @param \StructType\OtherChargePurchaseItemHierarchyVersionsList $hierarchyVersionsList
     * @param \StructType\RecordRef $consumptionUnit
     * @param \StructType\CustomFieldList $customFieldList
     * @param string $internalId
     * @param string $externalId
     */
    public function __construct($createdDate = null, $lastModifiedDate = null, $purchaseDescription = null, $manufacturingChargeItem = null, $cost = null, $costUnits = null, \StructType\RecordRef $expenseAccount = null, $isTaxable = null, $matrixType = null, \StructType\RecordRef $unitsType = null, \StructType\RecordRef $purchaseUnit = null, $includeChildren = null, \StructType\RecordRef $issueProduct = null, \StructType\RecordRef $customForm = null, $itemId = null, $upcCode = null, $displayName = null, $vendorName = null, \StructType\RecordRef $parent = null, $isInactive = null, $matrixItemNameTemplate = null, $availableToPartners = null, \StructType\RecordRef $department = null, \StructType\RecordRef $class = null, \StructType\RecordRefList $subsidiaryList = null, \StructType\RecordRef $location = null, \StructType\RecordRef $taxSchedule = null, \StructType\RecordRef $deferralAccount = null, \StructType\RecordRef $amortizationTemplate = null, $residual = null, $amortizationPeriod = null, $isFulfillable = null, $generateAccruals = null, \StructType\ItemAccountingBookDetailList $accountingBookDetailList = null, \StructType\RecordRef $costCategory = null, $overheadType = null, $purchaseOrderQuantity = null, $purchaseOrderAmount = null, $purchaseOrderQuantityDiff = null, $receiptQuantity = null, $receiptAmount = null, $receiptQuantityDiff = null, $currency = null, \StructType\ItemOptionsList $itemOptionsList = null, \StructType\MatrixOptionList $matrixOptionList = null, \StructType\ItemVendorList $itemVendorList = null, \StructType\RecordRef $purchaseTaxCode = null, \StructType\RecordRef $salesTaxCode = null, \StructType\TranslationList $translationsList = null, \StructType\RecordRef $vendor = null, \StructType\OtherChargePurchaseItemHierarchyVersionsList $hierarchyVersionsList = null, \StructType\RecordRef $consumptionUnit = null, \StructType\CustomFieldList $customFieldList = null, $internalId = null, $externalId = null)
    {
        $this
            ->setCreatedDate($createdDate)
            ->setLastModifiedDate($lastModifiedDate)
            ->setPurchaseDescription($purchaseDescription)
            ->setManufacturingChargeItem($manufacturingChargeItem)
            ->setCost($cost)
            ->setCostUnits($costUnits)
            ->setExpenseAccount($expenseAccount)
            ->setIsTaxable($isTaxable)
            ->setMatrixType($matrixType)
            ->setUnitsType($unitsType)
            ->setPurchaseUnit($purchaseUnit)
            ->setIncludeChildren($includeChildren)
            ->setIssueProduct($issueProduct)
            ->setCustomForm($customForm)
            ->setItemId($itemId)
            ->setUpcCode($upcCode)
            ->setDisplayName($displayName)
            ->setVendorName($vendorName)
            ->setParent($parent)
            ->setIsInactive($isInactive)
            ->setMatrixItemNameTemplate($matrixItemNameTemplate)
            ->setAvailableToPartners($availableToPartners)
            ->setDepartment($department)
            ->setClass($class)
            ->setSubsidiaryList($subsidiaryList)
            ->setLocation($location)
            ->setTaxSchedule($taxSchedule)
            ->setDeferralAccount($deferralAccount)
            ->setAmortizationTemplate($amortizationTemplate)
            ->setResidual($residual)
            ->setAmortizationPeriod($amortizationPeriod)
            ->setIsFulfillable($isFulfillable)
            ->setGenerateAccruals($generateAccruals)
            ->setAccountingBookDetailList($accountingBookDetailList)
            ->setCostCategory($costCategory)
            ->setOverheadType($overheadType)
            ->setPurchaseOrderQuantity($purchaseOrderQuantity)
            ->setPurchaseOrderAmount($purchaseOrderAmount)
            ->setPurchaseOrderQuantityDiff($purchaseOrderQuantityDiff)
            ->setReceiptQuantity($receiptQuantity)
            ->setReceiptAmount($receiptAmount)
            ->setReceiptQuantityDiff($receiptQuantityDiff)
            ->setCurrency($currency)
            ->setItemOptionsList($itemOptionsList)
            ->setMatrixOptionList($matrixOptionList)
            ->setItemVendorList($itemVendorList)
            ->setPurchaseTaxCode($purchaseTaxCode)
            ->setSalesTaxCode($salesTaxCode)
            ->setTranslationsList($translationsList)
            ->setVendor($vendor)
            ->setHierarchyVersionsList($hierarchyVersionsList)
            ->setConsumptionUnit($consumptionUnit)
            ->setCustomFieldList($customFieldList)
            ->setInternalId($internalId)
            ->setExternalId($externalId);
    }
    /**
     * Get createdDate value
     * @return string|null
     */
    public function getCreatedDate()
    {
        return $this->createdDate;
    }
    /**
     * Set createdDate value
     * @param string $createdDate
     * @return \StructType\OtherChargePurchaseItem
     */
    public function setCreatedDate($createdDate = null)
    {
        // validation for constraint: string
        if (!is_null($createdDate) && !is_string($createdDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createdDate, true), gettype($createdDate)), __LINE__);
        }
        $this->createdDate = $createdDate;
        return $this;
    }
    /**
     * Get lastModifiedDate value
     * @return string|null
     */
    public function getLastModifiedDate()
    {
        return $this->lastModifiedDate;
    }
    /**
     * Set lastModifiedDate value
     * @param string $lastModifiedDate
     * @return \StructType\OtherChargePurchaseItem
     */
    public function setLastModifiedDate($lastModifiedDate = null)
    {
        // validation for constraint: string
        if (!is_null($lastModifiedDate) && !is_string($lastModifiedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastModifiedDate, true), gettype($lastModifiedDate)), __LINE__);
        }
        $this->lastModifiedDate = $lastModifiedDate;
        return $this;
    }
    /**
     * Get purchaseDescription value
     * @return string|null
     */
    public function getPurchaseDescription()
    {
        return $this->purchaseDescription;
    }
    /**
     * Set purchaseDescription value
     * @param string $purchaseDescription
     * @return \StructType\OtherChargePurchaseItem
     */
    public function setPurchaseDescription($purchaseDescription = null)
    {
        // validation for constraint: string
        if (!is_null($purchaseDescription) && !is_string($purchaseDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($purchaseDescription, true), gettype($purchaseDescription)), __LINE__);
        }
        $this->purchaseDescription = $purchaseDescription;
        return $this;
    }
    /**
     * Get manufacturingChargeItem value
     * @return bool|null
     */
    public function getManufacturingChargeItem()
    {
        return $this->manufacturingChargeItem;
    }
    /**
     * Set manufacturingChargeItem value
     * @param bool $manufacturingChargeItem
     * @return \StructType\OtherChargePurchaseItem
     */
    public function setManufacturingChargeItem($manufacturingChargeItem = null)
    {
        // validation for constraint: boolean
        if (!is_null($manufacturingChargeItem) && !is_bool($manufacturingChargeItem)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($manufacturingChargeItem, true), gettype($manufacturingChargeItem)), __LINE__);
        }
        $this->manufacturingChargeItem = $manufacturingChargeItem;
        return $this;
    }
    /**
     * Get cost value
     * @return float|null
     */
    public function getCost()
    {
        return $this->cost;
    }
    /**
     * Set cost value
     * @param float $cost
     * @return \StructType\OtherChargePurchaseItem
     */
    public function setCost($cost = null)
    {
        // validation for constraint: float
        if (!is_null($cost) && !(is_float($cost) || is_numeric($cost))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($cost, true), gettype($cost)), __LINE__);
        }
        $this->cost = $cost;
        return $this;
    }
    /**
     * Get costUnits value
     * @return string|null
     */
    public function getCostUnits()
    {
        return $this->costUnits;
    }
    /**
     * Set costUnits value
     * @param string $costUnits
     * @return \StructType\OtherChargePurchaseItem
     */
    public function setCostUnits($costUnits = null)
    {
        // validation for constraint: string
        if (!is_null($costUnits) && !is_string($costUnits)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($costUnits, true), gettype($costUnits)), __LINE__);
        }
        $this->costUnits = $costUnits;
        return $this;
    }
    /**
     * Get expenseAccount value
     * @return \StructType\RecordRef|null
     */
    public function getExpenseAccount()
    {
        return $this->expenseAccount;
    }
    /**
     * Set expenseAccount value
     * @param \StructType\RecordRef $expenseAccount
     * @return \StructType\OtherChargePurchaseItem
     */
    public function setExpenseAccount(\StructType\RecordRef $expenseAccount = null)
    {
        $this->expenseAccount = $expenseAccount;
        return $this;
    }
    /**
     * Get isTaxable value
     * @return bool|null
     */
    public function getIsTaxable()
    {
        return $this->isTaxable;
    }
    /**
     * Set isTaxable value
     * @param bool $isTaxable
     * @return \StructType\OtherChargePurchaseItem
     */
    public function setIsTaxable($isTaxable = null)
    {
        // validation for constraint: boolean
        if (!is_null($isTaxable) && !is_bool($isTaxable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isTaxable, true), gettype($isTaxable)), __LINE__);
        }
        $this->isTaxable = $isTaxable;
        return $this;
    }
    /**
     * Get matrixType value
     * @return string|null
     */
    public function getMatrixType()
    {
        return $this->matrixType;
    }
    /**
     * Set matrixType value
     * @uses \EnumType\ItemMatrixType::valueIsValid()
     * @uses \EnumType\ItemMatrixType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $matrixType
     * @return \StructType\OtherChargePurchaseItem
     */
    public function setMatrixType($matrixType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ItemMatrixType::valueIsValid($matrixType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\ItemMatrixType', is_array($matrixType) ? implode(', ', $matrixType) : var_export($matrixType, true), implode(', ', \EnumType\ItemMatrixType::getValidValues())), __LINE__);
        }
        $this->matrixType = $matrixType;
        return $this;
    }
    /**
     * Get unitsType value
     * @return \StructType\RecordRef|null
     */
    public function getUnitsType()
    {
        return $this->unitsType;
    }
    /**
     * Set unitsType value
     * @param \StructType\RecordRef $unitsType
     * @return \StructType\OtherChargePurchaseItem
     */
    public function setUnitsType(\StructType\RecordRef $unitsType = null)
    {
        $this->unitsType = $unitsType;
        return $this;
    }
    /**
     * Get purchaseUnit value
     * @return \StructType\RecordRef|null
     */
    public function getPurchaseUnit()
    {
        return $this->purchaseUnit;
    }
    /**
     * Set purchaseUnit value
     * @param \StructType\RecordRef $purchaseUnit
     * @return \StructType\OtherChargePurchaseItem
     */
    public function setPurchaseUnit(\StructType\RecordRef $purchaseUnit = null)
    {
        $this->purchaseUnit = $purchaseUnit;
        return $this;
    }
    /**
     * Get includeChildren value
     * @return bool|null
     */
    public function getIncludeChildren()
    {
        return $this->includeChildren;
    }
    /**
     * Set includeChildren value
     * @param bool $includeChildren
     * @return \StructType\OtherChargePurchaseItem
     */
    public function setIncludeChildren($includeChildren = null)
    {
        // validation for constraint: boolean
        if (!is_null($includeChildren) && !is_bool($includeChildren)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($includeChildren, true), gettype($includeChildren)), __LINE__);
        }
        $this->includeChildren = $includeChildren;
        return $this;
    }
    /**
     * Get issueProduct value
     * @return \StructType\RecordRef|null
     */
    public function getIssueProduct()
    {
        return $this->issueProduct;
    }
    /**
     * Set issueProduct value
     * @param \StructType\RecordRef $issueProduct
     * @return \StructType\OtherChargePurchaseItem
     */
    public function setIssueProduct(\StructType\RecordRef $issueProduct = null)
    {
        $this->issueProduct = $issueProduct;
        return $this;
    }
    /**
     * Get customForm value
     * @return \StructType\RecordRef|null
     */
    public function getCustomForm()
    {
        return $this->customForm;
    }
    /**
     * Set customForm value
     * @param \StructType\RecordRef $customForm
     * @return \StructType\OtherChargePurchaseItem
     */
    public function setCustomForm(\StructType\RecordRef $customForm = null)
    {
        $this->customForm = $customForm;
        return $this;
    }
    /**
     * Get itemId value
     * @return string|null
     */
    public function getItemId()
    {
        return $this->itemId;
    }
    /**
     * Set itemId value
     * @param string $itemId
     * @return \StructType\OtherChargePurchaseItem
     */
    public function setItemId($itemId = null)
    {
        // validation for constraint: string
        if (!is_null($itemId) && !is_string($itemId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($itemId, true), gettype($itemId)), __LINE__);
        }
        $this->itemId = $itemId;
        return $this;
    }
    /**
     * Get upcCode value
     * @return string|null
     */
    public function getUpcCode()
    {
        return $this->upcCode;
    }
    /**
     * Set upcCode value
     * @param string $upcCode
     * @return \StructType\OtherChargePurchaseItem
     */
    public function setUpcCode($upcCode = null)
    {
        // validation for constraint: string
        if (!is_null($upcCode) && !is_string($upcCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($upcCode, true), gettype($upcCode)), __LINE__);
        }
        $this->upcCode = $upcCode;
        return $this;
    }
    /**
     * Get displayName value
     * @return string|null
     */
    public function getDisplayName()
    {
        return $this->displayName;
    }
    /**
     * Set displayName value
     * @param string $displayName
     * @return \StructType\OtherChargePurchaseItem
     */
    public function setDisplayName($displayName = null)
    {
        // validation for constraint: string
        if (!is_null($displayName) && !is_string($displayName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($displayName, true), gettype($displayName)), __LINE__);
        }
        $this->displayName = $displayName;
        return $this;
    }
    /**
     * Get vendorName value
     * @return string|null
     */
    public function getVendorName()
    {
        return $this->vendorName;
    }
    /**
     * Set vendorName value
     * @param string $vendorName
     * @return \StructType\OtherChargePurchaseItem
     */
    public function setVendorName($vendorName = null)
    {
        // validation for constraint: string
        if (!is_null($vendorName) && !is_string($vendorName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vendorName, true), gettype($vendorName)), __LINE__);
        }
        $this->vendorName = $vendorName;
        return $this;
    }
    /**
     * Get parent value
     * @return \StructType\RecordRef|null
     */
    public function getParent()
    {
        return $this->parent;
    }
    /**
     * Set parent value
     * @param \StructType\RecordRef $parent
     * @return \StructType\OtherChargePurchaseItem
     */
    public function setParent(\StructType\RecordRef $parent = null)
    {
        $this->parent = $parent;
        return $this;
    }
    /**
     * Get isInactive value
     * @return bool|null
     */
    public function getIsInactive()
    {
        return $this->isInactive;
    }
    /**
     * Set isInactive value
     * @param bool $isInactive
     * @return \StructType\OtherChargePurchaseItem
     */
    public function setIsInactive($isInactive = null)
    {
        // validation for constraint: boolean
        if (!is_null($isInactive) && !is_bool($isInactive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isInactive, true), gettype($isInactive)), __LINE__);
        }
        $this->isInactive = $isInactive;
        return $this;
    }
    /**
     * Get matrixItemNameTemplate value
     * @return string|null
     */
    public function getMatrixItemNameTemplate()
    {
        return $this->matrixItemNameTemplate;
    }
    /**
     * Set matrixItemNameTemplate value
     * @param string $matrixItemNameTemplate
     * @return \StructType\OtherChargePurchaseItem
     */
    public function setMatrixItemNameTemplate($matrixItemNameTemplate = null)
    {
        // validation for constraint: string
        if (!is_null($matrixItemNameTemplate) && !is_string($matrixItemNameTemplate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($matrixItemNameTemplate, true), gettype($matrixItemNameTemplate)), __LINE__);
        }
        $this->matrixItemNameTemplate = $matrixItemNameTemplate;
        return $this;
    }
    /**
     * Get availableToPartners value
     * @return bool|null
     */
    public function getAvailableToPartners()
    {
        return $this->availableToPartners;
    }
    /**
     * Set availableToPartners value
     * @param bool $availableToPartners
     * @return \StructType\OtherChargePurchaseItem
     */
    public function setAvailableToPartners($availableToPartners = null)
    {
        // validation for constraint: boolean
        if (!is_null($availableToPartners) && !is_bool($availableToPartners)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($availableToPartners, true), gettype($availableToPartners)), __LINE__);
        }
        $this->availableToPartners = $availableToPartners;
        return $this;
    }
    /**
     * Get department value
     * @return \StructType\RecordRef|null
     */
    public function getDepartment()
    {
        return $this->department;
    }
    /**
     * Set department value
     * @param \StructType\RecordRef $department
     * @return \StructType\OtherChargePurchaseItem
     */
    public function setDepartment(\StructType\RecordRef $department = null)
    {
        $this->department = $department;
        return $this;
    }
    /**
     * Get class value
     * @return \StructType\RecordRef|null
     */
    public function getClass()
    {
        return $this->class;
    }
    /**
     * Set class value
     * @param \StructType\RecordRef $class
     * @return \StructType\OtherChargePurchaseItem
     */
    public function setClass(\StructType\RecordRef $class = null)
    {
        $this->class = $class;
        return $this;
    }
    /**
     * Get subsidiaryList value
     * @return \StructType\RecordRefList|null
     */
    public function getSubsidiaryList()
    {
        return $this->subsidiaryList;
    }
    /**
     * Set subsidiaryList value
     * @param \StructType\RecordRefList $subsidiaryList
     * @return \StructType\OtherChargePurchaseItem
     */
    public function setSubsidiaryList(\StructType\RecordRefList $subsidiaryList = null)
    {
        $this->subsidiaryList = $subsidiaryList;
        return $this;
    }
    /**
     * Get location value
     * @return \StructType\RecordRef|null
     */
    public function getLocation()
    {
        return $this->location;
    }
    /**
     * Set location value
     * @param \StructType\RecordRef $location
     * @return \StructType\OtherChargePurchaseItem
     */
    public function setLocation(\StructType\RecordRef $location = null)
    {
        $this->location = $location;
        return $this;
    }
    /**
     * Get taxSchedule value
     * @return \StructType\RecordRef|null
     */
    public function getTaxSchedule()
    {
        return $this->taxSchedule;
    }
    /**
     * Set taxSchedule value
     * @param \StructType\RecordRef $taxSchedule
     * @return \StructType\OtherChargePurchaseItem
     */
    public function setTaxSchedule(\StructType\RecordRef $taxSchedule = null)
    {
        $this->taxSchedule = $taxSchedule;
        return $this;
    }
    /**
     * Get deferralAccount value
     * @return \StructType\RecordRef|null
     */
    public function getDeferralAccount()
    {
        return $this->deferralAccount;
    }
    /**
     * Set deferralAccount value
     * @param \StructType\RecordRef $deferralAccount
     * @return \StructType\OtherChargePurchaseItem
     */
    public function setDeferralAccount(\StructType\RecordRef $deferralAccount = null)
    {
        $this->deferralAccount = $deferralAccount;
        return $this;
    }
    /**
     * Get amortizationTemplate value
     * @return \StructType\RecordRef|null
     */
    public function getAmortizationTemplate()
    {
        return $this->amortizationTemplate;
    }
    /**
     * Set amortizationTemplate value
     * @param \StructType\RecordRef $amortizationTemplate
     * @return \StructType\OtherChargePurchaseItem
     */
    public function setAmortizationTemplate(\StructType\RecordRef $amortizationTemplate = null)
    {
        $this->amortizationTemplate = $amortizationTemplate;
        return $this;
    }
    /**
     * Get residual value
     * @return string|null
     */
    public function getResidual()
    {
        return $this->residual;
    }
    /**
     * Set residual value
     * @param string $residual
     * @return \StructType\OtherChargePurchaseItem
     */
    public function setResidual($residual = null)
    {
        // validation for constraint: string
        if (!is_null($residual) && !is_string($residual)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($residual, true), gettype($residual)), __LINE__);
        }
        $this->residual = $residual;
        return $this;
    }
    /**
     * Get amortizationPeriod value
     * @return int|null
     */
    public function getAmortizationPeriod()
    {
        return $this->amortizationPeriod;
    }
    /**
     * Set amortizationPeriod value
     * @param int $amortizationPeriod
     * @return \StructType\OtherChargePurchaseItem
     */
    public function setAmortizationPeriod($amortizationPeriod = null)
    {
        // validation for constraint: int
        if (!is_null($amortizationPeriod) && !(is_int($amortizationPeriod) || ctype_digit($amortizationPeriod))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($amortizationPeriod, true), gettype($amortizationPeriod)), __LINE__);
        }
        $this->amortizationPeriod = $amortizationPeriod;
        return $this;
    }
    /**
     * Get isFulfillable value
     * @return bool|null
     */
    public function getIsFulfillable()
    {
        return $this->isFulfillable;
    }
    /**
     * Set isFulfillable value
     * @param bool $isFulfillable
     * @return \StructType\OtherChargePurchaseItem
     */
    public function setIsFulfillable($isFulfillable = null)
    {
        // validation for constraint: boolean
        if (!is_null($isFulfillable) && !is_bool($isFulfillable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isFulfillable, true), gettype($isFulfillable)), __LINE__);
        }
        $this->isFulfillable = $isFulfillable;
        return $this;
    }
    /**
     * Get generateAccruals value
     * @return bool|null
     */
    public function getGenerateAccruals()
    {
        return $this->generateAccruals;
    }
    /**
     * Set generateAccruals value
     * @param bool $generateAccruals
     * @return \StructType\OtherChargePurchaseItem
     */
    public function setGenerateAccruals($generateAccruals = null)
    {
        // validation for constraint: boolean
        if (!is_null($generateAccruals) && !is_bool($generateAccruals)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($generateAccruals, true), gettype($generateAccruals)), __LINE__);
        }
        $this->generateAccruals = $generateAccruals;
        return $this;
    }
    /**
     * Get accountingBookDetailList value
     * @return \StructType\ItemAccountingBookDetailList|null
     */
    public function getAccountingBookDetailList()
    {
        return $this->accountingBookDetailList;
    }
    /**
     * Set accountingBookDetailList value
     * @param \StructType\ItemAccountingBookDetailList $accountingBookDetailList
     * @return \StructType\OtherChargePurchaseItem
     */
    public function setAccountingBookDetailList(\StructType\ItemAccountingBookDetailList $accountingBookDetailList = null)
    {
        $this->accountingBookDetailList = $accountingBookDetailList;
        return $this;
    }
    /**
     * Get costCategory value
     * @return \StructType\RecordRef|null
     */
    public function getCostCategory()
    {
        return $this->costCategory;
    }
    /**
     * Set costCategory value
     * @param \StructType\RecordRef $costCategory
     * @return \StructType\OtherChargePurchaseItem
     */
    public function setCostCategory(\StructType\RecordRef $costCategory = null)
    {
        $this->costCategory = $costCategory;
        return $this;
    }
    /**
     * Get overheadType value
     * @return string|null
     */
    public function getOverheadType()
    {
        return $this->overheadType;
    }
    /**
     * Set overheadType value
     * @uses \EnumType\ItemOverheadType::valueIsValid()
     * @uses \EnumType\ItemOverheadType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $overheadType
     * @return \StructType\OtherChargePurchaseItem
     */
    public function setOverheadType($overheadType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ItemOverheadType::valueIsValid($overheadType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\ItemOverheadType', is_array($overheadType) ? implode(', ', $overheadType) : var_export($overheadType, true), implode(', ', \EnumType\ItemOverheadType::getValidValues())), __LINE__);
        }
        $this->overheadType = $overheadType;
        return $this;
    }
    /**
     * Get purchaseOrderQuantity value
     * @return float|null
     */
    public function getPurchaseOrderQuantity()
    {
        return $this->purchaseOrderQuantity;
    }
    /**
     * Set purchaseOrderQuantity value
     * @param float $purchaseOrderQuantity
     * @return \StructType\OtherChargePurchaseItem
     */
    public function setPurchaseOrderQuantity($purchaseOrderQuantity = null)
    {
        // validation for constraint: float
        if (!is_null($purchaseOrderQuantity) && !(is_float($purchaseOrderQuantity) || is_numeric($purchaseOrderQuantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($purchaseOrderQuantity, true), gettype($purchaseOrderQuantity)), __LINE__);
        }
        $this->purchaseOrderQuantity = $purchaseOrderQuantity;
        return $this;
    }
    /**
     * Get purchaseOrderAmount value
     * @return float|null
     */
    public function getPurchaseOrderAmount()
    {
        return $this->purchaseOrderAmount;
    }
    /**
     * Set purchaseOrderAmount value
     * @param float $purchaseOrderAmount
     * @return \StructType\OtherChargePurchaseItem
     */
    public function setPurchaseOrderAmount($purchaseOrderAmount = null)
    {
        // validation for constraint: float
        if (!is_null($purchaseOrderAmount) && !(is_float($purchaseOrderAmount) || is_numeric($purchaseOrderAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($purchaseOrderAmount, true), gettype($purchaseOrderAmount)), __LINE__);
        }
        $this->purchaseOrderAmount = $purchaseOrderAmount;
        return $this;
    }
    /**
     * Get purchaseOrderQuantityDiff value
     * @return float|null
     */
    public function getPurchaseOrderQuantityDiff()
    {
        return $this->purchaseOrderQuantityDiff;
    }
    /**
     * Set purchaseOrderQuantityDiff value
     * @param float $purchaseOrderQuantityDiff
     * @return \StructType\OtherChargePurchaseItem
     */
    public function setPurchaseOrderQuantityDiff($purchaseOrderQuantityDiff = null)
    {
        // validation for constraint: float
        if (!is_null($purchaseOrderQuantityDiff) && !(is_float($purchaseOrderQuantityDiff) || is_numeric($purchaseOrderQuantityDiff))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($purchaseOrderQuantityDiff, true), gettype($purchaseOrderQuantityDiff)), __LINE__);
        }
        $this->purchaseOrderQuantityDiff = $purchaseOrderQuantityDiff;
        return $this;
    }
    /**
     * Get receiptQuantity value
     * @return float|null
     */
    public function getReceiptQuantity()
    {
        return $this->receiptQuantity;
    }
    /**
     * Set receiptQuantity value
     * @param float $receiptQuantity
     * @return \StructType\OtherChargePurchaseItem
     */
    public function setReceiptQuantity($receiptQuantity = null)
    {
        // validation for constraint: float
        if (!is_null($receiptQuantity) && !(is_float($receiptQuantity) || is_numeric($receiptQuantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($receiptQuantity, true), gettype($receiptQuantity)), __LINE__);
        }
        $this->receiptQuantity = $receiptQuantity;
        return $this;
    }
    /**
     * Get receiptAmount value
     * @return float|null
     */
    public function getReceiptAmount()
    {
        return $this->receiptAmount;
    }
    /**
     * Set receiptAmount value
     * @param float $receiptAmount
     * @return \StructType\OtherChargePurchaseItem
     */
    public function setReceiptAmount($receiptAmount = null)
    {
        // validation for constraint: float
        if (!is_null($receiptAmount) && !(is_float($receiptAmount) || is_numeric($receiptAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($receiptAmount, true), gettype($receiptAmount)), __LINE__);
        }
        $this->receiptAmount = $receiptAmount;
        return $this;
    }
    /**
     * Get receiptQuantityDiff value
     * @return float|null
     */
    public function getReceiptQuantityDiff()
    {
        return $this->receiptQuantityDiff;
    }
    /**
     * Set receiptQuantityDiff value
     * @param float $receiptQuantityDiff
     * @return \StructType\OtherChargePurchaseItem
     */
    public function setReceiptQuantityDiff($receiptQuantityDiff = null)
    {
        // validation for constraint: float
        if (!is_null($receiptQuantityDiff) && !(is_float($receiptQuantityDiff) || is_numeric($receiptQuantityDiff))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($receiptQuantityDiff, true), gettype($receiptQuantityDiff)), __LINE__);
        }
        $this->receiptQuantityDiff = $receiptQuantityDiff;
        return $this;
    }
    /**
     * Get currency value
     * @return string|null
     */
    public function getCurrency()
    {
        return $this->currency;
    }
    /**
     * Set currency value
     * @param string $currency
     * @return \StructType\OtherChargePurchaseItem
     */
    public function setCurrency($currency = null)
    {
        // validation for constraint: string
        if (!is_null($currency) && !is_string($currency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currency, true), gettype($currency)), __LINE__);
        }
        $this->currency = $currency;
        return $this;
    }
    /**
     * Get itemOptionsList value
     * @return \StructType\ItemOptionsList|null
     */
    public function getItemOptionsList()
    {
        return $this->itemOptionsList;
    }
    /**
     * Set itemOptionsList value
     * @param \StructType\ItemOptionsList $itemOptionsList
     * @return \StructType\OtherChargePurchaseItem
     */
    public function setItemOptionsList(\StructType\ItemOptionsList $itemOptionsList = null)
    {
        $this->itemOptionsList = $itemOptionsList;
        return $this;
    }
    /**
     * Get matrixOptionList value
     * @return \StructType\MatrixOptionList|null
     */
    public function getMatrixOptionList()
    {
        return $this->matrixOptionList;
    }
    /**
     * Set matrixOptionList value
     * @param \StructType\MatrixOptionList $matrixOptionList
     * @return \StructType\OtherChargePurchaseItem
     */
    public function setMatrixOptionList(\StructType\MatrixOptionList $matrixOptionList = null)
    {
        $this->matrixOptionList = $matrixOptionList;
        return $this;
    }
    /**
     * Get itemVendorList value
     * @return \StructType\ItemVendorList|null
     */
    public function getItemVendorList()
    {
        return $this->itemVendorList;
    }
    /**
     * Set itemVendorList value
     * @param \StructType\ItemVendorList $itemVendorList
     * @return \StructType\OtherChargePurchaseItem
     */
    public function setItemVendorList(\StructType\ItemVendorList $itemVendorList = null)
    {
        $this->itemVendorList = $itemVendorList;
        return $this;
    }
    /**
     * Get purchaseTaxCode value
     * @return \StructType\RecordRef|null
     */
    public function getPurchaseTaxCode()
    {
        return $this->purchaseTaxCode;
    }
    /**
     * Set purchaseTaxCode value
     * @param \StructType\RecordRef $purchaseTaxCode
     * @return \StructType\OtherChargePurchaseItem
     */
    public function setPurchaseTaxCode(\StructType\RecordRef $purchaseTaxCode = null)
    {
        $this->purchaseTaxCode = $purchaseTaxCode;
        return $this;
    }
    /**
     * Get salesTaxCode value
     * @return \StructType\RecordRef|null
     */
    public function getSalesTaxCode()
    {
        return $this->salesTaxCode;
    }
    /**
     * Set salesTaxCode value
     * @param \StructType\RecordRef $salesTaxCode
     * @return \StructType\OtherChargePurchaseItem
     */
    public function setSalesTaxCode(\StructType\RecordRef $salesTaxCode = null)
    {
        $this->salesTaxCode = $salesTaxCode;
        return $this;
    }
    /**
     * Get translationsList value
     * @return \StructType\TranslationList|null
     */
    public function getTranslationsList()
    {
        return $this->translationsList;
    }
    /**
     * Set translationsList value
     * @param \StructType\TranslationList $translationsList
     * @return \StructType\OtherChargePurchaseItem
     */
    public function setTranslationsList(\StructType\TranslationList $translationsList = null)
    {
        $this->translationsList = $translationsList;
        return $this;
    }
    /**
     * Get vendor value
     * @return \StructType\RecordRef|null
     */
    public function getVendor()
    {
        return $this->vendor;
    }
    /**
     * Set vendor value
     * @param \StructType\RecordRef $vendor
     * @return \StructType\OtherChargePurchaseItem
     */
    public function setVendor(\StructType\RecordRef $vendor = null)
    {
        $this->vendor = $vendor;
        return $this;
    }
    /**
     * Get hierarchyVersionsList value
     * @return \StructType\OtherChargePurchaseItemHierarchyVersionsList|null
     */
    public function getHierarchyVersionsList()
    {
        return $this->hierarchyVersionsList;
    }
    /**
     * Set hierarchyVersionsList value
     * @param \StructType\OtherChargePurchaseItemHierarchyVersionsList $hierarchyVersionsList
     * @return \StructType\OtherChargePurchaseItem
     */
    public function setHierarchyVersionsList(\StructType\OtherChargePurchaseItemHierarchyVersionsList $hierarchyVersionsList = null)
    {
        $this->hierarchyVersionsList = $hierarchyVersionsList;
        return $this;
    }
    /**
     * Get consumptionUnit value
     * @return \StructType\RecordRef|null
     */
    public function getConsumptionUnit()
    {
        return $this->consumptionUnit;
    }
    /**
     * Set consumptionUnit value
     * @param \StructType\RecordRef $consumptionUnit
     * @return \StructType\OtherChargePurchaseItem
     */
    public function setConsumptionUnit(\StructType\RecordRef $consumptionUnit = null)
    {
        $this->consumptionUnit = $consumptionUnit;
        return $this;
    }
    /**
     * Get customFieldList value
     * @return \StructType\CustomFieldList|null
     */
    public function getCustomFieldList()
    {
        return $this->customFieldList;
    }
    /**
     * Set customFieldList value
     * @param \StructType\CustomFieldList $customFieldList
     * @return \StructType\OtherChargePurchaseItem
     */
    public function setCustomFieldList(\StructType\CustomFieldList $customFieldList = null)
    {
        $this->customFieldList = $customFieldList;
        return $this;
    }
    /**
     * Get internalId value
     * @return string|null
     */
    public function getInternalId()
    {
        return $this->internalId;
    }
    /**
     * Set internalId value
     * @param string $internalId
     * @return \StructType\OtherChargePurchaseItem
     */
    public function setInternalId($internalId = null)
    {
        // validation for constraint: string
        if (!is_null($internalId) && !is_string($internalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($internalId, true), gettype($internalId)), __LINE__);
        }
        $this->internalId = $internalId;
        return $this;
    }
    /**
     * Get externalId value
     * @return string|null
     */
    public function getExternalId()
    {
        return $this->externalId;
    }
    /**
     * Set externalId value
     * @param string $externalId
     * @return \StructType\OtherChargePurchaseItem
     */
    public function setExternalId($externalId = null)
    {
        // validation for constraint: string
        if (!is_null($externalId) && !is_string($externalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($externalId, true), gettype($externalId)), __LINE__);
        }
        $this->externalId = $externalId;
        return $this;
    }
}
