<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OpportunitySearchBasic StructType
 * @subpackage Structs
 */
class OpportunitySearchBasic extends SearchRecordBasic
{
    /**
     * The amount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SearchDoubleField
     */
    public $amount;
    /**
     * The availableOffline
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SearchBooleanField
     */
    public $availableOffline;
    /**
     * The buyingReason
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SearchMultiSelectField
     */
    public $buyingReason;
    /**
     * The buyingTimeFrame
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SearchMultiSelectField
     */
    public $buyingTimeFrame;
    /**
     * The class
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SearchMultiSelectField
     */
    public $class;
    /**
     * The closeDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SearchDateField
     */
    public $closeDate;
    /**
     * The competitor
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SearchMultiSelectField
     */
    public $competitor;
    /**
     * The contribution
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SearchLongField
     */
    public $contribution;
    /**
     * The currency
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SearchMultiSelectField
     */
    public $currency;
    /**
     * The custType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SearchMultiSelectField
     */
    public $custType;
    /**
     * The dateCreated
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SearchDateField
     */
    public $dateCreated;
    /**
     * The daysOpen
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SearchLongField
     */
    public $daysOpen;
    /**
     * The daysToClose
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SearchLongField
     */
    public $daysToClose;
    /**
     * The department
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SearchMultiSelectField
     */
    public $department;
    /**
     * The entity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SearchMultiSelectField
     */
    public $entity;
    /**
     * The entityStatus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SearchMultiSelectField
     */
    public $entityStatus;
    /**
     * The estimatedBudget
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SearchDoubleField
     */
    public $estimatedBudget;
    /**
     * The expectedCloseDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SearchDateField
     */
    public $expectedCloseDate;
    /**
     * The externalId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SearchMultiSelectField
     */
    public $externalId;
    /**
     * The externalIdString
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SearchStringField
     */
    public $externalIdString;
    /**
     * The forecastType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SearchEnumMultiSelectField
     */
    public $forecastType;
    /**
     * The foreignProjectedAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SearchDoubleField
     */
    public $foreignProjectedAmount;
    /**
     * The foreignRangeHigh
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SearchDoubleField
     */
    public $foreignRangeHigh;
    /**
     * The foreignRangeLow
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SearchDoubleField
     */
    public $foreignRangeLow;
    /**
     * The fxTranCostEstimate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SearchDoubleField
     */
    public $fxTranCostEstimate;
    /**
     * The internalId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SearchMultiSelectField
     */
    public $internalId;
    /**
     * The internalIdNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SearchLongField
     */
    public $internalIdNumber;
    /**
     * The isBudgetApproved
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SearchBooleanField
     */
    public $isBudgetApproved;
    /**
     * The item
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SearchMultiSelectField
     */
    public $item;
    /**
     * The lastModifiedDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SearchDateField
     */
    public $lastModifiedDate;
    /**
     * The leadSource
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SearchMultiSelectField
     */
    public $leadSource;
    /**
     * The location
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SearchMultiSelectField
     */
    public $location;
    /**
     * The memo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SearchStringField
     */
    public $memo;
    /**
     * The number
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SearchLongField
     */
    public $number;
    /**
     * The partner
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SearchMultiSelectField
     */
    public $partner;
    /**
     * The partnerContribution
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SearchLongField
     */
    public $partnerContribution;
    /**
     * The partnerRole
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SearchMultiSelectField
     */
    public $partnerRole;
    /**
     * The partnerTeamMember
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SearchMultiSelectField
     */
    public $partnerTeamMember;
    /**
     * The postingPeriod
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $postingPeriod;
    /**
     * The postingPeriodRelative
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $postingPeriodRelative;
    /**
     * The probability
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SearchLongField
     */
    public $probability;
    /**
     * The projAltSalesAmt
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SearchDoubleField
     */
    public $projAltSalesAmt;
    /**
     * The projectedTotal
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SearchDoubleField
     */
    public $projectedTotal;
    /**
     * The rangeHigh
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SearchDoubleField
     */
    public $rangeHigh;
    /**
     * The rangeHighAlt
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SearchDoubleField
     */
    public $rangeHighAlt;
    /**
     * The rangeLow
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SearchDoubleField
     */
    public $rangeLow;
    /**
     * The rangeLowAlt
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SearchDoubleField
     */
    public $rangeLowAlt;
    /**
     * The salesReadiness
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SearchMultiSelectField
     */
    public $salesReadiness;
    /**
     * The salesRep
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SearchMultiSelectField
     */
    public $salesRep;
    /**
     * The salesTeamMember
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SearchMultiSelectField
     */
    public $salesTeamMember;
    /**
     * The salesTeamRole
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SearchMultiSelectField
     */
    public $salesTeamRole;
    /**
     * The status
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SearchEnumMultiSelectField
     */
    public $status;
    /**
     * The subsidiary
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SearchMultiSelectField
     */
    public $subsidiary;
    /**
     * The taxPeriod
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $taxPeriod;
    /**
     * The taxPeriodRelative
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $taxPeriodRelative;
    /**
     * The title
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SearchStringField
     */
    public $title;
    /**
     * The tranCostEstimate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SearchDoubleField
     */
    public $tranCostEstimate;
    /**
     * The tranDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SearchDateField
     */
    public $tranDate;
    /**
     * The tranEstGrossProfit
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SearchDoubleField
     */
    public $tranEstGrossProfit;
    /**
     * The tranEstGrossProfitPct
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SearchDoubleField
     */
    public $tranEstGrossProfitPct;
    /**
     * The tranFxEstGrossProfit
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SearchDoubleField
     */
    public $tranFxEstGrossProfit;
    /**
     * The tranId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SearchStringField
     */
    public $tranId;
    /**
     * The winLossReason
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SearchMultiSelectField
     */
    public $winLossReason;
    /**
     * The wonBy
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SearchMultiSelectField
     */
    public $wonBy;
    /**
     * The customFieldList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SearchCustomFieldList
     */
    public $customFieldList;
    /**
     * Constructor method for OpportunitySearchBasic
     * @uses OpportunitySearchBasic::setAmount()
     * @uses OpportunitySearchBasic::setAvailableOffline()
     * @uses OpportunitySearchBasic::setBuyingReason()
     * @uses OpportunitySearchBasic::setBuyingTimeFrame()
     * @uses OpportunitySearchBasic::setClass()
     * @uses OpportunitySearchBasic::setCloseDate()
     * @uses OpportunitySearchBasic::setCompetitor()
     * @uses OpportunitySearchBasic::setContribution()
     * @uses OpportunitySearchBasic::setCurrency()
     * @uses OpportunitySearchBasic::setCustType()
     * @uses OpportunitySearchBasic::setDateCreated()
     * @uses OpportunitySearchBasic::setDaysOpen()
     * @uses OpportunitySearchBasic::setDaysToClose()
     * @uses OpportunitySearchBasic::setDepartment()
     * @uses OpportunitySearchBasic::setEntity()
     * @uses OpportunitySearchBasic::setEntityStatus()
     * @uses OpportunitySearchBasic::setEstimatedBudget()
     * @uses OpportunitySearchBasic::setExpectedCloseDate()
     * @uses OpportunitySearchBasic::setExternalId()
     * @uses OpportunitySearchBasic::setExternalIdString()
     * @uses OpportunitySearchBasic::setForecastType()
     * @uses OpportunitySearchBasic::setForeignProjectedAmount()
     * @uses OpportunitySearchBasic::setForeignRangeHigh()
     * @uses OpportunitySearchBasic::setForeignRangeLow()
     * @uses OpportunitySearchBasic::setFxTranCostEstimate()
     * @uses OpportunitySearchBasic::setInternalId()
     * @uses OpportunitySearchBasic::setInternalIdNumber()
     * @uses OpportunitySearchBasic::setIsBudgetApproved()
     * @uses OpportunitySearchBasic::setItem()
     * @uses OpportunitySearchBasic::setLastModifiedDate()
     * @uses OpportunitySearchBasic::setLeadSource()
     * @uses OpportunitySearchBasic::setLocation()
     * @uses OpportunitySearchBasic::setMemo()
     * @uses OpportunitySearchBasic::setNumber()
     * @uses OpportunitySearchBasic::setPartner()
     * @uses OpportunitySearchBasic::setPartnerContribution()
     * @uses OpportunitySearchBasic::setPartnerRole()
     * @uses OpportunitySearchBasic::setPartnerTeamMember()
     * @uses OpportunitySearchBasic::setPostingPeriod()
     * @uses OpportunitySearchBasic::setPostingPeriodRelative()
     * @uses OpportunitySearchBasic::setProbability()
     * @uses OpportunitySearchBasic::setProjAltSalesAmt()
     * @uses OpportunitySearchBasic::setProjectedTotal()
     * @uses OpportunitySearchBasic::setRangeHigh()
     * @uses OpportunitySearchBasic::setRangeHighAlt()
     * @uses OpportunitySearchBasic::setRangeLow()
     * @uses OpportunitySearchBasic::setRangeLowAlt()
     * @uses OpportunitySearchBasic::setSalesReadiness()
     * @uses OpportunitySearchBasic::setSalesRep()
     * @uses OpportunitySearchBasic::setSalesTeamMember()
     * @uses OpportunitySearchBasic::setSalesTeamRole()
     * @uses OpportunitySearchBasic::setStatus()
     * @uses OpportunitySearchBasic::setSubsidiary()
     * @uses OpportunitySearchBasic::setTaxPeriod()
     * @uses OpportunitySearchBasic::setTaxPeriodRelative()
     * @uses OpportunitySearchBasic::setTitle()
     * @uses OpportunitySearchBasic::setTranCostEstimate()
     * @uses OpportunitySearchBasic::setTranDate()
     * @uses OpportunitySearchBasic::setTranEstGrossProfit()
     * @uses OpportunitySearchBasic::setTranEstGrossProfitPct()
     * @uses OpportunitySearchBasic::setTranFxEstGrossProfit()
     * @uses OpportunitySearchBasic::setTranId()
     * @uses OpportunitySearchBasic::setWinLossReason()
     * @uses OpportunitySearchBasic::setWonBy()
     * @uses OpportunitySearchBasic::setCustomFieldList()
     * @param \StructType\SearchDoubleField $amount
     * @param \StructType\SearchBooleanField $availableOffline
     * @param \StructType\SearchMultiSelectField $buyingReason
     * @param \StructType\SearchMultiSelectField $buyingTimeFrame
     * @param \StructType\SearchMultiSelectField $class
     * @param \StructType\SearchDateField $closeDate
     * @param \StructType\SearchMultiSelectField $competitor
     * @param \StructType\SearchLongField $contribution
     * @param \StructType\SearchMultiSelectField $currency
     * @param \StructType\SearchMultiSelectField $custType
     * @param \StructType\SearchDateField $dateCreated
     * @param \StructType\SearchLongField $daysOpen
     * @param \StructType\SearchLongField $daysToClose
     * @param \StructType\SearchMultiSelectField $department
     * @param \StructType\SearchMultiSelectField $entity
     * @param \StructType\SearchMultiSelectField $entityStatus
     * @param \StructType\SearchDoubleField $estimatedBudget
     * @param \StructType\SearchDateField $expectedCloseDate
     * @param \StructType\SearchMultiSelectField $externalId
     * @param \StructType\SearchStringField $externalIdString
     * @param \StructType\SearchEnumMultiSelectField $forecastType
     * @param \StructType\SearchDoubleField $foreignProjectedAmount
     * @param \StructType\SearchDoubleField $foreignRangeHigh
     * @param \StructType\SearchDoubleField $foreignRangeLow
     * @param \StructType\SearchDoubleField $fxTranCostEstimate
     * @param \StructType\SearchMultiSelectField $internalId
     * @param \StructType\SearchLongField $internalIdNumber
     * @param \StructType\SearchBooleanField $isBudgetApproved
     * @param \StructType\SearchMultiSelectField $item
     * @param \StructType\SearchDateField $lastModifiedDate
     * @param \StructType\SearchMultiSelectField $leadSource
     * @param \StructType\SearchMultiSelectField $location
     * @param \StructType\SearchStringField $memo
     * @param \StructType\SearchLongField $number
     * @param \StructType\SearchMultiSelectField $partner
     * @param \StructType\SearchLongField $partnerContribution
     * @param \StructType\SearchMultiSelectField $partnerRole
     * @param \StructType\SearchMultiSelectField $partnerTeamMember
     * @param \StructType\RecordRef $postingPeriod
     * @param string $postingPeriodRelative
     * @param \StructType\SearchLongField $probability
     * @param \StructType\SearchDoubleField $projAltSalesAmt
     * @param \StructType\SearchDoubleField $projectedTotal
     * @param \StructType\SearchDoubleField $rangeHigh
     * @param \StructType\SearchDoubleField $rangeHighAlt
     * @param \StructType\SearchDoubleField $rangeLow
     * @param \StructType\SearchDoubleField $rangeLowAlt
     * @param \StructType\SearchMultiSelectField $salesReadiness
     * @param \StructType\SearchMultiSelectField $salesRep
     * @param \StructType\SearchMultiSelectField $salesTeamMember
     * @param \StructType\SearchMultiSelectField $salesTeamRole
     * @param \StructType\SearchEnumMultiSelectField $status
     * @param \StructType\SearchMultiSelectField $subsidiary
     * @param \StructType\RecordRef $taxPeriod
     * @param string $taxPeriodRelative
     * @param \StructType\SearchStringField $title
     * @param \StructType\SearchDoubleField $tranCostEstimate
     * @param \StructType\SearchDateField $tranDate
     * @param \StructType\SearchDoubleField $tranEstGrossProfit
     * @param \StructType\SearchDoubleField $tranEstGrossProfitPct
     * @param \StructType\SearchDoubleField $tranFxEstGrossProfit
     * @param \StructType\SearchStringField $tranId
     * @param \StructType\SearchMultiSelectField $winLossReason
     * @param \StructType\SearchMultiSelectField $wonBy
     * @param \StructType\SearchCustomFieldList $customFieldList
     */
    public function __construct(\StructType\SearchDoubleField $amount = null, \StructType\SearchBooleanField $availableOffline = null, \StructType\SearchMultiSelectField $buyingReason = null, \StructType\SearchMultiSelectField $buyingTimeFrame = null, \StructType\SearchMultiSelectField $class = null, \StructType\SearchDateField $closeDate = null, \StructType\SearchMultiSelectField $competitor = null, \StructType\SearchLongField $contribution = null, \StructType\SearchMultiSelectField $currency = null, \StructType\SearchMultiSelectField $custType = null, \StructType\SearchDateField $dateCreated = null, \StructType\SearchLongField $daysOpen = null, \StructType\SearchLongField $daysToClose = null, \StructType\SearchMultiSelectField $department = null, \StructType\SearchMultiSelectField $entity = null, \StructType\SearchMultiSelectField $entityStatus = null, \StructType\SearchDoubleField $estimatedBudget = null, \StructType\SearchDateField $expectedCloseDate = null, \StructType\SearchMultiSelectField $externalId = null, \StructType\SearchStringField $externalIdString = null, \StructType\SearchEnumMultiSelectField $forecastType = null, \StructType\SearchDoubleField $foreignProjectedAmount = null, \StructType\SearchDoubleField $foreignRangeHigh = null, \StructType\SearchDoubleField $foreignRangeLow = null, \StructType\SearchDoubleField $fxTranCostEstimate = null, \StructType\SearchMultiSelectField $internalId = null, \StructType\SearchLongField $internalIdNumber = null, \StructType\SearchBooleanField $isBudgetApproved = null, \StructType\SearchMultiSelectField $item = null, \StructType\SearchDateField $lastModifiedDate = null, \StructType\SearchMultiSelectField $leadSource = null, \StructType\SearchMultiSelectField $location = null, \StructType\SearchStringField $memo = null, \StructType\SearchLongField $number = null, \StructType\SearchMultiSelectField $partner = null, \StructType\SearchLongField $partnerContribution = null, \StructType\SearchMultiSelectField $partnerRole = null, \StructType\SearchMultiSelectField $partnerTeamMember = null, \StructType\RecordRef $postingPeriod = null, $postingPeriodRelative = null, \StructType\SearchLongField $probability = null, \StructType\SearchDoubleField $projAltSalesAmt = null, \StructType\SearchDoubleField $projectedTotal = null, \StructType\SearchDoubleField $rangeHigh = null, \StructType\SearchDoubleField $rangeHighAlt = null, \StructType\SearchDoubleField $rangeLow = null, \StructType\SearchDoubleField $rangeLowAlt = null, \StructType\SearchMultiSelectField $salesReadiness = null, \StructType\SearchMultiSelectField $salesRep = null, \StructType\SearchMultiSelectField $salesTeamMember = null, \StructType\SearchMultiSelectField $salesTeamRole = null, \StructType\SearchEnumMultiSelectField $status = null, \StructType\SearchMultiSelectField $subsidiary = null, \StructType\RecordRef $taxPeriod = null, $taxPeriodRelative = null, \StructType\SearchStringField $title = null, \StructType\SearchDoubleField $tranCostEstimate = null, \StructType\SearchDateField $tranDate = null, \StructType\SearchDoubleField $tranEstGrossProfit = null, \StructType\SearchDoubleField $tranEstGrossProfitPct = null, \StructType\SearchDoubleField $tranFxEstGrossProfit = null, \StructType\SearchStringField $tranId = null, \StructType\SearchMultiSelectField $winLossReason = null, \StructType\SearchMultiSelectField $wonBy = null, \StructType\SearchCustomFieldList $customFieldList = null)
    {
        $this
            ->setAmount($amount)
            ->setAvailableOffline($availableOffline)
            ->setBuyingReason($buyingReason)
            ->setBuyingTimeFrame($buyingTimeFrame)
            ->setClass($class)
            ->setCloseDate($closeDate)
            ->setCompetitor($competitor)
            ->setContribution($contribution)
            ->setCurrency($currency)
            ->setCustType($custType)
            ->setDateCreated($dateCreated)
            ->setDaysOpen($daysOpen)
            ->setDaysToClose($daysToClose)
            ->setDepartment($department)
            ->setEntity($entity)
            ->setEntityStatus($entityStatus)
            ->setEstimatedBudget($estimatedBudget)
            ->setExpectedCloseDate($expectedCloseDate)
            ->setExternalId($externalId)
            ->setExternalIdString($externalIdString)
            ->setForecastType($forecastType)
            ->setForeignProjectedAmount($foreignProjectedAmount)
            ->setForeignRangeHigh($foreignRangeHigh)
            ->setForeignRangeLow($foreignRangeLow)
            ->setFxTranCostEstimate($fxTranCostEstimate)
            ->setInternalId($internalId)
            ->setInternalIdNumber($internalIdNumber)
            ->setIsBudgetApproved($isBudgetApproved)
            ->setItem($item)
            ->setLastModifiedDate($lastModifiedDate)
            ->setLeadSource($leadSource)
            ->setLocation($location)
            ->setMemo($memo)
            ->setNumber($number)
            ->setPartner($partner)
            ->setPartnerContribution($partnerContribution)
            ->setPartnerRole($partnerRole)
            ->setPartnerTeamMember($partnerTeamMember)
            ->setPostingPeriod($postingPeriod)
            ->setPostingPeriodRelative($postingPeriodRelative)
            ->setProbability($probability)
            ->setProjAltSalesAmt($projAltSalesAmt)
            ->setProjectedTotal($projectedTotal)
            ->setRangeHigh($rangeHigh)
            ->setRangeHighAlt($rangeHighAlt)
            ->setRangeLow($rangeLow)
            ->setRangeLowAlt($rangeLowAlt)
            ->setSalesReadiness($salesReadiness)
            ->setSalesRep($salesRep)
            ->setSalesTeamMember($salesTeamMember)
            ->setSalesTeamRole($salesTeamRole)
            ->setStatus($status)
            ->setSubsidiary($subsidiary)
            ->setTaxPeriod($taxPeriod)
            ->setTaxPeriodRelative($taxPeriodRelative)
            ->setTitle($title)
            ->setTranCostEstimate($tranCostEstimate)
            ->setTranDate($tranDate)
            ->setTranEstGrossProfit($tranEstGrossProfit)
            ->setTranEstGrossProfitPct($tranEstGrossProfitPct)
            ->setTranFxEstGrossProfit($tranFxEstGrossProfit)
            ->setTranId($tranId)
            ->setWinLossReason($winLossReason)
            ->setWonBy($wonBy)
            ->setCustomFieldList($customFieldList);
    }
    /**
     * Get amount value
     * @return \StructType\SearchDoubleField|null
     */
    public function getAmount()
    {
        return $this->amount;
    }
    /**
     * Set amount value
     * @param \StructType\SearchDoubleField $amount
     * @return \StructType\OpportunitySearchBasic
     */
    public function setAmount(\StructType\SearchDoubleField $amount = null)
    {
        $this->amount = $amount;
        return $this;
    }
    /**
     * Get availableOffline value
     * @return \StructType\SearchBooleanField|null
     */
    public function getAvailableOffline()
    {
        return $this->availableOffline;
    }
    /**
     * Set availableOffline value
     * @param \StructType\SearchBooleanField $availableOffline
     * @return \StructType\OpportunitySearchBasic
     */
    public function setAvailableOffline(\StructType\SearchBooleanField $availableOffline = null)
    {
        $this->availableOffline = $availableOffline;
        return $this;
    }
    /**
     * Get buyingReason value
     * @return \StructType\SearchMultiSelectField|null
     */
    public function getBuyingReason()
    {
        return $this->buyingReason;
    }
    /**
     * Set buyingReason value
     * @param \StructType\SearchMultiSelectField $buyingReason
     * @return \StructType\OpportunitySearchBasic
     */
    public function setBuyingReason(\StructType\SearchMultiSelectField $buyingReason = null)
    {
        $this->buyingReason = $buyingReason;
        return $this;
    }
    /**
     * Get buyingTimeFrame value
     * @return \StructType\SearchMultiSelectField|null
     */
    public function getBuyingTimeFrame()
    {
        return $this->buyingTimeFrame;
    }
    /**
     * Set buyingTimeFrame value
     * @param \StructType\SearchMultiSelectField $buyingTimeFrame
     * @return \StructType\OpportunitySearchBasic
     */
    public function setBuyingTimeFrame(\StructType\SearchMultiSelectField $buyingTimeFrame = null)
    {
        $this->buyingTimeFrame = $buyingTimeFrame;
        return $this;
    }
    /**
     * Get class value
     * @return \StructType\SearchMultiSelectField|null
     */
    public function getClass()
    {
        return $this->class;
    }
    /**
     * Set class value
     * @param \StructType\SearchMultiSelectField $class
     * @return \StructType\OpportunitySearchBasic
     */
    public function setClass(\StructType\SearchMultiSelectField $class = null)
    {
        $this->class = $class;
        return $this;
    }
    /**
     * Get closeDate value
     * @return \StructType\SearchDateField|null
     */
    public function getCloseDate()
    {
        return $this->closeDate;
    }
    /**
     * Set closeDate value
     * @param \StructType\SearchDateField $closeDate
     * @return \StructType\OpportunitySearchBasic
     */
    public function setCloseDate(\StructType\SearchDateField $closeDate = null)
    {
        $this->closeDate = $closeDate;
        return $this;
    }
    /**
     * Get competitor value
     * @return \StructType\SearchMultiSelectField|null
     */
    public function getCompetitor()
    {
        return $this->competitor;
    }
    /**
     * Set competitor value
     * @param \StructType\SearchMultiSelectField $competitor
     * @return \StructType\OpportunitySearchBasic
     */
    public function setCompetitor(\StructType\SearchMultiSelectField $competitor = null)
    {
        $this->competitor = $competitor;
        return $this;
    }
    /**
     * Get contribution value
     * @return \StructType\SearchLongField|null
     */
    public function getContribution()
    {
        return $this->contribution;
    }
    /**
     * Set contribution value
     * @param \StructType\SearchLongField $contribution
     * @return \StructType\OpportunitySearchBasic
     */
    public function setContribution(\StructType\SearchLongField $contribution = null)
    {
        $this->contribution = $contribution;
        return $this;
    }
    /**
     * Get currency value
     * @return \StructType\SearchMultiSelectField|null
     */
    public function getCurrency()
    {
        return $this->currency;
    }
    /**
     * Set currency value
     * @param \StructType\SearchMultiSelectField $currency
     * @return \StructType\OpportunitySearchBasic
     */
    public function setCurrency(\StructType\SearchMultiSelectField $currency = null)
    {
        $this->currency = $currency;
        return $this;
    }
    /**
     * Get custType value
     * @return \StructType\SearchMultiSelectField|null
     */
    public function getCustType()
    {
        return $this->custType;
    }
    /**
     * Set custType value
     * @param \StructType\SearchMultiSelectField $custType
     * @return \StructType\OpportunitySearchBasic
     */
    public function setCustType(\StructType\SearchMultiSelectField $custType = null)
    {
        $this->custType = $custType;
        return $this;
    }
    /**
     * Get dateCreated value
     * @return \StructType\SearchDateField|null
     */
    public function getDateCreated()
    {
        return $this->dateCreated;
    }
    /**
     * Set dateCreated value
     * @param \StructType\SearchDateField $dateCreated
     * @return \StructType\OpportunitySearchBasic
     */
    public function setDateCreated(\StructType\SearchDateField $dateCreated = null)
    {
        $this->dateCreated = $dateCreated;
        return $this;
    }
    /**
     * Get daysOpen value
     * @return \StructType\SearchLongField|null
     */
    public function getDaysOpen()
    {
        return $this->daysOpen;
    }
    /**
     * Set daysOpen value
     * @param \StructType\SearchLongField $daysOpen
     * @return \StructType\OpportunitySearchBasic
     */
    public function setDaysOpen(\StructType\SearchLongField $daysOpen = null)
    {
        $this->daysOpen = $daysOpen;
        return $this;
    }
    /**
     * Get daysToClose value
     * @return \StructType\SearchLongField|null
     */
    public function getDaysToClose()
    {
        return $this->daysToClose;
    }
    /**
     * Set daysToClose value
     * @param \StructType\SearchLongField $daysToClose
     * @return \StructType\OpportunitySearchBasic
     */
    public function setDaysToClose(\StructType\SearchLongField $daysToClose = null)
    {
        $this->daysToClose = $daysToClose;
        return $this;
    }
    /**
     * Get department value
     * @return \StructType\SearchMultiSelectField|null
     */
    public function getDepartment()
    {
        return $this->department;
    }
    /**
     * Set department value
     * @param \StructType\SearchMultiSelectField $department
     * @return \StructType\OpportunitySearchBasic
     */
    public function setDepartment(\StructType\SearchMultiSelectField $department = null)
    {
        $this->department = $department;
        return $this;
    }
    /**
     * Get entity value
     * @return \StructType\SearchMultiSelectField|null
     */
    public function getEntity()
    {
        return $this->entity;
    }
    /**
     * Set entity value
     * @param \StructType\SearchMultiSelectField $entity
     * @return \StructType\OpportunitySearchBasic
     */
    public function setEntity(\StructType\SearchMultiSelectField $entity = null)
    {
        $this->entity = $entity;
        return $this;
    }
    /**
     * Get entityStatus value
     * @return \StructType\SearchMultiSelectField|null
     */
    public function getEntityStatus()
    {
        return $this->entityStatus;
    }
    /**
     * Set entityStatus value
     * @param \StructType\SearchMultiSelectField $entityStatus
     * @return \StructType\OpportunitySearchBasic
     */
    public function setEntityStatus(\StructType\SearchMultiSelectField $entityStatus = null)
    {
        $this->entityStatus = $entityStatus;
        return $this;
    }
    /**
     * Get estimatedBudget value
     * @return \StructType\SearchDoubleField|null
     */
    public function getEstimatedBudget()
    {
        return $this->estimatedBudget;
    }
    /**
     * Set estimatedBudget value
     * @param \StructType\SearchDoubleField $estimatedBudget
     * @return \StructType\OpportunitySearchBasic
     */
    public function setEstimatedBudget(\StructType\SearchDoubleField $estimatedBudget = null)
    {
        $this->estimatedBudget = $estimatedBudget;
        return $this;
    }
    /**
     * Get expectedCloseDate value
     * @return \StructType\SearchDateField|null
     */
    public function getExpectedCloseDate()
    {
        return $this->expectedCloseDate;
    }
    /**
     * Set expectedCloseDate value
     * @param \StructType\SearchDateField $expectedCloseDate
     * @return \StructType\OpportunitySearchBasic
     */
    public function setExpectedCloseDate(\StructType\SearchDateField $expectedCloseDate = null)
    {
        $this->expectedCloseDate = $expectedCloseDate;
        return $this;
    }
    /**
     * Get externalId value
     * @return \StructType\SearchMultiSelectField|null
     */
    public function getExternalId()
    {
        return $this->externalId;
    }
    /**
     * Set externalId value
     * @param \StructType\SearchMultiSelectField $externalId
     * @return \StructType\OpportunitySearchBasic
     */
    public function setExternalId(\StructType\SearchMultiSelectField $externalId = null)
    {
        $this->externalId = $externalId;
        return $this;
    }
    /**
     * Get externalIdString value
     * @return \StructType\SearchStringField|null
     */
    public function getExternalIdString()
    {
        return $this->externalIdString;
    }
    /**
     * Set externalIdString value
     * @param \StructType\SearchStringField $externalIdString
     * @return \StructType\OpportunitySearchBasic
     */
    public function setExternalIdString(\StructType\SearchStringField $externalIdString = null)
    {
        $this->externalIdString = $externalIdString;
        return $this;
    }
    /**
     * Get forecastType value
     * @return \StructType\SearchEnumMultiSelectField|null
     */
    public function getForecastType()
    {
        return $this->forecastType;
    }
    /**
     * Set forecastType value
     * @param \StructType\SearchEnumMultiSelectField $forecastType
     * @return \StructType\OpportunitySearchBasic
     */
    public function setForecastType(\StructType\SearchEnumMultiSelectField $forecastType = null)
    {
        $this->forecastType = $forecastType;
        return $this;
    }
    /**
     * Get foreignProjectedAmount value
     * @return \StructType\SearchDoubleField|null
     */
    public function getForeignProjectedAmount()
    {
        return $this->foreignProjectedAmount;
    }
    /**
     * Set foreignProjectedAmount value
     * @param \StructType\SearchDoubleField $foreignProjectedAmount
     * @return \StructType\OpportunitySearchBasic
     */
    public function setForeignProjectedAmount(\StructType\SearchDoubleField $foreignProjectedAmount = null)
    {
        $this->foreignProjectedAmount = $foreignProjectedAmount;
        return $this;
    }
    /**
     * Get foreignRangeHigh value
     * @return \StructType\SearchDoubleField|null
     */
    public function getForeignRangeHigh()
    {
        return $this->foreignRangeHigh;
    }
    /**
     * Set foreignRangeHigh value
     * @param \StructType\SearchDoubleField $foreignRangeHigh
     * @return \StructType\OpportunitySearchBasic
     */
    public function setForeignRangeHigh(\StructType\SearchDoubleField $foreignRangeHigh = null)
    {
        $this->foreignRangeHigh = $foreignRangeHigh;
        return $this;
    }
    /**
     * Get foreignRangeLow value
     * @return \StructType\SearchDoubleField|null
     */
    public function getForeignRangeLow()
    {
        return $this->foreignRangeLow;
    }
    /**
     * Set foreignRangeLow value
     * @param \StructType\SearchDoubleField $foreignRangeLow
     * @return \StructType\OpportunitySearchBasic
     */
    public function setForeignRangeLow(\StructType\SearchDoubleField $foreignRangeLow = null)
    {
        $this->foreignRangeLow = $foreignRangeLow;
        return $this;
    }
    /**
     * Get fxTranCostEstimate value
     * @return \StructType\SearchDoubleField|null
     */
    public function getFxTranCostEstimate()
    {
        return $this->fxTranCostEstimate;
    }
    /**
     * Set fxTranCostEstimate value
     * @param \StructType\SearchDoubleField $fxTranCostEstimate
     * @return \StructType\OpportunitySearchBasic
     */
    public function setFxTranCostEstimate(\StructType\SearchDoubleField $fxTranCostEstimate = null)
    {
        $this->fxTranCostEstimate = $fxTranCostEstimate;
        return $this;
    }
    /**
     * Get internalId value
     * @return \StructType\SearchMultiSelectField|null
     */
    public function getInternalId()
    {
        return $this->internalId;
    }
    /**
     * Set internalId value
     * @param \StructType\SearchMultiSelectField $internalId
     * @return \StructType\OpportunitySearchBasic
     */
    public function setInternalId(\StructType\SearchMultiSelectField $internalId = null)
    {
        $this->internalId = $internalId;
        return $this;
    }
    /**
     * Get internalIdNumber value
     * @return \StructType\SearchLongField|null
     */
    public function getInternalIdNumber()
    {
        return $this->internalIdNumber;
    }
    /**
     * Set internalIdNumber value
     * @param \StructType\SearchLongField $internalIdNumber
     * @return \StructType\OpportunitySearchBasic
     */
    public function setInternalIdNumber(\StructType\SearchLongField $internalIdNumber = null)
    {
        $this->internalIdNumber = $internalIdNumber;
        return $this;
    }
    /**
     * Get isBudgetApproved value
     * @return \StructType\SearchBooleanField|null
     */
    public function getIsBudgetApproved()
    {
        return $this->isBudgetApproved;
    }
    /**
     * Set isBudgetApproved value
     * @param \StructType\SearchBooleanField $isBudgetApproved
     * @return \StructType\OpportunitySearchBasic
     */
    public function setIsBudgetApproved(\StructType\SearchBooleanField $isBudgetApproved = null)
    {
        $this->isBudgetApproved = $isBudgetApproved;
        return $this;
    }
    /**
     * Get item value
     * @return \StructType\SearchMultiSelectField|null
     */
    public function getItem()
    {
        return $this->item;
    }
    /**
     * Set item value
     * @param \StructType\SearchMultiSelectField $item
     * @return \StructType\OpportunitySearchBasic
     */
    public function setItem(\StructType\SearchMultiSelectField $item = null)
    {
        $this->item = $item;
        return $this;
    }
    /**
     * Get lastModifiedDate value
     * @return \StructType\SearchDateField|null
     */
    public function getLastModifiedDate()
    {
        return $this->lastModifiedDate;
    }
    /**
     * Set lastModifiedDate value
     * @param \StructType\SearchDateField $lastModifiedDate
     * @return \StructType\OpportunitySearchBasic
     */
    public function setLastModifiedDate(\StructType\SearchDateField $lastModifiedDate = null)
    {
        $this->lastModifiedDate = $lastModifiedDate;
        return $this;
    }
    /**
     * Get leadSource value
     * @return \StructType\SearchMultiSelectField|null
     */
    public function getLeadSource()
    {
        return $this->leadSource;
    }
    /**
     * Set leadSource value
     * @param \StructType\SearchMultiSelectField $leadSource
     * @return \StructType\OpportunitySearchBasic
     */
    public function setLeadSource(\StructType\SearchMultiSelectField $leadSource = null)
    {
        $this->leadSource = $leadSource;
        return $this;
    }
    /**
     * Get location value
     * @return \StructType\SearchMultiSelectField|null
     */
    public function getLocation()
    {
        return $this->location;
    }
    /**
     * Set location value
     * @param \StructType\SearchMultiSelectField $location
     * @return \StructType\OpportunitySearchBasic
     */
    public function setLocation(\StructType\SearchMultiSelectField $location = null)
    {
        $this->location = $location;
        return $this;
    }
    /**
     * Get memo value
     * @return \StructType\SearchStringField|null
     */
    public function getMemo()
    {
        return $this->memo;
    }
    /**
     * Set memo value
     * @param \StructType\SearchStringField $memo
     * @return \StructType\OpportunitySearchBasic
     */
    public function setMemo(\StructType\SearchStringField $memo = null)
    {
        $this->memo = $memo;
        return $this;
    }
    /**
     * Get number value
     * @return \StructType\SearchLongField|null
     */
    public function getNumber()
    {
        return $this->number;
    }
    /**
     * Set number value
     * @param \StructType\SearchLongField $number
     * @return \StructType\OpportunitySearchBasic
     */
    public function setNumber(\StructType\SearchLongField $number = null)
    {
        $this->number = $number;
        return $this;
    }
    /**
     * Get partner value
     * @return \StructType\SearchMultiSelectField|null
     */
    public function getPartner()
    {
        return $this->partner;
    }
    /**
     * Set partner value
     * @param \StructType\SearchMultiSelectField $partner
     * @return \StructType\OpportunitySearchBasic
     */
    public function setPartner(\StructType\SearchMultiSelectField $partner = null)
    {
        $this->partner = $partner;
        return $this;
    }
    /**
     * Get partnerContribution value
     * @return \StructType\SearchLongField|null
     */
    public function getPartnerContribution()
    {
        return $this->partnerContribution;
    }
    /**
     * Set partnerContribution value
     * @param \StructType\SearchLongField $partnerContribution
     * @return \StructType\OpportunitySearchBasic
     */
    public function setPartnerContribution(\StructType\SearchLongField $partnerContribution = null)
    {
        $this->partnerContribution = $partnerContribution;
        return $this;
    }
    /**
     * Get partnerRole value
     * @return \StructType\SearchMultiSelectField|null
     */
    public function getPartnerRole()
    {
        return $this->partnerRole;
    }
    /**
     * Set partnerRole value
     * @param \StructType\SearchMultiSelectField $partnerRole
     * @return \StructType\OpportunitySearchBasic
     */
    public function setPartnerRole(\StructType\SearchMultiSelectField $partnerRole = null)
    {
        $this->partnerRole = $partnerRole;
        return $this;
    }
    /**
     * Get partnerTeamMember value
     * @return \StructType\SearchMultiSelectField|null
     */
    public function getPartnerTeamMember()
    {
        return $this->partnerTeamMember;
    }
    /**
     * Set partnerTeamMember value
     * @param \StructType\SearchMultiSelectField $partnerTeamMember
     * @return \StructType\OpportunitySearchBasic
     */
    public function setPartnerTeamMember(\StructType\SearchMultiSelectField $partnerTeamMember = null)
    {
        $this->partnerTeamMember = $partnerTeamMember;
        return $this;
    }
    /**
     * Get postingPeriod value
     * @return \StructType\RecordRef|null
     */
    public function getPostingPeriod()
    {
        return $this->postingPeriod;
    }
    /**
     * Set postingPeriod value
     * @param \StructType\RecordRef $postingPeriod
     * @return \StructType\OpportunitySearchBasic
     */
    public function setPostingPeriod(\StructType\RecordRef $postingPeriod = null)
    {
        $this->postingPeriod = $postingPeriod;
        return $this;
    }
    /**
     * Get postingPeriodRelative value
     * @return string|null
     */
    public function getPostingPeriodRelative()
    {
        return $this->postingPeriodRelative;
    }
    /**
     * Set postingPeriodRelative value
     * @uses \EnumType\PostingPeriodDate::valueIsValid()
     * @uses \EnumType\PostingPeriodDate::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $postingPeriodRelative
     * @return \StructType\OpportunitySearchBasic
     */
    public function setPostingPeriodRelative($postingPeriodRelative = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\PostingPeriodDate::valueIsValid($postingPeriodRelative)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\PostingPeriodDate', is_array($postingPeriodRelative) ? implode(', ', $postingPeriodRelative) : var_export($postingPeriodRelative, true), implode(', ', \EnumType\PostingPeriodDate::getValidValues())), __LINE__);
        }
        $this->postingPeriodRelative = $postingPeriodRelative;
        return $this;
    }
    /**
     * Get probability value
     * @return \StructType\SearchLongField|null
     */
    public function getProbability()
    {
        return $this->probability;
    }
    /**
     * Set probability value
     * @param \StructType\SearchLongField $probability
     * @return \StructType\OpportunitySearchBasic
     */
    public function setProbability(\StructType\SearchLongField $probability = null)
    {
        $this->probability = $probability;
        return $this;
    }
    /**
     * Get projAltSalesAmt value
     * @return \StructType\SearchDoubleField|null
     */
    public function getProjAltSalesAmt()
    {
        return $this->projAltSalesAmt;
    }
    /**
     * Set projAltSalesAmt value
     * @param \StructType\SearchDoubleField $projAltSalesAmt
     * @return \StructType\OpportunitySearchBasic
     */
    public function setProjAltSalesAmt(\StructType\SearchDoubleField $projAltSalesAmt = null)
    {
        $this->projAltSalesAmt = $projAltSalesAmt;
        return $this;
    }
    /**
     * Get projectedTotal value
     * @return \StructType\SearchDoubleField|null
     */
    public function getProjectedTotal()
    {
        return $this->projectedTotal;
    }
    /**
     * Set projectedTotal value
     * @param \StructType\SearchDoubleField $projectedTotal
     * @return \StructType\OpportunitySearchBasic
     */
    public function setProjectedTotal(\StructType\SearchDoubleField $projectedTotal = null)
    {
        $this->projectedTotal = $projectedTotal;
        return $this;
    }
    /**
     * Get rangeHigh value
     * @return \StructType\SearchDoubleField|null
     */
    public function getRangeHigh()
    {
        return $this->rangeHigh;
    }
    /**
     * Set rangeHigh value
     * @param \StructType\SearchDoubleField $rangeHigh
     * @return \StructType\OpportunitySearchBasic
     */
    public function setRangeHigh(\StructType\SearchDoubleField $rangeHigh = null)
    {
        $this->rangeHigh = $rangeHigh;
        return $this;
    }
    /**
     * Get rangeHighAlt value
     * @return \StructType\SearchDoubleField|null
     */
    public function getRangeHighAlt()
    {
        return $this->rangeHighAlt;
    }
    /**
     * Set rangeHighAlt value
     * @param \StructType\SearchDoubleField $rangeHighAlt
     * @return \StructType\OpportunitySearchBasic
     */
    public function setRangeHighAlt(\StructType\SearchDoubleField $rangeHighAlt = null)
    {
        $this->rangeHighAlt = $rangeHighAlt;
        return $this;
    }
    /**
     * Get rangeLow value
     * @return \StructType\SearchDoubleField|null
     */
    public function getRangeLow()
    {
        return $this->rangeLow;
    }
    /**
     * Set rangeLow value
     * @param \StructType\SearchDoubleField $rangeLow
     * @return \StructType\OpportunitySearchBasic
     */
    public function setRangeLow(\StructType\SearchDoubleField $rangeLow = null)
    {
        $this->rangeLow = $rangeLow;
        return $this;
    }
    /**
     * Get rangeLowAlt value
     * @return \StructType\SearchDoubleField|null
     */
    public function getRangeLowAlt()
    {
        return $this->rangeLowAlt;
    }
    /**
     * Set rangeLowAlt value
     * @param \StructType\SearchDoubleField $rangeLowAlt
     * @return \StructType\OpportunitySearchBasic
     */
    public function setRangeLowAlt(\StructType\SearchDoubleField $rangeLowAlt = null)
    {
        $this->rangeLowAlt = $rangeLowAlt;
        return $this;
    }
    /**
     * Get salesReadiness value
     * @return \StructType\SearchMultiSelectField|null
     */
    public function getSalesReadiness()
    {
        return $this->salesReadiness;
    }
    /**
     * Set salesReadiness value
     * @param \StructType\SearchMultiSelectField $salesReadiness
     * @return \StructType\OpportunitySearchBasic
     */
    public function setSalesReadiness(\StructType\SearchMultiSelectField $salesReadiness = null)
    {
        $this->salesReadiness = $salesReadiness;
        return $this;
    }
    /**
     * Get salesRep value
     * @return \StructType\SearchMultiSelectField|null
     */
    public function getSalesRep()
    {
        return $this->salesRep;
    }
    /**
     * Set salesRep value
     * @param \StructType\SearchMultiSelectField $salesRep
     * @return \StructType\OpportunitySearchBasic
     */
    public function setSalesRep(\StructType\SearchMultiSelectField $salesRep = null)
    {
        $this->salesRep = $salesRep;
        return $this;
    }
    /**
     * Get salesTeamMember value
     * @return \StructType\SearchMultiSelectField|null
     */
    public function getSalesTeamMember()
    {
        return $this->salesTeamMember;
    }
    /**
     * Set salesTeamMember value
     * @param \StructType\SearchMultiSelectField $salesTeamMember
     * @return \StructType\OpportunitySearchBasic
     */
    public function setSalesTeamMember(\StructType\SearchMultiSelectField $salesTeamMember = null)
    {
        $this->salesTeamMember = $salesTeamMember;
        return $this;
    }
    /**
     * Get salesTeamRole value
     * @return \StructType\SearchMultiSelectField|null
     */
    public function getSalesTeamRole()
    {
        return $this->salesTeamRole;
    }
    /**
     * Set salesTeamRole value
     * @param \StructType\SearchMultiSelectField $salesTeamRole
     * @return \StructType\OpportunitySearchBasic
     */
    public function setSalesTeamRole(\StructType\SearchMultiSelectField $salesTeamRole = null)
    {
        $this->salesTeamRole = $salesTeamRole;
        return $this;
    }
    /**
     * Get status value
     * @return \StructType\SearchEnumMultiSelectField|null
     */
    public function getStatus()
    {
        return $this->status;
    }
    /**
     * Set status value
     * @param \StructType\SearchEnumMultiSelectField $status
     * @return \StructType\OpportunitySearchBasic
     */
    public function setStatus(\StructType\SearchEnumMultiSelectField $status = null)
    {
        $this->status = $status;
        return $this;
    }
    /**
     * Get subsidiary value
     * @return \StructType\SearchMultiSelectField|null
     */
    public function getSubsidiary()
    {
        return $this->subsidiary;
    }
    /**
     * Set subsidiary value
     * @param \StructType\SearchMultiSelectField $subsidiary
     * @return \StructType\OpportunitySearchBasic
     */
    public function setSubsidiary(\StructType\SearchMultiSelectField $subsidiary = null)
    {
        $this->subsidiary = $subsidiary;
        return $this;
    }
    /**
     * Get taxPeriod value
     * @return \StructType\RecordRef|null
     */
    public function getTaxPeriod()
    {
        return $this->taxPeriod;
    }
    /**
     * Set taxPeriod value
     * @param \StructType\RecordRef $taxPeriod
     * @return \StructType\OpportunitySearchBasic
     */
    public function setTaxPeriod(\StructType\RecordRef $taxPeriod = null)
    {
        $this->taxPeriod = $taxPeriod;
        return $this;
    }
    /**
     * Get taxPeriodRelative value
     * @return string|null
     */
    public function getTaxPeriodRelative()
    {
        return $this->taxPeriodRelative;
    }
    /**
     * Set taxPeriodRelative value
     * @uses \EnumType\PostingPeriodDate::valueIsValid()
     * @uses \EnumType\PostingPeriodDate::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $taxPeriodRelative
     * @return \StructType\OpportunitySearchBasic
     */
    public function setTaxPeriodRelative($taxPeriodRelative = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\PostingPeriodDate::valueIsValid($taxPeriodRelative)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\PostingPeriodDate', is_array($taxPeriodRelative) ? implode(', ', $taxPeriodRelative) : var_export($taxPeriodRelative, true), implode(', ', \EnumType\PostingPeriodDate::getValidValues())), __LINE__);
        }
        $this->taxPeriodRelative = $taxPeriodRelative;
        return $this;
    }
    /**
     * Get title value
     * @return \StructType\SearchStringField|null
     */
    public function getTitle()
    {
        return $this->title;
    }
    /**
     * Set title value
     * @param \StructType\SearchStringField $title
     * @return \StructType\OpportunitySearchBasic
     */
    public function setTitle(\StructType\SearchStringField $title = null)
    {
        $this->title = $title;
        return $this;
    }
    /**
     * Get tranCostEstimate value
     * @return \StructType\SearchDoubleField|null
     */
    public function getTranCostEstimate()
    {
        return $this->tranCostEstimate;
    }
    /**
     * Set tranCostEstimate value
     * @param \StructType\SearchDoubleField $tranCostEstimate
     * @return \StructType\OpportunitySearchBasic
     */
    public function setTranCostEstimate(\StructType\SearchDoubleField $tranCostEstimate = null)
    {
        $this->tranCostEstimate = $tranCostEstimate;
        return $this;
    }
    /**
     * Get tranDate value
     * @return \StructType\SearchDateField|null
     */
    public function getTranDate()
    {
        return $this->tranDate;
    }
    /**
     * Set tranDate value
     * @param \StructType\SearchDateField $tranDate
     * @return \StructType\OpportunitySearchBasic
     */
    public function setTranDate(\StructType\SearchDateField $tranDate = null)
    {
        $this->tranDate = $tranDate;
        return $this;
    }
    /**
     * Get tranEstGrossProfit value
     * @return \StructType\SearchDoubleField|null
     */
    public function getTranEstGrossProfit()
    {
        return $this->tranEstGrossProfit;
    }
    /**
     * Set tranEstGrossProfit value
     * @param \StructType\SearchDoubleField $tranEstGrossProfit
     * @return \StructType\OpportunitySearchBasic
     */
    public function setTranEstGrossProfit(\StructType\SearchDoubleField $tranEstGrossProfit = null)
    {
        $this->tranEstGrossProfit = $tranEstGrossProfit;
        return $this;
    }
    /**
     * Get tranEstGrossProfitPct value
     * @return \StructType\SearchDoubleField|null
     */
    public function getTranEstGrossProfitPct()
    {
        return $this->tranEstGrossProfitPct;
    }
    /**
     * Set tranEstGrossProfitPct value
     * @param \StructType\SearchDoubleField $tranEstGrossProfitPct
     * @return \StructType\OpportunitySearchBasic
     */
    public function setTranEstGrossProfitPct(\StructType\SearchDoubleField $tranEstGrossProfitPct = null)
    {
        $this->tranEstGrossProfitPct = $tranEstGrossProfitPct;
        return $this;
    }
    /**
     * Get tranFxEstGrossProfit value
     * @return \StructType\SearchDoubleField|null
     */
    public function getTranFxEstGrossProfit()
    {
        return $this->tranFxEstGrossProfit;
    }
    /**
     * Set tranFxEstGrossProfit value
     * @param \StructType\SearchDoubleField $tranFxEstGrossProfit
     * @return \StructType\OpportunitySearchBasic
     */
    public function setTranFxEstGrossProfit(\StructType\SearchDoubleField $tranFxEstGrossProfit = null)
    {
        $this->tranFxEstGrossProfit = $tranFxEstGrossProfit;
        return $this;
    }
    /**
     * Get tranId value
     * @return \StructType\SearchStringField|null
     */
    public function getTranId()
    {
        return $this->tranId;
    }
    /**
     * Set tranId value
     * @param \StructType\SearchStringField $tranId
     * @return \StructType\OpportunitySearchBasic
     */
    public function setTranId(\StructType\SearchStringField $tranId = null)
    {
        $this->tranId = $tranId;
        return $this;
    }
    /**
     * Get winLossReason value
     * @return \StructType\SearchMultiSelectField|null
     */
    public function getWinLossReason()
    {
        return $this->winLossReason;
    }
    /**
     * Set winLossReason value
     * @param \StructType\SearchMultiSelectField $winLossReason
     * @return \StructType\OpportunitySearchBasic
     */
    public function setWinLossReason(\StructType\SearchMultiSelectField $winLossReason = null)
    {
        $this->winLossReason = $winLossReason;
        return $this;
    }
    /**
     * Get wonBy value
     * @return \StructType\SearchMultiSelectField|null
     */
    public function getWonBy()
    {
        return $this->wonBy;
    }
    /**
     * Set wonBy value
     * @param \StructType\SearchMultiSelectField $wonBy
     * @return \StructType\OpportunitySearchBasic
     */
    public function setWonBy(\StructType\SearchMultiSelectField $wonBy = null)
    {
        $this->wonBy = $wonBy;
        return $this;
    }
    /**
     * Get customFieldList value
     * @return \StructType\SearchCustomFieldList|null
     */
    public function getCustomFieldList()
    {
        return $this->customFieldList;
    }
    /**
     * Set customFieldList value
     * @param \StructType\SearchCustomFieldList $customFieldList
     * @return \StructType\OpportunitySearchBasic
     */
    public function setCustomFieldList(\StructType\SearchCustomFieldList $customFieldList = null)
    {
        $this->customFieldList = $customFieldList;
        return $this;
    }
}
