<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OpportunitySearch StructType
 * @subpackage Structs
 */
class OpportunitySearch extends SearchRecord
{
    /**
     * The basic
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\OpportunitySearchBasic
     */
    public $basic;
    /**
     * The actualJoin
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\TransactionSearchBasic
     */
    public $actualJoin;
    /**
     * The callJoin
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\PhoneCallSearchBasic
     */
    public $callJoin;
    /**
     * The customerJoin
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CustomerSearchBasic
     */
    public $customerJoin;
    /**
     * The decisionMakerJoin
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ContactSearchBasic
     */
    public $decisionMakerJoin;
    /**
     * The estimateJoin
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\TransactionSearchBasic
     */
    public $estimateJoin;
    /**
     * The eventJoin
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CalendarEventSearchBasic
     */
    public $eventJoin;
    /**
     * The fileJoin
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\FileSearchBasic
     */
    public $fileJoin;
    /**
     * The itemJoin
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ItemSearchBasic
     */
    public $itemJoin;
    /**
     * The leadSourceJoin
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CampaignSearchBasic
     */
    public $leadSourceJoin;
    /**
     * The messagesJoin
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\MessageSearchBasic
     */
    public $messagesJoin;
    /**
     * The orderJoin
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\TransactionSearchBasic
     */
    public $orderJoin;
    /**
     * The originatingLeadJoin
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\OriginatingLeadSearchBasic
     */
    public $originatingLeadJoin;
    /**
     * The partnerJoin
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\PartnerSearchBasic
     */
    public $partnerJoin;
    /**
     * The salesRepJoin
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\EmployeeSearchBasic
     */
    public $salesRepJoin;
    /**
     * The taskJoin
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\TaskSearchBasic
     */
    public $taskJoin;
    /**
     * The userNotesJoin
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\NoteSearchBasic
     */
    public $userNotesJoin;
    /**
     * The customSearchJoin
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\CustomSearchJoin[]
     */
    public $customSearchJoin;
    /**
     * Constructor method for OpportunitySearch
     * @uses OpportunitySearch::setBasic()
     * @uses OpportunitySearch::setActualJoin()
     * @uses OpportunitySearch::setCallJoin()
     * @uses OpportunitySearch::setCustomerJoin()
     * @uses OpportunitySearch::setDecisionMakerJoin()
     * @uses OpportunitySearch::setEstimateJoin()
     * @uses OpportunitySearch::setEventJoin()
     * @uses OpportunitySearch::setFileJoin()
     * @uses OpportunitySearch::setItemJoin()
     * @uses OpportunitySearch::setLeadSourceJoin()
     * @uses OpportunitySearch::setMessagesJoin()
     * @uses OpportunitySearch::setOrderJoin()
     * @uses OpportunitySearch::setOriginatingLeadJoin()
     * @uses OpportunitySearch::setPartnerJoin()
     * @uses OpportunitySearch::setSalesRepJoin()
     * @uses OpportunitySearch::setTaskJoin()
     * @uses OpportunitySearch::setUserNotesJoin()
     * @uses OpportunitySearch::setCustomSearchJoin()
     * @param \StructType\OpportunitySearchBasic $basic
     * @param \StructType\TransactionSearchBasic $actualJoin
     * @param \StructType\PhoneCallSearchBasic $callJoin
     * @param \StructType\CustomerSearchBasic $customerJoin
     * @param \StructType\ContactSearchBasic $decisionMakerJoin
     * @param \StructType\TransactionSearchBasic $estimateJoin
     * @param \StructType\CalendarEventSearchBasic $eventJoin
     * @param \StructType\FileSearchBasic $fileJoin
     * @param \StructType\ItemSearchBasic $itemJoin
     * @param \StructType\CampaignSearchBasic $leadSourceJoin
     * @param \StructType\MessageSearchBasic $messagesJoin
     * @param \StructType\TransactionSearchBasic $orderJoin
     * @param \StructType\OriginatingLeadSearchBasic $originatingLeadJoin
     * @param \StructType\PartnerSearchBasic $partnerJoin
     * @param \StructType\EmployeeSearchBasic $salesRepJoin
     * @param \StructType\TaskSearchBasic $taskJoin
     * @param \StructType\NoteSearchBasic $userNotesJoin
     * @param \StructType\CustomSearchJoin[] $customSearchJoin
     */
    public function __construct(\StructType\OpportunitySearchBasic $basic = null, \StructType\TransactionSearchBasic $actualJoin = null, \StructType\PhoneCallSearchBasic $callJoin = null, \StructType\CustomerSearchBasic $customerJoin = null, \StructType\ContactSearchBasic $decisionMakerJoin = null, \StructType\TransactionSearchBasic $estimateJoin = null, \StructType\CalendarEventSearchBasic $eventJoin = null, \StructType\FileSearchBasic $fileJoin = null, \StructType\ItemSearchBasic $itemJoin = null, \StructType\CampaignSearchBasic $leadSourceJoin = null, \StructType\MessageSearchBasic $messagesJoin = null, \StructType\TransactionSearchBasic $orderJoin = null, \StructType\OriginatingLeadSearchBasic $originatingLeadJoin = null, \StructType\PartnerSearchBasic $partnerJoin = null, \StructType\EmployeeSearchBasic $salesRepJoin = null, \StructType\TaskSearchBasic $taskJoin = null, \StructType\NoteSearchBasic $userNotesJoin = null, array $customSearchJoin = array())
    {
        $this
            ->setBasic($basic)
            ->setActualJoin($actualJoin)
            ->setCallJoin($callJoin)
            ->setCustomerJoin($customerJoin)
            ->setDecisionMakerJoin($decisionMakerJoin)
            ->setEstimateJoin($estimateJoin)
            ->setEventJoin($eventJoin)
            ->setFileJoin($fileJoin)
            ->setItemJoin($itemJoin)
            ->setLeadSourceJoin($leadSourceJoin)
            ->setMessagesJoin($messagesJoin)
            ->setOrderJoin($orderJoin)
            ->setOriginatingLeadJoin($originatingLeadJoin)
            ->setPartnerJoin($partnerJoin)
            ->setSalesRepJoin($salesRepJoin)
            ->setTaskJoin($taskJoin)
            ->setUserNotesJoin($userNotesJoin)
            ->setCustomSearchJoin($customSearchJoin);
    }
    /**
     * Get basic value
     * @return \StructType\OpportunitySearchBasic|null
     */
    public function getBasic()
    {
        return $this->basic;
    }
    /**
     * Set basic value
     * @param \StructType\OpportunitySearchBasic $basic
     * @return \StructType\OpportunitySearch
     */
    public function setBasic(\StructType\OpportunitySearchBasic $basic = null)
    {
        $this->basic = $basic;
        return $this;
    }
    /**
     * Get actualJoin value
     * @return \StructType\TransactionSearchBasic|null
     */
    public function getActualJoin()
    {
        return $this->actualJoin;
    }
    /**
     * Set actualJoin value
     * @param \StructType\TransactionSearchBasic $actualJoin
     * @return \StructType\OpportunitySearch
     */
    public function setActualJoin(\StructType\TransactionSearchBasic $actualJoin = null)
    {
        $this->actualJoin = $actualJoin;
        return $this;
    }
    /**
     * Get callJoin value
     * @return \StructType\PhoneCallSearchBasic|null
     */
    public function getCallJoin()
    {
        return $this->callJoin;
    }
    /**
     * Set callJoin value
     * @param \StructType\PhoneCallSearchBasic $callJoin
     * @return \StructType\OpportunitySearch
     */
    public function setCallJoin(\StructType\PhoneCallSearchBasic $callJoin = null)
    {
        $this->callJoin = $callJoin;
        return $this;
    }
    /**
     * Get customerJoin value
     * @return \StructType\CustomerSearchBasic|null
     */
    public function getCustomerJoin()
    {
        return $this->customerJoin;
    }
    /**
     * Set customerJoin value
     * @param \StructType\CustomerSearchBasic $customerJoin
     * @return \StructType\OpportunitySearch
     */
    public function setCustomerJoin(\StructType\CustomerSearchBasic $customerJoin = null)
    {
        $this->customerJoin = $customerJoin;
        return $this;
    }
    /**
     * Get decisionMakerJoin value
     * @return \StructType\ContactSearchBasic|null
     */
    public function getDecisionMakerJoin()
    {
        return $this->decisionMakerJoin;
    }
    /**
     * Set decisionMakerJoin value
     * @param \StructType\ContactSearchBasic $decisionMakerJoin
     * @return \StructType\OpportunitySearch
     */
    public function setDecisionMakerJoin(\StructType\ContactSearchBasic $decisionMakerJoin = null)
    {
        $this->decisionMakerJoin = $decisionMakerJoin;
        return $this;
    }
    /**
     * Get estimateJoin value
     * @return \StructType\TransactionSearchBasic|null
     */
    public function getEstimateJoin()
    {
        return $this->estimateJoin;
    }
    /**
     * Set estimateJoin value
     * @param \StructType\TransactionSearchBasic $estimateJoin
     * @return \StructType\OpportunitySearch
     */
    public function setEstimateJoin(\StructType\TransactionSearchBasic $estimateJoin = null)
    {
        $this->estimateJoin = $estimateJoin;
        return $this;
    }
    /**
     * Get eventJoin value
     * @return \StructType\CalendarEventSearchBasic|null
     */
    public function getEventJoin()
    {
        return $this->eventJoin;
    }
    /**
     * Set eventJoin value
     * @param \StructType\CalendarEventSearchBasic $eventJoin
     * @return \StructType\OpportunitySearch
     */
    public function setEventJoin(\StructType\CalendarEventSearchBasic $eventJoin = null)
    {
        $this->eventJoin = $eventJoin;
        return $this;
    }
    /**
     * Get fileJoin value
     * @return \StructType\FileSearchBasic|null
     */
    public function getFileJoin()
    {
        return $this->fileJoin;
    }
    /**
     * Set fileJoin value
     * @param \StructType\FileSearchBasic $fileJoin
     * @return \StructType\OpportunitySearch
     */
    public function setFileJoin(\StructType\FileSearchBasic $fileJoin = null)
    {
        $this->fileJoin = $fileJoin;
        return $this;
    }
    /**
     * Get itemJoin value
     * @return \StructType\ItemSearchBasic|null
     */
    public function getItemJoin()
    {
        return $this->itemJoin;
    }
    /**
     * Set itemJoin value
     * @param \StructType\ItemSearchBasic $itemJoin
     * @return \StructType\OpportunitySearch
     */
    public function setItemJoin(\StructType\ItemSearchBasic $itemJoin = null)
    {
        $this->itemJoin = $itemJoin;
        return $this;
    }
    /**
     * Get leadSourceJoin value
     * @return \StructType\CampaignSearchBasic|null
     */
    public function getLeadSourceJoin()
    {
        return $this->leadSourceJoin;
    }
    /**
     * Set leadSourceJoin value
     * @param \StructType\CampaignSearchBasic $leadSourceJoin
     * @return \StructType\OpportunitySearch
     */
    public function setLeadSourceJoin(\StructType\CampaignSearchBasic $leadSourceJoin = null)
    {
        $this->leadSourceJoin = $leadSourceJoin;
        return $this;
    }
    /**
     * Get messagesJoin value
     * @return \StructType\MessageSearchBasic|null
     */
    public function getMessagesJoin()
    {
        return $this->messagesJoin;
    }
    /**
     * Set messagesJoin value
     * @param \StructType\MessageSearchBasic $messagesJoin
     * @return \StructType\OpportunitySearch
     */
    public function setMessagesJoin(\StructType\MessageSearchBasic $messagesJoin = null)
    {
        $this->messagesJoin = $messagesJoin;
        return $this;
    }
    /**
     * Get orderJoin value
     * @return \StructType\TransactionSearchBasic|null
     */
    public function getOrderJoin()
    {
        return $this->orderJoin;
    }
    /**
     * Set orderJoin value
     * @param \StructType\TransactionSearchBasic $orderJoin
     * @return \StructType\OpportunitySearch
     */
    public function setOrderJoin(\StructType\TransactionSearchBasic $orderJoin = null)
    {
        $this->orderJoin = $orderJoin;
        return $this;
    }
    /**
     * Get originatingLeadJoin value
     * @return \StructType\OriginatingLeadSearchBasic|null
     */
    public function getOriginatingLeadJoin()
    {
        return $this->originatingLeadJoin;
    }
    /**
     * Set originatingLeadJoin value
     * @param \StructType\OriginatingLeadSearchBasic $originatingLeadJoin
     * @return \StructType\OpportunitySearch
     */
    public function setOriginatingLeadJoin(\StructType\OriginatingLeadSearchBasic $originatingLeadJoin = null)
    {
        $this->originatingLeadJoin = $originatingLeadJoin;
        return $this;
    }
    /**
     * Get partnerJoin value
     * @return \StructType\PartnerSearchBasic|null
     */
    public function getPartnerJoin()
    {
        return $this->partnerJoin;
    }
    /**
     * Set partnerJoin value
     * @param \StructType\PartnerSearchBasic $partnerJoin
     * @return \StructType\OpportunitySearch
     */
    public function setPartnerJoin(\StructType\PartnerSearchBasic $partnerJoin = null)
    {
        $this->partnerJoin = $partnerJoin;
        return $this;
    }
    /**
     * Get salesRepJoin value
     * @return \StructType\EmployeeSearchBasic|null
     */
    public function getSalesRepJoin()
    {
        return $this->salesRepJoin;
    }
    /**
     * Set salesRepJoin value
     * @param \StructType\EmployeeSearchBasic $salesRepJoin
     * @return \StructType\OpportunitySearch
     */
    public function setSalesRepJoin(\StructType\EmployeeSearchBasic $salesRepJoin = null)
    {
        $this->salesRepJoin = $salesRepJoin;
        return $this;
    }
    /**
     * Get taskJoin value
     * @return \StructType\TaskSearchBasic|null
     */
    public function getTaskJoin()
    {
        return $this->taskJoin;
    }
    /**
     * Set taskJoin value
     * @param \StructType\TaskSearchBasic $taskJoin
     * @return \StructType\OpportunitySearch
     */
    public function setTaskJoin(\StructType\TaskSearchBasic $taskJoin = null)
    {
        $this->taskJoin = $taskJoin;
        return $this;
    }
    /**
     * Get userNotesJoin value
     * @return \StructType\NoteSearchBasic|null
     */
    public function getUserNotesJoin()
    {
        return $this->userNotesJoin;
    }
    /**
     * Set userNotesJoin value
     * @param \StructType\NoteSearchBasic $userNotesJoin
     * @return \StructType\OpportunitySearch
     */
    public function setUserNotesJoin(\StructType\NoteSearchBasic $userNotesJoin = null)
    {
        $this->userNotesJoin = $userNotesJoin;
        return $this;
    }
    /**
     * Get customSearchJoin value
     * @return \StructType\CustomSearchJoin[]|null
     */
    public function getCustomSearchJoin()
    {
        return $this->customSearchJoin;
    }
    /**
     * This method is responsible for validating the values passed to the setCustomSearchJoin method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCustomSearchJoin method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCustomSearchJoinForArrayConstraintsFromSetCustomSearchJoin(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $opportunitySearchCustomSearchJoinItem) {
            // validation for constraint: itemType
            if (!$opportunitySearchCustomSearchJoinItem instanceof \StructType\CustomSearchJoin) {
                $invalidValues[] = is_object($opportunitySearchCustomSearchJoinItem) ? get_class($opportunitySearchCustomSearchJoinItem) : sprintf('%s(%s)', gettype($opportunitySearchCustomSearchJoinItem), var_export($opportunitySearchCustomSearchJoinItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The customSearchJoin property can only contain items of type \StructType\CustomSearchJoin, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set customSearchJoin value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomSearchJoin[] $customSearchJoin
     * @return \StructType\OpportunitySearch
     */
    public function setCustomSearchJoin(array $customSearchJoin = array())
    {
        // validation for constraint: array
        if ('' !== ($customSearchJoinArrayErrorMessage = self::validateCustomSearchJoinForArrayConstraintsFromSetCustomSearchJoin($customSearchJoin))) {
            throw new \InvalidArgumentException($customSearchJoinArrayErrorMessage, __LINE__);
        }
        $this->customSearchJoin = $customSearchJoin;
        return $this;
    }
    /**
     * Add item to customSearchJoin value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomSearchJoin $item
     * @return \StructType\OpportunitySearch
     */
    public function addToCustomSearchJoin(\StructType\CustomSearchJoin $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CustomSearchJoin) {
            throw new \InvalidArgumentException(sprintf('The customSearchJoin property can only contain items of type \StructType\CustomSearchJoin, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->customSearchJoin[] = $item;
        return $this;
    }
}
