<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OpportunityItem StructType
 * @subpackage Structs
 */
class OpportunityItem extends AbstractStructBase
{
    /**
     * The job
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $job;
    /**
     * The item
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $item;
    /**
     * The line
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $line;
    /**
     * The quantityAvailable
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $quantityAvailable;
    /**
     * The quantityOnHand
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $quantityOnHand;
    /**
     * The quantity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $quantity;
    /**
     * The units
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $units;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $description;
    /**
     * The price
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $price;
    /**
     * The rate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $rate;
    /**
     * The amount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $amount;
    /**
     * The altSalesAmt
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $altSalesAmt;
    /**
     * The revRecTermInMonths
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $revRecTermInMonths;
    /**
     * The options
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CustomFieldList
     */
    public $options;
    /**
     * The fromJob
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $fromJob;
    /**
     * The department
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $department;
    /**
     * The isEstimate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $isEstimate;
    /**
     * The location
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $location;
    /**
     * The class
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $class;
    /**
     * The costEstimateType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $costEstimateType;
    /**
     * The costEstimate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $costEstimate;
    /**
     * The taxAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $taxAmount;
    /**
     * The taxDetailsReference
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $taxDetailsReference;
    /**
     * The grossAmt
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $grossAmt;
    /**
     * The tax1Amt
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $tax1Amt;
    /**
     * The taxCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $taxCode;
    /**
     * The taxRate1
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $taxRate1;
    /**
     * The taxRate2
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $taxRate2;
    /**
     * The expectedShipDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $expectedShipDate;
    /**
     * The subscription
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $subscription;
    /**
     * The customFieldList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CustomFieldList
     */
    public $customFieldList;
    /**
     * Constructor method for OpportunityItem
     * @uses OpportunityItem::setJob()
     * @uses OpportunityItem::setItem()
     * @uses OpportunityItem::setLine()
     * @uses OpportunityItem::setQuantityAvailable()
     * @uses OpportunityItem::setQuantityOnHand()
     * @uses OpportunityItem::setQuantity()
     * @uses OpportunityItem::setUnits()
     * @uses OpportunityItem::setDescription()
     * @uses OpportunityItem::setPrice()
     * @uses OpportunityItem::setRate()
     * @uses OpportunityItem::setAmount()
     * @uses OpportunityItem::setAltSalesAmt()
     * @uses OpportunityItem::setRevRecTermInMonths()
     * @uses OpportunityItem::setOptions()
     * @uses OpportunityItem::setFromJob()
     * @uses OpportunityItem::setDepartment()
     * @uses OpportunityItem::setIsEstimate()
     * @uses OpportunityItem::setLocation()
     * @uses OpportunityItem::setClass()
     * @uses OpportunityItem::setCostEstimateType()
     * @uses OpportunityItem::setCostEstimate()
     * @uses OpportunityItem::setTaxAmount()
     * @uses OpportunityItem::setTaxDetailsReference()
     * @uses OpportunityItem::setGrossAmt()
     * @uses OpportunityItem::setTax1Amt()
     * @uses OpportunityItem::setTaxCode()
     * @uses OpportunityItem::setTaxRate1()
     * @uses OpportunityItem::setTaxRate2()
     * @uses OpportunityItem::setExpectedShipDate()
     * @uses OpportunityItem::setSubscription()
     * @uses OpportunityItem::setCustomFieldList()
     * @param \StructType\RecordRef $job
     * @param \StructType\RecordRef $item
     * @param int $line
     * @param float $quantityAvailable
     * @param float $quantityOnHand
     * @param float $quantity
     * @param \StructType\RecordRef $units
     * @param string $description
     * @param \StructType\RecordRef $price
     * @param string $rate
     * @param float $amount
     * @param float $altSalesAmt
     * @param int $revRecTermInMonths
     * @param \StructType\CustomFieldList $options
     * @param bool $fromJob
     * @param \StructType\RecordRef $department
     * @param bool $isEstimate
     * @param \StructType\RecordRef $location
     * @param \StructType\RecordRef $class
     * @param string $costEstimateType
     * @param float $costEstimate
     * @param float $taxAmount
     * @param string $taxDetailsReference
     * @param float $grossAmt
     * @param float $tax1Amt
     * @param \StructType\RecordRef $taxCode
     * @param float $taxRate1
     * @param float $taxRate2
     * @param string $expectedShipDate
     * @param \StructType\RecordRef $subscription
     * @param \StructType\CustomFieldList $customFieldList
     */
    public function __construct(\StructType\RecordRef $job = null, \StructType\RecordRef $item = null, $line = null, $quantityAvailable = null, $quantityOnHand = null, $quantity = null, \StructType\RecordRef $units = null, $description = null, \StructType\RecordRef $price = null, $rate = null, $amount = null, $altSalesAmt = null, $revRecTermInMonths = null, \StructType\CustomFieldList $options = null, $fromJob = null, \StructType\RecordRef $department = null, $isEstimate = null, \StructType\RecordRef $location = null, \StructType\RecordRef $class = null, $costEstimateType = null, $costEstimate = null, $taxAmount = null, $taxDetailsReference = null, $grossAmt = null, $tax1Amt = null, \StructType\RecordRef $taxCode = null, $taxRate1 = null, $taxRate2 = null, $expectedShipDate = null, \StructType\RecordRef $subscription = null, \StructType\CustomFieldList $customFieldList = null)
    {
        $this
            ->setJob($job)
            ->setItem($item)
            ->setLine($line)
            ->setQuantityAvailable($quantityAvailable)
            ->setQuantityOnHand($quantityOnHand)
            ->setQuantity($quantity)
            ->setUnits($units)
            ->setDescription($description)
            ->setPrice($price)
            ->setRate($rate)
            ->setAmount($amount)
            ->setAltSalesAmt($altSalesAmt)
            ->setRevRecTermInMonths($revRecTermInMonths)
            ->setOptions($options)
            ->setFromJob($fromJob)
            ->setDepartment($department)
            ->setIsEstimate($isEstimate)
            ->setLocation($location)
            ->setClass($class)
            ->setCostEstimateType($costEstimateType)
            ->setCostEstimate($costEstimate)
            ->setTaxAmount($taxAmount)
            ->setTaxDetailsReference($taxDetailsReference)
            ->setGrossAmt($grossAmt)
            ->setTax1Amt($tax1Amt)
            ->setTaxCode($taxCode)
            ->setTaxRate1($taxRate1)
            ->setTaxRate2($taxRate2)
            ->setExpectedShipDate($expectedShipDate)
            ->setSubscription($subscription)
            ->setCustomFieldList($customFieldList);
    }
    /**
     * Get job value
     * @return \StructType\RecordRef|null
     */
    public function getJob()
    {
        return $this->job;
    }
    /**
     * Set job value
     * @param \StructType\RecordRef $job
     * @return \StructType\OpportunityItem
     */
    public function setJob(\StructType\RecordRef $job = null)
    {
        $this->job = $job;
        return $this;
    }
    /**
     * Get item value
     * @return \StructType\RecordRef|null
     */
    public function getItem()
    {
        return $this->item;
    }
    /**
     * Set item value
     * @param \StructType\RecordRef $item
     * @return \StructType\OpportunityItem
     */
    public function setItem(\StructType\RecordRef $item = null)
    {
        $this->item = $item;
        return $this;
    }
    /**
     * Get line value
     * @return int|null
     */
    public function getLine()
    {
        return $this->line;
    }
    /**
     * Set line value
     * @param int $line
     * @return \StructType\OpportunityItem
     */
    public function setLine($line = null)
    {
        // validation for constraint: int
        if (!is_null($line) && !(is_int($line) || ctype_digit($line))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($line, true), gettype($line)), __LINE__);
        }
        $this->line = $line;
        return $this;
    }
    /**
     * Get quantityAvailable value
     * @return float|null
     */
    public function getQuantityAvailable()
    {
        return $this->quantityAvailable;
    }
    /**
     * Set quantityAvailable value
     * @param float $quantityAvailable
     * @return \StructType\OpportunityItem
     */
    public function setQuantityAvailable($quantityAvailable = null)
    {
        // validation for constraint: float
        if (!is_null($quantityAvailable) && !(is_float($quantityAvailable) || is_numeric($quantityAvailable))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($quantityAvailable, true), gettype($quantityAvailable)), __LINE__);
        }
        $this->quantityAvailable = $quantityAvailable;
        return $this;
    }
    /**
     * Get quantityOnHand value
     * @return float|null
     */
    public function getQuantityOnHand()
    {
        return $this->quantityOnHand;
    }
    /**
     * Set quantityOnHand value
     * @param float $quantityOnHand
     * @return \StructType\OpportunityItem
     */
    public function setQuantityOnHand($quantityOnHand = null)
    {
        // validation for constraint: float
        if (!is_null($quantityOnHand) && !(is_float($quantityOnHand) || is_numeric($quantityOnHand))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($quantityOnHand, true), gettype($quantityOnHand)), __LINE__);
        }
        $this->quantityOnHand = $quantityOnHand;
        return $this;
    }
    /**
     * Get quantity value
     * @return float|null
     */
    public function getQuantity()
    {
        return $this->quantity;
    }
    /**
     * Set quantity value
     * @param float $quantity
     * @return \StructType\OpportunityItem
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: float
        if (!is_null($quantity) && !(is_float($quantity) || is_numeric($quantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($quantity, true), gettype($quantity)), __LINE__);
        }
        $this->quantity = $quantity;
        return $this;
    }
    /**
     * Get units value
     * @return \StructType\RecordRef|null
     */
    public function getUnits()
    {
        return $this->units;
    }
    /**
     * Set units value
     * @param \StructType\RecordRef $units
     * @return \StructType\OpportunityItem
     */
    public function setUnits(\StructType\RecordRef $units = null)
    {
        $this->units = $units;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\OpportunityItem
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get price value
     * @return \StructType\RecordRef|null
     */
    public function getPrice()
    {
        return $this->price;
    }
    /**
     * Set price value
     * @param \StructType\RecordRef $price
     * @return \StructType\OpportunityItem
     */
    public function setPrice(\StructType\RecordRef $price = null)
    {
        $this->price = $price;
        return $this;
    }
    /**
     * Get rate value
     * @return string|null
     */
    public function getRate()
    {
        return $this->rate;
    }
    /**
     * Set rate value
     * @param string $rate
     * @return \StructType\OpportunityItem
     */
    public function setRate($rate = null)
    {
        // validation for constraint: string
        if (!is_null($rate) && !is_string($rate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rate, true), gettype($rate)), __LINE__);
        }
        $this->rate = $rate;
        return $this;
    }
    /**
     * Get amount value
     * @return float|null
     */
    public function getAmount()
    {
        return $this->amount;
    }
    /**
     * Set amount value
     * @param float $amount
     * @return \StructType\OpportunityItem
     */
    public function setAmount($amount = null)
    {
        // validation for constraint: float
        if (!is_null($amount) && !(is_float($amount) || is_numeric($amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($amount, true), gettype($amount)), __LINE__);
        }
        $this->amount = $amount;
        return $this;
    }
    /**
     * Get altSalesAmt value
     * @return float|null
     */
    public function getAltSalesAmt()
    {
        return $this->altSalesAmt;
    }
    /**
     * Set altSalesAmt value
     * @param float $altSalesAmt
     * @return \StructType\OpportunityItem
     */
    public function setAltSalesAmt($altSalesAmt = null)
    {
        // validation for constraint: float
        if (!is_null($altSalesAmt) && !(is_float($altSalesAmt) || is_numeric($altSalesAmt))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($altSalesAmt, true), gettype($altSalesAmt)), __LINE__);
        }
        $this->altSalesAmt = $altSalesAmt;
        return $this;
    }
    /**
     * Get revRecTermInMonths value
     * @return int|null
     */
    public function getRevRecTermInMonths()
    {
        return $this->revRecTermInMonths;
    }
    /**
     * Set revRecTermInMonths value
     * @param int $revRecTermInMonths
     * @return \StructType\OpportunityItem
     */
    public function setRevRecTermInMonths($revRecTermInMonths = null)
    {
        // validation for constraint: int
        if (!is_null($revRecTermInMonths) && !(is_int($revRecTermInMonths) || ctype_digit($revRecTermInMonths))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($revRecTermInMonths, true), gettype($revRecTermInMonths)), __LINE__);
        }
        $this->revRecTermInMonths = $revRecTermInMonths;
        return $this;
    }
    /**
     * Get options value
     * @return \StructType\CustomFieldList|null
     */
    public function getOptions()
    {
        return $this->options;
    }
    /**
     * Set options value
     * @param \StructType\CustomFieldList $options
     * @return \StructType\OpportunityItem
     */
    public function setOptions(\StructType\CustomFieldList $options = null)
    {
        $this->options = $options;
        return $this;
    }
    /**
     * Get fromJob value
     * @return bool|null
     */
    public function getFromJob()
    {
        return $this->fromJob;
    }
    /**
     * Set fromJob value
     * @param bool $fromJob
     * @return \StructType\OpportunityItem
     */
    public function setFromJob($fromJob = null)
    {
        // validation for constraint: boolean
        if (!is_null($fromJob) && !is_bool($fromJob)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($fromJob, true), gettype($fromJob)), __LINE__);
        }
        $this->fromJob = $fromJob;
        return $this;
    }
    /**
     * Get department value
     * @return \StructType\RecordRef|null
     */
    public function getDepartment()
    {
        return $this->department;
    }
    /**
     * Set department value
     * @param \StructType\RecordRef $department
     * @return \StructType\OpportunityItem
     */
    public function setDepartment(\StructType\RecordRef $department = null)
    {
        $this->department = $department;
        return $this;
    }
    /**
     * Get isEstimate value
     * @return bool|null
     */
    public function getIsEstimate()
    {
        return $this->isEstimate;
    }
    /**
     * Set isEstimate value
     * @param bool $isEstimate
     * @return \StructType\OpportunityItem
     */
    public function setIsEstimate($isEstimate = null)
    {
        // validation for constraint: boolean
        if (!is_null($isEstimate) && !is_bool($isEstimate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isEstimate, true), gettype($isEstimate)), __LINE__);
        }
        $this->isEstimate = $isEstimate;
        return $this;
    }
    /**
     * Get location value
     * @return \StructType\RecordRef|null
     */
    public function getLocation()
    {
        return $this->location;
    }
    /**
     * Set location value
     * @param \StructType\RecordRef $location
     * @return \StructType\OpportunityItem
     */
    public function setLocation(\StructType\RecordRef $location = null)
    {
        $this->location = $location;
        return $this;
    }
    /**
     * Get class value
     * @return \StructType\RecordRef|null
     */
    public function getClass()
    {
        return $this->class;
    }
    /**
     * Set class value
     * @param \StructType\RecordRef $class
     * @return \StructType\OpportunityItem
     */
    public function setClass(\StructType\RecordRef $class = null)
    {
        $this->class = $class;
        return $this;
    }
    /**
     * Get costEstimateType value
     * @return string|null
     */
    public function getCostEstimateType()
    {
        return $this->costEstimateType;
    }
    /**
     * Set costEstimateType value
     * @uses \EnumType\ItemCostEstimateType::valueIsValid()
     * @uses \EnumType\ItemCostEstimateType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $costEstimateType
     * @return \StructType\OpportunityItem
     */
    public function setCostEstimateType($costEstimateType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ItemCostEstimateType::valueIsValid($costEstimateType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\ItemCostEstimateType', is_array($costEstimateType) ? implode(', ', $costEstimateType) : var_export($costEstimateType, true), implode(', ', \EnumType\ItemCostEstimateType::getValidValues())), __LINE__);
        }
        $this->costEstimateType = $costEstimateType;
        return $this;
    }
    /**
     * Get costEstimate value
     * @return float|null
     */
    public function getCostEstimate()
    {
        return $this->costEstimate;
    }
    /**
     * Set costEstimate value
     * @param float $costEstimate
     * @return \StructType\OpportunityItem
     */
    public function setCostEstimate($costEstimate = null)
    {
        // validation for constraint: float
        if (!is_null($costEstimate) && !(is_float($costEstimate) || is_numeric($costEstimate))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($costEstimate, true), gettype($costEstimate)), __LINE__);
        }
        $this->costEstimate = $costEstimate;
        return $this;
    }
    /**
     * Get taxAmount value
     * @return float|null
     */
    public function getTaxAmount()
    {
        return $this->taxAmount;
    }
    /**
     * Set taxAmount value
     * @param float $taxAmount
     * @return \StructType\OpportunityItem
     */
    public function setTaxAmount($taxAmount = null)
    {
        // validation for constraint: float
        if (!is_null($taxAmount) && !(is_float($taxAmount) || is_numeric($taxAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($taxAmount, true), gettype($taxAmount)), __LINE__);
        }
        $this->taxAmount = $taxAmount;
        return $this;
    }
    /**
     * Get taxDetailsReference value
     * @return string|null
     */
    public function getTaxDetailsReference()
    {
        return $this->taxDetailsReference;
    }
    /**
     * Set taxDetailsReference value
     * @param string $taxDetailsReference
     * @return \StructType\OpportunityItem
     */
    public function setTaxDetailsReference($taxDetailsReference = null)
    {
        // validation for constraint: string
        if (!is_null($taxDetailsReference) && !is_string($taxDetailsReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($taxDetailsReference, true), gettype($taxDetailsReference)), __LINE__);
        }
        $this->taxDetailsReference = $taxDetailsReference;
        return $this;
    }
    /**
     * Get grossAmt value
     * @return float|null
     */
    public function getGrossAmt()
    {
        return $this->grossAmt;
    }
    /**
     * Set grossAmt value
     * @param float $grossAmt
     * @return \StructType\OpportunityItem
     */
    public function setGrossAmt($grossAmt = null)
    {
        // validation for constraint: float
        if (!is_null($grossAmt) && !(is_float($grossAmt) || is_numeric($grossAmt))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($grossAmt, true), gettype($grossAmt)), __LINE__);
        }
        $this->grossAmt = $grossAmt;
        return $this;
    }
    /**
     * Get tax1Amt value
     * @return float|null
     */
    public function getTax1Amt()
    {
        return $this->tax1Amt;
    }
    /**
     * Set tax1Amt value
     * @param float $tax1Amt
     * @return \StructType\OpportunityItem
     */
    public function setTax1Amt($tax1Amt = null)
    {
        // validation for constraint: float
        if (!is_null($tax1Amt) && !(is_float($tax1Amt) || is_numeric($tax1Amt))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($tax1Amt, true), gettype($tax1Amt)), __LINE__);
        }
        $this->tax1Amt = $tax1Amt;
        return $this;
    }
    /**
     * Get taxCode value
     * @return \StructType\RecordRef|null
     */
    public function getTaxCode()
    {
        return $this->taxCode;
    }
    /**
     * Set taxCode value
     * @param \StructType\RecordRef $taxCode
     * @return \StructType\OpportunityItem
     */
    public function setTaxCode(\StructType\RecordRef $taxCode = null)
    {
        $this->taxCode = $taxCode;
        return $this;
    }
    /**
     * Get taxRate1 value
     * @return float|null
     */
    public function getTaxRate1()
    {
        return $this->taxRate1;
    }
    /**
     * Set taxRate1 value
     * @param float $taxRate1
     * @return \StructType\OpportunityItem
     */
    public function setTaxRate1($taxRate1 = null)
    {
        // validation for constraint: float
        if (!is_null($taxRate1) && !(is_float($taxRate1) || is_numeric($taxRate1))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($taxRate1, true), gettype($taxRate1)), __LINE__);
        }
        $this->taxRate1 = $taxRate1;
        return $this;
    }
    /**
     * Get taxRate2 value
     * @return float|null
     */
    public function getTaxRate2()
    {
        return $this->taxRate2;
    }
    /**
     * Set taxRate2 value
     * @param float $taxRate2
     * @return \StructType\OpportunityItem
     */
    public function setTaxRate2($taxRate2 = null)
    {
        // validation for constraint: float
        if (!is_null($taxRate2) && !(is_float($taxRate2) || is_numeric($taxRate2))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($taxRate2, true), gettype($taxRate2)), __LINE__);
        }
        $this->taxRate2 = $taxRate2;
        return $this;
    }
    /**
     * Get expectedShipDate value
     * @return string|null
     */
    public function getExpectedShipDate()
    {
        return $this->expectedShipDate;
    }
    /**
     * Set expectedShipDate value
     * @param string $expectedShipDate
     * @return \StructType\OpportunityItem
     */
    public function setExpectedShipDate($expectedShipDate = null)
    {
        // validation for constraint: string
        if (!is_null($expectedShipDate) && !is_string($expectedShipDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($expectedShipDate, true), gettype($expectedShipDate)), __LINE__);
        }
        $this->expectedShipDate = $expectedShipDate;
        return $this;
    }
    /**
     * Get subscription value
     * @return \StructType\RecordRef|null
     */
    public function getSubscription()
    {
        return $this->subscription;
    }
    /**
     * Set subscription value
     * @param \StructType\RecordRef $subscription
     * @return \StructType\OpportunityItem
     */
    public function setSubscription(\StructType\RecordRef $subscription = null)
    {
        $this->subscription = $subscription;
        return $this;
    }
    /**
     * Get customFieldList value
     * @return \StructType\CustomFieldList|null
     */
    public function getCustomFieldList()
    {
        return $this->customFieldList;
    }
    /**
     * Set customFieldList value
     * @param \StructType\CustomFieldList $customFieldList
     * @return \StructType\OpportunityItem
     */
    public function setCustomFieldList(\StructType\CustomFieldList $customFieldList = null)
    {
        $this->customFieldList = $customFieldList;
        return $this;
    }
}
